/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codecommit.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.codecommit.model.CodeCommitResponse;
import software.amazon.awssdk.services.codecommit.model.File;
import software.amazon.awssdk.services.codecommit.model.FileListCopier;
import software.amazon.awssdk.services.codecommit.model.Folder;
import software.amazon.awssdk.services.codecommit.model.FolderListCopier;
import software.amazon.awssdk.services.codecommit.model.SubModule;
import software.amazon.awssdk.services.codecommit.model.SubModuleListCopier;
import software.amazon.awssdk.services.codecommit.model.SymbolicLink;
import software.amazon.awssdk.services.codecommit.model.SymbolicLinkListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetFolderResponse
extends CodeCommitResponse
implements ToCopyableBuilder<Builder, GetFolderResponse> {
    private static final SdkField<String> COMMIT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("commitId").getter(GetFolderResponse.getter(GetFolderResponse::commitId)).setter(GetFolderResponse.setter(Builder::commitId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("commitId").build()}).build();
    private static final SdkField<String> FOLDER_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("folderPath").getter(GetFolderResponse.getter(GetFolderResponse::folderPath)).setter(GetFolderResponse.setter(Builder::folderPath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("folderPath").build()}).build();
    private static final SdkField<String> TREE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("treeId").getter(GetFolderResponse.getter(GetFolderResponse::treeId)).setter(GetFolderResponse.setter(Builder::treeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("treeId").build()}).build();
    private static final SdkField<List<Folder>> SUB_FOLDERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("subFolders").getter(GetFolderResponse.getter(GetFolderResponse::subFolders)).setter(GetFolderResponse.setter(Builder::subFolders)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subFolders").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Folder::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<File>> FILES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("files").getter(GetFolderResponse.getter(GetFolderResponse::files)).setter(GetFolderResponse.setter(Builder::files)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("files").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(File::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<SymbolicLink>> SYMBOLIC_LINKS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("symbolicLinks").getter(GetFolderResponse.getter(GetFolderResponse::symbolicLinks)).setter(GetFolderResponse.setter(Builder::symbolicLinks)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("symbolicLinks").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SymbolicLink::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<SubModule>> SUB_MODULES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("subModules").getter(GetFolderResponse.getter(GetFolderResponse::subModules)).setter(GetFolderResponse.setter(Builder::subModules)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subModules").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SubModule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMMIT_ID_FIELD, FOLDER_PATH_FIELD, TREE_ID_FIELD, SUB_FOLDERS_FIELD, FILES_FIELD, SYMBOLIC_LINKS_FIELD, SUB_MODULES_FIELD));
    private final String commitId;
    private final String folderPath;
    private final String treeId;
    private final List<Folder> subFolders;
    private final List<File> files;
    private final List<SymbolicLink> symbolicLinks;
    private final List<SubModule> subModules;

    private GetFolderResponse(BuilderImpl builder) {
        super(builder);
        this.commitId = builder.commitId;
        this.folderPath = builder.folderPath;
        this.treeId = builder.treeId;
        this.subFolders = builder.subFolders;
        this.files = builder.files;
        this.symbolicLinks = builder.symbolicLinks;
        this.subModules = builder.subModules;
    }

    public final String commitId() {
        return this.commitId;
    }

    public final String folderPath() {
        return this.folderPath;
    }

    public final String treeId() {
        return this.treeId;
    }

    public final boolean hasSubFolders() {
        return this.subFolders != null && !(this.subFolders instanceof SdkAutoConstructList);
    }

    public final List<Folder> subFolders() {
        return this.subFolders;
    }

    public final boolean hasFiles() {
        return this.files != null && !(this.files instanceof SdkAutoConstructList);
    }

    public final List<File> files() {
        return this.files;
    }

    public final boolean hasSymbolicLinks() {
        return this.symbolicLinks != null && !(this.symbolicLinks instanceof SdkAutoConstructList);
    }

    public final List<SymbolicLink> symbolicLinks() {
        return this.symbolicLinks;
    }

    public final boolean hasSubModules() {
        return this.subModules != null && !(this.subModules instanceof SdkAutoConstructList);
    }

    public final List<SubModule> subModules() {
        return this.subModules;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.commitId());
        hashCode = 31 * hashCode + Objects.hashCode(this.folderPath());
        hashCode = 31 * hashCode + Objects.hashCode(this.treeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSubFolders() ? this.subFolders() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFiles() ? this.files() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSymbolicLinks() ? this.symbolicLinks() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSubModules() ? this.subModules() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetFolderResponse)) {
            return false;
        }
        GetFolderResponse other = (GetFolderResponse)((Object)obj);
        return Objects.equals(this.commitId(), other.commitId()) && Objects.equals(this.folderPath(), other.folderPath()) && Objects.equals(this.treeId(), other.treeId()) && this.hasSubFolders() == other.hasSubFolders() && Objects.equals(this.subFolders(), other.subFolders()) && this.hasFiles() == other.hasFiles() && Objects.equals(this.files(), other.files()) && this.hasSymbolicLinks() == other.hasSymbolicLinks() && Objects.equals(this.symbolicLinks(), other.symbolicLinks()) && this.hasSubModules() == other.hasSubModules() && Objects.equals(this.subModules(), other.subModules());
    }

    public final String toString() {
        return ToString.builder((String)"GetFolderResponse").add("CommitId", (Object)this.commitId()).add("FolderPath", (Object)this.folderPath()).add("TreeId", (Object)this.treeId()).add("SubFolders", this.hasSubFolders() ? this.subFolders() : null).add("Files", this.hasFiles() ? this.files() : null).add("SymbolicLinks", this.hasSymbolicLinks() ? this.symbolicLinks() : null).add("SubModules", this.hasSubModules() ? this.subModules() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "commitId": {
                return Optional.ofNullable(clazz.cast(this.commitId()));
            }
            case "folderPath": {
                return Optional.ofNullable(clazz.cast(this.folderPath()));
            }
            case "treeId": {
                return Optional.ofNullable(clazz.cast(this.treeId()));
            }
            case "subFolders": {
                return Optional.ofNullable(clazz.cast(this.subFolders()));
            }
            case "files": {
                return Optional.ofNullable(clazz.cast(this.files()));
            }
            case "symbolicLinks": {
                return Optional.ofNullable(clazz.cast(this.symbolicLinks()));
            }
            case "subModules": {
                return Optional.ofNullable(clazz.cast(this.subModules()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetFolderResponse, T> g) {
        return obj -> g.apply((GetFolderResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeCommitResponse.BuilderImpl
    implements Builder {
        private String commitId;
        private String folderPath;
        private String treeId;
        private List<Folder> subFolders = DefaultSdkAutoConstructList.getInstance();
        private List<File> files = DefaultSdkAutoConstructList.getInstance();
        private List<SymbolicLink> symbolicLinks = DefaultSdkAutoConstructList.getInstance();
        private List<SubModule> subModules = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetFolderResponse model) {
            super(model);
            this.commitId(model.commitId);
            this.folderPath(model.folderPath);
            this.treeId(model.treeId);
            this.subFolders(model.subFolders);
            this.files(model.files);
            this.symbolicLinks(model.symbolicLinks);
            this.subModules(model.subModules);
        }

        public final String getCommitId() {
            return this.commitId;
        }

        public final void setCommitId(String commitId) {
            this.commitId = commitId;
        }

        @Override
        @Transient
        public final Builder commitId(String commitId) {
            this.commitId = commitId;
            return this;
        }

        public final String getFolderPath() {
            return this.folderPath;
        }

        public final void setFolderPath(String folderPath) {
            this.folderPath = folderPath;
        }

        @Override
        @Transient
        public final Builder folderPath(String folderPath) {
            this.folderPath = folderPath;
            return this;
        }

        public final String getTreeId() {
            return this.treeId;
        }

        public final void setTreeId(String treeId) {
            this.treeId = treeId;
        }

        @Override
        @Transient
        public final Builder treeId(String treeId) {
            this.treeId = treeId;
            return this;
        }

        public final List<Folder.Builder> getSubFolders() {
            List<Folder.Builder> result = FolderListCopier.copyToBuilder(this.subFolders);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSubFolders(Collection<Folder.BuilderImpl> subFolders) {
            this.subFolders = FolderListCopier.copyFromBuilder(subFolders);
        }

        @Override
        @Transient
        public final Builder subFolders(Collection<Folder> subFolders) {
            this.subFolders = FolderListCopier.copy(subFolders);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder subFolders(Folder ... subFolders) {
            this.subFolders(Arrays.asList(subFolders));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder subFolders(Consumer<Folder.Builder> ... subFolders) {
            this.subFolders(Stream.of(subFolders).map(c -> (Folder)((Folder.Builder)Folder.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<File.Builder> getFiles() {
            List<File.Builder> result = FileListCopier.copyToBuilder(this.files);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFiles(Collection<File.BuilderImpl> files) {
            this.files = FileListCopier.copyFromBuilder(files);
        }

        @Override
        @Transient
        public final Builder files(Collection<File> files) {
            this.files = FileListCopier.copy(files);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder files(File ... files) {
            this.files(Arrays.asList(files));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder files(Consumer<File.Builder> ... files) {
            this.files(Stream.of(files).map(c -> (File)((File.Builder)File.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<SymbolicLink.Builder> getSymbolicLinks() {
            List<SymbolicLink.Builder> result = SymbolicLinkListCopier.copyToBuilder(this.symbolicLinks);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSymbolicLinks(Collection<SymbolicLink.BuilderImpl> symbolicLinks) {
            this.symbolicLinks = SymbolicLinkListCopier.copyFromBuilder(symbolicLinks);
        }

        @Override
        @Transient
        public final Builder symbolicLinks(Collection<SymbolicLink> symbolicLinks) {
            this.symbolicLinks = SymbolicLinkListCopier.copy(symbolicLinks);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder symbolicLinks(SymbolicLink ... symbolicLinks) {
            this.symbolicLinks(Arrays.asList(symbolicLinks));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder symbolicLinks(Consumer<SymbolicLink.Builder> ... symbolicLinks) {
            this.symbolicLinks(Stream.of(symbolicLinks).map(c -> (SymbolicLink)((SymbolicLink.Builder)SymbolicLink.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<SubModule.Builder> getSubModules() {
            List<SubModule.Builder> result = SubModuleListCopier.copyToBuilder(this.subModules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSubModules(Collection<SubModule.BuilderImpl> subModules) {
            this.subModules = SubModuleListCopier.copyFromBuilder(subModules);
        }

        @Override
        @Transient
        public final Builder subModules(Collection<SubModule> subModules) {
            this.subModules = SubModuleListCopier.copy(subModules);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder subModules(SubModule ... subModules) {
            this.subModules(Arrays.asList(subModules));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder subModules(Consumer<SubModule.Builder> ... subModules) {
            this.subModules(Stream.of(subModules).map(c -> (SubModule)((SubModule.Builder)SubModule.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetFolderResponse build() {
            return new GetFolderResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CodeCommitResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetFolderResponse> {
        public Builder commitId(String var1);

        public Builder folderPath(String var1);

        public Builder treeId(String var1);

        public Builder subFolders(Collection<Folder> var1);

        public Builder subFolders(Folder ... var1);

        public Builder subFolders(Consumer<Folder.Builder> ... var1);

        public Builder files(Collection<File> var1);

        public Builder files(File ... var1);

        public Builder files(Consumer<File.Builder> ... var1);

        public Builder symbolicLinks(Collection<SymbolicLink> var1);

        public Builder symbolicLinks(SymbolicLink ... var1);

        public Builder symbolicLinks(Consumer<SymbolicLink.Builder> ... var1);

        public Builder subModules(Collection<SubModule> var1);

        public Builder subModules(SubModule ... var1);

        public Builder subModules(Consumer<SubModule.Builder> ... var1);
    }
}

