/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codecommit.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.codecommit.CodeCommitAsyncClient;
import software.amazon.awssdk.services.codecommit.model.GetCommentsForPullRequestRequest;
import software.amazon.awssdk.services.codecommit.model.GetCommentsForPullRequestResponse;

public class GetCommentsForPullRequestPublisher
implements SdkPublisher<GetCommentsForPullRequestResponse> {
    private final CodeCommitAsyncClient client;
    private final GetCommentsForPullRequestRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetCommentsForPullRequestPublisher(CodeCommitAsyncClient client, GetCommentsForPullRequestRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetCommentsForPullRequestPublisher(CodeCommitAsyncClient client, GetCommentsForPullRequestRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetCommentsForPullRequestResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetCommentsForPullRequestResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class GetCommentsForPullRequestResponseFetcher
    implements AsyncPageFetcher<GetCommentsForPullRequestResponse> {
        private GetCommentsForPullRequestResponseFetcher() {
        }

        public boolean hasNextPage(GetCommentsForPullRequestResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetCommentsForPullRequestResponse> nextPage(GetCommentsForPullRequestResponse previousPage) {
            if (previousPage == null) {
                return GetCommentsForPullRequestPublisher.this.client.getCommentsForPullRequest(GetCommentsForPullRequestPublisher.this.firstRequest);
            }
            return GetCommentsForPullRequestPublisher.this.client.getCommentsForPullRequest((GetCommentsForPullRequestRequest)((Object)GetCommentsForPullRequestPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

