/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codecommit.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codecommit.model.CodeCommitRequest;
import software.amazon.awssdk.services.codecommit.model.Location;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PostCommentForComparedCommitRequest
extends CodeCommitRequest
implements ToCopyableBuilder<Builder, PostCommentForComparedCommitRequest> {
    private static final SdkField<String> REPOSITORY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("repositoryName").getter(PostCommentForComparedCommitRequest.getter(PostCommentForComparedCommitRequest::repositoryName)).setter(PostCommentForComparedCommitRequest.setter(Builder::repositoryName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositoryName").build()}).build();
    private static final SdkField<String> BEFORE_COMMIT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("beforeCommitId").getter(PostCommentForComparedCommitRequest.getter(PostCommentForComparedCommitRequest::beforeCommitId)).setter(PostCommentForComparedCommitRequest.setter(Builder::beforeCommitId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("beforeCommitId").build()}).build();
    private static final SdkField<String> AFTER_COMMIT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("afterCommitId").getter(PostCommentForComparedCommitRequest.getter(PostCommentForComparedCommitRequest::afterCommitId)).setter(PostCommentForComparedCommitRequest.setter(Builder::afterCommitId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("afterCommitId").build()}).build();
    private static final SdkField<Location> LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("location").getter(PostCommentForComparedCommitRequest.getter(PostCommentForComparedCommitRequest::location)).setter(PostCommentForComparedCommitRequest.setter(Builder::location)).constructor(Location::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("location").build()}).build();
    private static final SdkField<String> CONTENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("content").getter(PostCommentForComparedCommitRequest.getter(PostCommentForComparedCommitRequest::content)).setter(PostCommentForComparedCommitRequest.setter(Builder::content)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("content").build()}).build();
    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientRequestToken").getter(PostCommentForComparedCommitRequest.getter(PostCommentForComparedCommitRequest::clientRequestToken)).setter(PostCommentForComparedCommitRequest.setter(Builder::clientRequestToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientRequestToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPOSITORY_NAME_FIELD, BEFORE_COMMIT_ID_FIELD, AFTER_COMMIT_ID_FIELD, LOCATION_FIELD, CONTENT_FIELD, CLIENT_REQUEST_TOKEN_FIELD));
    private final String repositoryName;
    private final String beforeCommitId;
    private final String afterCommitId;
    private final Location location;
    private final String content;
    private final String clientRequestToken;

    private PostCommentForComparedCommitRequest(BuilderImpl builder) {
        super(builder);
        this.repositoryName = builder.repositoryName;
        this.beforeCommitId = builder.beforeCommitId;
        this.afterCommitId = builder.afterCommitId;
        this.location = builder.location;
        this.content = builder.content;
        this.clientRequestToken = builder.clientRequestToken;
    }

    public final String repositoryName() {
        return this.repositoryName;
    }

    public final String beforeCommitId() {
        return this.beforeCommitId;
    }

    public final String afterCommitId() {
        return this.afterCommitId;
    }

    public final Location location() {
        return this.location;
    }

    public final String content() {
        return this.content;
    }

    public final String clientRequestToken() {
        return this.clientRequestToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.repositoryName());
        hashCode = 31 * hashCode + Objects.hashCode(this.beforeCommitId());
        hashCode = 31 * hashCode + Objects.hashCode(this.afterCommitId());
        hashCode = 31 * hashCode + Objects.hashCode(this.location());
        hashCode = 31 * hashCode + Objects.hashCode(this.content());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientRequestToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PostCommentForComparedCommitRequest)) {
            return false;
        }
        PostCommentForComparedCommitRequest other = (PostCommentForComparedCommitRequest)((Object)obj);
        return Objects.equals(this.repositoryName(), other.repositoryName()) && Objects.equals(this.beforeCommitId(), other.beforeCommitId()) && Objects.equals(this.afterCommitId(), other.afterCommitId()) && Objects.equals(this.location(), other.location()) && Objects.equals(this.content(), other.content()) && Objects.equals(this.clientRequestToken(), other.clientRequestToken());
    }

    public final String toString() {
        return ToString.builder((String)"PostCommentForComparedCommitRequest").add("RepositoryName", (Object)this.repositoryName()).add("BeforeCommitId", (Object)this.beforeCommitId()).add("AfterCommitId", (Object)this.afterCommitId()).add("Location", (Object)this.location()).add("Content", (Object)this.content()).add("ClientRequestToken", (Object)this.clientRequestToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "repositoryName": {
                return Optional.ofNullable(clazz.cast(this.repositoryName()));
            }
            case "beforeCommitId": {
                return Optional.ofNullable(clazz.cast(this.beforeCommitId()));
            }
            case "afterCommitId": {
                return Optional.ofNullable(clazz.cast(this.afterCommitId()));
            }
            case "location": {
                return Optional.ofNullable(clazz.cast(this.location()));
            }
            case "content": {
                return Optional.ofNullable(clazz.cast(this.content()));
            }
            case "clientRequestToken": {
                return Optional.ofNullable(clazz.cast(this.clientRequestToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PostCommentForComparedCommitRequest, T> g) {
        return obj -> g.apply((PostCommentForComparedCommitRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeCommitRequest.BuilderImpl
    implements Builder {
        private String repositoryName;
        private String beforeCommitId;
        private String afterCommitId;
        private Location location;
        private String content;
        private String clientRequestToken;

        private BuilderImpl() {
        }

        private BuilderImpl(PostCommentForComparedCommitRequest model) {
            super(model);
            this.repositoryName(model.repositoryName);
            this.beforeCommitId(model.beforeCommitId);
            this.afterCommitId(model.afterCommitId);
            this.location(model.location);
            this.content(model.content);
            this.clientRequestToken(model.clientRequestToken);
        }

        public final String getRepositoryName() {
            return this.repositoryName;
        }

        public final void setRepositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
        }

        @Override
        public final Builder repositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
            return this;
        }

        public final String getBeforeCommitId() {
            return this.beforeCommitId;
        }

        public final void setBeforeCommitId(String beforeCommitId) {
            this.beforeCommitId = beforeCommitId;
        }

        @Override
        public final Builder beforeCommitId(String beforeCommitId) {
            this.beforeCommitId = beforeCommitId;
            return this;
        }

        public final String getAfterCommitId() {
            return this.afterCommitId;
        }

        public final void setAfterCommitId(String afterCommitId) {
            this.afterCommitId = afterCommitId;
        }

        @Override
        public final Builder afterCommitId(String afterCommitId) {
            this.afterCommitId = afterCommitId;
            return this;
        }

        public final Location.Builder getLocation() {
            return this.location != null ? this.location.toBuilder() : null;
        }

        public final void setLocation(Location.BuilderImpl location) {
            this.location = location != null ? location.build() : null;
        }

        @Override
        public final Builder location(Location location) {
            this.location = location;
            return this;
        }

        public final String getContent() {
            return this.content;
        }

        public final void setContent(String content) {
            this.content = content;
        }

        @Override
        public final Builder content(String content) {
            this.content = content;
            return this;
        }

        public final String getClientRequestToken() {
            return this.clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PostCommentForComparedCommitRequest build() {
            return new PostCommentForComparedCommitRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CodeCommitRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PostCommentForComparedCommitRequest> {
        public Builder repositoryName(String var1);

        public Builder beforeCommitId(String var1);

        public Builder afterCommitId(String var1);

        public Builder location(Location var1);

        default public Builder location(Consumer<Location.Builder> location) {
            return this.location((Location)((Location.Builder)Location.builder().applyMutation(location)).build());
        }

        public Builder content(String var1);

        public Builder clientRequestToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

