/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codecommit.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about file modes in a merge or pull request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FileModes implements SdkPojo, Serializable, ToCopyableBuilder<FileModes.Builder, FileModes> {
    private static final SdkField<String> SOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("source")
            .getter(getter(FileModes::sourceAsString)).setter(setter(Builder::source))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("source").build()).build();

    private static final SdkField<String> DESTINATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("destination").getter(getter(FileModes::destinationAsString)).setter(setter(Builder::destination))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destination").build()).build();

    private static final SdkField<String> BASE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("base")
            .getter(getter(FileModes::baseAsString)).setter(setter(Builder::base))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("base").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_FIELD,
            DESTINATION_FIELD, BASE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String source;

    private final String destination;

    private final String base;

    private FileModes(BuilderImpl builder) {
        this.source = builder.source;
        this.destination = builder.destination;
        this.base = builder.base;
    }

    /**
     * <p>
     * The file mode of a file in the source of a merge or pull request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #source} will
     * return {@link FileModeTypeEnum#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sourceAsString}.
     * </p>
     * 
     * @return The file mode of a file in the source of a merge or pull request.
     * @see FileModeTypeEnum
     */
    public final FileModeTypeEnum source() {
        return FileModeTypeEnum.fromValue(source);
    }

    /**
     * <p>
     * The file mode of a file in the source of a merge or pull request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #source} will
     * return {@link FileModeTypeEnum#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sourceAsString}.
     * </p>
     * 
     * @return The file mode of a file in the source of a merge or pull request.
     * @see FileModeTypeEnum
     */
    public final String sourceAsString() {
        return source;
    }

    /**
     * <p>
     * The file mode of a file in the destination of a merge or pull request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #destination} will
     * return {@link FileModeTypeEnum#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #destinationAsString}.
     * </p>
     * 
     * @return The file mode of a file in the destination of a merge or pull request.
     * @see FileModeTypeEnum
     */
    public final FileModeTypeEnum destination() {
        return FileModeTypeEnum.fromValue(destination);
    }

    /**
     * <p>
     * The file mode of a file in the destination of a merge or pull request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #destination} will
     * return {@link FileModeTypeEnum#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #destinationAsString}.
     * </p>
     * 
     * @return The file mode of a file in the destination of a merge or pull request.
     * @see FileModeTypeEnum
     */
    public final String destinationAsString() {
        return destination;
    }

    /**
     * <p>
     * The file mode of a file in the base of a merge or pull request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #base} will return
     * {@link FileModeTypeEnum#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #baseAsString}.
     * </p>
     * 
     * @return The file mode of a file in the base of a merge or pull request.
     * @see FileModeTypeEnum
     */
    public final FileModeTypeEnum base() {
        return FileModeTypeEnum.fromValue(base);
    }

    /**
     * <p>
     * The file mode of a file in the base of a merge or pull request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #base} will return
     * {@link FileModeTypeEnum#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #baseAsString}.
     * </p>
     * 
     * @return The file mode of a file in the base of a merge or pull request.
     * @see FileModeTypeEnum
     */
    public final String baseAsString() {
        return base;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sourceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(destinationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(baseAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FileModes)) {
            return false;
        }
        FileModes other = (FileModes) obj;
        return Objects.equals(sourceAsString(), other.sourceAsString())
                && Objects.equals(destinationAsString(), other.destinationAsString())
                && Objects.equals(baseAsString(), other.baseAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FileModes").add("Source", sourceAsString()).add("Destination", destinationAsString())
                .add("Base", baseAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "source":
            return Optional.ofNullable(clazz.cast(sourceAsString()));
        case "destination":
            return Optional.ofNullable(clazz.cast(destinationAsString()));
        case "base":
            return Optional.ofNullable(clazz.cast(baseAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FileModes, T> g) {
        return obj -> g.apply((FileModes) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FileModes> {
        /**
         * <p>
         * The file mode of a file in the source of a merge or pull request.
         * </p>
         * 
         * @param source
         *        The file mode of a file in the source of a merge or pull request.
         * @see FileModeTypeEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FileModeTypeEnum
         */
        Builder source(String source);

        /**
         * <p>
         * The file mode of a file in the source of a merge or pull request.
         * </p>
         * 
         * @param source
         *        The file mode of a file in the source of a merge or pull request.
         * @see FileModeTypeEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FileModeTypeEnum
         */
        Builder source(FileModeTypeEnum source);

        /**
         * <p>
         * The file mode of a file in the destination of a merge or pull request.
         * </p>
         * 
         * @param destination
         *        The file mode of a file in the destination of a merge or pull request.
         * @see FileModeTypeEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FileModeTypeEnum
         */
        Builder destination(String destination);

        /**
         * <p>
         * The file mode of a file in the destination of a merge or pull request.
         * </p>
         * 
         * @param destination
         *        The file mode of a file in the destination of a merge or pull request.
         * @see FileModeTypeEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FileModeTypeEnum
         */
        Builder destination(FileModeTypeEnum destination);

        /**
         * <p>
         * The file mode of a file in the base of a merge or pull request.
         * </p>
         * 
         * @param base
         *        The file mode of a file in the base of a merge or pull request.
         * @see FileModeTypeEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FileModeTypeEnum
         */
        Builder base(String base);

        /**
         * <p>
         * The file mode of a file in the base of a merge or pull request.
         * </p>
         * 
         * @param base
         *        The file mode of a file in the base of a merge or pull request.
         * @see FileModeTypeEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FileModeTypeEnum
         */
        Builder base(FileModeTypeEnum base);
    }

    static final class BuilderImpl implements Builder {
        private String source;

        private String destination;

        private String base;

        private BuilderImpl() {
        }

        private BuilderImpl(FileModes model) {
            source(model.source);
            destination(model.destination);
            base(model.base);
        }

        public final String getSource() {
            return source;
        }

        public final void setSource(String source) {
            this.source = source;
        }

        @Override
        public final Builder source(String source) {
            this.source = source;
            return this;
        }

        @Override
        public final Builder source(FileModeTypeEnum source) {
            this.source(source == null ? null : source.toString());
            return this;
        }

        public final String getDestination() {
            return destination;
        }

        public final void setDestination(String destination) {
            this.destination = destination;
        }

        @Override
        public final Builder destination(String destination) {
            this.destination = destination;
            return this;
        }

        @Override
        public final Builder destination(FileModeTypeEnum destination) {
            this.destination(destination == null ? null : destination.toString());
            return this;
        }

        public final String getBase() {
            return base;
        }

        public final void setBase(String base) {
            this.base = base;
        }

        @Override
        public final Builder base(String base) {
            this.base = base;
            return this;
        }

        @Override
        public final Builder base(FileModeTypeEnum base) {
            this.base(base == null ? null : base.toString());
            return this;
        }

        @Override
        public FileModes build() {
            return new FileModes(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
