/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codecommit.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.codecommit.CodeCommitClient;
import software.amazon.awssdk.services.codecommit.model.DescribeMergeConflictsRequest;
import software.amazon.awssdk.services.codecommit.model.DescribeMergeConflictsResponse;

public class DescribeMergeConflictsIterable
implements SdkIterable<DescribeMergeConflictsResponse> {
    private final CodeCommitClient client;
    private final DescribeMergeConflictsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeMergeConflictsIterable(CodeCommitClient client, DescribeMergeConflictsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeMergeConflictsResponseFetcher();
    }

    public Iterator<DescribeMergeConflictsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class DescribeMergeConflictsResponseFetcher
    implements SyncPageFetcher<DescribeMergeConflictsResponse> {
        private DescribeMergeConflictsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeMergeConflictsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeMergeConflictsResponse nextPage(DescribeMergeConflictsResponse previousPage) {
            if (previousPage == null) {
                return DescribeMergeConflictsIterable.this.client.describeMergeConflicts(DescribeMergeConflictsIterable.this.firstRequest);
            }
            return DescribeMergeConflictsIterable.this.client.describeMergeConflicts((DescribeMergeConflictsRequest)((Object)DescribeMergeConflictsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

