/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codecommit.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the output of a list repositories operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListRepositoriesResponse extends CodeCommitResponse implements
        ToCopyableBuilder<ListRepositoriesResponse.Builder, ListRepositoriesResponse> {
    private static final SdkField<List<RepositoryNameIdPair>> REPOSITORIES_FIELD = SdkField
            .<List<RepositoryNameIdPair>> builder(MarshallingType.LIST)
            .memberName("repositories")
            .getter(getter(ListRepositoriesResponse::repositories))
            .setter(setter(Builder::repositories))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositories").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RepositoryNameIdPair> builder(MarshallingType.SDK_POJO)
                                            .constructor(RepositoryNameIdPair::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListRepositoriesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPOSITORIES_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<RepositoryNameIdPair> repositories;

    private final String nextToken;

    private ListRepositoriesResponse(BuilderImpl builder) {
        super(builder);
        this.repositories = builder.repositories;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Repositories property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRepositories() {
        return repositories != null && !(repositories instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Lists the repositories called by the list repositories operation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRepositories} method.
     * </p>
     * 
     * @return Lists the repositories called by the list repositories operation.
     */
    public final List<RepositoryNameIdPair> repositories() {
        return repositories;
    }

    /**
     * <p>
     * An enumeration token that allows the operation to batch the results of the operation. Batch sizes are 1,000 for
     * list repository operations. When the client sends the token back to AWS CodeCommit, another page of 1,000 records
     * is retrieved.
     * </p>
     * 
     * @return An enumeration token that allows the operation to batch the results of the operation. Batch sizes are
     *         1,000 for list repository operations. When the client sends the token back to AWS CodeCommit, another
     *         page of 1,000 records is retrieved.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasRepositories() ? repositories() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRepositoriesResponse)) {
            return false;
        }
        ListRepositoriesResponse other = (ListRepositoriesResponse) obj;
        return hasRepositories() == other.hasRepositories() && Objects.equals(repositories(), other.repositories())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListRepositoriesResponse").add("Repositories", hasRepositories() ? repositories() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "repositories":
            return Optional.ofNullable(clazz.cast(repositories()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListRepositoriesResponse, T> g) {
        return obj -> g.apply((ListRepositoriesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeCommitResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListRepositoriesResponse> {
        /**
         * <p>
         * Lists the repositories called by the list repositories operation.
         * </p>
         * 
         * @param repositories
         *        Lists the repositories called by the list repositories operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repositories(Collection<RepositoryNameIdPair> repositories);

        /**
         * <p>
         * Lists the repositories called by the list repositories operation.
         * </p>
         * 
         * @param repositories
         *        Lists the repositories called by the list repositories operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repositories(RepositoryNameIdPair... repositories);

        /**
         * <p>
         * Lists the repositories called by the list repositories operation.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.codecommit.model.RepositoryNameIdPair.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.codecommit.model.RepositoryNameIdPair#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.codecommit.model.RepositoryNameIdPair.Builder#build()} is called
         * immediately and its result is passed to {@link #repositories(List<RepositoryNameIdPair>)}.
         * 
         * @param repositories
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.codecommit.model.RepositoryNameIdPair.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #repositories(java.util.Collection<RepositoryNameIdPair>)
         */
        Builder repositories(Consumer<RepositoryNameIdPair.Builder>... repositories);

        /**
         * <p>
         * An enumeration token that allows the operation to batch the results of the operation. Batch sizes are 1,000
         * for list repository operations. When the client sends the token back to AWS CodeCommit, another page of 1,000
         * records is retrieved.
         * </p>
         * 
         * @param nextToken
         *        An enumeration token that allows the operation to batch the results of the operation. Batch sizes are
         *        1,000 for list repository operations. When the client sends the token back to AWS CodeCommit, another
         *        page of 1,000 records is retrieved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends CodeCommitResponse.BuilderImpl implements Builder {
        private List<RepositoryNameIdPair> repositories = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListRepositoriesResponse model) {
            super(model);
            repositories(model.repositories);
            nextToken(model.nextToken);
        }

        public final List<RepositoryNameIdPair.Builder> getRepositories() {
            List<RepositoryNameIdPair.Builder> result = RepositoryNameIdPairListCopier.copyToBuilder(this.repositories);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRepositories(Collection<RepositoryNameIdPair.BuilderImpl> repositories) {
            this.repositories = RepositoryNameIdPairListCopier.copyFromBuilder(repositories);
        }

        @Override
        public final Builder repositories(Collection<RepositoryNameIdPair> repositories) {
            this.repositories = RepositoryNameIdPairListCopier.copy(repositories);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder repositories(RepositoryNameIdPair... repositories) {
            repositories(Arrays.asList(repositories));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder repositories(Consumer<RepositoryNameIdPair.Builder>... repositories) {
            repositories(Stream.of(repositories).map(c -> RepositoryNameIdPair.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListRepositoriesResponse build() {
            return new ListRepositoriesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
