/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codecommit;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.codecommit.CodeCommitAsyncClient;
import software.amazon.awssdk.services.codecommit.CodeCommitServiceClientConfiguration;
import software.amazon.awssdk.services.codecommit.model.ActorDoesNotExistException;
import software.amazon.awssdk.services.codecommit.model.ApprovalRuleContentRequiredException;
import software.amazon.awssdk.services.codecommit.model.ApprovalRuleDoesNotExistException;
import software.amazon.awssdk.services.codecommit.model.ApprovalRuleNameAlreadyExistsException;
import software.amazon.awssdk.services.codecommit.model.ApprovalRuleNameRequiredException;
import software.amazon.awssdk.services.codecommit.model.ApprovalRuleTemplateContentRequiredException;
import software.amazon.awssdk.services.codecommit.model.ApprovalRuleTemplateDoesNotExistException;
import software.amazon.awssdk.services.codecommit.model.ApprovalRuleTemplateInUseException;
import software.amazon.awssdk.services.codecommit.model.ApprovalRuleTemplateNameAlreadyExistsException;
import software.amazon.awssdk.services.codecommit.model.ApprovalRuleTemplateNameRequiredException;
import software.amazon.awssdk.services.codecommit.model.ApprovalStateRequiredException;
import software.amazon.awssdk.services.codecommit.model.AssociateApprovalRuleTemplateWithRepositoryRequest;
import software.amazon.awssdk.services.codecommit.model.AssociateApprovalRuleTemplateWithRepositoryResponse;
import software.amazon.awssdk.services.codecommit.model.AuthorDoesNotExistException;
import software.amazon.awssdk.services.codecommit.model.BatchAssociateApprovalRuleTemplateWithRepositoriesRequest;
import software.amazon.awssdk.services.codecommit.model.BatchAssociateApprovalRuleTemplateWithRepositoriesResponse;
import software.amazon.awssdk.services.codecommit.model.BatchDescribeMergeConflictsRequest;
import software.amazon.awssdk.services.codecommit.model.BatchDescribeMergeConflictsResponse;
import software.amazon.awssdk.services.codecommit.model.BatchDisassociateApprovalRuleTemplateFromRepositoriesRequest;
import software.amazon.awssdk.services.codecommit.model.BatchDisassociateApprovalRuleTemplateFromRepositoriesResponse;
import software.amazon.awssdk.services.codecommit.model.BatchGetCommitsRequest;
import software.amazon.awssdk.services.codecommit.model.BatchGetCommitsResponse;
import software.amazon.awssdk.services.codecommit.model.BatchGetRepositoriesRequest;
import software.amazon.awssdk.services.codecommit.model.BatchGetRepositoriesResponse;
import software.amazon.awssdk.services.codecommit.model.BeforeCommitIdAndAfterCommitIdAreSameException;
import software.amazon.awssdk.services.codecommit.model.BlobIdDoesNotExistException;
import software.amazon.awssdk.services.codecommit.model.BlobIdRequiredException;
import software.amazon.awssdk.services.codecommit.model.BranchDoesNotExistException;
import software.amazon.awssdk.services.codecommit.model.BranchNameExistsException;
import software.amazon.awssdk.services.codecommit.model.BranchNameIsTagNameException;
import software.amazon.awssdk.services.codecommit.model.BranchNameRequiredException;
import software.amazon.awssdk.services.codecommit.model.CannotDeleteApprovalRuleFromTemplateException;
import software.amazon.awssdk.services.codecommit.model.CannotModifyApprovalRuleFromTemplateException;
import software.amazon.awssdk.services.codecommit.model.ClientRequestTokenRequiredException;
import software.amazon.awssdk.services.codecommit.model.CodeCommitException;
import software.amazon.awssdk.services.codecommit.model.CodeCommitRequest;
import software.amazon.awssdk.services.codecommit.model.CommentContentRequiredException;
import software.amazon.awssdk.services.codecommit.model.CommentContentSizeLimitExceededException;
import software.amazon.awssdk.services.codecommit.model.CommentDeletedException;
import software.amazon.awssdk.services.codecommit.model.CommentDoesNotExistException;
import software.amazon.awssdk.services.codecommit.model.CommentIdRequiredException;
import software.amazon.awssdk.services.codecommit.model.CommentNotCreatedByCallerException;
import software.amazon.awssdk.services.codecommit.model.CommitDoesNotExistException;
import software.amazon.awssdk.services.codecommit.model.CommitIdDoesNotExistException;
import software.amazon.awssdk.services.codecommit.model.CommitIdRequiredException;
import software.amazon.awssdk.services.codecommit.model.CommitIdsLimitExceededException;
import software.amazon.awssdk.services.codecommit.model.CommitIdsListRequiredException;
import software.amazon.awssdk.services.codecommit.model.CommitMessageLengthExceededException;
import software.amazon.awssdk.services.codecommit.model.CommitRequiredException;
import software.amazon.awssdk.services.codecommit.model.ConcurrentReferenceUpdateException;
import software.amazon.awssdk.services.codecommit.model.CreateApprovalRuleTemplateRequest;
import software.amazon.awssdk.services.codecommit.model.CreateApprovalRuleTemplateResponse;
import software.amazon.awssdk.services.codecommit.model.CreateBranchRequest;
import software.amazon.awssdk.services.codecommit.model.CreateBranchResponse;
import software.amazon.awssdk.services.codecommit.model.CreateCommitRequest;
import software.amazon.awssdk.services.codecommit.model.CreateCommitResponse;
import software.amazon.awssdk.services.codecommit.model.CreatePullRequestApprovalRuleRequest;
import software.amazon.awssdk.services.codecommit.model.CreatePullRequestApprovalRuleResponse;
import software.amazon.awssdk.services.codecommit.model.CreatePullRequestRequest;
import software.amazon.awssdk.services.codecommit.model.CreatePullRequestResponse;
import software.amazon.awssdk.services.codecommit.model.CreateRepositoryRequest;
import software.amazon.awssdk.services.codecommit.model.CreateRepositoryResponse;
import software.amazon.awssdk.services.codecommit.model.CreateUnreferencedMergeCommitRequest;
import software.amazon.awssdk.services.codecommit.model.CreateUnreferencedMergeCommitResponse;
import software.amazon.awssdk.services.codecommit.model.DefaultBranchCannotBeDeletedException;
import software.amazon.awssdk.services.codecommit.model.DeleteApprovalRuleTemplateRequest;
import software.amazon.awssdk.services.codecommit.model.DeleteApprovalRuleTemplateResponse;
import software.amazon.awssdk.services.codecommit.model.DeleteBranchRequest;
import software.amazon.awssdk.services.codecommit.model.DeleteBranchResponse;
import software.amazon.awssdk.services.codecommit.model.DeleteCommentContentRequest;
import software.amazon.awssdk.services.codecommit.model.DeleteCommentContentResponse;
import software.amazon.awssdk.services.codecommit.model.DeleteFileRequest;
import software.amazon.awssdk.services.codecommit.model.DeleteFileResponse;
import software.amazon.awssdk.services.codecommit.model.DeletePullRequestApprovalRuleRequest;
import software.amazon.awssdk.services.codecommit.model.DeletePullRequestApprovalRuleResponse;
import software.amazon.awssdk.services.codecommit.model.DeleteRepositoryRequest;
import software.amazon.awssdk.services.codecommit.model.DeleteRepositoryResponse;
import software.amazon.awssdk.services.codecommit.model.DescribeMergeConflictsRequest;
import software.amazon.awssdk.services.codecommit.model.DescribeMergeConflictsResponse;
import software.amazon.awssdk.services.codecommit.model.DescribePullRequestEventsRequest;
import software.amazon.awssdk.services.codecommit.model.DescribePullRequestEventsResponse;
import software.amazon.awssdk.services.codecommit.model.DirectoryNameConflictsWithFileNameException;
import software.amazon.awssdk.services.codecommit.model.DisassociateApprovalRuleTemplateFromRepositoryRequest;
import software.amazon.awssdk.services.codecommit.model.DisassociateApprovalRuleTemplateFromRepositoryResponse;
import software.amazon.awssdk.services.codecommit.model.EncryptionIntegrityChecksFailedException;
import software.amazon.awssdk.services.codecommit.model.EncryptionKeyAccessDeniedException;
import software.amazon.awssdk.services.codecommit.model.EncryptionKeyDisabledException;
import software.amazon.awssdk.services.codecommit.model.EncryptionKeyNotFoundException;
import software.amazon.awssdk.services.codecommit.model.EncryptionKeyUnavailableException;
import software.amazon.awssdk.services.codecommit.model.EvaluatePullRequestApprovalRulesRequest;
import software.amazon.awssdk.services.codecommit.model.EvaluatePullRequestApprovalRulesResponse;
import software.amazon.awssdk.services.codecommit.model.FileContentAndSourceFileSpecifiedException;
import software.amazon.awssdk.services.codecommit.model.FileContentRequiredException;
import software.amazon.awssdk.services.codecommit.model.FileContentSizeLimitExceededException;
import software.amazon.awssdk.services.codecommit.model.FileDoesNotExistException;
import software.amazon.awssdk.services.codecommit.model.FileEntryRequiredException;
import software.amazon.awssdk.services.codecommit.model.FileModeRequiredException;
import software.amazon.awssdk.services.codecommit.model.FileNameConflictsWithDirectoryNameException;
import software.amazon.awssdk.services.codecommit.model.FilePathConflictsWithSubmodulePathException;
import software.amazon.awssdk.services.codecommit.model.FileTooLargeException;
import software.amazon.awssdk.services.codecommit.model.FolderContentSizeLimitExceededException;
import software.amazon.awssdk.services.codecommit.model.FolderDoesNotExistException;
import software.amazon.awssdk.services.codecommit.model.GetApprovalRuleTemplateRequest;
import software.amazon.awssdk.services.codecommit.model.GetApprovalRuleTemplateResponse;
import software.amazon.awssdk.services.codecommit.model.GetBlobRequest;
import software.amazon.awssdk.services.codecommit.model.GetBlobResponse;
import software.amazon.awssdk.services.codecommit.model.GetBranchRequest;
import software.amazon.awssdk.services.codecommit.model.GetBranchResponse;
import software.amazon.awssdk.services.codecommit.model.GetCommentReactionsRequest;
import software.amazon.awssdk.services.codecommit.model.GetCommentReactionsResponse;
import software.amazon.awssdk.services.codecommit.model.GetCommentRequest;
import software.amazon.awssdk.services.codecommit.model.GetCommentResponse;
import software.amazon.awssdk.services.codecommit.model.GetCommentsForComparedCommitRequest;
import software.amazon.awssdk.services.codecommit.model.GetCommentsForComparedCommitResponse;
import software.amazon.awssdk.services.codecommit.model.GetCommentsForPullRequestRequest;
import software.amazon.awssdk.services.codecommit.model.GetCommentsForPullRequestResponse;
import software.amazon.awssdk.services.codecommit.model.GetCommitRequest;
import software.amazon.awssdk.services.codecommit.model.GetCommitResponse;
import software.amazon.awssdk.services.codecommit.model.GetDifferencesRequest;
import software.amazon.awssdk.services.codecommit.model.GetDifferencesResponse;
import software.amazon.awssdk.services.codecommit.model.GetFileRequest;
import software.amazon.awssdk.services.codecommit.model.GetFileResponse;
import software.amazon.awssdk.services.codecommit.model.GetFolderRequest;
import software.amazon.awssdk.services.codecommit.model.GetFolderResponse;
import software.amazon.awssdk.services.codecommit.model.GetMergeCommitRequest;
import software.amazon.awssdk.services.codecommit.model.GetMergeCommitResponse;
import software.amazon.awssdk.services.codecommit.model.GetMergeConflictsRequest;
import software.amazon.awssdk.services.codecommit.model.GetMergeConflictsResponse;
import software.amazon.awssdk.services.codecommit.model.GetMergeOptionsRequest;
import software.amazon.awssdk.services.codecommit.model.GetMergeOptionsResponse;
import software.amazon.awssdk.services.codecommit.model.GetPullRequestApprovalStatesRequest;
import software.amazon.awssdk.services.codecommit.model.GetPullRequestApprovalStatesResponse;
import software.amazon.awssdk.services.codecommit.model.GetPullRequestOverrideStateRequest;
import software.amazon.awssdk.services.codecommit.model.GetPullRequestOverrideStateResponse;
import software.amazon.awssdk.services.codecommit.model.GetPullRequestRequest;
import software.amazon.awssdk.services.codecommit.model.GetPullRequestResponse;
import software.amazon.awssdk.services.codecommit.model.GetRepositoryRequest;
import software.amazon.awssdk.services.codecommit.model.GetRepositoryResponse;
import software.amazon.awssdk.services.codecommit.model.GetRepositoryTriggersRequest;
import software.amazon.awssdk.services.codecommit.model.GetRepositoryTriggersResponse;
import software.amazon.awssdk.services.codecommit.model.IdempotencyParameterMismatchException;
import software.amazon.awssdk.services.codecommit.model.InvalidActorArnException;
import software.amazon.awssdk.services.codecommit.model.InvalidApprovalRuleContentException;
import software.amazon.awssdk.services.codecommit.model.InvalidApprovalRuleNameException;
import software.amazon.awssdk.services.codecommit.model.InvalidApprovalRuleTemplateContentException;
import software.amazon.awssdk.services.codecommit.model.InvalidApprovalRuleTemplateDescriptionException;
import software.amazon.awssdk.services.codecommit.model.InvalidApprovalRuleTemplateNameException;
import software.amazon.awssdk.services.codecommit.model.InvalidApprovalStateException;
import software.amazon.awssdk.services.codecommit.model.InvalidAuthorArnException;
import software.amazon.awssdk.services.codecommit.model.InvalidBlobIdException;
import software.amazon.awssdk.services.codecommit.model.InvalidBranchNameException;
import software.amazon.awssdk.services.codecommit.model.InvalidClientRequestTokenException;
import software.amazon.awssdk.services.codecommit.model.InvalidCommentIdException;
import software.amazon.awssdk.services.codecommit.model.InvalidCommitException;
import software.amazon.awssdk.services.codecommit.model.InvalidCommitIdException;
import software.amazon.awssdk.services.codecommit.model.InvalidConflictDetailLevelException;
import software.amazon.awssdk.services.codecommit.model.InvalidConflictResolutionException;
import software.amazon.awssdk.services.codecommit.model.InvalidConflictResolutionStrategyException;
import software.amazon.awssdk.services.codecommit.model.InvalidContinuationTokenException;
import software.amazon.awssdk.services.codecommit.model.InvalidDeletionParameterException;
import software.amazon.awssdk.services.codecommit.model.InvalidDescriptionException;
import software.amazon.awssdk.services.codecommit.model.InvalidDestinationCommitSpecifierException;
import software.amazon.awssdk.services.codecommit.model.InvalidEmailException;
import software.amazon.awssdk.services.codecommit.model.InvalidFileLocationException;
import software.amazon.awssdk.services.codecommit.model.InvalidFileModeException;
import software.amazon.awssdk.services.codecommit.model.InvalidFilePositionException;
import software.amazon.awssdk.services.codecommit.model.InvalidMaxConflictFilesException;
import software.amazon.awssdk.services.codecommit.model.InvalidMaxMergeHunksException;
import software.amazon.awssdk.services.codecommit.model.InvalidMaxResultsException;
import software.amazon.awssdk.services.codecommit.model.InvalidMergeOptionException;
import software.amazon.awssdk.services.codecommit.model.InvalidOrderException;
import software.amazon.awssdk.services.codecommit.model.InvalidOverrideStatusException;
import software.amazon.awssdk.services.codecommit.model.InvalidParentCommitIdException;
import software.amazon.awssdk.services.codecommit.model.InvalidPathException;
import software.amazon.awssdk.services.codecommit.model.InvalidPullRequestEventTypeException;
import software.amazon.awssdk.services.codecommit.model.InvalidPullRequestIdException;
import software.amazon.awssdk.services.codecommit.model.InvalidPullRequestStatusException;
import software.amazon.awssdk.services.codecommit.model.InvalidPullRequestStatusUpdateException;
import software.amazon.awssdk.services.codecommit.model.InvalidReactionUserArnException;
import software.amazon.awssdk.services.codecommit.model.InvalidReactionValueException;
import software.amazon.awssdk.services.codecommit.model.InvalidReferenceNameException;
import software.amazon.awssdk.services.codecommit.model.InvalidRelativeFileVersionEnumException;
import software.amazon.awssdk.services.codecommit.model.InvalidReplacementContentException;
import software.amazon.awssdk.services.codecommit.model.InvalidReplacementTypeException;
import software.amazon.awssdk.services.codecommit.model.InvalidRepositoryDescriptionException;
import software.amazon.awssdk.services.codecommit.model.InvalidRepositoryNameException;
import software.amazon.awssdk.services.codecommit.model.InvalidRepositoryTriggerBranchNameException;
import software.amazon.awssdk.services.codecommit.model.InvalidRepositoryTriggerCustomDataException;
import software.amazon.awssdk.services.codecommit.model.InvalidRepositoryTriggerDestinationArnException;
import software.amazon.awssdk.services.codecommit.model.InvalidRepositoryTriggerEventsException;
import software.amazon.awssdk.services.codecommit.model.InvalidRepositoryTriggerNameException;
import software.amazon.awssdk.services.codecommit.model.InvalidRepositoryTriggerRegionException;
import software.amazon.awssdk.services.codecommit.model.InvalidResourceArnException;
import software.amazon.awssdk.services.codecommit.model.InvalidRevisionIdException;
import software.amazon.awssdk.services.codecommit.model.InvalidRuleContentSha256Exception;
import software.amazon.awssdk.services.codecommit.model.InvalidSortByException;
import software.amazon.awssdk.services.codecommit.model.InvalidSourceCommitSpecifierException;
import software.amazon.awssdk.services.codecommit.model.InvalidSystemTagUsageException;
import software.amazon.awssdk.services.codecommit.model.InvalidTagKeysListException;
import software.amazon.awssdk.services.codecommit.model.InvalidTagsMapException;
import software.amazon.awssdk.services.codecommit.model.InvalidTargetBranchException;
import software.amazon.awssdk.services.codecommit.model.InvalidTargetException;
import software.amazon.awssdk.services.codecommit.model.InvalidTargetsException;
import software.amazon.awssdk.services.codecommit.model.InvalidTitleException;
import software.amazon.awssdk.services.codecommit.model.ListApprovalRuleTemplatesRequest;
import software.amazon.awssdk.services.codecommit.model.ListApprovalRuleTemplatesResponse;
import software.amazon.awssdk.services.codecommit.model.ListAssociatedApprovalRuleTemplatesForRepositoryRequest;
import software.amazon.awssdk.services.codecommit.model.ListAssociatedApprovalRuleTemplatesForRepositoryResponse;
import software.amazon.awssdk.services.codecommit.model.ListBranchesRequest;
import software.amazon.awssdk.services.codecommit.model.ListBranchesResponse;
import software.amazon.awssdk.services.codecommit.model.ListPullRequestsRequest;
import software.amazon.awssdk.services.codecommit.model.ListPullRequestsResponse;
import software.amazon.awssdk.services.codecommit.model.ListRepositoriesForApprovalRuleTemplateRequest;
import software.amazon.awssdk.services.codecommit.model.ListRepositoriesForApprovalRuleTemplateResponse;
import software.amazon.awssdk.services.codecommit.model.ListRepositoriesRequest;
import software.amazon.awssdk.services.codecommit.model.ListRepositoriesResponse;
import software.amazon.awssdk.services.codecommit.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.codecommit.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.codecommit.model.ManualMergeRequiredException;
import software.amazon.awssdk.services.codecommit.model.MaximumBranchesExceededException;
import software.amazon.awssdk.services.codecommit.model.MaximumConflictResolutionEntriesExceededException;
import software.amazon.awssdk.services.codecommit.model.MaximumFileContentToLoadExceededException;
import software.amazon.awssdk.services.codecommit.model.MaximumFileEntriesExceededException;
import software.amazon.awssdk.services.codecommit.model.MaximumItemsToCompareExceededException;
import software.amazon.awssdk.services.codecommit.model.MaximumNumberOfApprovalsExceededException;
import software.amazon.awssdk.services.codecommit.model.MaximumOpenPullRequestsExceededException;
import software.amazon.awssdk.services.codecommit.model.MaximumRepositoryNamesExceededException;
import software.amazon.awssdk.services.codecommit.model.MaximumRepositoryTriggersExceededException;
import software.amazon.awssdk.services.codecommit.model.MaximumRuleTemplatesAssociatedWithRepositoryException;
import software.amazon.awssdk.services.codecommit.model.MergeBranchesByFastForwardRequest;
import software.amazon.awssdk.services.codecommit.model.MergeBranchesByFastForwardResponse;
import software.amazon.awssdk.services.codecommit.model.MergeBranchesBySquashRequest;
import software.amazon.awssdk.services.codecommit.model.MergeBranchesBySquashResponse;
import software.amazon.awssdk.services.codecommit.model.MergeBranchesByThreeWayRequest;
import software.amazon.awssdk.services.codecommit.model.MergeBranchesByThreeWayResponse;
import software.amazon.awssdk.services.codecommit.model.MergeOptionRequiredException;
import software.amazon.awssdk.services.codecommit.model.MergePullRequestByFastForwardRequest;
import software.amazon.awssdk.services.codecommit.model.MergePullRequestByFastForwardResponse;
import software.amazon.awssdk.services.codecommit.model.MergePullRequestBySquashRequest;
import software.amazon.awssdk.services.codecommit.model.MergePullRequestBySquashResponse;
import software.amazon.awssdk.services.codecommit.model.MergePullRequestByThreeWayRequest;
import software.amazon.awssdk.services.codecommit.model.MergePullRequestByThreeWayResponse;
import software.amazon.awssdk.services.codecommit.model.MultipleConflictResolutionEntriesException;
import software.amazon.awssdk.services.codecommit.model.MultipleRepositoriesInPullRequestException;
import software.amazon.awssdk.services.codecommit.model.NameLengthExceededException;
import software.amazon.awssdk.services.codecommit.model.NoChangeException;
import software.amazon.awssdk.services.codecommit.model.NumberOfRuleTemplatesExceededException;
import software.amazon.awssdk.services.codecommit.model.NumberOfRulesExceededException;
import software.amazon.awssdk.services.codecommit.model.OverrideAlreadySetException;
import software.amazon.awssdk.services.codecommit.model.OverridePullRequestApprovalRulesRequest;
import software.amazon.awssdk.services.codecommit.model.OverridePullRequestApprovalRulesResponse;
import software.amazon.awssdk.services.codecommit.model.OverrideStatusRequiredException;
import software.amazon.awssdk.services.codecommit.model.ParentCommitDoesNotExistException;
import software.amazon.awssdk.services.codecommit.model.ParentCommitIdOutdatedException;
import software.amazon.awssdk.services.codecommit.model.ParentCommitIdRequiredException;
import software.amazon.awssdk.services.codecommit.model.PathDoesNotExistException;
import software.amazon.awssdk.services.codecommit.model.PathRequiredException;
import software.amazon.awssdk.services.codecommit.model.PostCommentForComparedCommitRequest;
import software.amazon.awssdk.services.codecommit.model.PostCommentForComparedCommitResponse;
import software.amazon.awssdk.services.codecommit.model.PostCommentForPullRequestRequest;
import software.amazon.awssdk.services.codecommit.model.PostCommentForPullRequestResponse;
import software.amazon.awssdk.services.codecommit.model.PostCommentReplyRequest;
import software.amazon.awssdk.services.codecommit.model.PostCommentReplyResponse;
import software.amazon.awssdk.services.codecommit.model.PullRequestAlreadyClosedException;
import software.amazon.awssdk.services.codecommit.model.PullRequestApprovalRulesNotSatisfiedException;
import software.amazon.awssdk.services.codecommit.model.PullRequestCannotBeApprovedByAuthorException;
import software.amazon.awssdk.services.codecommit.model.PullRequestDoesNotExistException;
import software.amazon.awssdk.services.codecommit.model.PullRequestIdRequiredException;
import software.amazon.awssdk.services.codecommit.model.PullRequestStatusRequiredException;
import software.amazon.awssdk.services.codecommit.model.PutCommentReactionRequest;
import software.amazon.awssdk.services.codecommit.model.PutCommentReactionResponse;
import software.amazon.awssdk.services.codecommit.model.PutFileEntryConflictException;
import software.amazon.awssdk.services.codecommit.model.PutFileRequest;
import software.amazon.awssdk.services.codecommit.model.PutFileResponse;
import software.amazon.awssdk.services.codecommit.model.PutRepositoryTriggersRequest;
import software.amazon.awssdk.services.codecommit.model.PutRepositoryTriggersResponse;
import software.amazon.awssdk.services.codecommit.model.ReactionLimitExceededException;
import software.amazon.awssdk.services.codecommit.model.ReactionValueRequiredException;
import software.amazon.awssdk.services.codecommit.model.ReferenceDoesNotExistException;
import software.amazon.awssdk.services.codecommit.model.ReferenceNameRequiredException;
import software.amazon.awssdk.services.codecommit.model.ReferenceTypeNotSupportedException;
import software.amazon.awssdk.services.codecommit.model.ReplacementContentRequiredException;
import software.amazon.awssdk.services.codecommit.model.ReplacementTypeRequiredException;
import software.amazon.awssdk.services.codecommit.model.RepositoryDoesNotExistException;
import software.amazon.awssdk.services.codecommit.model.RepositoryLimitExceededException;
import software.amazon.awssdk.services.codecommit.model.RepositoryNameExistsException;
import software.amazon.awssdk.services.codecommit.model.RepositoryNameRequiredException;
import software.amazon.awssdk.services.codecommit.model.RepositoryNamesRequiredException;
import software.amazon.awssdk.services.codecommit.model.RepositoryNotAssociatedWithPullRequestException;
import software.amazon.awssdk.services.codecommit.model.RepositoryTriggerBranchNameListRequiredException;
import software.amazon.awssdk.services.codecommit.model.RepositoryTriggerDestinationArnRequiredException;
import software.amazon.awssdk.services.codecommit.model.RepositoryTriggerEventsListRequiredException;
import software.amazon.awssdk.services.codecommit.model.RepositoryTriggerNameRequiredException;
import software.amazon.awssdk.services.codecommit.model.RepositoryTriggersListRequiredException;
import software.amazon.awssdk.services.codecommit.model.ResourceArnRequiredException;
import software.amazon.awssdk.services.codecommit.model.RestrictedSourceFileException;
import software.amazon.awssdk.services.codecommit.model.RevisionIdRequiredException;
import software.amazon.awssdk.services.codecommit.model.RevisionNotCurrentException;
import software.amazon.awssdk.services.codecommit.model.SameFileContentException;
import software.amazon.awssdk.services.codecommit.model.SamePathRequestException;
import software.amazon.awssdk.services.codecommit.model.SourceAndDestinationAreSameException;
import software.amazon.awssdk.services.codecommit.model.SourceFileOrContentRequiredException;
import software.amazon.awssdk.services.codecommit.model.TagKeysListRequiredException;
import software.amazon.awssdk.services.codecommit.model.TagPolicyException;
import software.amazon.awssdk.services.codecommit.model.TagResourceRequest;
import software.amazon.awssdk.services.codecommit.model.TagResourceResponse;
import software.amazon.awssdk.services.codecommit.model.TagsMapRequiredException;
import software.amazon.awssdk.services.codecommit.model.TargetRequiredException;
import software.amazon.awssdk.services.codecommit.model.TargetsRequiredException;
import software.amazon.awssdk.services.codecommit.model.TestRepositoryTriggersRequest;
import software.amazon.awssdk.services.codecommit.model.TestRepositoryTriggersResponse;
import software.amazon.awssdk.services.codecommit.model.TipOfSourceReferenceIsDifferentException;
import software.amazon.awssdk.services.codecommit.model.TipsDivergenceExceededException;
import software.amazon.awssdk.services.codecommit.model.TitleRequiredException;
import software.amazon.awssdk.services.codecommit.model.TooManyTagsException;
import software.amazon.awssdk.services.codecommit.model.UntagResourceRequest;
import software.amazon.awssdk.services.codecommit.model.UntagResourceResponse;
import software.amazon.awssdk.services.codecommit.model.UpdateApprovalRuleTemplateContentRequest;
import software.amazon.awssdk.services.codecommit.model.UpdateApprovalRuleTemplateContentResponse;
import software.amazon.awssdk.services.codecommit.model.UpdateApprovalRuleTemplateDescriptionRequest;
import software.amazon.awssdk.services.codecommit.model.UpdateApprovalRuleTemplateDescriptionResponse;
import software.amazon.awssdk.services.codecommit.model.UpdateApprovalRuleTemplateNameRequest;
import software.amazon.awssdk.services.codecommit.model.UpdateApprovalRuleTemplateNameResponse;
import software.amazon.awssdk.services.codecommit.model.UpdateCommentRequest;
import software.amazon.awssdk.services.codecommit.model.UpdateCommentResponse;
import software.amazon.awssdk.services.codecommit.model.UpdateDefaultBranchRequest;
import software.amazon.awssdk.services.codecommit.model.UpdateDefaultBranchResponse;
import software.amazon.awssdk.services.codecommit.model.UpdatePullRequestApprovalRuleContentRequest;
import software.amazon.awssdk.services.codecommit.model.UpdatePullRequestApprovalRuleContentResponse;
import software.amazon.awssdk.services.codecommit.model.UpdatePullRequestApprovalStateRequest;
import software.amazon.awssdk.services.codecommit.model.UpdatePullRequestApprovalStateResponse;
import software.amazon.awssdk.services.codecommit.model.UpdatePullRequestDescriptionRequest;
import software.amazon.awssdk.services.codecommit.model.UpdatePullRequestDescriptionResponse;
import software.amazon.awssdk.services.codecommit.model.UpdatePullRequestStatusRequest;
import software.amazon.awssdk.services.codecommit.model.UpdatePullRequestStatusResponse;
import software.amazon.awssdk.services.codecommit.model.UpdatePullRequestTitleRequest;
import software.amazon.awssdk.services.codecommit.model.UpdatePullRequestTitleResponse;
import software.amazon.awssdk.services.codecommit.model.UpdateRepositoryDescriptionRequest;
import software.amazon.awssdk.services.codecommit.model.UpdateRepositoryDescriptionResponse;
import software.amazon.awssdk.services.codecommit.model.UpdateRepositoryNameRequest;
import software.amazon.awssdk.services.codecommit.model.UpdateRepositoryNameResponse;
import software.amazon.awssdk.services.codecommit.paginators.DescribeMergeConflictsPublisher;
import software.amazon.awssdk.services.codecommit.paginators.DescribePullRequestEventsPublisher;
import software.amazon.awssdk.services.codecommit.paginators.GetCommentReactionsPublisher;
import software.amazon.awssdk.services.codecommit.paginators.GetCommentsForComparedCommitPublisher;
import software.amazon.awssdk.services.codecommit.paginators.GetCommentsForPullRequestPublisher;
import software.amazon.awssdk.services.codecommit.paginators.GetDifferencesPublisher;
import software.amazon.awssdk.services.codecommit.paginators.GetMergeConflictsPublisher;
import software.amazon.awssdk.services.codecommit.paginators.ListApprovalRuleTemplatesPublisher;
import software.amazon.awssdk.services.codecommit.paginators.ListAssociatedApprovalRuleTemplatesForRepositoryPublisher;
import software.amazon.awssdk.services.codecommit.paginators.ListBranchesPublisher;
import software.amazon.awssdk.services.codecommit.paginators.ListPullRequestsPublisher;
import software.amazon.awssdk.services.codecommit.paginators.ListRepositoriesForApprovalRuleTemplatePublisher;
import software.amazon.awssdk.services.codecommit.paginators.ListRepositoriesPublisher;
import software.amazon.awssdk.services.codecommit.transform.AssociateApprovalRuleTemplateWithRepositoryRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.BatchAssociateApprovalRuleTemplateWithRepositoriesRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.BatchDescribeMergeConflictsRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.BatchDisassociateApprovalRuleTemplateFromRepositoriesRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.BatchGetCommitsRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.BatchGetRepositoriesRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.CreateApprovalRuleTemplateRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.CreateBranchRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.CreateCommitRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.CreatePullRequestApprovalRuleRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.CreatePullRequestRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.CreateRepositoryRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.CreateUnreferencedMergeCommitRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.DeleteApprovalRuleTemplateRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.DeleteBranchRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.DeleteCommentContentRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.DeleteFileRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.DeletePullRequestApprovalRuleRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.DeleteRepositoryRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.DescribeMergeConflictsRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.DescribePullRequestEventsRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.DisassociateApprovalRuleTemplateFromRepositoryRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.EvaluatePullRequestApprovalRulesRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.GetApprovalRuleTemplateRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.GetBlobRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.GetBranchRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.GetCommentReactionsRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.GetCommentRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.GetCommentsForComparedCommitRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.GetCommentsForPullRequestRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.GetCommitRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.GetDifferencesRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.GetFileRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.GetFolderRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.GetMergeCommitRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.GetMergeConflictsRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.GetMergeOptionsRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.GetPullRequestApprovalStatesRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.GetPullRequestOverrideStateRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.GetPullRequestRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.GetRepositoryRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.GetRepositoryTriggersRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.ListApprovalRuleTemplatesRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.ListAssociatedApprovalRuleTemplatesForRepositoryRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.ListBranchesRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.ListPullRequestsRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.ListRepositoriesForApprovalRuleTemplateRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.ListRepositoriesRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.MergeBranchesByFastForwardRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.MergeBranchesBySquashRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.MergeBranchesByThreeWayRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.MergePullRequestByFastForwardRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.MergePullRequestBySquashRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.MergePullRequestByThreeWayRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.OverridePullRequestApprovalRulesRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.PostCommentForComparedCommitRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.PostCommentForPullRequestRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.PostCommentReplyRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.PutCommentReactionRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.PutFileRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.PutRepositoryTriggersRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.TestRepositoryTriggersRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.UpdateApprovalRuleTemplateContentRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.UpdateApprovalRuleTemplateDescriptionRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.UpdateApprovalRuleTemplateNameRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.UpdateCommentRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.UpdateDefaultBranchRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.UpdatePullRequestApprovalRuleContentRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.UpdatePullRequestApprovalStateRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.UpdatePullRequestDescriptionRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.UpdatePullRequestStatusRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.UpdatePullRequestTitleRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.UpdateRepositoryDescriptionRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.UpdateRepositoryNameRequestMarshaller;
import software.amazon.awssdk.utils.CompletableFutureUtils;

@SdkInternalApi
final class DefaultCodeCommitAsyncClient
implements CodeCommitAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultCodeCommitAsyncClient.class);
    private final AsyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;
    private final CodeCommitServiceClientConfiguration serviceClientConfiguration;

    protected DefaultCodeCommitAsyncClient(CodeCommitServiceClientConfiguration serviceClientConfiguration, SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.serviceClientConfiguration = serviceClientConfiguration;
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    @Override
    public CompletableFuture<AssociateApprovalRuleTemplateWithRepositoryResponse> associateApprovalRuleTemplateWithRepository(AssociateApprovalRuleTemplateWithRepositoryRequest associateApprovalRuleTemplateWithRepositoryRequest) {
        List<MetricPublisher> metricPublishers = DefaultCodeCommitAsyncClient.resolveMetricPublishers(this.clientConfiguration, associateApprovalRuleTemplateWithRepositoryRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeCommit");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AssociateApprovalRuleTemplateWithRepository");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AssociateApprovalRuleTemplateWithRepositoryResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("AssociateApprovalRuleTemplateWithRepository").withMarshaller((Marshaller)new AssociateApprovalRuleTemplateWithRepositoryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)associateApprovalRuleTemplateWithRepositoryRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodeCommitAsyncClient.lambda$associateApprovalRuleTemplateWithRepository$1(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodeCommitAsyncClient.lambda$associateApprovalRuleTemplateWithRepository$2((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<BatchAssociateApprovalRuleTemplateWithRepositoriesResponse> batchAssociateApprovalRuleTemplateWithRepositories(BatchAssociateApprovalRuleTemplateWithRepositoriesRequest batchAssociateApprovalRuleTemplateWithRepositoriesRequest) {
        List<MetricPublisher> metricPublishers = DefaultCodeCommitAsyncClient.resolveMetricPublishers(this.clientConfiguration, batchAssociateApprovalRuleTemplateWithRepositoriesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeCommit");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"BatchAssociateApprovalRuleTemplateWithRepositories");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchAssociateApprovalRuleTemplateWithRepositoriesResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchAssociateApprovalRuleTemplateWithRepositories").withMarshaller((Marshaller)new BatchAssociateApprovalRuleTemplateWithRepositoriesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)batchAssociateApprovalRuleTemplateWithRepositoriesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodeCommitAsyncClient.lambda$batchAssociateApprovalRuleTemplateWithRepositories$4(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodeCommitAsyncClient.lambda$batchAssociateApprovalRuleTemplateWithRepositories$5((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<BatchDescribeMergeConflictsResponse> batchDescribeMergeConflicts(BatchDescribeMergeConflictsRequest batchDescribeMergeConflictsRequest) {
        List<MetricPublisher> metricPublishers = DefaultCodeCommitAsyncClient.resolveMetricPublishers(this.clientConfiguration, batchDescribeMergeConflictsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeCommit");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"BatchDescribeMergeConflicts");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchDescribeMergeConflictsResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchDescribeMergeConflicts").withMarshaller((Marshaller)new BatchDescribeMergeConflictsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)batchDescribeMergeConflictsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodeCommitAsyncClient.lambda$batchDescribeMergeConflicts$7(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodeCommitAsyncClient.lambda$batchDescribeMergeConflicts$8((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<BatchDisassociateApprovalRuleTemplateFromRepositoriesResponse> batchDisassociateApprovalRuleTemplateFromRepositories(BatchDisassociateApprovalRuleTemplateFromRepositoriesRequest batchDisassociateApprovalRuleTemplateFromRepositoriesRequest) {
        List<MetricPublisher> metricPublishers = DefaultCodeCommitAsyncClient.resolveMetricPublishers(this.clientConfiguration, batchDisassociateApprovalRuleTemplateFromRepositoriesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeCommit");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"BatchDisassociateApprovalRuleTemplateFromRepositories");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchDisassociateApprovalRuleTemplateFromRepositoriesResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchDisassociateApprovalRuleTemplateFromRepositories").withMarshaller((Marshaller)new BatchDisassociateApprovalRuleTemplateFromRepositoriesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)batchDisassociateApprovalRuleTemplateFromRepositoriesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodeCommitAsyncClient.lambda$batchDisassociateApprovalRuleTemplateFromRepositories$10(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodeCommitAsyncClient.lambda$batchDisassociateApprovalRuleTemplateFromRepositories$11((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<BatchGetCommitsResponse> batchGetCommits(BatchGetCommitsRequest batchGetCommitsRequest) {
        List<MetricPublisher> metricPublishers = DefaultCodeCommitAsyncClient.resolveMetricPublishers(this.clientConfiguration, batchGetCommitsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeCommit");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"BatchGetCommits");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchGetCommitsResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchGetCommits").withMarshaller((Marshaller)new BatchGetCommitsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)batchGetCommitsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodeCommitAsyncClient.lambda$batchGetCommits$13(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodeCommitAsyncClient.lambda$batchGetCommits$14((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<BatchGetRepositoriesResponse> batchGetRepositories(BatchGetRepositoriesRequest batchGetRepositoriesRequest) {
        List<MetricPublisher> metricPublishers = DefaultCodeCommitAsyncClient.resolveMetricPublishers(this.clientConfiguration, batchGetRepositoriesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeCommit");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"BatchGetRepositories");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchGetRepositoriesResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchGetRepositories").withMarshaller((Marshaller)new BatchGetRepositoriesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)batchGetRepositoriesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodeCommitAsyncClient.lambda$batchGetRepositories$16(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodeCommitAsyncClient.lambda$batchGetRepositories$17((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateApprovalRuleTemplateResponse> createApprovalRuleTemplate(CreateApprovalRuleTemplateRequest createApprovalRuleTemplateRequest) {
        List<MetricPublisher> metricPublishers = DefaultCodeCommitAsyncClient.resolveMetricPublishers(this.clientConfiguration, createApprovalRuleTemplateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeCommit");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateApprovalRuleTemplate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateApprovalRuleTemplateResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateApprovalRuleTemplate").withMarshaller((Marshaller)new CreateApprovalRuleTemplateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createApprovalRuleTemplateRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodeCommitAsyncClient.lambda$createApprovalRuleTemplate$19(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodeCommitAsyncClient.lambda$createApprovalRuleTemplate$20((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateBranchResponse> createBranch(CreateBranchRequest createBranchRequest) {
        List<MetricPublisher> metricPublishers = DefaultCodeCommitAsyncClient.resolveMetricPublishers(this.clientConfiguration, createBranchRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeCommit");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateBranch");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateBranchResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateBranch").withMarshaller((Marshaller)new CreateBranchRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createBranchRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodeCommitAsyncClient.lambda$createBranch$22(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodeCommitAsyncClient.lambda$createBranch$23((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateCommitResponse> createCommit(CreateCommitRequest createCommitRequest) {
        List<MetricPublisher> metricPublishers = DefaultCodeCommitAsyncClient.resolveMetricPublishers(this.clientConfiguration, createCommitRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeCommit");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateCommit");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateCommitResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateCommit").withMarshaller((Marshaller)new CreateCommitRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createCommitRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodeCommitAsyncClient.lambda$createCommit$25(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodeCommitAsyncClient.lambda$createCommit$26((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreatePullRequestResponse> createPullRequest(CreatePullRequestRequest createPullRequestRequest) {
        List<MetricPublisher> metricPublishers = DefaultCodeCommitAsyncClient.resolveMetricPublishers(this.clientConfiguration, createPullRequestRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeCommit");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreatePullRequest");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreatePullRequestResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreatePullRequest").withMarshaller((Marshaller)new CreatePullRequestRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createPullRequestRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodeCommitAsyncClient.lambda$createPullRequest$28(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodeCommitAsyncClient.lambda$createPullRequest$29((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreatePullRequestApprovalRuleResponse> createPullRequestApprovalRule(CreatePullRequestApprovalRuleRequest createPullRequestApprovalRuleRequest) {
        List<MetricPublisher> metricPublishers = DefaultCodeCommitAsyncClient.resolveMetricPublishers(this.clientConfiguration, createPullRequestApprovalRuleRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeCommit");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreatePullRequestApprovalRule");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreatePullRequestApprovalRuleResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreatePullRequestApprovalRule").withMarshaller((Marshaller)new CreatePullRequestApprovalRuleRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createPullRequestApprovalRuleRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodeCommitAsyncClient.lambda$createPullRequestApprovalRule$31(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodeCommitAsyncClient.lambda$createPullRequestApprovalRule$32((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateRepositoryResponse> createRepository(CreateRepositoryRequest createRepositoryRequest) {
        List<MetricPublisher> metricPublishers = DefaultCodeCommitAsyncClient.resolveMetricPublishers(this.clientConfiguration, createRepositoryRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeCommit");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateRepository");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateRepositoryResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateRepository").withMarshaller((Marshaller)new CreateRepositoryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createRepositoryRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodeCommitAsyncClient.lambda$createRepository$34(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodeCommitAsyncClient.lambda$createRepository$35((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateUnreferencedMergeCommitResponse> createUnreferencedMergeCommit(CreateUnreferencedMergeCommitRequest createUnreferencedMergeCommitRequest) {
        List<MetricPublisher> metricPublishers = DefaultCodeCommitAsyncClient.resolveMetricPublishers(this.clientConfiguration, createUnreferencedMergeCommitRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeCommit");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateUnreferencedMergeCommit");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateUnreferencedMergeCommitResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateUnreferencedMergeCommit").withMarshaller((Marshaller)new CreateUnreferencedMergeCommitRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createUnreferencedMergeCommitRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodeCommitAsyncClient.lambda$createUnreferencedMergeCommit$37(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodeCommitAsyncClient.lambda$createUnreferencedMergeCommit$38((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteApprovalRuleTemplateResponse> deleteApprovalRuleTemplate(DeleteApprovalRuleTemplateRequest deleteApprovalRuleTemplateRequest) {
        List<MetricPublisher> metricPublishers = DefaultCodeCommitAsyncClient.resolveMetricPublishers(this.clientConfiguration, deleteApprovalRuleTemplateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeCommit");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteApprovalRuleTemplate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteApprovalRuleTemplateResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteApprovalRuleTemplate").withMarshaller((Marshaller)new DeleteApprovalRuleTemplateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteApprovalRuleTemplateRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodeCommitAsyncClient.lambda$deleteApprovalRuleTemplate$40(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodeCommitAsyncClient.lambda$deleteApprovalRuleTemplate$41((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteBranchResponse> deleteBranch(DeleteBranchRequest deleteBranchRequest) {
        List<MetricPublisher> metricPublishers = DefaultCodeCommitAsyncClient.resolveMetricPublishers(this.clientConfiguration, deleteBranchRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeCommit");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteBranch");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteBranchResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteBranch").withMarshaller((Marshaller)new DeleteBranchRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteBranchRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodeCommitAsyncClient.lambda$deleteBranch$43(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodeCommitAsyncClient.lambda$deleteBranch$44((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteCommentContentResponse> deleteCommentContent(DeleteCommentContentRequest deleteCommentContentRequest) {
        List<MetricPublisher> metricPublishers = DefaultCodeCommitAsyncClient.resolveMetricPublishers(this.clientConfiguration, deleteCommentContentRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeCommit");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteCommentContent");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteCommentContentResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteCommentContent").withMarshaller((Marshaller)new DeleteCommentContentRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteCommentContentRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodeCommitAsyncClient.lambda$deleteCommentContent$46(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodeCommitAsyncClient.lambda$deleteCommentContent$47((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteFileResponse> deleteFile(DeleteFileRequest deleteFileRequest) {
        List<MetricPublisher> metricPublishers = DefaultCodeCommitAsyncClient.resolveMetricPublishers(this.clientConfiguration, deleteFileRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeCommit");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteFile");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteFileResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteFile").withMarshaller((Marshaller)new DeleteFileRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteFileRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodeCommitAsyncClient.lambda$deleteFile$49(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodeCommitAsyncClient.lambda$deleteFile$50((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeletePullRequestApprovalRuleResponse> deletePullRequestApprovalRule(DeletePullRequestApprovalRuleRequest deletePullRequestApprovalRuleRequest) {
        List<MetricPublisher> metricPublishers = DefaultCodeCommitAsyncClient.resolveMetricPublishers(this.clientConfiguration, deletePullRequestApprovalRuleRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeCommit");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeletePullRequestApprovalRule");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeletePullRequestApprovalRuleResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeletePullRequestApprovalRule").withMarshaller((Marshaller)new DeletePullRequestApprovalRuleRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deletePullRequestApprovalRuleRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodeCommitAsyncClient.lambda$deletePullRequestApprovalRule$52(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodeCommitAsyncClient.lambda$deletePullRequestApprovalRule$53((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteRepositoryResponse> deleteRepository(DeleteRepositoryRequest deleteRepositoryRequest) {
        List<MetricPublisher> metricPublishers = DefaultCodeCommitAsyncClient.resolveMetricPublishers(this.clientConfiguration, deleteRepositoryRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeCommit");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteRepository");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteRepositoryResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteRepository").withMarshaller((Marshaller)new DeleteRepositoryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteRepositoryRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodeCommitAsyncClient.lambda$deleteRepository$55(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodeCommitAsyncClient.lambda$deleteRepository$56((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeMergeConflictsResponse> describeMergeConflicts(DescribeMergeConflictsRequest describeMergeConflictsRequest) {
        List<MetricPublisher> metricPublishers = DefaultCodeCommitAsyncClient.resolveMetricPublishers(this.clientConfiguration, describeMergeConflictsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeCommit");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeMergeConflicts");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeMergeConflictsResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeMergeConflicts").withMarshaller((Marshaller)new DescribeMergeConflictsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeMergeConflictsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodeCommitAsyncClient.lambda$describeMergeConflicts$58(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodeCommitAsyncClient.lambda$describeMergeConflicts$59((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public DescribeMergeConflictsPublisher describeMergeConflictsPaginator(DescribeMergeConflictsRequest describeMergeConflictsRequest) {
        return new DescribeMergeConflictsPublisher(this, this.applyPaginatorUserAgent(describeMergeConflictsRequest));
    }

    @Override
    public CompletableFuture<DescribePullRequestEventsResponse> describePullRequestEvents(DescribePullRequestEventsRequest describePullRequestEventsRequest) {
        List<MetricPublisher> metricPublishers = DefaultCodeCommitAsyncClient.resolveMetricPublishers(this.clientConfiguration, describePullRequestEventsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeCommit");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribePullRequestEvents");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribePullRequestEventsResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribePullRequestEvents").withMarshaller((Marshaller)new DescribePullRequestEventsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describePullRequestEventsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodeCommitAsyncClient.lambda$describePullRequestEvents$61(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodeCommitAsyncClient.lambda$describePullRequestEvents$62((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public DescribePullRequestEventsPublisher describePullRequestEventsPaginator(DescribePullRequestEventsRequest describePullRequestEventsRequest) {
        return new DescribePullRequestEventsPublisher(this, this.applyPaginatorUserAgent(describePullRequestEventsRequest));
    }

    @Override
    public CompletableFuture<DisassociateApprovalRuleTemplateFromRepositoryResponse> disassociateApprovalRuleTemplateFromRepository(DisassociateApprovalRuleTemplateFromRepositoryRequest disassociateApprovalRuleTemplateFromRepositoryRequest) {
        List<MetricPublisher> metricPublishers = DefaultCodeCommitAsyncClient.resolveMetricPublishers(this.clientConfiguration, disassociateApprovalRuleTemplateFromRepositoryRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeCommit");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DisassociateApprovalRuleTemplateFromRepository");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DisassociateApprovalRuleTemplateFromRepositoryResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DisassociateApprovalRuleTemplateFromRepository").withMarshaller((Marshaller)new DisassociateApprovalRuleTemplateFromRepositoryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)disassociateApprovalRuleTemplateFromRepositoryRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodeCommitAsyncClient.lambda$disassociateApprovalRuleTemplateFromRepository$64(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodeCommitAsyncClient.lambda$disassociateApprovalRuleTemplateFromRepository$65((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<EvaluatePullRequestApprovalRulesResponse> evaluatePullRequestApprovalRules(EvaluatePullRequestApprovalRulesRequest evaluatePullRequestApprovalRulesRequest) {
        List<MetricPublisher> metricPublishers = DefaultCodeCommitAsyncClient.resolveMetricPublishers(this.clientConfiguration, evaluatePullRequestApprovalRulesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeCommit");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"EvaluatePullRequestApprovalRules");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, EvaluatePullRequestApprovalRulesResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("EvaluatePullRequestApprovalRules").withMarshaller((Marshaller)new EvaluatePullRequestApprovalRulesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)evaluatePullRequestApprovalRulesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodeCommitAsyncClient.lambda$evaluatePullRequestApprovalRules$67(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodeCommitAsyncClient.lambda$evaluatePullRequestApprovalRules$68((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetApprovalRuleTemplateResponse> getApprovalRuleTemplate(GetApprovalRuleTemplateRequest getApprovalRuleTemplateRequest) {
        List<MetricPublisher> metricPublishers = DefaultCodeCommitAsyncClient.resolveMetricPublishers(this.clientConfiguration, getApprovalRuleTemplateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeCommit");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetApprovalRuleTemplate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetApprovalRuleTemplateResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetApprovalRuleTemplate").withMarshaller((Marshaller)new GetApprovalRuleTemplateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getApprovalRuleTemplateRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodeCommitAsyncClient.lambda$getApprovalRuleTemplate$70(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodeCommitAsyncClient.lambda$getApprovalRuleTemplate$71((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetBlobResponse> getBlob(GetBlobRequest getBlobRequest) {
        List<MetricPublisher> metricPublishers = DefaultCodeCommitAsyncClient.resolveMetricPublishers(this.clientConfiguration, getBlobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeCommit");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetBlob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetBlobResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetBlob").withMarshaller((Marshaller)new GetBlobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getBlobRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodeCommitAsyncClient.lambda$getBlob$73(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodeCommitAsyncClient.lambda$getBlob$74((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetBranchResponse> getBranch(GetBranchRequest getBranchRequest) {
        List<MetricPublisher> metricPublishers = DefaultCodeCommitAsyncClient.resolveMetricPublishers(this.clientConfiguration, getBranchRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeCommit");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetBranch");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetBranchResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetBranch").withMarshaller((Marshaller)new GetBranchRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getBranchRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodeCommitAsyncClient.lambda$getBranch$76(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodeCommitAsyncClient.lambda$getBranch$77((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetCommentResponse> getComment(GetCommentRequest getCommentRequest) {
        List<MetricPublisher> metricPublishers = DefaultCodeCommitAsyncClient.resolveMetricPublishers(this.clientConfiguration, getCommentRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeCommit");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetComment");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetCommentResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetComment").withMarshaller((Marshaller)new GetCommentRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getCommentRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodeCommitAsyncClient.lambda$getComment$79(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodeCommitAsyncClient.lambda$getComment$80((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetCommentReactionsResponse> getCommentReactions(GetCommentReactionsRequest getCommentReactionsRequest) {
        List<MetricPublisher> metricPublishers = DefaultCodeCommitAsyncClient.resolveMetricPublishers(this.clientConfiguration, getCommentReactionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeCommit");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetCommentReactions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetCommentReactionsResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetCommentReactions").withMarshaller((Marshaller)new GetCommentReactionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getCommentReactionsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodeCommitAsyncClient.lambda$getCommentReactions$82(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodeCommitAsyncClient.lambda$getCommentReactions$83((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public GetCommentReactionsPublisher getCommentReactionsPaginator(GetCommentReactionsRequest getCommentReactionsRequest) {
        return new GetCommentReactionsPublisher(this, this.applyPaginatorUserAgent(getCommentReactionsRequest));
    }

    @Override
    public CompletableFuture<GetCommentsForComparedCommitResponse> getCommentsForComparedCommit(GetCommentsForComparedCommitRequest getCommentsForComparedCommitRequest) {
        List<MetricPublisher> metricPublishers = DefaultCodeCommitAsyncClient.resolveMetricPublishers(this.clientConfiguration, getCommentsForComparedCommitRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeCommit");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetCommentsForComparedCommit");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetCommentsForComparedCommitResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetCommentsForComparedCommit").withMarshaller((Marshaller)new GetCommentsForComparedCommitRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getCommentsForComparedCommitRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodeCommitAsyncClient.lambda$getCommentsForComparedCommit$85(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodeCommitAsyncClient.lambda$getCommentsForComparedCommit$86((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public GetCommentsForComparedCommitPublisher getCommentsForComparedCommitPaginator(GetCommentsForComparedCommitRequest getCommentsForComparedCommitRequest) {
        return new GetCommentsForComparedCommitPublisher(this, this.applyPaginatorUserAgent(getCommentsForComparedCommitRequest));
    }

    @Override
    public CompletableFuture<GetCommentsForPullRequestResponse> getCommentsForPullRequest(GetCommentsForPullRequestRequest getCommentsForPullRequestRequest) {
        List<MetricPublisher> metricPublishers = DefaultCodeCommitAsyncClient.resolveMetricPublishers(this.clientConfiguration, getCommentsForPullRequestRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeCommit");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetCommentsForPullRequest");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetCommentsForPullRequestResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetCommentsForPullRequest").withMarshaller((Marshaller)new GetCommentsForPullRequestRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getCommentsForPullRequestRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodeCommitAsyncClient.lambda$getCommentsForPullRequest$88(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodeCommitAsyncClient.lambda$getCommentsForPullRequest$89((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public GetCommentsForPullRequestPublisher getCommentsForPullRequestPaginator(GetCommentsForPullRequestRequest getCommentsForPullRequestRequest) {
        return new GetCommentsForPullRequestPublisher(this, this.applyPaginatorUserAgent(getCommentsForPullRequestRequest));
    }

    @Override
    public CompletableFuture<GetCommitResponse> getCommit(GetCommitRequest getCommitRequest) {
        List<MetricPublisher> metricPublishers = DefaultCodeCommitAsyncClient.resolveMetricPublishers(this.clientConfiguration, getCommitRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeCommit");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetCommit");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetCommitResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetCommit").withMarshaller((Marshaller)new GetCommitRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getCommitRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodeCommitAsyncClient.lambda$getCommit$91(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodeCommitAsyncClient.lambda$getCommit$92((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetDifferencesResponse> getDifferences(GetDifferencesRequest getDifferencesRequest) {
        List<MetricPublisher> metricPublishers = DefaultCodeCommitAsyncClient.resolveMetricPublishers(this.clientConfiguration, getDifferencesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeCommit");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetDifferences");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetDifferencesResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetDifferences").withMarshaller((Marshaller)new GetDifferencesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getDifferencesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodeCommitAsyncClient.lambda$getDifferences$94(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodeCommitAsyncClient.lambda$getDifferences$95((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public GetDifferencesPublisher getDifferencesPaginator(GetDifferencesRequest getDifferencesRequest) {
        return new GetDifferencesPublisher(this, this.applyPaginatorUserAgent(getDifferencesRequest));
    }

    @Override
    public CompletableFuture<GetFileResponse> getFile(GetFileRequest getFileRequest) {
        List<MetricPublisher> metricPublishers = DefaultCodeCommitAsyncClient.resolveMetricPublishers(this.clientConfiguration, getFileRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeCommit");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetFile");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetFileResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetFile").withMarshaller((Marshaller)new GetFileRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getFileRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodeCommitAsyncClient.lambda$getFile$97(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodeCommitAsyncClient.lambda$getFile$98((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetFolderResponse> getFolder(GetFolderRequest getFolderRequest) {
        List<MetricPublisher> metricPublishers = DefaultCodeCommitAsyncClient.resolveMetricPublishers(this.clientConfiguration, getFolderRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeCommit");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetFolder");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetFolderResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetFolder").withMarshaller((Marshaller)new GetFolderRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getFolderRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodeCommitAsyncClient.lambda$getFolder$100(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodeCommitAsyncClient.lambda$getFolder$101((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetMergeCommitResponse> getMergeCommit(GetMergeCommitRequest getMergeCommitRequest) {
        List<MetricPublisher> metricPublishers = DefaultCodeCommitAsyncClient.resolveMetricPublishers(this.clientConfiguration, getMergeCommitRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeCommit");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetMergeCommit");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetMergeCommitResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetMergeCommit").withMarshaller((Marshaller)new GetMergeCommitRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getMergeCommitRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodeCommitAsyncClient.lambda$getMergeCommit$103(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodeCommitAsyncClient.lambda$getMergeCommit$104((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetMergeConflictsResponse> getMergeConflicts(GetMergeConflictsRequest getMergeConflictsRequest) {
        List<MetricPublisher> metricPublishers = DefaultCodeCommitAsyncClient.resolveMetricPublishers(this.clientConfiguration, getMergeConflictsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeCommit");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetMergeConflicts");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetMergeConflictsResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetMergeConflicts").withMarshaller((Marshaller)new GetMergeConflictsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getMergeConflictsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodeCommitAsyncClient.lambda$getMergeConflicts$106(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodeCommitAsyncClient.lambda$getMergeConflicts$107((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public GetMergeConflictsPublisher getMergeConflictsPaginator(GetMergeConflictsRequest getMergeConflictsRequest) {
        return new GetMergeConflictsPublisher(this, this.applyPaginatorUserAgent(getMergeConflictsRequest));
    }

    @Override
    public CompletableFuture<GetMergeOptionsResponse> getMergeOptions(GetMergeOptionsRequest getMergeOptionsRequest) {
        List<MetricPublisher> metricPublishers = DefaultCodeCommitAsyncClient.resolveMetricPublishers(this.clientConfiguration, getMergeOptionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeCommit");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetMergeOptions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetMergeOptionsResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetMergeOptions").withMarshaller((Marshaller)new GetMergeOptionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getMergeOptionsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodeCommitAsyncClient.lambda$getMergeOptions$109(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodeCommitAsyncClient.lambda$getMergeOptions$110((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetPullRequestResponse> getPullRequest(GetPullRequestRequest getPullRequestRequest) {
        List<MetricPublisher> metricPublishers = DefaultCodeCommitAsyncClient.resolveMetricPublishers(this.clientConfiguration, getPullRequestRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeCommit");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetPullRequest");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetPullRequestResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetPullRequest").withMarshaller((Marshaller)new GetPullRequestRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getPullRequestRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodeCommitAsyncClient.lambda$getPullRequest$112(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodeCommitAsyncClient.lambda$getPullRequest$113((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetPullRequestApprovalStatesResponse> getPullRequestApprovalStates(GetPullRequestApprovalStatesRequest getPullRequestApprovalStatesRequest) {
        List<MetricPublisher> metricPublishers = DefaultCodeCommitAsyncClient.resolveMetricPublishers(this.clientConfiguration, getPullRequestApprovalStatesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeCommit");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetPullRequestApprovalStates");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetPullRequestApprovalStatesResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetPullRequestApprovalStates").withMarshaller((Marshaller)new GetPullRequestApprovalStatesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getPullRequestApprovalStatesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodeCommitAsyncClient.lambda$getPullRequestApprovalStates$115(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodeCommitAsyncClient.lambda$getPullRequestApprovalStates$116((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetPullRequestOverrideStateResponse> getPullRequestOverrideState(GetPullRequestOverrideStateRequest getPullRequestOverrideStateRequest) {
        List<MetricPublisher> metricPublishers = DefaultCodeCommitAsyncClient.resolveMetricPublishers(this.clientConfiguration, getPullRequestOverrideStateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeCommit");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetPullRequestOverrideState");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetPullRequestOverrideStateResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetPullRequestOverrideState").withMarshaller((Marshaller)new GetPullRequestOverrideStateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getPullRequestOverrideStateRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodeCommitAsyncClient.lambda$getPullRequestOverrideState$118(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodeCommitAsyncClient.lambda$getPullRequestOverrideState$119((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetRepositoryResponse> getRepository(GetRepositoryRequest getRepositoryRequest) {
        List<MetricPublisher> metricPublishers = DefaultCodeCommitAsyncClient.resolveMetricPublishers(this.clientConfiguration, getRepositoryRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeCommit");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetRepository");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetRepositoryResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetRepository").withMarshaller((Marshaller)new GetRepositoryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getRepositoryRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodeCommitAsyncClient.lambda$getRepository$121(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodeCommitAsyncClient.lambda$getRepository$122((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetRepositoryTriggersResponse> getRepositoryTriggers(GetRepositoryTriggersRequest getRepositoryTriggersRequest) {
        List<MetricPublisher> metricPublishers = DefaultCodeCommitAsyncClient.resolveMetricPublishers(this.clientConfiguration, getRepositoryTriggersRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeCommit");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetRepositoryTriggers");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetRepositoryTriggersResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetRepositoryTriggers").withMarshaller((Marshaller)new GetRepositoryTriggersRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getRepositoryTriggersRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodeCommitAsyncClient.lambda$getRepositoryTriggers$124(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodeCommitAsyncClient.lambda$getRepositoryTriggers$125((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListApprovalRuleTemplatesResponse> listApprovalRuleTemplates(ListApprovalRuleTemplatesRequest listApprovalRuleTemplatesRequest) {
        List<MetricPublisher> metricPublishers = DefaultCodeCommitAsyncClient.resolveMetricPublishers(this.clientConfiguration, listApprovalRuleTemplatesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeCommit");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListApprovalRuleTemplates");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListApprovalRuleTemplatesResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListApprovalRuleTemplates").withMarshaller((Marshaller)new ListApprovalRuleTemplatesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listApprovalRuleTemplatesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodeCommitAsyncClient.lambda$listApprovalRuleTemplates$127(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodeCommitAsyncClient.lambda$listApprovalRuleTemplates$128((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public ListApprovalRuleTemplatesPublisher listApprovalRuleTemplatesPaginator(ListApprovalRuleTemplatesRequest listApprovalRuleTemplatesRequest) {
        return new ListApprovalRuleTemplatesPublisher(this, this.applyPaginatorUserAgent(listApprovalRuleTemplatesRequest));
    }

    @Override
    public CompletableFuture<ListAssociatedApprovalRuleTemplatesForRepositoryResponse> listAssociatedApprovalRuleTemplatesForRepository(ListAssociatedApprovalRuleTemplatesForRepositoryRequest listAssociatedApprovalRuleTemplatesForRepositoryRequest) {
        List<MetricPublisher> metricPublishers = DefaultCodeCommitAsyncClient.resolveMetricPublishers(this.clientConfiguration, listAssociatedApprovalRuleTemplatesForRepositoryRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeCommit");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListAssociatedApprovalRuleTemplatesForRepository");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListAssociatedApprovalRuleTemplatesForRepositoryResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListAssociatedApprovalRuleTemplatesForRepository").withMarshaller((Marshaller)new ListAssociatedApprovalRuleTemplatesForRepositoryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listAssociatedApprovalRuleTemplatesForRepositoryRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodeCommitAsyncClient.lambda$listAssociatedApprovalRuleTemplatesForRepository$130(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodeCommitAsyncClient.lambda$listAssociatedApprovalRuleTemplatesForRepository$131((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public ListAssociatedApprovalRuleTemplatesForRepositoryPublisher listAssociatedApprovalRuleTemplatesForRepositoryPaginator(ListAssociatedApprovalRuleTemplatesForRepositoryRequest listAssociatedApprovalRuleTemplatesForRepositoryRequest) {
        return new ListAssociatedApprovalRuleTemplatesForRepositoryPublisher(this, this.applyPaginatorUserAgent(listAssociatedApprovalRuleTemplatesForRepositoryRequest));
    }

    @Override
    public CompletableFuture<ListBranchesResponse> listBranches(ListBranchesRequest listBranchesRequest) {
        List<MetricPublisher> metricPublishers = DefaultCodeCommitAsyncClient.resolveMetricPublishers(this.clientConfiguration, listBranchesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeCommit");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListBranches");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListBranchesResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListBranches").withMarshaller((Marshaller)new ListBranchesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listBranchesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodeCommitAsyncClient.lambda$listBranches$133(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodeCommitAsyncClient.lambda$listBranches$134((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public ListBranchesPublisher listBranchesPaginator(ListBranchesRequest listBranchesRequest) {
        return new ListBranchesPublisher(this, this.applyPaginatorUserAgent(listBranchesRequest));
    }

    @Override
    public CompletableFuture<ListPullRequestsResponse> listPullRequests(ListPullRequestsRequest listPullRequestsRequest) {
        List<MetricPublisher> metricPublishers = DefaultCodeCommitAsyncClient.resolveMetricPublishers(this.clientConfiguration, listPullRequestsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeCommit");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListPullRequests");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListPullRequestsResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListPullRequests").withMarshaller((Marshaller)new ListPullRequestsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listPullRequestsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodeCommitAsyncClient.lambda$listPullRequests$136(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodeCommitAsyncClient.lambda$listPullRequests$137((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public ListPullRequestsPublisher listPullRequestsPaginator(ListPullRequestsRequest listPullRequestsRequest) {
        return new ListPullRequestsPublisher(this, this.applyPaginatorUserAgent(listPullRequestsRequest));
    }

    @Override
    public CompletableFuture<ListRepositoriesResponse> listRepositories(ListRepositoriesRequest listRepositoriesRequest) {
        List<MetricPublisher> metricPublishers = DefaultCodeCommitAsyncClient.resolveMetricPublishers(this.clientConfiguration, listRepositoriesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeCommit");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListRepositories");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListRepositoriesResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListRepositories").withMarshaller((Marshaller)new ListRepositoriesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listRepositoriesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodeCommitAsyncClient.lambda$listRepositories$139(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodeCommitAsyncClient.lambda$listRepositories$140((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListRepositoriesForApprovalRuleTemplateResponse> listRepositoriesForApprovalRuleTemplate(ListRepositoriesForApprovalRuleTemplateRequest listRepositoriesForApprovalRuleTemplateRequest) {
        List<MetricPublisher> metricPublishers = DefaultCodeCommitAsyncClient.resolveMetricPublishers(this.clientConfiguration, listRepositoriesForApprovalRuleTemplateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeCommit");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListRepositoriesForApprovalRuleTemplate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListRepositoriesForApprovalRuleTemplateResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListRepositoriesForApprovalRuleTemplate").withMarshaller((Marshaller)new ListRepositoriesForApprovalRuleTemplateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listRepositoriesForApprovalRuleTemplateRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodeCommitAsyncClient.lambda$listRepositoriesForApprovalRuleTemplate$142(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodeCommitAsyncClient.lambda$listRepositoriesForApprovalRuleTemplate$143((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public ListRepositoriesForApprovalRuleTemplatePublisher listRepositoriesForApprovalRuleTemplatePaginator(ListRepositoriesForApprovalRuleTemplateRequest listRepositoriesForApprovalRuleTemplateRequest) {
        return new ListRepositoriesForApprovalRuleTemplatePublisher(this, this.applyPaginatorUserAgent(listRepositoriesForApprovalRuleTemplateRequest));
    }

    @Override
    public ListRepositoriesPublisher listRepositoriesPaginator(ListRepositoriesRequest listRepositoriesRequest) {
        return new ListRepositoriesPublisher(this, this.applyPaginatorUserAgent(listRepositoriesRequest));
    }

    @Override
    public CompletableFuture<ListTagsForResourceResponse> listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) {
        List<MetricPublisher> metricPublishers = DefaultCodeCommitAsyncClient.resolveMetricPublishers(this.clientConfiguration, listTagsForResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeCommit");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTagsForResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsForResourceResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listTagsForResourceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodeCommitAsyncClient.lambda$listTagsForResource$145(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodeCommitAsyncClient.lambda$listTagsForResource$146((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<MergeBranchesByFastForwardResponse> mergeBranchesByFastForward(MergeBranchesByFastForwardRequest mergeBranchesByFastForwardRequest) {
        List<MetricPublisher> metricPublishers = DefaultCodeCommitAsyncClient.resolveMetricPublishers(this.clientConfiguration, mergeBranchesByFastForwardRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeCommit");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"MergeBranchesByFastForward");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, MergeBranchesByFastForwardResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("MergeBranchesByFastForward").withMarshaller((Marshaller)new MergeBranchesByFastForwardRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)mergeBranchesByFastForwardRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodeCommitAsyncClient.lambda$mergeBranchesByFastForward$148(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodeCommitAsyncClient.lambda$mergeBranchesByFastForward$149((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<MergeBranchesBySquashResponse> mergeBranchesBySquash(MergeBranchesBySquashRequest mergeBranchesBySquashRequest) {
        List<MetricPublisher> metricPublishers = DefaultCodeCommitAsyncClient.resolveMetricPublishers(this.clientConfiguration, mergeBranchesBySquashRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeCommit");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"MergeBranchesBySquash");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, MergeBranchesBySquashResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("MergeBranchesBySquash").withMarshaller((Marshaller)new MergeBranchesBySquashRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)mergeBranchesBySquashRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodeCommitAsyncClient.lambda$mergeBranchesBySquash$151(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodeCommitAsyncClient.lambda$mergeBranchesBySquash$152((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<MergeBranchesByThreeWayResponse> mergeBranchesByThreeWay(MergeBranchesByThreeWayRequest mergeBranchesByThreeWayRequest) {
        List<MetricPublisher> metricPublishers = DefaultCodeCommitAsyncClient.resolveMetricPublishers(this.clientConfiguration, mergeBranchesByThreeWayRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeCommit");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"MergeBranchesByThreeWay");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, MergeBranchesByThreeWayResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("MergeBranchesByThreeWay").withMarshaller((Marshaller)new MergeBranchesByThreeWayRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)mergeBranchesByThreeWayRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodeCommitAsyncClient.lambda$mergeBranchesByThreeWay$154(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodeCommitAsyncClient.lambda$mergeBranchesByThreeWay$155((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<MergePullRequestByFastForwardResponse> mergePullRequestByFastForward(MergePullRequestByFastForwardRequest mergePullRequestByFastForwardRequest) {
        List<MetricPublisher> metricPublishers = DefaultCodeCommitAsyncClient.resolveMetricPublishers(this.clientConfiguration, mergePullRequestByFastForwardRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeCommit");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"MergePullRequestByFastForward");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, MergePullRequestByFastForwardResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("MergePullRequestByFastForward").withMarshaller((Marshaller)new MergePullRequestByFastForwardRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)mergePullRequestByFastForwardRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodeCommitAsyncClient.lambda$mergePullRequestByFastForward$157(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodeCommitAsyncClient.lambda$mergePullRequestByFastForward$158((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<MergePullRequestBySquashResponse> mergePullRequestBySquash(MergePullRequestBySquashRequest mergePullRequestBySquashRequest) {
        List<MetricPublisher> metricPublishers = DefaultCodeCommitAsyncClient.resolveMetricPublishers(this.clientConfiguration, mergePullRequestBySquashRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeCommit");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"MergePullRequestBySquash");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, MergePullRequestBySquashResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("MergePullRequestBySquash").withMarshaller((Marshaller)new MergePullRequestBySquashRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)mergePullRequestBySquashRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodeCommitAsyncClient.lambda$mergePullRequestBySquash$160(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodeCommitAsyncClient.lambda$mergePullRequestBySquash$161((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<MergePullRequestByThreeWayResponse> mergePullRequestByThreeWay(MergePullRequestByThreeWayRequest mergePullRequestByThreeWayRequest) {
        List<MetricPublisher> metricPublishers = DefaultCodeCommitAsyncClient.resolveMetricPublishers(this.clientConfiguration, mergePullRequestByThreeWayRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeCommit");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"MergePullRequestByThreeWay");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, MergePullRequestByThreeWayResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("MergePullRequestByThreeWay").withMarshaller((Marshaller)new MergePullRequestByThreeWayRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)mergePullRequestByThreeWayRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodeCommitAsyncClient.lambda$mergePullRequestByThreeWay$163(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodeCommitAsyncClient.lambda$mergePullRequestByThreeWay$164((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<OverridePullRequestApprovalRulesResponse> overridePullRequestApprovalRules(OverridePullRequestApprovalRulesRequest overridePullRequestApprovalRulesRequest) {
        List<MetricPublisher> metricPublishers = DefaultCodeCommitAsyncClient.resolveMetricPublishers(this.clientConfiguration, overridePullRequestApprovalRulesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeCommit");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"OverridePullRequestApprovalRules");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, OverridePullRequestApprovalRulesResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("OverridePullRequestApprovalRules").withMarshaller((Marshaller)new OverridePullRequestApprovalRulesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)overridePullRequestApprovalRulesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodeCommitAsyncClient.lambda$overridePullRequestApprovalRules$166(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodeCommitAsyncClient.lambda$overridePullRequestApprovalRules$167((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<PostCommentForComparedCommitResponse> postCommentForComparedCommit(PostCommentForComparedCommitRequest postCommentForComparedCommitRequest) {
        List<MetricPublisher> metricPublishers = DefaultCodeCommitAsyncClient.resolveMetricPublishers(this.clientConfiguration, postCommentForComparedCommitRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeCommit");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PostCommentForComparedCommit");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PostCommentForComparedCommitResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("PostCommentForComparedCommit").withMarshaller((Marshaller)new PostCommentForComparedCommitRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)postCommentForComparedCommitRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodeCommitAsyncClient.lambda$postCommentForComparedCommit$169(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodeCommitAsyncClient.lambda$postCommentForComparedCommit$170((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<PostCommentForPullRequestResponse> postCommentForPullRequest(PostCommentForPullRequestRequest postCommentForPullRequestRequest) {
        List<MetricPublisher> metricPublishers = DefaultCodeCommitAsyncClient.resolveMetricPublishers(this.clientConfiguration, postCommentForPullRequestRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeCommit");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PostCommentForPullRequest");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PostCommentForPullRequestResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("PostCommentForPullRequest").withMarshaller((Marshaller)new PostCommentForPullRequestRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)postCommentForPullRequestRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodeCommitAsyncClient.lambda$postCommentForPullRequest$172(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodeCommitAsyncClient.lambda$postCommentForPullRequest$173((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<PostCommentReplyResponse> postCommentReply(PostCommentReplyRequest postCommentReplyRequest) {
        List<MetricPublisher> metricPublishers = DefaultCodeCommitAsyncClient.resolveMetricPublishers(this.clientConfiguration, postCommentReplyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeCommit");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PostCommentReply");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PostCommentReplyResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("PostCommentReply").withMarshaller((Marshaller)new PostCommentReplyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)postCommentReplyRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodeCommitAsyncClient.lambda$postCommentReply$175(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodeCommitAsyncClient.lambda$postCommentReply$176((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<PutCommentReactionResponse> putCommentReaction(PutCommentReactionRequest putCommentReactionRequest) {
        List<MetricPublisher> metricPublishers = DefaultCodeCommitAsyncClient.resolveMetricPublishers(this.clientConfiguration, putCommentReactionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeCommit");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutCommentReaction");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutCommentReactionResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutCommentReaction").withMarshaller((Marshaller)new PutCommentReactionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)putCommentReactionRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodeCommitAsyncClient.lambda$putCommentReaction$178(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodeCommitAsyncClient.lambda$putCommentReaction$179((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<PutFileResponse> putFile(PutFileRequest putFileRequest) {
        List<MetricPublisher> metricPublishers = DefaultCodeCommitAsyncClient.resolveMetricPublishers(this.clientConfiguration, putFileRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeCommit");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutFile");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutFileResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutFile").withMarshaller((Marshaller)new PutFileRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)putFileRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodeCommitAsyncClient.lambda$putFile$181(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodeCommitAsyncClient.lambda$putFile$182((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<PutRepositoryTriggersResponse> putRepositoryTriggers(PutRepositoryTriggersRequest putRepositoryTriggersRequest) {
        List<MetricPublisher> metricPublishers = DefaultCodeCommitAsyncClient.resolveMetricPublishers(this.clientConfiguration, putRepositoryTriggersRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeCommit");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutRepositoryTriggers");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutRepositoryTriggersResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutRepositoryTriggers").withMarshaller((Marshaller)new PutRepositoryTriggersRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)putRepositoryTriggersRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodeCommitAsyncClient.lambda$putRepositoryTriggers$184(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodeCommitAsyncClient.lambda$putRepositoryTriggers$185((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        List<MetricPublisher> metricPublishers = DefaultCodeCommitAsyncClient.resolveMetricPublishers(this.clientConfiguration, tagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeCommit");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagResourceResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withMarshaller((Marshaller)new TagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)tagResourceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodeCommitAsyncClient.lambda$tagResource$187(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodeCommitAsyncClient.lambda$tagResource$188((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<TestRepositoryTriggersResponse> testRepositoryTriggers(TestRepositoryTriggersRequest testRepositoryTriggersRequest) {
        List<MetricPublisher> metricPublishers = DefaultCodeCommitAsyncClient.resolveMetricPublishers(this.clientConfiguration, testRepositoryTriggersRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeCommit");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TestRepositoryTriggers");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TestRepositoryTriggersResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("TestRepositoryTriggers").withMarshaller((Marshaller)new TestRepositoryTriggersRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)testRepositoryTriggersRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodeCommitAsyncClient.lambda$testRepositoryTriggers$190(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodeCommitAsyncClient.lambda$testRepositoryTriggers$191((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        List<MetricPublisher> metricPublishers = DefaultCodeCommitAsyncClient.resolveMetricPublishers(this.clientConfiguration, untagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeCommit");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UntagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagResourceResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withMarshaller((Marshaller)new UntagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)untagResourceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodeCommitAsyncClient.lambda$untagResource$193(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodeCommitAsyncClient.lambda$untagResource$194((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateApprovalRuleTemplateContentResponse> updateApprovalRuleTemplateContent(UpdateApprovalRuleTemplateContentRequest updateApprovalRuleTemplateContentRequest) {
        List<MetricPublisher> metricPublishers = DefaultCodeCommitAsyncClient.resolveMetricPublishers(this.clientConfiguration, updateApprovalRuleTemplateContentRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeCommit");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateApprovalRuleTemplateContent");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateApprovalRuleTemplateContentResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateApprovalRuleTemplateContent").withMarshaller((Marshaller)new UpdateApprovalRuleTemplateContentRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateApprovalRuleTemplateContentRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodeCommitAsyncClient.lambda$updateApprovalRuleTemplateContent$196(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodeCommitAsyncClient.lambda$updateApprovalRuleTemplateContent$197((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateApprovalRuleTemplateDescriptionResponse> updateApprovalRuleTemplateDescription(UpdateApprovalRuleTemplateDescriptionRequest updateApprovalRuleTemplateDescriptionRequest) {
        List<MetricPublisher> metricPublishers = DefaultCodeCommitAsyncClient.resolveMetricPublishers(this.clientConfiguration, updateApprovalRuleTemplateDescriptionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeCommit");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateApprovalRuleTemplateDescription");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateApprovalRuleTemplateDescriptionResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateApprovalRuleTemplateDescription").withMarshaller((Marshaller)new UpdateApprovalRuleTemplateDescriptionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateApprovalRuleTemplateDescriptionRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodeCommitAsyncClient.lambda$updateApprovalRuleTemplateDescription$199(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodeCommitAsyncClient.lambda$updateApprovalRuleTemplateDescription$200((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateApprovalRuleTemplateNameResponse> updateApprovalRuleTemplateName(UpdateApprovalRuleTemplateNameRequest updateApprovalRuleTemplateNameRequest) {
        List<MetricPublisher> metricPublishers = DefaultCodeCommitAsyncClient.resolveMetricPublishers(this.clientConfiguration, updateApprovalRuleTemplateNameRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeCommit");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateApprovalRuleTemplateName");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateApprovalRuleTemplateNameResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateApprovalRuleTemplateName").withMarshaller((Marshaller)new UpdateApprovalRuleTemplateNameRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateApprovalRuleTemplateNameRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodeCommitAsyncClient.lambda$updateApprovalRuleTemplateName$202(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodeCommitAsyncClient.lambda$updateApprovalRuleTemplateName$203((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateCommentResponse> updateComment(UpdateCommentRequest updateCommentRequest) {
        List<MetricPublisher> metricPublishers = DefaultCodeCommitAsyncClient.resolveMetricPublishers(this.clientConfiguration, updateCommentRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeCommit");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateComment");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateCommentResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateComment").withMarshaller((Marshaller)new UpdateCommentRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateCommentRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodeCommitAsyncClient.lambda$updateComment$205(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodeCommitAsyncClient.lambda$updateComment$206((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateDefaultBranchResponse> updateDefaultBranch(UpdateDefaultBranchRequest updateDefaultBranchRequest) {
        List<MetricPublisher> metricPublishers = DefaultCodeCommitAsyncClient.resolveMetricPublishers(this.clientConfiguration, updateDefaultBranchRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeCommit");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateDefaultBranch");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateDefaultBranchResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateDefaultBranch").withMarshaller((Marshaller)new UpdateDefaultBranchRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateDefaultBranchRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodeCommitAsyncClient.lambda$updateDefaultBranch$208(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodeCommitAsyncClient.lambda$updateDefaultBranch$209((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdatePullRequestApprovalRuleContentResponse> updatePullRequestApprovalRuleContent(UpdatePullRequestApprovalRuleContentRequest updatePullRequestApprovalRuleContentRequest) {
        List<MetricPublisher> metricPublishers = DefaultCodeCommitAsyncClient.resolveMetricPublishers(this.clientConfiguration, updatePullRequestApprovalRuleContentRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeCommit");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdatePullRequestApprovalRuleContent");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdatePullRequestApprovalRuleContentResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdatePullRequestApprovalRuleContent").withMarshaller((Marshaller)new UpdatePullRequestApprovalRuleContentRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updatePullRequestApprovalRuleContentRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodeCommitAsyncClient.lambda$updatePullRequestApprovalRuleContent$211(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodeCommitAsyncClient.lambda$updatePullRequestApprovalRuleContent$212((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdatePullRequestApprovalStateResponse> updatePullRequestApprovalState(UpdatePullRequestApprovalStateRequest updatePullRequestApprovalStateRequest) {
        List<MetricPublisher> metricPublishers = DefaultCodeCommitAsyncClient.resolveMetricPublishers(this.clientConfiguration, updatePullRequestApprovalStateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeCommit");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdatePullRequestApprovalState");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdatePullRequestApprovalStateResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdatePullRequestApprovalState").withMarshaller((Marshaller)new UpdatePullRequestApprovalStateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updatePullRequestApprovalStateRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodeCommitAsyncClient.lambda$updatePullRequestApprovalState$214(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodeCommitAsyncClient.lambda$updatePullRequestApprovalState$215((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdatePullRequestDescriptionResponse> updatePullRequestDescription(UpdatePullRequestDescriptionRequest updatePullRequestDescriptionRequest) {
        List<MetricPublisher> metricPublishers = DefaultCodeCommitAsyncClient.resolveMetricPublishers(this.clientConfiguration, updatePullRequestDescriptionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeCommit");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdatePullRequestDescription");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdatePullRequestDescriptionResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdatePullRequestDescription").withMarshaller((Marshaller)new UpdatePullRequestDescriptionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updatePullRequestDescriptionRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodeCommitAsyncClient.lambda$updatePullRequestDescription$217(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodeCommitAsyncClient.lambda$updatePullRequestDescription$218((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdatePullRequestStatusResponse> updatePullRequestStatus(UpdatePullRequestStatusRequest updatePullRequestStatusRequest) {
        List<MetricPublisher> metricPublishers = DefaultCodeCommitAsyncClient.resolveMetricPublishers(this.clientConfiguration, updatePullRequestStatusRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeCommit");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdatePullRequestStatus");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdatePullRequestStatusResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdatePullRequestStatus").withMarshaller((Marshaller)new UpdatePullRequestStatusRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updatePullRequestStatusRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodeCommitAsyncClient.lambda$updatePullRequestStatus$220(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodeCommitAsyncClient.lambda$updatePullRequestStatus$221((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdatePullRequestTitleResponse> updatePullRequestTitle(UpdatePullRequestTitleRequest updatePullRequestTitleRequest) {
        List<MetricPublisher> metricPublishers = DefaultCodeCommitAsyncClient.resolveMetricPublishers(this.clientConfiguration, updatePullRequestTitleRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeCommit");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdatePullRequestTitle");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdatePullRequestTitleResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdatePullRequestTitle").withMarshaller((Marshaller)new UpdatePullRequestTitleRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updatePullRequestTitleRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodeCommitAsyncClient.lambda$updatePullRequestTitle$223(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodeCommitAsyncClient.lambda$updatePullRequestTitle$224((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateRepositoryDescriptionResponse> updateRepositoryDescription(UpdateRepositoryDescriptionRequest updateRepositoryDescriptionRequest) {
        List<MetricPublisher> metricPublishers = DefaultCodeCommitAsyncClient.resolveMetricPublishers(this.clientConfiguration, updateRepositoryDescriptionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeCommit");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateRepositoryDescription");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateRepositoryDescriptionResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateRepositoryDescription").withMarshaller((Marshaller)new UpdateRepositoryDescriptionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateRepositoryDescriptionRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodeCommitAsyncClient.lambda$updateRepositoryDescription$226(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodeCommitAsyncClient.lambda$updateRepositoryDescription$227((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateRepositoryNameResponse> updateRepositoryName(UpdateRepositoryNameRequest updateRepositoryNameRequest) {
        List<MetricPublisher> metricPublishers = DefaultCodeCommitAsyncClient.resolveMetricPublishers(this.clientConfiguration, updateRepositoryNameRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodeCommit");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateRepositoryName");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateRepositoryNameResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateRepositoryName").withMarshaller((Marshaller)new UpdateRepositoryNameRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateRepositoryNameRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCodeCommitAsyncClient.lambda$updateRepositoryName$229(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCodeCommitAsyncClient.lambda$updateRepositoryName$230((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public final CodeCommitServiceClientConfiguration serviceClientConfiguration() {
        return this.serviceClientConfiguration;
    }

    public final String serviceName() {
        return "codecommit";
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(CodeCommitException::builder).protocol(AwsJsonProtocol.AWS_JSON).protocolVersion("1.1").registerModeledException(ExceptionMetadata.builder().errorCode("FileContentRequiredException").exceptionBuilderSupplier(FileContentRequiredException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidApprovalRuleTemplateDescriptionException").exceptionBuilderSupplier(InvalidApprovalRuleTemplateDescriptionException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ApprovalRuleTemplateDoesNotExistException").exceptionBuilderSupplier(ApprovalRuleTemplateDoesNotExistException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("CommentDeletedException").exceptionBuilderSupplier(CommentDeletedException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("MaximumItemsToCompareExceededException").exceptionBuilderSupplier(MaximumItemsToCompareExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidBlobIdException").exceptionBuilderSupplier(InvalidBlobIdException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidRepositoryDescriptionException").exceptionBuilderSupplier(InvalidRepositoryDescriptionException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerDestinationArnException").exceptionBuilderSupplier(InvalidRepositoryTriggerDestinationArnException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("CommentDoesNotExistException").exceptionBuilderSupplier(CommentDoesNotExistException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidConflictDetailLevelException").exceptionBuilderSupplier(InvalidConflictDetailLevelException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ReactionLimitExceededException").exceptionBuilderSupplier(ReactionLimitExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("BeforeCommitIdAndAfterCommitIdAreSameException").exceptionBuilderSupplier(BeforeCommitIdAndAfterCommitIdAreSameException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("CannotModifyApprovalRuleFromTemplateException").exceptionBuilderSupplier(CannotModifyApprovalRuleFromTemplateException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("RevisionIdRequiredException").exceptionBuilderSupplier(RevisionIdRequiredException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("PullRequestDoesNotExistException").exceptionBuilderSupplier(PullRequestDoesNotExistException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ReferenceTypeNotSupportedException").exceptionBuilderSupplier(ReferenceTypeNotSupportedException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("FilePathConflictsWithSubmodulePathException").exceptionBuilderSupplier(FilePathConflictsWithSubmodulePathException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("RepositoryTriggerEventsListRequiredException").exceptionBuilderSupplier(RepositoryTriggerEventsListRequiredException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("FileModeRequiredException").exceptionBuilderSupplier(FileModeRequiredException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("CommitDoesNotExistException").exceptionBuilderSupplier(CommitDoesNotExistException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceArnRequiredException").exceptionBuilderSupplier(ResourceArnRequiredException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidReactionUserArnException").exceptionBuilderSupplier(InvalidReactionUserArnException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerEventsException").exceptionBuilderSupplier(InvalidRepositoryTriggerEventsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("RepositoryNotAssociatedWithPullRequestException").exceptionBuilderSupplier(RepositoryNotAssociatedWithPullRequestException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidFileLocationException").exceptionBuilderSupplier(InvalidFileLocationException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("MaximumBranchesExceededException").exceptionBuilderSupplier(MaximumBranchesExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidRelativeFileVersionEnumException").exceptionBuilderSupplier(InvalidRelativeFileVersionEnumException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidReactionValueException").exceptionBuilderSupplier(InvalidReactionValueException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TagKeysListRequiredException").exceptionBuilderSupplier(TagKeysListRequiredException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidClientRequestTokenException").exceptionBuilderSupplier(InvalidClientRequestTokenException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("FolderContentSizeLimitExceededException").exceptionBuilderSupplier(FolderContentSizeLimitExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("RepositoryNameRequiredException").exceptionBuilderSupplier(RepositoryNameRequiredException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidReferenceNameException").exceptionBuilderSupplier(InvalidReferenceNameException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("CommentContentRequiredException").exceptionBuilderSupplier(CommentContentRequiredException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidTagKeysListException").exceptionBuilderSupplier(InvalidTagKeysListException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TagsMapRequiredException").exceptionBuilderSupplier(TagsMapRequiredException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("PathRequiredException").exceptionBuilderSupplier(PathRequiredException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidSystemTagUsageException").exceptionBuilderSupplier(InvalidSystemTagUsageException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("CommitIdDoesNotExistException").exceptionBuilderSupplier(CommitIdDoesNotExistException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidParentCommitIdException").exceptionBuilderSupplier(InvalidParentCommitIdException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ReferenceNameRequiredException").exceptionBuilderSupplier(ReferenceNameRequiredException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidMaxConflictFilesException").exceptionBuilderSupplier(InvalidMaxConflictFilesException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("MaximumRuleTemplatesAssociatedWithRepositoryException").exceptionBuilderSupplier(MaximumRuleTemplatesAssociatedWithRepositoryException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ApprovalRuleTemplateContentRequiredException").exceptionBuilderSupplier(ApprovalRuleTemplateContentRequiredException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidCommentIdException").exceptionBuilderSupplier(InvalidCommentIdException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidApprovalStateException").exceptionBuilderSupplier(InvalidApprovalStateException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidCommitException").exceptionBuilderSupplier(InvalidCommitException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ApprovalRuleTemplateNameRequiredException").exceptionBuilderSupplier(ApprovalRuleTemplateNameRequiredException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("NoChangeException").exceptionBuilderSupplier(NoChangeException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ApprovalRuleDoesNotExistException").exceptionBuilderSupplier(ApprovalRuleDoesNotExistException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("MaximumFileContentToLoadExceededException").exceptionBuilderSupplier(MaximumFileContentToLoadExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("MultipleRepositoriesInPullRequestException").exceptionBuilderSupplier(MultipleRepositoriesInPullRequestException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("BlobIdDoesNotExistException").exceptionBuilderSupplier(BlobIdDoesNotExistException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("MergeOptionRequiredException").exceptionBuilderSupplier(MergeOptionRequiredException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidPullRequestIdException").exceptionBuilderSupplier(InvalidPullRequestIdException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ApprovalRuleTemplateInUseException").exceptionBuilderSupplier(ApprovalRuleTemplateInUseException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("FileDoesNotExistException").exceptionBuilderSupplier(FileDoesNotExistException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("RepositoryNameExistsException").exceptionBuilderSupplier(RepositoryNameExistsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("PathDoesNotExistException").exceptionBuilderSupplier(PathDoesNotExistException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("BranchNameExistsException").exceptionBuilderSupplier(BranchNameExistsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("EncryptionIntegrityChecksFailedException").exceptionBuilderSupplier(EncryptionIntegrityChecksFailedException::builder).httpStatusCode(Integer.valueOf(500)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidCommitIdException").exceptionBuilderSupplier(InvalidCommitIdException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidOrderException").exceptionBuilderSupplier(InvalidOrderException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("PullRequestAlreadyClosedException").exceptionBuilderSupplier(PullRequestAlreadyClosedException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("BranchNameRequiredException").exceptionBuilderSupplier(BranchNameRequiredException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerNameException").exceptionBuilderSupplier(InvalidRepositoryTriggerNameException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidMergeOptionException").exceptionBuilderSupplier(InvalidMergeOptionException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ParentCommitIdOutdatedException").exceptionBuilderSupplier(ParentCommitIdOutdatedException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("CommitIdsListRequiredException").exceptionBuilderSupplier(CommitIdsListRequiredException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidContinuationTokenException").exceptionBuilderSupplier(InvalidContinuationTokenException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("MaximumFileEntriesExceededException").exceptionBuilderSupplier(MaximumFileEntriesExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("PullRequestApprovalRulesNotSatisfiedException").exceptionBuilderSupplier(PullRequestApprovalRulesNotSatisfiedException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ClientRequestTokenRequiredException").exceptionBuilderSupplier(ClientRequestTokenRequiredException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("NameLengthExceededException").exceptionBuilderSupplier(NameLengthExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("EncryptionKeyDisabledException").exceptionBuilderSupplier(EncryptionKeyDisabledException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("MultipleConflictResolutionEntriesException").exceptionBuilderSupplier(MultipleConflictResolutionEntriesException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyTagsException").exceptionBuilderSupplier(TooManyTagsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("FileContentSizeLimitExceededException").exceptionBuilderSupplier(FileContentSizeLimitExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ManualMergeRequiredException").exceptionBuilderSupplier(ManualMergeRequiredException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidApprovalRuleContentException").exceptionBuilderSupplier(InvalidApprovalRuleContentException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerBranchNameException").exceptionBuilderSupplier(InvalidRepositoryTriggerBranchNameException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("SameFileContentException").exceptionBuilderSupplier(SameFileContentException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidTargetException").exceptionBuilderSupplier(InvalidTargetException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerRegionException").exceptionBuilderSupplier(InvalidRepositoryTriggerRegionException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("CommentContentSizeLimitExceededException").exceptionBuilderSupplier(CommentContentSizeLimitExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").exceptionBuilderSupplier(InvalidMaxResultsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ParentCommitDoesNotExistException").exceptionBuilderSupplier(ParentCommitDoesNotExistException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("FileEntryRequiredException").exceptionBuilderSupplier(FileEntryRequiredException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidActorArnException").exceptionBuilderSupplier(InvalidActorArnException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("CommitIdsLimitExceededException").exceptionBuilderSupplier(CommitIdsLimitExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidDestinationCommitSpecifierException").exceptionBuilderSupplier(InvalidDestinationCommitSpecifierException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("RepositoryTriggerBranchNameListRequiredException").exceptionBuilderSupplier(RepositoryTriggerBranchNameListRequiredException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidApprovalRuleNameException").exceptionBuilderSupplier(InvalidApprovalRuleNameException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DirectoryNameConflictsWithFileNameException").exceptionBuilderSupplier(DirectoryNameConflictsWithFileNameException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("SourceAndDestinationAreSameException").exceptionBuilderSupplier(SourceAndDestinationAreSameException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidTitleException").exceptionBuilderSupplier(InvalidTitleException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("EncryptionKeyUnavailableException").exceptionBuilderSupplier(EncryptionKeyUnavailableException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidRepositoryNameException").exceptionBuilderSupplier(InvalidRepositoryNameException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidBranchNameException").exceptionBuilderSupplier(InvalidBranchNameException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TargetsRequiredException").exceptionBuilderSupplier(TargetsRequiredException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("RepositoryLimitExceededException").exceptionBuilderSupplier(RepositoryLimitExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("BranchNameIsTagNameException").exceptionBuilderSupplier(BranchNameIsTagNameException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("CommitIdRequiredException").exceptionBuilderSupplier(CommitIdRequiredException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TitleRequiredException").exceptionBuilderSupplier(TitleRequiredException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidTargetsException").exceptionBuilderSupplier(InvalidTargetsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("MaximumRepositoryTriggersExceededException").exceptionBuilderSupplier(MaximumRepositoryTriggersExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("BlobIdRequiredException").exceptionBuilderSupplier(BlobIdRequiredException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidReplacementTypeException").exceptionBuilderSupplier(InvalidReplacementTypeException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("RepositoryNamesRequiredException").exceptionBuilderSupplier(RepositoryNamesRequiredException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("AuthorDoesNotExistException").exceptionBuilderSupplier(AuthorDoesNotExistException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidFilePositionException").exceptionBuilderSupplier(InvalidFilePositionException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("FileNameConflictsWithDirectoryNameException").exceptionBuilderSupplier(FileNameConflictsWithDirectoryNameException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidResourceArnException").exceptionBuilderSupplier(InvalidResourceArnException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("EncryptionKeyAccessDeniedException").exceptionBuilderSupplier(EncryptionKeyAccessDeniedException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("PullRequestCannotBeApprovedByAuthorException").exceptionBuilderSupplier(PullRequestCannotBeApprovedByAuthorException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("BranchDoesNotExistException").exceptionBuilderSupplier(BranchDoesNotExistException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ReactionValueRequiredException").exceptionBuilderSupplier(ReactionValueRequiredException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ApprovalRuleTemplateNameAlreadyExistsException").exceptionBuilderSupplier(ApprovalRuleTemplateNameAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerCustomDataException").exceptionBuilderSupplier(InvalidRepositoryTriggerCustomDataException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ApprovalRuleContentRequiredException").exceptionBuilderSupplier(ApprovalRuleContentRequiredException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("MaximumRepositoryNamesExceededException").exceptionBuilderSupplier(MaximumRepositoryNamesExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("RepositoryDoesNotExistException").exceptionBuilderSupplier(RepositoryDoesNotExistException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidRevisionIdException").exceptionBuilderSupplier(InvalidRevisionIdException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("MaximumOpenPullRequestsExceededException").exceptionBuilderSupplier(MaximumOpenPullRequestsExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DefaultBranchCannotBeDeletedException").exceptionBuilderSupplier(DefaultBranchCannotBeDeletedException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("EncryptionKeyNotFoundException").exceptionBuilderSupplier(EncryptionKeyNotFoundException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidPathException").exceptionBuilderSupplier(InvalidPathException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidConflictResolutionException").exceptionBuilderSupplier(InvalidConflictResolutionException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidApprovalRuleTemplateContentException").exceptionBuilderSupplier(InvalidApprovalRuleTemplateContentException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("RepositoryTriggerDestinationArnRequiredException").exceptionBuilderSupplier(RepositoryTriggerDestinationArnRequiredException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidConflictResolutionStrategyException").exceptionBuilderSupplier(InvalidConflictResolutionStrategyException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidAuthorArnException").exceptionBuilderSupplier(InvalidAuthorArnException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidTargetBranchException").exceptionBuilderSupplier(InvalidTargetBranchException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ReplacementTypeRequiredException").exceptionBuilderSupplier(ReplacementTypeRequiredException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("RepositoryTriggerNameRequiredException").exceptionBuilderSupplier(RepositoryTriggerNameRequiredException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ApprovalStateRequiredException").exceptionBuilderSupplier(ApprovalStateRequiredException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidPullRequestStatusException").exceptionBuilderSupplier(InvalidPullRequestStatusException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("OverrideAlreadySetException").exceptionBuilderSupplier(OverrideAlreadySetException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("NumberOfRulesExceededException").exceptionBuilderSupplier(NumberOfRulesExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidOverrideStatusException").exceptionBuilderSupplier(InvalidOverrideStatusException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ApprovalRuleNameRequiredException").exceptionBuilderSupplier(ApprovalRuleNameRequiredException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidPullRequestStatusUpdateException").exceptionBuilderSupplier(InvalidPullRequestStatusUpdateException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ParentCommitIdRequiredException").exceptionBuilderSupplier(ParentCommitIdRequiredException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidPullRequestEventTypeException").exceptionBuilderSupplier(InvalidPullRequestEventTypeException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ActorDoesNotExistException").exceptionBuilderSupplier(ActorDoesNotExistException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("IdempotencyParameterMismatchException").exceptionBuilderSupplier(IdempotencyParameterMismatchException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("NumberOfRuleTemplatesExceededException").exceptionBuilderSupplier(NumberOfRuleTemplatesExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidDescriptionException").exceptionBuilderSupplier(InvalidDescriptionException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("FolderDoesNotExistException").exceptionBuilderSupplier(FolderDoesNotExistException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("PullRequestIdRequiredException").exceptionBuilderSupplier(PullRequestIdRequiredException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TipOfSourceReferenceIsDifferentException").exceptionBuilderSupplier(TipOfSourceReferenceIsDifferentException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("RepositoryTriggersListRequiredException").exceptionBuilderSupplier(RepositoryTriggersListRequiredException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidReplacementContentException").exceptionBuilderSupplier(InvalidReplacementContentException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("MaximumNumberOfApprovalsExceededException").exceptionBuilderSupplier(MaximumNumberOfApprovalsExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("CommitMessageLengthExceededException").exceptionBuilderSupplier(CommitMessageLengthExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidMaxMergeHunksException").exceptionBuilderSupplier(InvalidMaxMergeHunksException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidEmailException").exceptionBuilderSupplier(InvalidEmailException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidDeletionParameterException").exceptionBuilderSupplier(InvalidDeletionParameterException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidRuleContentSha256Exception").exceptionBuilderSupplier(InvalidRuleContentSha256Exception::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("SourceFileOrContentRequiredException").exceptionBuilderSupplier(SourceFileOrContentRequiredException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("CommentIdRequiredException").exceptionBuilderSupplier(CommentIdRequiredException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("CommitRequiredException").exceptionBuilderSupplier(CommitRequiredException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("RevisionNotCurrentException").exceptionBuilderSupplier(RevisionNotCurrentException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("MaximumConflictResolutionEntriesExceededException").exceptionBuilderSupplier(MaximumConflictResolutionEntriesExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("CommentNotCreatedByCallerException").exceptionBuilderSupplier(CommentNotCreatedByCallerException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TargetRequiredException").exceptionBuilderSupplier(TargetRequiredException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidTagsMapException").exceptionBuilderSupplier(InvalidTagsMapException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("RestrictedSourceFileException").exceptionBuilderSupplier(RestrictedSourceFileException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("FileTooLargeException").exceptionBuilderSupplier(FileTooLargeException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("PutFileEntryConflictException").exceptionBuilderSupplier(PutFileEntryConflictException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("FileContentAndSourceFileSpecifiedException").exceptionBuilderSupplier(FileContentAndSourceFileSpecifiedException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("PullRequestStatusRequiredException").exceptionBuilderSupplier(PullRequestStatusRequiredException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ConcurrentReferenceUpdateException").exceptionBuilderSupplier(ConcurrentReferenceUpdateException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("SamePathRequestException").exceptionBuilderSupplier(SamePathRequestException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TipsDivergenceExceededException").exceptionBuilderSupplier(TipsDivergenceExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidSortByException").exceptionBuilderSupplier(InvalidSortByException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("CannotDeleteApprovalRuleFromTemplateException").exceptionBuilderSupplier(CannotDeleteApprovalRuleFromTemplateException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ReferenceDoesNotExistException").exceptionBuilderSupplier(ReferenceDoesNotExistException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("OverrideStatusRequiredException").exceptionBuilderSupplier(OverrideStatusRequiredException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ApprovalRuleNameAlreadyExistsException").exceptionBuilderSupplier(ApprovalRuleNameAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TagPolicyException").exceptionBuilderSupplier(TagPolicyException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidFileModeException").exceptionBuilderSupplier(InvalidFileModeException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidApprovalRuleTemplateNameException").exceptionBuilderSupplier(InvalidApprovalRuleTemplateNameException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidSourceCommitSpecifierException").exceptionBuilderSupplier(InvalidSourceCommitSpecifierException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ReplacementContentRequiredException").exceptionBuilderSupplier(ReplacementContentRequiredException::builder).httpStatusCode(Integer.valueOf(400)).build());
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private <T extends CodeCommitRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.20.40").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((CodeCommitRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$updateRepositoryName$230(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateRepositoryName$229(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateRepositoryNameResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateRepositoryDescription$227(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateRepositoryDescription$226(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateRepositoryDescriptionResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updatePullRequestTitle$224(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updatePullRequestTitle$223(List metricPublishers, MetricCollector apiCallMetricCollector, UpdatePullRequestTitleResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updatePullRequestStatus$221(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updatePullRequestStatus$220(List metricPublishers, MetricCollector apiCallMetricCollector, UpdatePullRequestStatusResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updatePullRequestDescription$218(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updatePullRequestDescription$217(List metricPublishers, MetricCollector apiCallMetricCollector, UpdatePullRequestDescriptionResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updatePullRequestApprovalState$215(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updatePullRequestApprovalState$214(List metricPublishers, MetricCollector apiCallMetricCollector, UpdatePullRequestApprovalStateResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updatePullRequestApprovalRuleContent$212(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updatePullRequestApprovalRuleContent$211(List metricPublishers, MetricCollector apiCallMetricCollector, UpdatePullRequestApprovalRuleContentResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateDefaultBranch$209(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateDefaultBranch$208(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateDefaultBranchResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateComment$206(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateComment$205(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateCommentResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateApprovalRuleTemplateName$203(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateApprovalRuleTemplateName$202(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateApprovalRuleTemplateNameResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateApprovalRuleTemplateDescription$200(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateApprovalRuleTemplateDescription$199(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateApprovalRuleTemplateDescriptionResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateApprovalRuleTemplateContent$197(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateApprovalRuleTemplateContent$196(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateApprovalRuleTemplateContentResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$untagResource$194(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$untagResource$193(List metricPublishers, MetricCollector apiCallMetricCollector, UntagResourceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$testRepositoryTriggers$191(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$testRepositoryTriggers$190(List metricPublishers, MetricCollector apiCallMetricCollector, TestRepositoryTriggersResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$tagResource$188(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$tagResource$187(List metricPublishers, MetricCollector apiCallMetricCollector, TagResourceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$putRepositoryTriggers$185(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putRepositoryTriggers$184(List metricPublishers, MetricCollector apiCallMetricCollector, PutRepositoryTriggersResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$putFile$182(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putFile$181(List metricPublishers, MetricCollector apiCallMetricCollector, PutFileResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$putCommentReaction$179(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putCommentReaction$178(List metricPublishers, MetricCollector apiCallMetricCollector, PutCommentReactionResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$postCommentReply$176(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$postCommentReply$175(List metricPublishers, MetricCollector apiCallMetricCollector, PostCommentReplyResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$postCommentForPullRequest$173(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$postCommentForPullRequest$172(List metricPublishers, MetricCollector apiCallMetricCollector, PostCommentForPullRequestResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$postCommentForComparedCommit$170(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$postCommentForComparedCommit$169(List metricPublishers, MetricCollector apiCallMetricCollector, PostCommentForComparedCommitResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$overridePullRequestApprovalRules$167(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$overridePullRequestApprovalRules$166(List metricPublishers, MetricCollector apiCallMetricCollector, OverridePullRequestApprovalRulesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$mergePullRequestByThreeWay$164(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$mergePullRequestByThreeWay$163(List metricPublishers, MetricCollector apiCallMetricCollector, MergePullRequestByThreeWayResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$mergePullRequestBySquash$161(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$mergePullRequestBySquash$160(List metricPublishers, MetricCollector apiCallMetricCollector, MergePullRequestBySquashResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$mergePullRequestByFastForward$158(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$mergePullRequestByFastForward$157(List metricPublishers, MetricCollector apiCallMetricCollector, MergePullRequestByFastForwardResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$mergeBranchesByThreeWay$155(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$mergeBranchesByThreeWay$154(List metricPublishers, MetricCollector apiCallMetricCollector, MergeBranchesByThreeWayResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$mergeBranchesBySquash$152(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$mergeBranchesBySquash$151(List metricPublishers, MetricCollector apiCallMetricCollector, MergeBranchesBySquashResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$mergeBranchesByFastForward$149(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$mergeBranchesByFastForward$148(List metricPublishers, MetricCollector apiCallMetricCollector, MergeBranchesByFastForwardResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listTagsForResource$146(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTagsForResource$145(List metricPublishers, MetricCollector apiCallMetricCollector, ListTagsForResourceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listRepositoriesForApprovalRuleTemplate$143(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listRepositoriesForApprovalRuleTemplate$142(List metricPublishers, MetricCollector apiCallMetricCollector, ListRepositoriesForApprovalRuleTemplateResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listRepositories$140(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listRepositories$139(List metricPublishers, MetricCollector apiCallMetricCollector, ListRepositoriesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listPullRequests$137(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listPullRequests$136(List metricPublishers, MetricCollector apiCallMetricCollector, ListPullRequestsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listBranches$134(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listBranches$133(List metricPublishers, MetricCollector apiCallMetricCollector, ListBranchesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listAssociatedApprovalRuleTemplatesForRepository$131(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listAssociatedApprovalRuleTemplatesForRepository$130(List metricPublishers, MetricCollector apiCallMetricCollector, ListAssociatedApprovalRuleTemplatesForRepositoryResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listApprovalRuleTemplates$128(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listApprovalRuleTemplates$127(List metricPublishers, MetricCollector apiCallMetricCollector, ListApprovalRuleTemplatesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getRepositoryTriggers$125(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getRepositoryTriggers$124(List metricPublishers, MetricCollector apiCallMetricCollector, GetRepositoryTriggersResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getRepository$122(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getRepository$121(List metricPublishers, MetricCollector apiCallMetricCollector, GetRepositoryResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getPullRequestOverrideState$119(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getPullRequestOverrideState$118(List metricPublishers, MetricCollector apiCallMetricCollector, GetPullRequestOverrideStateResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getPullRequestApprovalStates$116(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getPullRequestApprovalStates$115(List metricPublishers, MetricCollector apiCallMetricCollector, GetPullRequestApprovalStatesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getPullRequest$113(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getPullRequest$112(List metricPublishers, MetricCollector apiCallMetricCollector, GetPullRequestResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getMergeOptions$110(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getMergeOptions$109(List metricPublishers, MetricCollector apiCallMetricCollector, GetMergeOptionsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getMergeConflicts$107(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getMergeConflicts$106(List metricPublishers, MetricCollector apiCallMetricCollector, GetMergeConflictsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getMergeCommit$104(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getMergeCommit$103(List metricPublishers, MetricCollector apiCallMetricCollector, GetMergeCommitResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getFolder$101(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getFolder$100(List metricPublishers, MetricCollector apiCallMetricCollector, GetFolderResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getFile$98(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getFile$97(List metricPublishers, MetricCollector apiCallMetricCollector, GetFileResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getDifferences$95(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getDifferences$94(List metricPublishers, MetricCollector apiCallMetricCollector, GetDifferencesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getCommit$92(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getCommit$91(List metricPublishers, MetricCollector apiCallMetricCollector, GetCommitResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getCommentsForPullRequest$89(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getCommentsForPullRequest$88(List metricPublishers, MetricCollector apiCallMetricCollector, GetCommentsForPullRequestResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getCommentsForComparedCommit$86(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getCommentsForComparedCommit$85(List metricPublishers, MetricCollector apiCallMetricCollector, GetCommentsForComparedCommitResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getCommentReactions$83(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getCommentReactions$82(List metricPublishers, MetricCollector apiCallMetricCollector, GetCommentReactionsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getComment$80(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getComment$79(List metricPublishers, MetricCollector apiCallMetricCollector, GetCommentResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getBranch$77(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getBranch$76(List metricPublishers, MetricCollector apiCallMetricCollector, GetBranchResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getBlob$74(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getBlob$73(List metricPublishers, MetricCollector apiCallMetricCollector, GetBlobResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getApprovalRuleTemplate$71(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getApprovalRuleTemplate$70(List metricPublishers, MetricCollector apiCallMetricCollector, GetApprovalRuleTemplateResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$evaluatePullRequestApprovalRules$68(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$evaluatePullRequestApprovalRules$67(List metricPublishers, MetricCollector apiCallMetricCollector, EvaluatePullRequestApprovalRulesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$disassociateApprovalRuleTemplateFromRepository$65(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$disassociateApprovalRuleTemplateFromRepository$64(List metricPublishers, MetricCollector apiCallMetricCollector, DisassociateApprovalRuleTemplateFromRepositoryResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describePullRequestEvents$62(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describePullRequestEvents$61(List metricPublishers, MetricCollector apiCallMetricCollector, DescribePullRequestEventsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeMergeConflicts$59(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeMergeConflicts$58(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeMergeConflictsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteRepository$56(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteRepository$55(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteRepositoryResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deletePullRequestApprovalRule$53(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deletePullRequestApprovalRule$52(List metricPublishers, MetricCollector apiCallMetricCollector, DeletePullRequestApprovalRuleResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteFile$50(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteFile$49(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteFileResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteCommentContent$47(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteCommentContent$46(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteCommentContentResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteBranch$44(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteBranch$43(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteBranchResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteApprovalRuleTemplate$41(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteApprovalRuleTemplate$40(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteApprovalRuleTemplateResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createUnreferencedMergeCommit$38(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createUnreferencedMergeCommit$37(List metricPublishers, MetricCollector apiCallMetricCollector, CreateUnreferencedMergeCommitResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createRepository$35(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createRepository$34(List metricPublishers, MetricCollector apiCallMetricCollector, CreateRepositoryResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createPullRequestApprovalRule$32(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createPullRequestApprovalRule$31(List metricPublishers, MetricCollector apiCallMetricCollector, CreatePullRequestApprovalRuleResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createPullRequest$29(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createPullRequest$28(List metricPublishers, MetricCollector apiCallMetricCollector, CreatePullRequestResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createCommit$26(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createCommit$25(List metricPublishers, MetricCollector apiCallMetricCollector, CreateCommitResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createBranch$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createBranch$22(List metricPublishers, MetricCollector apiCallMetricCollector, CreateBranchResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createApprovalRuleTemplate$20(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createApprovalRuleTemplate$19(List metricPublishers, MetricCollector apiCallMetricCollector, CreateApprovalRuleTemplateResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$batchGetRepositories$17(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$batchGetRepositories$16(List metricPublishers, MetricCollector apiCallMetricCollector, BatchGetRepositoriesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$batchGetCommits$14(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$batchGetCommits$13(List metricPublishers, MetricCollector apiCallMetricCollector, BatchGetCommitsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$batchDisassociateApprovalRuleTemplateFromRepositories$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$batchDisassociateApprovalRuleTemplateFromRepositories$10(List metricPublishers, MetricCollector apiCallMetricCollector, BatchDisassociateApprovalRuleTemplateFromRepositoriesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$batchDescribeMergeConflicts$8(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$batchDescribeMergeConflicts$7(List metricPublishers, MetricCollector apiCallMetricCollector, BatchDescribeMergeConflictsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$batchAssociateApprovalRuleTemplateWithRepositories$5(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$batchAssociateApprovalRuleTemplateWithRepositories$4(List metricPublishers, MetricCollector apiCallMetricCollector, BatchAssociateApprovalRuleTemplateWithRepositoriesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$associateApprovalRuleTemplateWithRepository$2(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$associateApprovalRuleTemplateWithRepository$1(List metricPublishers, MetricCollector apiCallMetricCollector, AssociateApprovalRuleTemplateWithRepositoryResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }
}

