/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codecommit;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.codecommit.CodeCommitClient;
import software.amazon.awssdk.services.codecommit.CodeCommitClientBuilder;
import software.amazon.awssdk.services.codecommit.CodeCommitServiceClientConfiguration;
import software.amazon.awssdk.services.codecommit.DefaultCodeCommitBaseClientBuilder;
import software.amazon.awssdk.services.codecommit.DefaultCodeCommitClient;
import software.amazon.awssdk.services.codecommit.endpoints.CodeCommitEndpointProvider;

@SdkInternalApi
final class DefaultCodeCommitClientBuilder
extends DefaultCodeCommitBaseClientBuilder<CodeCommitClientBuilder, CodeCommitClient>
implements CodeCommitClientBuilder {
    DefaultCodeCommitClientBuilder() {
    }

    @Override
    public DefaultCodeCommitClientBuilder endpointProvider(CodeCommitEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final CodeCommitClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultCodeCommitClientBuilder.validateClientOptions(clientConfiguration);
        URI endpointOverride = null;
        if (clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        CodeCommitServiceClientConfiguration serviceClientConfiguration = CodeCommitServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).build();
        return new DefaultCodeCommitClient(serviceClientConfiguration, clientConfiguration);
    }
}

