/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codecommit.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.codecommit.CodeCommitAsyncClient;
import software.amazon.awssdk.services.codecommit.model.GetCommentsForComparedCommitRequest;
import software.amazon.awssdk.services.codecommit.model.GetCommentsForComparedCommitResponse;

public class GetCommentsForComparedCommitPublisher
implements SdkPublisher<GetCommentsForComparedCommitResponse> {
    private final CodeCommitAsyncClient client;
    private final GetCommentsForComparedCommitRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetCommentsForComparedCommitPublisher(CodeCommitAsyncClient client, GetCommentsForComparedCommitRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetCommentsForComparedCommitPublisher(CodeCommitAsyncClient client, GetCommentsForComparedCommitRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetCommentsForComparedCommitResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetCommentsForComparedCommitResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class GetCommentsForComparedCommitResponseFetcher
    implements AsyncPageFetcher<GetCommentsForComparedCommitResponse> {
        private GetCommentsForComparedCommitResponseFetcher() {
        }

        public boolean hasNextPage(GetCommentsForComparedCommitResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetCommentsForComparedCommitResponse> nextPage(GetCommentsForComparedCommitResponse previousPage) {
            if (previousPage == null) {
                return GetCommentsForComparedCommitPublisher.this.client.getCommentsForComparedCommit(GetCommentsForComparedCommitPublisher.this.firstRequest);
            }
            return GetCommentsForComparedCommitPublisher.this.client.getCommentsForComparedCommit((GetCommentsForComparedCommitRequest)((Object)GetCommentsForComparedCommitPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

