/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codecommit.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeMergeConflictsRequest extends CodeCommitRequest implements
        ToCopyableBuilder<DescribeMergeConflictsRequest.Builder, DescribeMergeConflictsRequest> {
    private static final SdkField<String> REPOSITORY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("repositoryName").getter(getter(DescribeMergeConflictsRequest::repositoryName))
            .setter(setter(Builder::repositoryName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositoryName").build()).build();

    private static final SdkField<String> DESTINATION_COMMIT_SPECIFIER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("destinationCommitSpecifier")
            .getter(getter(DescribeMergeConflictsRequest::destinationCommitSpecifier))
            .setter(setter(Builder::destinationCommitSpecifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationCommitSpecifier").build())
            .build();

    private static final SdkField<String> SOURCE_COMMIT_SPECIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sourceCommitSpecifier").getter(getter(DescribeMergeConflictsRequest::sourceCommitSpecifier))
            .setter(setter(Builder::sourceCommitSpecifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceCommitSpecifier").build())
            .build();

    private static final SdkField<String> MERGE_OPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("mergeOption").getter(getter(DescribeMergeConflictsRequest::mergeOptionAsString))
            .setter(setter(Builder::mergeOption))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mergeOption").build()).build();

    private static final SdkField<Integer> MAX_MERGE_HUNKS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxMergeHunks").getter(getter(DescribeMergeConflictsRequest::maxMergeHunks))
            .setter(setter(Builder::maxMergeHunks))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxMergeHunks").build()).build();

    private static final SdkField<String> FILE_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("filePath").getter(getter(DescribeMergeConflictsRequest::filePath)).setter(setter(Builder::filePath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filePath").build()).build();

    private static final SdkField<String> CONFLICT_DETAIL_LEVEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("conflictDetailLevel").getter(getter(DescribeMergeConflictsRequest::conflictDetailLevelAsString))
            .setter(setter(Builder::conflictDetailLevel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("conflictDetailLevel").build())
            .build();

    private static final SdkField<String> CONFLICT_RESOLUTION_STRATEGY_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("conflictResolutionStrategy")
            .getter(getter(DescribeMergeConflictsRequest::conflictResolutionStrategyAsString))
            .setter(setter(Builder::conflictResolutionStrategy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("conflictResolutionStrategy").build())
            .build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(DescribeMergeConflictsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPOSITORY_NAME_FIELD,
            DESTINATION_COMMIT_SPECIFIER_FIELD, SOURCE_COMMIT_SPECIFIER_FIELD, MERGE_OPTION_FIELD, MAX_MERGE_HUNKS_FIELD,
            FILE_PATH_FIELD, CONFLICT_DETAIL_LEVEL_FIELD, CONFLICT_RESOLUTION_STRATEGY_FIELD, NEXT_TOKEN_FIELD));

    private final String repositoryName;

    private final String destinationCommitSpecifier;

    private final String sourceCommitSpecifier;

    private final String mergeOption;

    private final Integer maxMergeHunks;

    private final String filePath;

    private final String conflictDetailLevel;

    private final String conflictResolutionStrategy;

    private final String nextToken;

    private DescribeMergeConflictsRequest(BuilderImpl builder) {
        super(builder);
        this.repositoryName = builder.repositoryName;
        this.destinationCommitSpecifier = builder.destinationCommitSpecifier;
        this.sourceCommitSpecifier = builder.sourceCommitSpecifier;
        this.mergeOption = builder.mergeOption;
        this.maxMergeHunks = builder.maxMergeHunks;
        this.filePath = builder.filePath;
        this.conflictDetailLevel = builder.conflictDetailLevel;
        this.conflictResolutionStrategy = builder.conflictResolutionStrategy;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The name of the repository where you want to get information about a merge conflict.
     * </p>
     * 
     * @return The name of the repository where you want to get information about a merge conflict.
     */
    public final String repositoryName() {
        return repositoryName;
    }

    /**
     * <p>
     * The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, a branch name
     * or a full commit ID).
     * </p>
     * 
     * @return The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, a
     *         branch name or a full commit ID).
     */
    public final String destinationCommitSpecifier() {
        return destinationCommitSpecifier;
    }

    /**
     * <p>
     * The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, a branch name
     * or a full commit ID).
     * </p>
     * 
     * @return The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, a
     *         branch name or a full commit ID).
     */
    public final String sourceCommitSpecifier() {
        return sourceCommitSpecifier;
    }

    /**
     * <p>
     * The merge option or strategy you want to use to merge the code.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mergeOption} will
     * return {@link MergeOptionTypeEnum#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #mergeOptionAsString}.
     * </p>
     * 
     * @return The merge option or strategy you want to use to merge the code.
     * @see MergeOptionTypeEnum
     */
    public final MergeOptionTypeEnum mergeOption() {
        return MergeOptionTypeEnum.fromValue(mergeOption);
    }

    /**
     * <p>
     * The merge option or strategy you want to use to merge the code.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mergeOption} will
     * return {@link MergeOptionTypeEnum#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #mergeOptionAsString}.
     * </p>
     * 
     * @return The merge option or strategy you want to use to merge the code.
     * @see MergeOptionTypeEnum
     */
    public final String mergeOptionAsString() {
        return mergeOption;
    }

    /**
     * <p>
     * The maximum number of merge hunks to include in the output.
     * </p>
     * 
     * @return The maximum number of merge hunks to include in the output.
     */
    public final Integer maxMergeHunks() {
        return maxMergeHunks;
    }

    /**
     * <p>
     * The path of the target files used to describe the conflicts.
     * </p>
     * 
     * @return The path of the target files used to describe the conflicts.
     */
    public final String filePath() {
        return filePath;
    }

    /**
     * <p>
     * The level of conflict detail to use. If unspecified, the default FILE_LEVEL is used, which returns a
     * not-mergeable result if the same file has differences in both branches. If LINE_LEVEL is specified, a conflict is
     * considered not mergeable if the same file in both branches has differences on the same line.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #conflictDetailLevel} will return {@link ConflictDetailLevelTypeEnum#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #conflictDetailLevelAsString}.
     * </p>
     * 
     * @return The level of conflict detail to use. If unspecified, the default FILE_LEVEL is used, which returns a
     *         not-mergeable result if the same file has differences in both branches. If LINE_LEVEL is specified, a
     *         conflict is considered not mergeable if the same file in both branches has differences on the same line.
     * @see ConflictDetailLevelTypeEnum
     */
    public final ConflictDetailLevelTypeEnum conflictDetailLevel() {
        return ConflictDetailLevelTypeEnum.fromValue(conflictDetailLevel);
    }

    /**
     * <p>
     * The level of conflict detail to use. If unspecified, the default FILE_LEVEL is used, which returns a
     * not-mergeable result if the same file has differences in both branches. If LINE_LEVEL is specified, a conflict is
     * considered not mergeable if the same file in both branches has differences on the same line.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #conflictDetailLevel} will return {@link ConflictDetailLevelTypeEnum#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #conflictDetailLevelAsString}.
     * </p>
     * 
     * @return The level of conflict detail to use. If unspecified, the default FILE_LEVEL is used, which returns a
     *         not-mergeable result if the same file has differences in both branches. If LINE_LEVEL is specified, a
     *         conflict is considered not mergeable if the same file in both branches has differences on the same line.
     * @see ConflictDetailLevelTypeEnum
     */
    public final String conflictDetailLevelAsString() {
        return conflictDetailLevel;
    }

    /**
     * <p>
     * Specifies which branch to use when resolving conflicts, or whether to attempt automatically merging two versions
     * of a file. The default is NONE, which requires any conflicts to be resolved manually before the merge operation
     * is successful.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #conflictResolutionStrategy} will return {@link ConflictResolutionStrategyTypeEnum#UNKNOWN_TO_SDK_VERSION}
     * . The raw value returned by the service is available from {@link #conflictResolutionStrategyAsString}.
     * </p>
     * 
     * @return Specifies which branch to use when resolving conflicts, or whether to attempt automatically merging two
     *         versions of a file. The default is NONE, which requires any conflicts to be resolved manually before the
     *         merge operation is successful.
     * @see ConflictResolutionStrategyTypeEnum
     */
    public final ConflictResolutionStrategyTypeEnum conflictResolutionStrategy() {
        return ConflictResolutionStrategyTypeEnum.fromValue(conflictResolutionStrategy);
    }

    /**
     * <p>
     * Specifies which branch to use when resolving conflicts, or whether to attempt automatically merging two versions
     * of a file. The default is NONE, which requires any conflicts to be resolved manually before the merge operation
     * is successful.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #conflictResolutionStrategy} will return {@link ConflictResolutionStrategyTypeEnum#UNKNOWN_TO_SDK_VERSION}
     * . The raw value returned by the service is available from {@link #conflictResolutionStrategyAsString}.
     * </p>
     * 
     * @return Specifies which branch to use when resolving conflicts, or whether to attempt automatically merging two
     *         versions of a file. The default is NONE, which requires any conflicts to be resolved manually before the
     *         merge operation is successful.
     * @see ConflictResolutionStrategyTypeEnum
     */
    public final String conflictResolutionStrategyAsString() {
        return conflictResolutionStrategy;
    }

    /**
     * <p>
     * An enumeration token that, when provided in a request, returns the next batch of the results.
     * </p>
     * 
     * @return An enumeration token that, when provided in a request, returns the next batch of the results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(repositoryName());
        hashCode = 31 * hashCode + Objects.hashCode(destinationCommitSpecifier());
        hashCode = 31 * hashCode + Objects.hashCode(sourceCommitSpecifier());
        hashCode = 31 * hashCode + Objects.hashCode(mergeOptionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(maxMergeHunks());
        hashCode = 31 * hashCode + Objects.hashCode(filePath());
        hashCode = 31 * hashCode + Objects.hashCode(conflictDetailLevelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(conflictResolutionStrategyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeMergeConflictsRequest)) {
            return false;
        }
        DescribeMergeConflictsRequest other = (DescribeMergeConflictsRequest) obj;
        return Objects.equals(repositoryName(), other.repositoryName())
                && Objects.equals(destinationCommitSpecifier(), other.destinationCommitSpecifier())
                && Objects.equals(sourceCommitSpecifier(), other.sourceCommitSpecifier())
                && Objects.equals(mergeOptionAsString(), other.mergeOptionAsString())
                && Objects.equals(maxMergeHunks(), other.maxMergeHunks()) && Objects.equals(filePath(), other.filePath())
                && Objects.equals(conflictDetailLevelAsString(), other.conflictDetailLevelAsString())
                && Objects.equals(conflictResolutionStrategyAsString(), other.conflictResolutionStrategyAsString())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeMergeConflictsRequest").add("RepositoryName", repositoryName())
                .add("DestinationCommitSpecifier", destinationCommitSpecifier())
                .add("SourceCommitSpecifier", sourceCommitSpecifier()).add("MergeOption", mergeOptionAsString())
                .add("MaxMergeHunks", maxMergeHunks()).add("FilePath", filePath())
                .add("ConflictDetailLevel", conflictDetailLevelAsString())
                .add("ConflictResolutionStrategy", conflictResolutionStrategyAsString()).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "repositoryName":
            return Optional.ofNullable(clazz.cast(repositoryName()));
        case "destinationCommitSpecifier":
            return Optional.ofNullable(clazz.cast(destinationCommitSpecifier()));
        case "sourceCommitSpecifier":
            return Optional.ofNullable(clazz.cast(sourceCommitSpecifier()));
        case "mergeOption":
            return Optional.ofNullable(clazz.cast(mergeOptionAsString()));
        case "maxMergeHunks":
            return Optional.ofNullable(clazz.cast(maxMergeHunks()));
        case "filePath":
            return Optional.ofNullable(clazz.cast(filePath()));
        case "conflictDetailLevel":
            return Optional.ofNullable(clazz.cast(conflictDetailLevelAsString()));
        case "conflictResolutionStrategy":
            return Optional.ofNullable(clazz.cast(conflictResolutionStrategyAsString()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeMergeConflictsRequest, T> g) {
        return obj -> g.apply((DescribeMergeConflictsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeCommitRequest.Builder, SdkPojo, CopyableBuilder<Builder, DescribeMergeConflictsRequest> {
        /**
         * <p>
         * The name of the repository where you want to get information about a merge conflict.
         * </p>
         * 
         * @param repositoryName
         *        The name of the repository where you want to get information about a merge conflict.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repositoryName(String repositoryName);

        /**
         * <p>
         * The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, a branch
         * name or a full commit ID).
         * </p>
         * 
         * @param destinationCommitSpecifier
         *        The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, a
         *        branch name or a full commit ID).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationCommitSpecifier(String destinationCommitSpecifier);

        /**
         * <p>
         * The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, a branch
         * name or a full commit ID).
         * </p>
         * 
         * @param sourceCommitSpecifier
         *        The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, a
         *        branch name or a full commit ID).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceCommitSpecifier(String sourceCommitSpecifier);

        /**
         * <p>
         * The merge option or strategy you want to use to merge the code.
         * </p>
         * 
         * @param mergeOption
         *        The merge option or strategy you want to use to merge the code.
         * @see MergeOptionTypeEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MergeOptionTypeEnum
         */
        Builder mergeOption(String mergeOption);

        /**
         * <p>
         * The merge option or strategy you want to use to merge the code.
         * </p>
         * 
         * @param mergeOption
         *        The merge option or strategy you want to use to merge the code.
         * @see MergeOptionTypeEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MergeOptionTypeEnum
         */
        Builder mergeOption(MergeOptionTypeEnum mergeOption);

        /**
         * <p>
         * The maximum number of merge hunks to include in the output.
         * </p>
         * 
         * @param maxMergeHunks
         *        The maximum number of merge hunks to include in the output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxMergeHunks(Integer maxMergeHunks);

        /**
         * <p>
         * The path of the target files used to describe the conflicts.
         * </p>
         * 
         * @param filePath
         *        The path of the target files used to describe the conflicts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filePath(String filePath);

        /**
         * <p>
         * The level of conflict detail to use. If unspecified, the default FILE_LEVEL is used, which returns a
         * not-mergeable result if the same file has differences in both branches. If LINE_LEVEL is specified, a
         * conflict is considered not mergeable if the same file in both branches has differences on the same line.
         * </p>
         * 
         * @param conflictDetailLevel
         *        The level of conflict detail to use. If unspecified, the default FILE_LEVEL is used, which returns a
         *        not-mergeable result if the same file has differences in both branches. If LINE_LEVEL is specified, a
         *        conflict is considered not mergeable if the same file in both branches has differences on the same
         *        line.
         * @see ConflictDetailLevelTypeEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConflictDetailLevelTypeEnum
         */
        Builder conflictDetailLevel(String conflictDetailLevel);

        /**
         * <p>
         * The level of conflict detail to use. If unspecified, the default FILE_LEVEL is used, which returns a
         * not-mergeable result if the same file has differences in both branches. If LINE_LEVEL is specified, a
         * conflict is considered not mergeable if the same file in both branches has differences on the same line.
         * </p>
         * 
         * @param conflictDetailLevel
         *        The level of conflict detail to use. If unspecified, the default FILE_LEVEL is used, which returns a
         *        not-mergeable result if the same file has differences in both branches. If LINE_LEVEL is specified, a
         *        conflict is considered not mergeable if the same file in both branches has differences on the same
         *        line.
         * @see ConflictDetailLevelTypeEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConflictDetailLevelTypeEnum
         */
        Builder conflictDetailLevel(ConflictDetailLevelTypeEnum conflictDetailLevel);

        /**
         * <p>
         * Specifies which branch to use when resolving conflicts, or whether to attempt automatically merging two
         * versions of a file. The default is NONE, which requires any conflicts to be resolved manually before the
         * merge operation is successful.
         * </p>
         * 
         * @param conflictResolutionStrategy
         *        Specifies which branch to use when resolving conflicts, or whether to attempt automatically merging
         *        two versions of a file. The default is NONE, which requires any conflicts to be resolved manually
         *        before the merge operation is successful.
         * @see ConflictResolutionStrategyTypeEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConflictResolutionStrategyTypeEnum
         */
        Builder conflictResolutionStrategy(String conflictResolutionStrategy);

        /**
         * <p>
         * Specifies which branch to use when resolving conflicts, or whether to attempt automatically merging two
         * versions of a file. The default is NONE, which requires any conflicts to be resolved manually before the
         * merge operation is successful.
         * </p>
         * 
         * @param conflictResolutionStrategy
         *        Specifies which branch to use when resolving conflicts, or whether to attempt automatically merging
         *        two versions of a file. The default is NONE, which requires any conflicts to be resolved manually
         *        before the merge operation is successful.
         * @see ConflictResolutionStrategyTypeEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConflictResolutionStrategyTypeEnum
         */
        Builder conflictResolutionStrategy(ConflictResolutionStrategyTypeEnum conflictResolutionStrategy);

        /**
         * <p>
         * An enumeration token that, when provided in a request, returns the next batch of the results.
         * </p>
         * 
         * @param nextToken
         *        An enumeration token that, when provided in a request, returns the next batch of the results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CodeCommitRequest.BuilderImpl implements Builder {
        private String repositoryName;

        private String destinationCommitSpecifier;

        private String sourceCommitSpecifier;

        private String mergeOption;

        private Integer maxMergeHunks;

        private String filePath;

        private String conflictDetailLevel;

        private String conflictResolutionStrategy;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeMergeConflictsRequest model) {
            super(model);
            repositoryName(model.repositoryName);
            destinationCommitSpecifier(model.destinationCommitSpecifier);
            sourceCommitSpecifier(model.sourceCommitSpecifier);
            mergeOption(model.mergeOption);
            maxMergeHunks(model.maxMergeHunks);
            filePath(model.filePath);
            conflictDetailLevel(model.conflictDetailLevel);
            conflictResolutionStrategy(model.conflictResolutionStrategy);
            nextToken(model.nextToken);
        }

        public final String getRepositoryName() {
            return repositoryName;
        }

        public final void setRepositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
        }

        @Override
        public final Builder repositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
            return this;
        }

        public final String getDestinationCommitSpecifier() {
            return destinationCommitSpecifier;
        }

        public final void setDestinationCommitSpecifier(String destinationCommitSpecifier) {
            this.destinationCommitSpecifier = destinationCommitSpecifier;
        }

        @Override
        public final Builder destinationCommitSpecifier(String destinationCommitSpecifier) {
            this.destinationCommitSpecifier = destinationCommitSpecifier;
            return this;
        }

        public final String getSourceCommitSpecifier() {
            return sourceCommitSpecifier;
        }

        public final void setSourceCommitSpecifier(String sourceCommitSpecifier) {
            this.sourceCommitSpecifier = sourceCommitSpecifier;
        }

        @Override
        public final Builder sourceCommitSpecifier(String sourceCommitSpecifier) {
            this.sourceCommitSpecifier = sourceCommitSpecifier;
            return this;
        }

        public final String getMergeOption() {
            return mergeOption;
        }

        public final void setMergeOption(String mergeOption) {
            this.mergeOption = mergeOption;
        }

        @Override
        public final Builder mergeOption(String mergeOption) {
            this.mergeOption = mergeOption;
            return this;
        }

        @Override
        public final Builder mergeOption(MergeOptionTypeEnum mergeOption) {
            this.mergeOption(mergeOption == null ? null : mergeOption.toString());
            return this;
        }

        public final Integer getMaxMergeHunks() {
            return maxMergeHunks;
        }

        public final void setMaxMergeHunks(Integer maxMergeHunks) {
            this.maxMergeHunks = maxMergeHunks;
        }

        @Override
        public final Builder maxMergeHunks(Integer maxMergeHunks) {
            this.maxMergeHunks = maxMergeHunks;
            return this;
        }

        public final String getFilePath() {
            return filePath;
        }

        public final void setFilePath(String filePath) {
            this.filePath = filePath;
        }

        @Override
        public final Builder filePath(String filePath) {
            this.filePath = filePath;
            return this;
        }

        public final String getConflictDetailLevel() {
            return conflictDetailLevel;
        }

        public final void setConflictDetailLevel(String conflictDetailLevel) {
            this.conflictDetailLevel = conflictDetailLevel;
        }

        @Override
        public final Builder conflictDetailLevel(String conflictDetailLevel) {
            this.conflictDetailLevel = conflictDetailLevel;
            return this;
        }

        @Override
        public final Builder conflictDetailLevel(ConflictDetailLevelTypeEnum conflictDetailLevel) {
            this.conflictDetailLevel(conflictDetailLevel == null ? null : conflictDetailLevel.toString());
            return this;
        }

        public final String getConflictResolutionStrategy() {
            return conflictResolutionStrategy;
        }

        public final void setConflictResolutionStrategy(String conflictResolutionStrategy) {
            this.conflictResolutionStrategy = conflictResolutionStrategy;
        }

        @Override
        public final Builder conflictResolutionStrategy(String conflictResolutionStrategy) {
            this.conflictResolutionStrategy = conflictResolutionStrategy;
            return this;
        }

        @Override
        public final Builder conflictResolutionStrategy(ConflictResolutionStrategyTypeEnum conflictResolutionStrategy) {
            this.conflictResolutionStrategy(conflictResolutionStrategy == null ? null : conflictResolutionStrategy.toString());
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeMergeConflictsRequest build() {
            return new DescribeMergeConflictsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
