/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codecommit.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.codecommit.CodeCommitClient;
import software.amazon.awssdk.services.codecommit.internal.UserAgentUtils;
import software.amazon.awssdk.services.codecommit.model.GetCommentsForPullRequestRequest;
import software.amazon.awssdk.services.codecommit.model.GetCommentsForPullRequestResponse;

public class GetCommentsForPullRequestIterable
implements SdkIterable<GetCommentsForPullRequestResponse> {
    private final CodeCommitClient client;
    private final GetCommentsForPullRequestRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetCommentsForPullRequestIterable(CodeCommitClient client, GetCommentsForPullRequestRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new GetCommentsForPullRequestResponseFetcher();
    }

    public Iterator<GetCommentsForPullRequestResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class GetCommentsForPullRequestResponseFetcher
    implements SyncPageFetcher<GetCommentsForPullRequestResponse> {
        private GetCommentsForPullRequestResponseFetcher() {
        }

        public boolean hasNextPage(GetCommentsForPullRequestResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetCommentsForPullRequestResponse nextPage(GetCommentsForPullRequestResponse previousPage) {
            if (previousPage == null) {
                return GetCommentsForPullRequestIterable.this.client.getCommentsForPullRequest(GetCommentsForPullRequestIterable.this.firstRequest);
            }
            return GetCommentsForPullRequestIterable.this.client.getCommentsForPullRequest((GetCommentsForPullRequestRequest)((Object)GetCommentsForPullRequestIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

