/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codecommit.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteFileResponse extends CodeCommitResponse implements
        ToCopyableBuilder<DeleteFileResponse.Builder, DeleteFileResponse> {
    private static final SdkField<String> COMMIT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("commitId").getter(getter(DeleteFileResponse::commitId)).setter(setter(Builder::commitId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("commitId").build()).build();

    private static final SdkField<String> BLOB_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("blobId")
            .getter(getter(DeleteFileResponse::blobId)).setter(setter(Builder::blobId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blobId").build()).build();

    private static final SdkField<String> TREE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("treeId")
            .getter(getter(DeleteFileResponse::treeId)).setter(setter(Builder::treeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("treeId").build()).build();

    private static final SdkField<String> FILE_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("filePath").getter(getter(DeleteFileResponse::filePath)).setter(setter(Builder::filePath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filePath").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMMIT_ID_FIELD,
            BLOB_ID_FIELD, TREE_ID_FIELD, FILE_PATH_FIELD));

    private final String commitId;

    private final String blobId;

    private final String treeId;

    private final String filePath;

    private DeleteFileResponse(BuilderImpl builder) {
        super(builder);
        this.commitId = builder.commitId;
        this.blobId = builder.blobId;
        this.treeId = builder.treeId;
        this.filePath = builder.filePath;
    }

    /**
     * <p>
     * The full commit ID of the commit that contains the change that deletes the file.
     * </p>
     * 
     * @return The full commit ID of the commit that contains the change that deletes the file.
     */
    public final String commitId() {
        return commitId;
    }

    /**
     * <p>
     * The blob ID removed from the tree as part of deleting the file.
     * </p>
     * 
     * @return The blob ID removed from the tree as part of deleting the file.
     */
    public final String blobId() {
        return blobId;
    }

    /**
     * <p>
     * The full SHA-1 pointer of the tree information for the commit that contains the delete file change.
     * </p>
     * 
     * @return The full SHA-1 pointer of the tree information for the commit that contains the delete file change.
     */
    public final String treeId() {
        return treeId;
    }

    /**
     * <p>
     * The fully qualified path to the file to be deleted, including the full name and extension of that file.
     * </p>
     * 
     * @return The fully qualified path to the file to be deleted, including the full name and extension of that file.
     */
    public final String filePath() {
        return filePath;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(commitId());
        hashCode = 31 * hashCode + Objects.hashCode(blobId());
        hashCode = 31 * hashCode + Objects.hashCode(treeId());
        hashCode = 31 * hashCode + Objects.hashCode(filePath());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteFileResponse)) {
            return false;
        }
        DeleteFileResponse other = (DeleteFileResponse) obj;
        return Objects.equals(commitId(), other.commitId()) && Objects.equals(blobId(), other.blobId())
                && Objects.equals(treeId(), other.treeId()) && Objects.equals(filePath(), other.filePath());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteFileResponse").add("CommitId", commitId()).add("BlobId", blobId()).add("TreeId", treeId())
                .add("FilePath", filePath()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "commitId":
            return Optional.ofNullable(clazz.cast(commitId()));
        case "blobId":
            return Optional.ofNullable(clazz.cast(blobId()));
        case "treeId":
            return Optional.ofNullable(clazz.cast(treeId()));
        case "filePath":
            return Optional.ofNullable(clazz.cast(filePath()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteFileResponse, T> g) {
        return obj -> g.apply((DeleteFileResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeCommitResponse.Builder, SdkPojo, CopyableBuilder<Builder, DeleteFileResponse> {
        /**
         * <p>
         * The full commit ID of the commit that contains the change that deletes the file.
         * </p>
         * 
         * @param commitId
         *        The full commit ID of the commit that contains the change that deletes the file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder commitId(String commitId);

        /**
         * <p>
         * The blob ID removed from the tree as part of deleting the file.
         * </p>
         * 
         * @param blobId
         *        The blob ID removed from the tree as part of deleting the file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blobId(String blobId);

        /**
         * <p>
         * The full SHA-1 pointer of the tree information for the commit that contains the delete file change.
         * </p>
         * 
         * @param treeId
         *        The full SHA-1 pointer of the tree information for the commit that contains the delete file change.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder treeId(String treeId);

        /**
         * <p>
         * The fully qualified path to the file to be deleted, including the full name and extension of that file.
         * </p>
         * 
         * @param filePath
         *        The fully qualified path to the file to be deleted, including the full name and extension of that
         *        file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filePath(String filePath);
    }

    static final class BuilderImpl extends CodeCommitResponse.BuilderImpl implements Builder {
        private String commitId;

        private String blobId;

        private String treeId;

        private String filePath;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteFileResponse model) {
            super(model);
            commitId(model.commitId);
            blobId(model.blobId);
            treeId(model.treeId);
            filePath(model.filePath);
        }

        public final String getCommitId() {
            return commitId;
        }

        public final void setCommitId(String commitId) {
            this.commitId = commitId;
        }

        @Override
        public final Builder commitId(String commitId) {
            this.commitId = commitId;
            return this;
        }

        public final String getBlobId() {
            return blobId;
        }

        public final void setBlobId(String blobId) {
            this.blobId = blobId;
        }

        @Override
        public final Builder blobId(String blobId) {
            this.blobId = blobId;
            return this;
        }

        public final String getTreeId() {
            return treeId;
        }

        public final void setTreeId(String treeId) {
            this.treeId = treeId;
        }

        @Override
        public final Builder treeId(String treeId) {
            this.treeId = treeId;
            return this;
        }

        public final String getFilePath() {
            return filePath;
        }

        public final void setFilePath(String filePath) {
            this.filePath = filePath;
        }

        @Override
        public final Builder filePath(String filePath) {
            this.filePath = filePath;
            return this;
        }

        @Override
        public DeleteFileResponse build() {
            return new DeleteFileResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
