/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codecommit.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class MergeHunksCopier {
    static List<MergeHunk> copy(Collection<? extends MergeHunk> mergeHunksParam) {
        List<MergeHunk> list;
        if (mergeHunksParam == null || mergeHunksParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<MergeHunk> modifiableList = new ArrayList<>();
            mergeHunksParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<MergeHunk> copyFromBuilder(Collection<? extends MergeHunk.Builder> mergeHunksParam) {
        List<MergeHunk> list;
        if (mergeHunksParam == null || mergeHunksParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<MergeHunk> modifiableList = new ArrayList<>();
            mergeHunksParam.forEach(entry -> {
                MergeHunk member = entry == null ? null : entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<MergeHunk.Builder> copyToBuilder(Collection<? extends MergeHunk> mergeHunksParam) {
        List<MergeHunk.Builder> list;
        if (mergeHunksParam == null || mergeHunksParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<MergeHunk.Builder> modifiableList = new ArrayList<>();
            mergeHunksParam.forEach(entry -> {
                MergeHunk.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
