/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codecommit.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetCommentReactionsRequest extends CodeCommitRequest implements
        ToCopyableBuilder<GetCommentReactionsRequest.Builder, GetCommentReactionsRequest> {
    private static final SdkField<String> COMMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("commentId").getter(getter(GetCommentReactionsRequest::commentId)).setter(setter(Builder::commentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("commentId").build()).build();

    private static final SdkField<String> REACTION_USER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("reactionUserArn").getter(getter(GetCommentReactionsRequest::reactionUserArn))
            .setter(setter(Builder::reactionUserArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reactionUserArn").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(GetCommentReactionsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(GetCommentReactionsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMMENT_ID_FIELD,
            REACTION_USER_ARN_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));

    private final String commentId;

    private final String reactionUserArn;

    private final String nextToken;

    private final Integer maxResults;

    private GetCommentReactionsRequest(BuilderImpl builder) {
        super(builder);
        this.commentId = builder.commentId;
        this.reactionUserArn = builder.reactionUserArn;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * <p>
     * The ID of the comment for which you want to get reactions information.
     * </p>
     * 
     * @return The ID of the comment for which you want to get reactions information.
     */
    public final String commentId() {
        return commentId;
    }

    /**
     * <p>
     * Optional. The Amazon Resource Name (ARN) of the user or identity for which you want to get reaction information.
     * </p>
     * 
     * @return Optional. The Amazon Resource Name (ARN) of the user or identity for which you want to get reaction
     *         information.
     */
    public final String reactionUserArn() {
        return reactionUserArn;
    }

    /**
     * <p>
     * An enumeration token that, when provided in a request, returns the next batch of the results.
     * </p>
     * 
     * @return An enumeration token that, when provided in a request, returns the next batch of the results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * A non-zero, non-negative integer used to limit the number of returned results. The default is the same as the
     * allowed maximum, 1,000.
     * </p>
     * 
     * @return A non-zero, non-negative integer used to limit the number of returned results. The default is the same as
     *         the allowed maximum, 1,000.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(commentId());
        hashCode = 31 * hashCode + Objects.hashCode(reactionUserArn());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCommentReactionsRequest)) {
            return false;
        }
        GetCommentReactionsRequest other = (GetCommentReactionsRequest) obj;
        return Objects.equals(commentId(), other.commentId()) && Objects.equals(reactionUserArn(), other.reactionUserArn())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetCommentReactionsRequest").add("CommentId", commentId())
                .add("ReactionUserArn", reactionUserArn()).add("NextToken", nextToken()).add("MaxResults", maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "commentId":
            return Optional.ofNullable(clazz.cast(commentId()));
        case "reactionUserArn":
            return Optional.ofNullable(clazz.cast(reactionUserArn()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetCommentReactionsRequest, T> g) {
        return obj -> g.apply((GetCommentReactionsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeCommitRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetCommentReactionsRequest> {
        /**
         * <p>
         * The ID of the comment for which you want to get reactions information.
         * </p>
         * 
         * @param commentId
         *        The ID of the comment for which you want to get reactions information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder commentId(String commentId);

        /**
         * <p>
         * Optional. The Amazon Resource Name (ARN) of the user or identity for which you want to get reaction
         * information.
         * </p>
         * 
         * @param reactionUserArn
         *        Optional. The Amazon Resource Name (ARN) of the user or identity for which you want to get reaction
         *        information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reactionUserArn(String reactionUserArn);

        /**
         * <p>
         * An enumeration token that, when provided in a request, returns the next batch of the results.
         * </p>
         * 
         * @param nextToken
         *        An enumeration token that, when provided in a request, returns the next batch of the results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * A non-zero, non-negative integer used to limit the number of returned results. The default is the same as the
         * allowed maximum, 1,000.
         * </p>
         * 
         * @param maxResults
         *        A non-zero, non-negative integer used to limit the number of returned results. The default is the same
         *        as the allowed maximum, 1,000.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CodeCommitRequest.BuilderImpl implements Builder {
        private String commentId;

        private String reactionUserArn;

        private String nextToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(GetCommentReactionsRequest model) {
            super(model);
            commentId(model.commentId);
            reactionUserArn(model.reactionUserArn);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
        }

        public final String getCommentId() {
            return commentId;
        }

        public final void setCommentId(String commentId) {
            this.commentId = commentId;
        }

        @Override
        public final Builder commentId(String commentId) {
            this.commentId = commentId;
            return this;
        }

        public final String getReactionUserArn() {
            return reactionUserArn;
        }

        public final void setReactionUserArn(String reactionUserArn) {
            this.reactionUserArn = reactionUserArn;
        }

        @Override
        public final Builder reactionUserArn(String reactionUserArn) {
            this.reactionUserArn = reactionUserArn;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetCommentReactionsRequest build() {
            return new GetCommentReactionsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
