/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codecommit.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.codecommit.CodeCommitClient;
import software.amazon.awssdk.services.codecommit.internal.UserAgentUtils;
import software.amazon.awssdk.services.codecommit.model.GetMergeConflictsRequest;
import software.amazon.awssdk.services.codecommit.model.GetMergeConflictsResponse;

public class GetMergeConflictsIterable
implements SdkIterable<GetMergeConflictsResponse> {
    private final CodeCommitClient client;
    private final GetMergeConflictsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetMergeConflictsIterable(CodeCommitClient client, GetMergeConflictsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new GetMergeConflictsResponseFetcher();
    }

    public Iterator<GetMergeConflictsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class GetMergeConflictsResponseFetcher
    implements SyncPageFetcher<GetMergeConflictsResponse> {
        private GetMergeConflictsResponseFetcher() {
        }

        public boolean hasNextPage(GetMergeConflictsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetMergeConflictsResponse nextPage(GetMergeConflictsResponse previousPage) {
            if (previousPage == null) {
                return GetMergeConflictsIterable.this.client.getMergeConflicts(GetMergeConflictsIterable.this.firstRequest);
            }
            return GetMergeConflictsIterable.this.client.getMergeConflicts((GetMergeConflictsRequest)((Object)GetMergeConflictsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

