/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codecommit.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteCommentContentResponse extends CodeCommitResponse implements
        ToCopyableBuilder<DeleteCommentContentResponse.Builder, DeleteCommentContentResponse> {
    private static final SdkField<Comment> COMMENT_FIELD = SdkField.<Comment> builder(MarshallingType.SDK_POJO)
            .memberName("comment").getter(getter(DeleteCommentContentResponse::comment)).setter(setter(Builder::comment))
            .constructor(Comment::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("comment").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMMENT_FIELD));

    private final Comment comment;

    private DeleteCommentContentResponse(BuilderImpl builder) {
        super(builder);
        this.comment = builder.comment;
    }

    /**
     * <p>
     * Information about the comment you just deleted.
     * </p>
     * 
     * @return Information about the comment you just deleted.
     */
    public final Comment comment() {
        return comment;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(comment());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteCommentContentResponse)) {
            return false;
        }
        DeleteCommentContentResponse other = (DeleteCommentContentResponse) obj;
        return Objects.equals(comment(), other.comment());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteCommentContentResponse").add("Comment", comment()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "comment":
            return Optional.ofNullable(clazz.cast(comment()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteCommentContentResponse, T> g) {
        return obj -> g.apply((DeleteCommentContentResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeCommitResponse.Builder, SdkPojo, CopyableBuilder<Builder, DeleteCommentContentResponse> {
        /**
         * <p>
         * Information about the comment you just deleted.
         * </p>
         * 
         * @param comment
         *        Information about the comment you just deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder comment(Comment comment);

        /**
         * <p>
         * Information about the comment you just deleted.
         * </p>
         * This is a convenience method that creates an instance of the {@link Comment.Builder} avoiding the need to
         * create one manually via {@link Comment#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Comment.Builder#build()} is called immediately and its result is
         * passed to {@link #comment(Comment)}.
         * 
         * @param comment
         *        a consumer that will call methods on {@link Comment.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #comment(Comment)
         */
        default Builder comment(Consumer<Comment.Builder> comment) {
            return comment(Comment.builder().applyMutation(comment).build());
        }
    }

    static final class BuilderImpl extends CodeCommitResponse.BuilderImpl implements Builder {
        private Comment comment;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteCommentContentResponse model) {
            super(model);
            comment(model.comment);
        }

        public final Comment.Builder getComment() {
            return comment != null ? comment.toBuilder() : null;
        }

        public final void setComment(Comment.BuilderImpl comment) {
            this.comment = comment != null ? comment.build() : null;
        }

        @Override
        public final Builder comment(Comment comment) {
            this.comment = comment;
            return this;
        }

        @Override
        public DeleteCommentContentResponse build() {
            return new DeleteCommentContentResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
