/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codecommit.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codecommit.model.BlobMetadata;
import software.amazon.awssdk.services.codecommit.model.ChangeTypeEnum;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Difference
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Difference> {
    private static final SdkField<BlobMetadata> BEFORE_BLOB_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("beforeBlob").getter(Difference.getter(Difference::beforeBlob)).setter(Difference.setter(Builder::beforeBlob)).constructor(BlobMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("beforeBlob").build()}).build();
    private static final SdkField<BlobMetadata> AFTER_BLOB_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("afterBlob").getter(Difference.getter(Difference::afterBlob)).setter(Difference.setter(Builder::afterBlob)).constructor(BlobMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("afterBlob").build()}).build();
    private static final SdkField<String> CHANGE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("changeType").getter(Difference.getter(Difference::changeTypeAsString)).setter(Difference.setter(Builder::changeType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("changeType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BEFORE_BLOB_FIELD, AFTER_BLOB_FIELD, CHANGE_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("beforeBlob", BEFORE_BLOB_FIELD);
            this.put("afterBlob", AFTER_BLOB_FIELD);
            this.put("changeType", CHANGE_TYPE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final BlobMetadata beforeBlob;
    private final BlobMetadata afterBlob;
    private final String changeType;

    private Difference(BuilderImpl builder) {
        this.beforeBlob = builder.beforeBlob;
        this.afterBlob = builder.afterBlob;
        this.changeType = builder.changeType;
    }

    public final BlobMetadata beforeBlob() {
        return this.beforeBlob;
    }

    public final BlobMetadata afterBlob() {
        return this.afterBlob;
    }

    public final ChangeTypeEnum changeType() {
        return ChangeTypeEnum.fromValue(this.changeType);
    }

    public final String changeTypeAsString() {
        return this.changeType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.beforeBlob());
        hashCode = 31 * hashCode + Objects.hashCode(this.afterBlob());
        hashCode = 31 * hashCode + Objects.hashCode(this.changeTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Difference)) {
            return false;
        }
        Difference other = (Difference)obj;
        return Objects.equals(this.beforeBlob(), other.beforeBlob()) && Objects.equals(this.afterBlob(), other.afterBlob()) && Objects.equals(this.changeTypeAsString(), other.changeTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"Difference").add("BeforeBlob", (Object)this.beforeBlob()).add("AfterBlob", (Object)this.afterBlob()).add("ChangeType", (Object)this.changeTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "beforeBlob": {
                return Optional.ofNullable(clazz.cast(this.beforeBlob()));
            }
            case "afterBlob": {
                return Optional.ofNullable(clazz.cast(this.afterBlob()));
            }
            case "changeType": {
                return Optional.ofNullable(clazz.cast(this.changeTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<Difference, T> g) {
        return obj -> g.apply((Difference)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private BlobMetadata beforeBlob;
        private BlobMetadata afterBlob;
        private String changeType;

        private BuilderImpl() {
        }

        private BuilderImpl(Difference model) {
            this.beforeBlob(model.beforeBlob);
            this.afterBlob(model.afterBlob);
            this.changeType(model.changeType);
        }

        public final BlobMetadata.Builder getBeforeBlob() {
            return this.beforeBlob != null ? this.beforeBlob.toBuilder() : null;
        }

        public final void setBeforeBlob(BlobMetadata.BuilderImpl beforeBlob) {
            this.beforeBlob = beforeBlob != null ? beforeBlob.build() : null;
        }

        @Override
        public final Builder beforeBlob(BlobMetadata beforeBlob) {
            this.beforeBlob = beforeBlob;
            return this;
        }

        public final BlobMetadata.Builder getAfterBlob() {
            return this.afterBlob != null ? this.afterBlob.toBuilder() : null;
        }

        public final void setAfterBlob(BlobMetadata.BuilderImpl afterBlob) {
            this.afterBlob = afterBlob != null ? afterBlob.build() : null;
        }

        @Override
        public final Builder afterBlob(BlobMetadata afterBlob) {
            this.afterBlob = afterBlob;
            return this;
        }

        public final String getChangeType() {
            return this.changeType;
        }

        public final void setChangeType(String changeType) {
            this.changeType = changeType;
        }

        @Override
        public final Builder changeType(String changeType) {
            this.changeType = changeType;
            return this;
        }

        @Override
        public final Builder changeType(ChangeTypeEnum changeType) {
            this.changeType(changeType == null ? null : changeType.toString());
            return this;
        }

        public Difference build() {
            return new Difference(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Difference> {
        public Builder beforeBlob(BlobMetadata var1);

        default public Builder beforeBlob(Consumer<BlobMetadata.Builder> beforeBlob) {
            return this.beforeBlob((BlobMetadata)((BlobMetadata.Builder)BlobMetadata.builder().applyMutation(beforeBlob)).build());
        }

        public Builder afterBlob(BlobMetadata var1);

        default public Builder afterBlob(Consumer<BlobMetadata.Builder> afterBlob) {
            return this.afterBlob((BlobMetadata)((BlobMetadata.Builder)BlobMetadata.builder().applyMutation(afterBlob)).build());
        }

        public Builder changeType(String var1);

        public Builder changeType(ChangeTypeEnum var1);
    }
}

