/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codecommit.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.codecommit.model.CodeCommitResponse;
import software.amazon.awssdk.services.codecommit.model.ConflictMetadata;
import software.amazon.awssdk.services.codecommit.model.ConflictMetadataListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetMergeConflictsResponse
extends CodeCommitResponse
implements ToCopyableBuilder<Builder, GetMergeConflictsResponse> {
    private static final SdkField<Boolean> MERGEABLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("mergeable").getter(GetMergeConflictsResponse.getter(GetMergeConflictsResponse::mergeable)).setter(GetMergeConflictsResponse.setter(Builder::mergeable)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mergeable").build()}).build();
    private static final SdkField<String> DESTINATION_COMMIT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("destinationCommitId").getter(GetMergeConflictsResponse.getter(GetMergeConflictsResponse::destinationCommitId)).setter(GetMergeConflictsResponse.setter(Builder::destinationCommitId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationCommitId").build()}).build();
    private static final SdkField<String> SOURCE_COMMIT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sourceCommitId").getter(GetMergeConflictsResponse.getter(GetMergeConflictsResponse::sourceCommitId)).setter(GetMergeConflictsResponse.setter(Builder::sourceCommitId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceCommitId").build()}).build();
    private static final SdkField<String> BASE_COMMIT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("baseCommitId").getter(GetMergeConflictsResponse.getter(GetMergeConflictsResponse::baseCommitId)).setter(GetMergeConflictsResponse.setter(Builder::baseCommitId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("baseCommitId").build()}).build();
    private static final SdkField<List<ConflictMetadata>> CONFLICT_METADATA_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("conflictMetadataList").getter(GetMergeConflictsResponse.getter(GetMergeConflictsResponse::conflictMetadataList)).setter(GetMergeConflictsResponse.setter(Builder::conflictMetadataList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("conflictMetadataList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ConflictMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(GetMergeConflictsResponse.getter(GetMergeConflictsResponse::nextToken)).setter(GetMergeConflictsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MERGEABLE_FIELD, DESTINATION_COMMIT_ID_FIELD, SOURCE_COMMIT_ID_FIELD, BASE_COMMIT_ID_FIELD, CONFLICT_METADATA_LIST_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("mergeable", MERGEABLE_FIELD);
            this.put("destinationCommitId", DESTINATION_COMMIT_ID_FIELD);
            this.put("sourceCommitId", SOURCE_COMMIT_ID_FIELD);
            this.put("baseCommitId", BASE_COMMIT_ID_FIELD);
            this.put("conflictMetadataList", CONFLICT_METADATA_LIST_FIELD);
            this.put("nextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final Boolean mergeable;
    private final String destinationCommitId;
    private final String sourceCommitId;
    private final String baseCommitId;
    private final List<ConflictMetadata> conflictMetadataList;
    private final String nextToken;

    private GetMergeConflictsResponse(BuilderImpl builder) {
        super(builder);
        this.mergeable = builder.mergeable;
        this.destinationCommitId = builder.destinationCommitId;
        this.sourceCommitId = builder.sourceCommitId;
        this.baseCommitId = builder.baseCommitId;
        this.conflictMetadataList = builder.conflictMetadataList;
        this.nextToken = builder.nextToken;
    }

    public final Boolean mergeable() {
        return this.mergeable;
    }

    public final String destinationCommitId() {
        return this.destinationCommitId;
    }

    public final String sourceCommitId() {
        return this.sourceCommitId;
    }

    public final String baseCommitId() {
        return this.baseCommitId;
    }

    public final boolean hasConflictMetadataList() {
        return this.conflictMetadataList != null && !(this.conflictMetadataList instanceof SdkAutoConstructList);
    }

    public final List<ConflictMetadata> conflictMetadataList() {
        return this.conflictMetadataList;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.mergeable());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationCommitId());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceCommitId());
        hashCode = 31 * hashCode + Objects.hashCode(this.baseCommitId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasConflictMetadataList() ? this.conflictMetadataList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetMergeConflictsResponse)) {
            return false;
        }
        GetMergeConflictsResponse other = (GetMergeConflictsResponse)((Object)obj);
        return Objects.equals(this.mergeable(), other.mergeable()) && Objects.equals(this.destinationCommitId(), other.destinationCommitId()) && Objects.equals(this.sourceCommitId(), other.sourceCommitId()) && Objects.equals(this.baseCommitId(), other.baseCommitId()) && this.hasConflictMetadataList() == other.hasConflictMetadataList() && Objects.equals(this.conflictMetadataList(), other.conflictMetadataList()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"GetMergeConflictsResponse").add("Mergeable", (Object)this.mergeable()).add("DestinationCommitId", (Object)this.destinationCommitId()).add("SourceCommitId", (Object)this.sourceCommitId()).add("BaseCommitId", (Object)this.baseCommitId()).add("ConflictMetadataList", this.hasConflictMetadataList() ? this.conflictMetadataList() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "mergeable": {
                return Optional.ofNullable(clazz.cast(this.mergeable()));
            }
            case "destinationCommitId": {
                return Optional.ofNullable(clazz.cast(this.destinationCommitId()));
            }
            case "sourceCommitId": {
                return Optional.ofNullable(clazz.cast(this.sourceCommitId()));
            }
            case "baseCommitId": {
                return Optional.ofNullable(clazz.cast(this.baseCommitId()));
            }
            case "conflictMetadataList": {
                return Optional.ofNullable(clazz.cast(this.conflictMetadataList()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetMergeConflictsResponse, T> g) {
        return obj -> g.apply((GetMergeConflictsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeCommitResponse.BuilderImpl
    implements Builder {
        private Boolean mergeable;
        private String destinationCommitId;
        private String sourceCommitId;
        private String baseCommitId;
        private List<ConflictMetadata> conflictMetadataList = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetMergeConflictsResponse model) {
            super(model);
            this.mergeable(model.mergeable);
            this.destinationCommitId(model.destinationCommitId);
            this.sourceCommitId(model.sourceCommitId);
            this.baseCommitId(model.baseCommitId);
            this.conflictMetadataList(model.conflictMetadataList);
            this.nextToken(model.nextToken);
        }

        public final Boolean getMergeable() {
            return this.mergeable;
        }

        public final void setMergeable(Boolean mergeable) {
            this.mergeable = mergeable;
        }

        @Override
        public final Builder mergeable(Boolean mergeable) {
            this.mergeable = mergeable;
            return this;
        }

        public final String getDestinationCommitId() {
            return this.destinationCommitId;
        }

        public final void setDestinationCommitId(String destinationCommitId) {
            this.destinationCommitId = destinationCommitId;
        }

        @Override
        public final Builder destinationCommitId(String destinationCommitId) {
            this.destinationCommitId = destinationCommitId;
            return this;
        }

        public final String getSourceCommitId() {
            return this.sourceCommitId;
        }

        public final void setSourceCommitId(String sourceCommitId) {
            this.sourceCommitId = sourceCommitId;
        }

        @Override
        public final Builder sourceCommitId(String sourceCommitId) {
            this.sourceCommitId = sourceCommitId;
            return this;
        }

        public final String getBaseCommitId() {
            return this.baseCommitId;
        }

        public final void setBaseCommitId(String baseCommitId) {
            this.baseCommitId = baseCommitId;
        }

        @Override
        public final Builder baseCommitId(String baseCommitId) {
            this.baseCommitId = baseCommitId;
            return this;
        }

        public final List<ConflictMetadata.Builder> getConflictMetadataList() {
            List<ConflictMetadata.Builder> result = ConflictMetadataListCopier.copyToBuilder(this.conflictMetadataList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setConflictMetadataList(Collection<ConflictMetadata.BuilderImpl> conflictMetadataList) {
            this.conflictMetadataList = ConflictMetadataListCopier.copyFromBuilder(conflictMetadataList);
        }

        @Override
        public final Builder conflictMetadataList(Collection<ConflictMetadata> conflictMetadataList) {
            this.conflictMetadataList = ConflictMetadataListCopier.copy(conflictMetadataList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder conflictMetadataList(ConflictMetadata ... conflictMetadataList) {
            this.conflictMetadataList(Arrays.asList(conflictMetadataList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder conflictMetadataList(Consumer<ConflictMetadata.Builder> ... conflictMetadataList) {
            this.conflictMetadataList(Stream.of(conflictMetadataList).map(c -> (ConflictMetadata)((ConflictMetadata.Builder)ConflictMetadata.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public GetMergeConflictsResponse build() {
            return new GetMergeConflictsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CodeCommitResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetMergeConflictsResponse> {
        public Builder mergeable(Boolean var1);

        public Builder destinationCommitId(String var1);

        public Builder sourceCommitId(String var1);

        public Builder baseCommitId(String var1);

        public Builder conflictMetadataList(Collection<ConflictMetadata> var1);

        public Builder conflictMetadataList(ConflictMetadata ... var1);

        public Builder conflictMetadataList(Consumer<ConflictMetadata.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

