/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codecommit.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.codecommit.model.CodeCommitResponse;
import software.amazon.awssdk.services.codecommit.model.RepositoryTrigger;
import software.amazon.awssdk.services.codecommit.model.RepositoryTriggersListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetRepositoryTriggersResponse
extends CodeCommitResponse
implements ToCopyableBuilder<Builder, GetRepositoryTriggersResponse> {
    private static final SdkField<String> CONFIGURATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("configurationId").getter(GetRepositoryTriggersResponse.getter(GetRepositoryTriggersResponse::configurationId)).setter(GetRepositoryTriggersResponse.setter(Builder::configurationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configurationId").build()}).build();
    private static final SdkField<List<RepositoryTrigger>> TRIGGERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("triggers").getter(GetRepositoryTriggersResponse.getter(GetRepositoryTriggersResponse::triggers)).setter(GetRepositoryTriggersResponse.setter(Builder::triggers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("triggers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RepositoryTrigger::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIGURATION_ID_FIELD, TRIGGERS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("configurationId", CONFIGURATION_ID_FIELD);
            this.put("triggers", TRIGGERS_FIELD);
        }
    });
    private final String configurationId;
    private final List<RepositoryTrigger> triggers;

    private GetRepositoryTriggersResponse(BuilderImpl builder) {
        super(builder);
        this.configurationId = builder.configurationId;
        this.triggers = builder.triggers;
    }

    public final String configurationId() {
        return this.configurationId;
    }

    public final boolean hasTriggers() {
        return this.triggers != null && !(this.triggers instanceof SdkAutoConstructList);
    }

    public final List<RepositoryTrigger> triggers() {
        return this.triggers;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.configurationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTriggers() ? this.triggers() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRepositoryTriggersResponse)) {
            return false;
        }
        GetRepositoryTriggersResponse other = (GetRepositoryTriggersResponse)((Object)obj);
        return Objects.equals(this.configurationId(), other.configurationId()) && this.hasTriggers() == other.hasTriggers() && Objects.equals(this.triggers(), other.triggers());
    }

    public final String toString() {
        return ToString.builder((String)"GetRepositoryTriggersResponse").add("ConfigurationId", (Object)this.configurationId()).add("Triggers", this.hasTriggers() ? this.triggers() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "configurationId": {
                return Optional.ofNullable(clazz.cast(this.configurationId()));
            }
            case "triggers": {
                return Optional.ofNullable(clazz.cast(this.triggers()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetRepositoryTriggersResponse, T> g) {
        return obj -> g.apply((GetRepositoryTriggersResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeCommitResponse.BuilderImpl
    implements Builder {
        private String configurationId;
        private List<RepositoryTrigger> triggers = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetRepositoryTriggersResponse model) {
            super(model);
            this.configurationId(model.configurationId);
            this.triggers(model.triggers);
        }

        public final String getConfigurationId() {
            return this.configurationId;
        }

        public final void setConfigurationId(String configurationId) {
            this.configurationId = configurationId;
        }

        @Override
        public final Builder configurationId(String configurationId) {
            this.configurationId = configurationId;
            return this;
        }

        public final List<RepositoryTrigger.Builder> getTriggers() {
            List<RepositoryTrigger.Builder> result = RepositoryTriggersListCopier.copyToBuilder(this.triggers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTriggers(Collection<RepositoryTrigger.BuilderImpl> triggers) {
            this.triggers = RepositoryTriggersListCopier.copyFromBuilder(triggers);
        }

        @Override
        public final Builder triggers(Collection<RepositoryTrigger> triggers) {
            this.triggers = RepositoryTriggersListCopier.copy(triggers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder triggers(RepositoryTrigger ... triggers) {
            this.triggers(Arrays.asList(triggers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder triggers(Consumer<RepositoryTrigger.Builder> ... triggers) {
            this.triggers(Stream.of(triggers).map(c -> (RepositoryTrigger)((RepositoryTrigger.Builder)RepositoryTrigger.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetRepositoryTriggersResponse build() {
            return new GetRepositoryTriggersResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CodeCommitResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetRepositoryTriggersResponse> {
        public Builder configurationId(String var1);

        public Builder triggers(Collection<RepositoryTrigger> var1);

        public Builder triggers(RepositoryTrigger ... var1);

        public Builder triggers(Consumer<RepositoryTrigger.Builder> ... var1);
    }
}

