/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codecommit.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codecommit.model.CodeCommitResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetMergeCommitResponse
extends CodeCommitResponse
implements ToCopyableBuilder<Builder, GetMergeCommitResponse> {
    private static final SdkField<String> SOURCE_COMMIT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sourceCommitId").getter(GetMergeCommitResponse.getter(GetMergeCommitResponse::sourceCommitId)).setter(GetMergeCommitResponse.setter(Builder::sourceCommitId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceCommitId").build()}).build();
    private static final SdkField<String> DESTINATION_COMMIT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("destinationCommitId").getter(GetMergeCommitResponse.getter(GetMergeCommitResponse::destinationCommitId)).setter(GetMergeCommitResponse.setter(Builder::destinationCommitId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationCommitId").build()}).build();
    private static final SdkField<String> BASE_COMMIT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("baseCommitId").getter(GetMergeCommitResponse.getter(GetMergeCommitResponse::baseCommitId)).setter(GetMergeCommitResponse.setter(Builder::baseCommitId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("baseCommitId").build()}).build();
    private static final SdkField<String> MERGED_COMMIT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("mergedCommitId").getter(GetMergeCommitResponse.getter(GetMergeCommitResponse::mergedCommitId)).setter(GetMergeCommitResponse.setter(Builder::mergedCommitId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mergedCommitId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_COMMIT_ID_FIELD, DESTINATION_COMMIT_ID_FIELD, BASE_COMMIT_ID_FIELD, MERGED_COMMIT_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("sourceCommitId", SOURCE_COMMIT_ID_FIELD);
            this.put("destinationCommitId", DESTINATION_COMMIT_ID_FIELD);
            this.put("baseCommitId", BASE_COMMIT_ID_FIELD);
            this.put("mergedCommitId", MERGED_COMMIT_ID_FIELD);
        }
    });
    private final String sourceCommitId;
    private final String destinationCommitId;
    private final String baseCommitId;
    private final String mergedCommitId;

    private GetMergeCommitResponse(BuilderImpl builder) {
        super(builder);
        this.sourceCommitId = builder.sourceCommitId;
        this.destinationCommitId = builder.destinationCommitId;
        this.baseCommitId = builder.baseCommitId;
        this.mergedCommitId = builder.mergedCommitId;
    }

    public final String sourceCommitId() {
        return this.sourceCommitId;
    }

    public final String destinationCommitId() {
        return this.destinationCommitId;
    }

    public final String baseCommitId() {
        return this.baseCommitId;
    }

    public final String mergedCommitId() {
        return this.mergedCommitId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceCommitId());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationCommitId());
        hashCode = 31 * hashCode + Objects.hashCode(this.baseCommitId());
        hashCode = 31 * hashCode + Objects.hashCode(this.mergedCommitId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetMergeCommitResponse)) {
            return false;
        }
        GetMergeCommitResponse other = (GetMergeCommitResponse)((Object)obj);
        return Objects.equals(this.sourceCommitId(), other.sourceCommitId()) && Objects.equals(this.destinationCommitId(), other.destinationCommitId()) && Objects.equals(this.baseCommitId(), other.baseCommitId()) && Objects.equals(this.mergedCommitId(), other.mergedCommitId());
    }

    public final String toString() {
        return ToString.builder((String)"GetMergeCommitResponse").add("SourceCommitId", (Object)this.sourceCommitId()).add("DestinationCommitId", (Object)this.destinationCommitId()).add("BaseCommitId", (Object)this.baseCommitId()).add("MergedCommitId", (Object)this.mergedCommitId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "sourceCommitId": {
                return Optional.ofNullable(clazz.cast(this.sourceCommitId()));
            }
            case "destinationCommitId": {
                return Optional.ofNullable(clazz.cast(this.destinationCommitId()));
            }
            case "baseCommitId": {
                return Optional.ofNullable(clazz.cast(this.baseCommitId()));
            }
            case "mergedCommitId": {
                return Optional.ofNullable(clazz.cast(this.mergedCommitId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetMergeCommitResponse, T> g) {
        return obj -> g.apply((GetMergeCommitResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeCommitResponse.BuilderImpl
    implements Builder {
        private String sourceCommitId;
        private String destinationCommitId;
        private String baseCommitId;
        private String mergedCommitId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetMergeCommitResponse model) {
            super(model);
            this.sourceCommitId(model.sourceCommitId);
            this.destinationCommitId(model.destinationCommitId);
            this.baseCommitId(model.baseCommitId);
            this.mergedCommitId(model.mergedCommitId);
        }

        public final String getSourceCommitId() {
            return this.sourceCommitId;
        }

        public final void setSourceCommitId(String sourceCommitId) {
            this.sourceCommitId = sourceCommitId;
        }

        @Override
        public final Builder sourceCommitId(String sourceCommitId) {
            this.sourceCommitId = sourceCommitId;
            return this;
        }

        public final String getDestinationCommitId() {
            return this.destinationCommitId;
        }

        public final void setDestinationCommitId(String destinationCommitId) {
            this.destinationCommitId = destinationCommitId;
        }

        @Override
        public final Builder destinationCommitId(String destinationCommitId) {
            this.destinationCommitId = destinationCommitId;
            return this;
        }

        public final String getBaseCommitId() {
            return this.baseCommitId;
        }

        public final void setBaseCommitId(String baseCommitId) {
            this.baseCommitId = baseCommitId;
        }

        @Override
        public final Builder baseCommitId(String baseCommitId) {
            this.baseCommitId = baseCommitId;
            return this;
        }

        public final String getMergedCommitId() {
            return this.mergedCommitId;
        }

        public final void setMergedCommitId(String mergedCommitId) {
            this.mergedCommitId = mergedCommitId;
        }

        @Override
        public final Builder mergedCommitId(String mergedCommitId) {
            this.mergedCommitId = mergedCommitId;
            return this;
        }

        @Override
        public GetMergeCommitResponse build() {
            return new GetMergeCommitResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CodeCommitResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetMergeCommitResponse> {
        public Builder sourceCommitId(String var1);

        public Builder destinationCommitId(String var1);

        public Builder baseCommitId(String var1);

        public Builder mergedCommitId(String var1);
    }
}

