/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codecommit.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.codecommit.CodeCommitClient;
import software.amazon.awssdk.services.codecommit.internal.UserAgentUtils;
import software.amazon.awssdk.services.codecommit.model.ListPullRequestsRequest;
import software.amazon.awssdk.services.codecommit.model.ListPullRequestsResponse;

public class ListPullRequestsIterable
implements SdkIterable<ListPullRequestsResponse> {
    private final CodeCommitClient client;
    private final ListPullRequestsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListPullRequestsIterable(CodeCommitClient client, ListPullRequestsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListPullRequestsResponseFetcher();
    }

    public Iterator<ListPullRequestsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListPullRequestsResponseFetcher
    implements SyncPageFetcher<ListPullRequestsResponse> {
        private ListPullRequestsResponseFetcher() {
        }

        public boolean hasNextPage(ListPullRequestsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListPullRequestsResponse nextPage(ListPullRequestsResponse previousPage) {
            if (previousPage == null) {
                return ListPullRequestsIterable.this.client.listPullRequests(ListPullRequestsIterable.this.firstRequest);
            }
            return ListPullRequestsIterable.this.client.listPullRequests((ListPullRequestsRequest)((Object)ListPullRequestsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

