/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codecommit;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.codecommit.CodeCommitClient;
import software.amazon.awssdk.services.codecommit.model.ActorDoesNotExistException;
import software.amazon.awssdk.services.codecommit.model.AuthorDoesNotExistException;
import software.amazon.awssdk.services.codecommit.model.BatchGetRepositoriesRequest;
import software.amazon.awssdk.services.codecommit.model.BatchGetRepositoriesResponse;
import software.amazon.awssdk.services.codecommit.model.BeforeCommitIdAndAfterCommitIdAreSameException;
import software.amazon.awssdk.services.codecommit.model.BlobIdDoesNotExistException;
import software.amazon.awssdk.services.codecommit.model.BlobIdRequiredException;
import software.amazon.awssdk.services.codecommit.model.BranchDoesNotExistException;
import software.amazon.awssdk.services.codecommit.model.BranchNameExistsException;
import software.amazon.awssdk.services.codecommit.model.BranchNameIsTagNameException;
import software.amazon.awssdk.services.codecommit.model.BranchNameRequiredException;
import software.amazon.awssdk.services.codecommit.model.ClientRequestTokenRequiredException;
import software.amazon.awssdk.services.codecommit.model.CodeCommitException;
import software.amazon.awssdk.services.codecommit.model.CodeCommitRequest;
import software.amazon.awssdk.services.codecommit.model.CommentContentRequiredException;
import software.amazon.awssdk.services.codecommit.model.CommentContentSizeLimitExceededException;
import software.amazon.awssdk.services.codecommit.model.CommentDeletedException;
import software.amazon.awssdk.services.codecommit.model.CommentDoesNotExistException;
import software.amazon.awssdk.services.codecommit.model.CommentIdRequiredException;
import software.amazon.awssdk.services.codecommit.model.CommentNotCreatedByCallerException;
import software.amazon.awssdk.services.codecommit.model.CommitDoesNotExistException;
import software.amazon.awssdk.services.codecommit.model.CommitIdDoesNotExistException;
import software.amazon.awssdk.services.codecommit.model.CommitIdRequiredException;
import software.amazon.awssdk.services.codecommit.model.CommitMessageLengthExceededException;
import software.amazon.awssdk.services.codecommit.model.CommitRequiredException;
import software.amazon.awssdk.services.codecommit.model.CreateBranchRequest;
import software.amazon.awssdk.services.codecommit.model.CreateBranchResponse;
import software.amazon.awssdk.services.codecommit.model.CreatePullRequestRequest;
import software.amazon.awssdk.services.codecommit.model.CreatePullRequestResponse;
import software.amazon.awssdk.services.codecommit.model.CreateRepositoryRequest;
import software.amazon.awssdk.services.codecommit.model.CreateRepositoryResponse;
import software.amazon.awssdk.services.codecommit.model.DefaultBranchCannotBeDeletedException;
import software.amazon.awssdk.services.codecommit.model.DeleteBranchRequest;
import software.amazon.awssdk.services.codecommit.model.DeleteBranchResponse;
import software.amazon.awssdk.services.codecommit.model.DeleteCommentContentRequest;
import software.amazon.awssdk.services.codecommit.model.DeleteCommentContentResponse;
import software.amazon.awssdk.services.codecommit.model.DeleteFileRequest;
import software.amazon.awssdk.services.codecommit.model.DeleteFileResponse;
import software.amazon.awssdk.services.codecommit.model.DeleteRepositoryRequest;
import software.amazon.awssdk.services.codecommit.model.DeleteRepositoryResponse;
import software.amazon.awssdk.services.codecommit.model.DescribePullRequestEventsRequest;
import software.amazon.awssdk.services.codecommit.model.DescribePullRequestEventsResponse;
import software.amazon.awssdk.services.codecommit.model.DirectoryNameConflictsWithFileNameException;
import software.amazon.awssdk.services.codecommit.model.EncryptionIntegrityChecksFailedException;
import software.amazon.awssdk.services.codecommit.model.EncryptionKeyAccessDeniedException;
import software.amazon.awssdk.services.codecommit.model.EncryptionKeyDisabledException;
import software.amazon.awssdk.services.codecommit.model.EncryptionKeyNotFoundException;
import software.amazon.awssdk.services.codecommit.model.EncryptionKeyUnavailableException;
import software.amazon.awssdk.services.codecommit.model.FileContentRequiredException;
import software.amazon.awssdk.services.codecommit.model.FileContentSizeLimitExceededException;
import software.amazon.awssdk.services.codecommit.model.FileDoesNotExistException;
import software.amazon.awssdk.services.codecommit.model.FileNameConflictsWithDirectoryNameException;
import software.amazon.awssdk.services.codecommit.model.FileTooLargeException;
import software.amazon.awssdk.services.codecommit.model.FolderDoesNotExistException;
import software.amazon.awssdk.services.codecommit.model.GetBlobRequest;
import software.amazon.awssdk.services.codecommit.model.GetBlobResponse;
import software.amazon.awssdk.services.codecommit.model.GetBranchRequest;
import software.amazon.awssdk.services.codecommit.model.GetBranchResponse;
import software.amazon.awssdk.services.codecommit.model.GetCommentRequest;
import software.amazon.awssdk.services.codecommit.model.GetCommentResponse;
import software.amazon.awssdk.services.codecommit.model.GetCommentsForComparedCommitRequest;
import software.amazon.awssdk.services.codecommit.model.GetCommentsForComparedCommitResponse;
import software.amazon.awssdk.services.codecommit.model.GetCommentsForPullRequestRequest;
import software.amazon.awssdk.services.codecommit.model.GetCommentsForPullRequestResponse;
import software.amazon.awssdk.services.codecommit.model.GetCommitRequest;
import software.amazon.awssdk.services.codecommit.model.GetCommitResponse;
import software.amazon.awssdk.services.codecommit.model.GetDifferencesRequest;
import software.amazon.awssdk.services.codecommit.model.GetDifferencesResponse;
import software.amazon.awssdk.services.codecommit.model.GetFileRequest;
import software.amazon.awssdk.services.codecommit.model.GetFileResponse;
import software.amazon.awssdk.services.codecommit.model.GetFolderRequest;
import software.amazon.awssdk.services.codecommit.model.GetFolderResponse;
import software.amazon.awssdk.services.codecommit.model.GetMergeConflictsRequest;
import software.amazon.awssdk.services.codecommit.model.GetMergeConflictsResponse;
import software.amazon.awssdk.services.codecommit.model.GetPullRequestRequest;
import software.amazon.awssdk.services.codecommit.model.GetPullRequestResponse;
import software.amazon.awssdk.services.codecommit.model.GetRepositoryRequest;
import software.amazon.awssdk.services.codecommit.model.GetRepositoryResponse;
import software.amazon.awssdk.services.codecommit.model.GetRepositoryTriggersRequest;
import software.amazon.awssdk.services.codecommit.model.GetRepositoryTriggersResponse;
import software.amazon.awssdk.services.codecommit.model.IdempotencyParameterMismatchException;
import software.amazon.awssdk.services.codecommit.model.InvalidActorArnException;
import software.amazon.awssdk.services.codecommit.model.InvalidAuthorArnException;
import software.amazon.awssdk.services.codecommit.model.InvalidBlobIdException;
import software.amazon.awssdk.services.codecommit.model.InvalidBranchNameException;
import software.amazon.awssdk.services.codecommit.model.InvalidClientRequestTokenException;
import software.amazon.awssdk.services.codecommit.model.InvalidCommentIdException;
import software.amazon.awssdk.services.codecommit.model.InvalidCommitException;
import software.amazon.awssdk.services.codecommit.model.InvalidCommitIdException;
import software.amazon.awssdk.services.codecommit.model.InvalidContinuationTokenException;
import software.amazon.awssdk.services.codecommit.model.InvalidDeletionParameterException;
import software.amazon.awssdk.services.codecommit.model.InvalidDescriptionException;
import software.amazon.awssdk.services.codecommit.model.InvalidDestinationCommitSpecifierException;
import software.amazon.awssdk.services.codecommit.model.InvalidEmailException;
import software.amazon.awssdk.services.codecommit.model.InvalidFileLocationException;
import software.amazon.awssdk.services.codecommit.model.InvalidFileModeException;
import software.amazon.awssdk.services.codecommit.model.InvalidFilePositionException;
import software.amazon.awssdk.services.codecommit.model.InvalidMaxResultsException;
import software.amazon.awssdk.services.codecommit.model.InvalidMergeOptionException;
import software.amazon.awssdk.services.codecommit.model.InvalidOrderException;
import software.amazon.awssdk.services.codecommit.model.InvalidParentCommitIdException;
import software.amazon.awssdk.services.codecommit.model.InvalidPathException;
import software.amazon.awssdk.services.codecommit.model.InvalidPullRequestEventTypeException;
import software.amazon.awssdk.services.codecommit.model.InvalidPullRequestIdException;
import software.amazon.awssdk.services.codecommit.model.InvalidPullRequestStatusException;
import software.amazon.awssdk.services.codecommit.model.InvalidPullRequestStatusUpdateException;
import software.amazon.awssdk.services.codecommit.model.InvalidReferenceNameException;
import software.amazon.awssdk.services.codecommit.model.InvalidRelativeFileVersionEnumException;
import software.amazon.awssdk.services.codecommit.model.InvalidRepositoryDescriptionException;
import software.amazon.awssdk.services.codecommit.model.InvalidRepositoryNameException;
import software.amazon.awssdk.services.codecommit.model.InvalidRepositoryTriggerBranchNameException;
import software.amazon.awssdk.services.codecommit.model.InvalidRepositoryTriggerCustomDataException;
import software.amazon.awssdk.services.codecommit.model.InvalidRepositoryTriggerDestinationArnException;
import software.amazon.awssdk.services.codecommit.model.InvalidRepositoryTriggerEventsException;
import software.amazon.awssdk.services.codecommit.model.InvalidRepositoryTriggerNameException;
import software.amazon.awssdk.services.codecommit.model.InvalidRepositoryTriggerRegionException;
import software.amazon.awssdk.services.codecommit.model.InvalidSortByException;
import software.amazon.awssdk.services.codecommit.model.InvalidSourceCommitSpecifierException;
import software.amazon.awssdk.services.codecommit.model.InvalidTargetException;
import software.amazon.awssdk.services.codecommit.model.InvalidTargetsException;
import software.amazon.awssdk.services.codecommit.model.InvalidTitleException;
import software.amazon.awssdk.services.codecommit.model.ListBranchesRequest;
import software.amazon.awssdk.services.codecommit.model.ListBranchesResponse;
import software.amazon.awssdk.services.codecommit.model.ListPullRequestsRequest;
import software.amazon.awssdk.services.codecommit.model.ListPullRequestsResponse;
import software.amazon.awssdk.services.codecommit.model.ListRepositoriesRequest;
import software.amazon.awssdk.services.codecommit.model.ListRepositoriesResponse;
import software.amazon.awssdk.services.codecommit.model.ManualMergeRequiredException;
import software.amazon.awssdk.services.codecommit.model.MaximumBranchesExceededException;
import software.amazon.awssdk.services.codecommit.model.MaximumOpenPullRequestsExceededException;
import software.amazon.awssdk.services.codecommit.model.MaximumRepositoryNamesExceededException;
import software.amazon.awssdk.services.codecommit.model.MaximumRepositoryTriggersExceededException;
import software.amazon.awssdk.services.codecommit.model.MergeOptionRequiredException;
import software.amazon.awssdk.services.codecommit.model.MergePullRequestByFastForwardRequest;
import software.amazon.awssdk.services.codecommit.model.MergePullRequestByFastForwardResponse;
import software.amazon.awssdk.services.codecommit.model.MultipleRepositoriesInPullRequestException;
import software.amazon.awssdk.services.codecommit.model.NameLengthExceededException;
import software.amazon.awssdk.services.codecommit.model.ParentCommitDoesNotExistException;
import software.amazon.awssdk.services.codecommit.model.ParentCommitIdOutdatedException;
import software.amazon.awssdk.services.codecommit.model.ParentCommitIdRequiredException;
import software.amazon.awssdk.services.codecommit.model.PathDoesNotExistException;
import software.amazon.awssdk.services.codecommit.model.PathRequiredException;
import software.amazon.awssdk.services.codecommit.model.PostCommentForComparedCommitRequest;
import software.amazon.awssdk.services.codecommit.model.PostCommentForComparedCommitResponse;
import software.amazon.awssdk.services.codecommit.model.PostCommentForPullRequestRequest;
import software.amazon.awssdk.services.codecommit.model.PostCommentForPullRequestResponse;
import software.amazon.awssdk.services.codecommit.model.PostCommentReplyRequest;
import software.amazon.awssdk.services.codecommit.model.PostCommentReplyResponse;
import software.amazon.awssdk.services.codecommit.model.PullRequestAlreadyClosedException;
import software.amazon.awssdk.services.codecommit.model.PullRequestDoesNotExistException;
import software.amazon.awssdk.services.codecommit.model.PullRequestIdRequiredException;
import software.amazon.awssdk.services.codecommit.model.PullRequestStatusRequiredException;
import software.amazon.awssdk.services.codecommit.model.PutFileRequest;
import software.amazon.awssdk.services.codecommit.model.PutFileResponse;
import software.amazon.awssdk.services.codecommit.model.PutRepositoryTriggersRequest;
import software.amazon.awssdk.services.codecommit.model.PutRepositoryTriggersResponse;
import software.amazon.awssdk.services.codecommit.model.ReferenceDoesNotExistException;
import software.amazon.awssdk.services.codecommit.model.ReferenceNameRequiredException;
import software.amazon.awssdk.services.codecommit.model.ReferenceTypeNotSupportedException;
import software.amazon.awssdk.services.codecommit.model.RepositoryDoesNotExistException;
import software.amazon.awssdk.services.codecommit.model.RepositoryLimitExceededException;
import software.amazon.awssdk.services.codecommit.model.RepositoryNameExistsException;
import software.amazon.awssdk.services.codecommit.model.RepositoryNameRequiredException;
import software.amazon.awssdk.services.codecommit.model.RepositoryNamesRequiredException;
import software.amazon.awssdk.services.codecommit.model.RepositoryNotAssociatedWithPullRequestException;
import software.amazon.awssdk.services.codecommit.model.RepositoryTriggerBranchNameListRequiredException;
import software.amazon.awssdk.services.codecommit.model.RepositoryTriggerDestinationArnRequiredException;
import software.amazon.awssdk.services.codecommit.model.RepositoryTriggerEventsListRequiredException;
import software.amazon.awssdk.services.codecommit.model.RepositoryTriggerNameRequiredException;
import software.amazon.awssdk.services.codecommit.model.RepositoryTriggersListRequiredException;
import software.amazon.awssdk.services.codecommit.model.SameFileContentException;
import software.amazon.awssdk.services.codecommit.model.SourceAndDestinationAreSameException;
import software.amazon.awssdk.services.codecommit.model.TargetRequiredException;
import software.amazon.awssdk.services.codecommit.model.TargetsRequiredException;
import software.amazon.awssdk.services.codecommit.model.TestRepositoryTriggersRequest;
import software.amazon.awssdk.services.codecommit.model.TestRepositoryTriggersResponse;
import software.amazon.awssdk.services.codecommit.model.TipOfSourceReferenceIsDifferentException;
import software.amazon.awssdk.services.codecommit.model.TipsDivergenceExceededException;
import software.amazon.awssdk.services.codecommit.model.TitleRequiredException;
import software.amazon.awssdk.services.codecommit.model.UpdateCommentRequest;
import software.amazon.awssdk.services.codecommit.model.UpdateCommentResponse;
import software.amazon.awssdk.services.codecommit.model.UpdateDefaultBranchRequest;
import software.amazon.awssdk.services.codecommit.model.UpdateDefaultBranchResponse;
import software.amazon.awssdk.services.codecommit.model.UpdatePullRequestDescriptionRequest;
import software.amazon.awssdk.services.codecommit.model.UpdatePullRequestDescriptionResponse;
import software.amazon.awssdk.services.codecommit.model.UpdatePullRequestStatusRequest;
import software.amazon.awssdk.services.codecommit.model.UpdatePullRequestStatusResponse;
import software.amazon.awssdk.services.codecommit.model.UpdatePullRequestTitleRequest;
import software.amazon.awssdk.services.codecommit.model.UpdatePullRequestTitleResponse;
import software.amazon.awssdk.services.codecommit.model.UpdateRepositoryDescriptionRequest;
import software.amazon.awssdk.services.codecommit.model.UpdateRepositoryDescriptionResponse;
import software.amazon.awssdk.services.codecommit.model.UpdateRepositoryNameRequest;
import software.amazon.awssdk.services.codecommit.model.UpdateRepositoryNameResponse;
import software.amazon.awssdk.services.codecommit.paginators.DescribePullRequestEventsIterable;
import software.amazon.awssdk.services.codecommit.paginators.GetCommentsForComparedCommitIterable;
import software.amazon.awssdk.services.codecommit.paginators.GetCommentsForPullRequestIterable;
import software.amazon.awssdk.services.codecommit.paginators.GetDifferencesIterable;
import software.amazon.awssdk.services.codecommit.paginators.ListBranchesIterable;
import software.amazon.awssdk.services.codecommit.paginators.ListPullRequestsIterable;
import software.amazon.awssdk.services.codecommit.paginators.ListRepositoriesIterable;
import software.amazon.awssdk.services.codecommit.transform.BatchGetRepositoriesRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.CreateBranchRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.CreatePullRequestRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.CreateRepositoryRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.DeleteBranchRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.DeleteCommentContentRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.DeleteFileRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.DeleteRepositoryRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.DescribePullRequestEventsRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.GetBlobRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.GetBranchRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.GetCommentRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.GetCommentsForComparedCommitRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.GetCommentsForPullRequestRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.GetCommitRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.GetDifferencesRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.GetFileRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.GetFolderRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.GetMergeConflictsRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.GetPullRequestRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.GetRepositoryRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.GetRepositoryTriggersRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.ListBranchesRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.ListPullRequestsRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.ListRepositoriesRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.MergePullRequestByFastForwardRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.PostCommentForComparedCommitRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.PostCommentForPullRequestRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.PostCommentReplyRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.PutFileRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.PutRepositoryTriggersRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.TestRepositoryTriggersRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.UpdateCommentRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.UpdateDefaultBranchRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.UpdatePullRequestDescriptionRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.UpdatePullRequestStatusRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.UpdatePullRequestTitleRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.UpdateRepositoryDescriptionRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.UpdateRepositoryNameRequestMarshaller;

@SdkInternalApi
final class DefaultCodeCommitClient
implements CodeCommitClient {
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultCodeCommitClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    public final String serviceName() {
        return "codecommit";
    }

    @Override
    public BatchGetRepositoriesResponse batchGetRepositories(BatchGetRepositoriesRequest batchGetRepositoriesRequest) throws RepositoryNamesRequiredException, MaximumRepositoryNamesExceededException, InvalidRepositoryNameException, EncryptionIntegrityChecksFailedException, EncryptionKeyAccessDeniedException, EncryptionKeyDisabledException, EncryptionKeyNotFoundException, EncryptionKeyUnavailableException, AwsServiceException, SdkClientException, CodeCommitException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchGetRepositoriesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (BatchGetRepositoriesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchGetRepositories").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)batchGetRepositoriesRequest).withMarshaller((Marshaller)new BatchGetRepositoriesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public CreateBranchResponse createBranch(CreateBranchRequest createBranchRequest) throws RepositoryNameRequiredException, InvalidRepositoryNameException, RepositoryDoesNotExistException, BranchNameRequiredException, BranchNameExistsException, InvalidBranchNameException, CommitIdRequiredException, CommitDoesNotExistException, InvalidCommitIdException, EncryptionIntegrityChecksFailedException, EncryptionKeyAccessDeniedException, EncryptionKeyDisabledException, EncryptionKeyNotFoundException, EncryptionKeyUnavailableException, AwsServiceException, SdkClientException, CodeCommitException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateBranchResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (CreateBranchResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateBranch").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createBranchRequest).withMarshaller((Marshaller)new CreateBranchRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public CreatePullRequestResponse createPullRequest(CreatePullRequestRequest createPullRequestRequest) throws RepositoryNameRequiredException, InvalidRepositoryNameException, RepositoryDoesNotExistException, EncryptionIntegrityChecksFailedException, EncryptionKeyAccessDeniedException, EncryptionKeyDisabledException, EncryptionKeyNotFoundException, EncryptionKeyUnavailableException, ClientRequestTokenRequiredException, InvalidClientRequestTokenException, IdempotencyParameterMismatchException, ReferenceNameRequiredException, InvalidReferenceNameException, ReferenceDoesNotExistException, ReferenceTypeNotSupportedException, TitleRequiredException, InvalidTitleException, InvalidDescriptionException, TargetsRequiredException, InvalidTargetsException, TargetRequiredException, InvalidTargetException, MultipleRepositoriesInPullRequestException, MaximumOpenPullRequestsExceededException, SourceAndDestinationAreSameException, AwsServiceException, SdkClientException, CodeCommitException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreatePullRequestResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (CreatePullRequestResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreatePullRequest").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createPullRequestRequest).withMarshaller((Marshaller)new CreatePullRequestRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public CreateRepositoryResponse createRepository(CreateRepositoryRequest createRepositoryRequest) throws RepositoryNameExistsException, RepositoryNameRequiredException, InvalidRepositoryNameException, InvalidRepositoryDescriptionException, RepositoryLimitExceededException, EncryptionIntegrityChecksFailedException, EncryptionKeyAccessDeniedException, EncryptionKeyDisabledException, EncryptionKeyNotFoundException, EncryptionKeyUnavailableException, AwsServiceException, SdkClientException, CodeCommitException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateRepositoryResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (CreateRepositoryResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateRepository").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createRepositoryRequest).withMarshaller((Marshaller)new CreateRepositoryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DeleteBranchResponse deleteBranch(DeleteBranchRequest deleteBranchRequest) throws RepositoryNameRequiredException, RepositoryDoesNotExistException, InvalidRepositoryNameException, BranchNameRequiredException, InvalidBranchNameException, DefaultBranchCannotBeDeletedException, EncryptionIntegrityChecksFailedException, EncryptionKeyAccessDeniedException, EncryptionKeyDisabledException, EncryptionKeyNotFoundException, EncryptionKeyUnavailableException, AwsServiceException, SdkClientException, CodeCommitException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteBranchResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DeleteBranchResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteBranch").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteBranchRequest).withMarshaller((Marshaller)new DeleteBranchRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DeleteCommentContentResponse deleteCommentContent(DeleteCommentContentRequest deleteCommentContentRequest) throws CommentDoesNotExistException, CommentIdRequiredException, InvalidCommentIdException, CommentDeletedException, AwsServiceException, SdkClientException, CodeCommitException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteCommentContentResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DeleteCommentContentResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteCommentContent").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteCommentContentRequest).withMarshaller((Marshaller)new DeleteCommentContentRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DeleteFileResponse deleteFile(DeleteFileRequest deleteFileRequest) throws RepositoryNameRequiredException, InvalidRepositoryNameException, RepositoryDoesNotExistException, ParentCommitIdRequiredException, InvalidParentCommitIdException, ParentCommitDoesNotExistException, ParentCommitIdOutdatedException, PathRequiredException, InvalidPathException, FileDoesNotExistException, BranchNameRequiredException, InvalidBranchNameException, BranchDoesNotExistException, BranchNameIsTagNameException, NameLengthExceededException, InvalidEmailException, CommitMessageLengthExceededException, EncryptionIntegrityChecksFailedException, EncryptionKeyAccessDeniedException, EncryptionKeyDisabledException, EncryptionKeyNotFoundException, EncryptionKeyUnavailableException, AwsServiceException, SdkClientException, CodeCommitException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteFileResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DeleteFileResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteFile").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteFileRequest).withMarshaller((Marshaller)new DeleteFileRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DeleteRepositoryResponse deleteRepository(DeleteRepositoryRequest deleteRepositoryRequest) throws RepositoryNameRequiredException, InvalidRepositoryNameException, EncryptionIntegrityChecksFailedException, EncryptionKeyAccessDeniedException, EncryptionKeyDisabledException, EncryptionKeyNotFoundException, EncryptionKeyUnavailableException, AwsServiceException, SdkClientException, CodeCommitException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteRepositoryResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DeleteRepositoryResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteRepository").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteRepositoryRequest).withMarshaller((Marshaller)new DeleteRepositoryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DescribePullRequestEventsResponse describePullRequestEvents(DescribePullRequestEventsRequest describePullRequestEventsRequest) throws PullRequestDoesNotExistException, InvalidPullRequestIdException, PullRequestIdRequiredException, InvalidPullRequestEventTypeException, InvalidActorArnException, ActorDoesNotExistException, InvalidMaxResultsException, InvalidContinuationTokenException, EncryptionIntegrityChecksFailedException, EncryptionKeyAccessDeniedException, EncryptionKeyDisabledException, EncryptionKeyNotFoundException, EncryptionKeyUnavailableException, AwsServiceException, SdkClientException, CodeCommitException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribePullRequestEventsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DescribePullRequestEventsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribePullRequestEvents").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describePullRequestEventsRequest).withMarshaller((Marshaller)new DescribePullRequestEventsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DescribePullRequestEventsIterable describePullRequestEventsPaginator(DescribePullRequestEventsRequest describePullRequestEventsRequest) throws PullRequestDoesNotExistException, InvalidPullRequestIdException, PullRequestIdRequiredException, InvalidPullRequestEventTypeException, InvalidActorArnException, ActorDoesNotExistException, InvalidMaxResultsException, InvalidContinuationTokenException, EncryptionIntegrityChecksFailedException, EncryptionKeyAccessDeniedException, EncryptionKeyDisabledException, EncryptionKeyNotFoundException, EncryptionKeyUnavailableException, AwsServiceException, SdkClientException, CodeCommitException {
        return new DescribePullRequestEventsIterable(this, this.applyPaginatorUserAgent(describePullRequestEventsRequest));
    }

    @Override
    public GetBlobResponse getBlob(GetBlobRequest getBlobRequest) throws RepositoryNameRequiredException, InvalidRepositoryNameException, RepositoryDoesNotExistException, BlobIdRequiredException, InvalidBlobIdException, BlobIdDoesNotExistException, EncryptionIntegrityChecksFailedException, EncryptionKeyAccessDeniedException, EncryptionKeyDisabledException, EncryptionKeyNotFoundException, EncryptionKeyUnavailableException, FileTooLargeException, AwsServiceException, SdkClientException, CodeCommitException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetBlobResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (GetBlobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetBlob").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getBlobRequest).withMarshaller((Marshaller)new GetBlobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public GetBranchResponse getBranch(GetBranchRequest getBranchRequest) throws RepositoryNameRequiredException, RepositoryDoesNotExistException, InvalidRepositoryNameException, BranchNameRequiredException, InvalidBranchNameException, BranchDoesNotExistException, EncryptionIntegrityChecksFailedException, EncryptionKeyAccessDeniedException, EncryptionKeyDisabledException, EncryptionKeyNotFoundException, EncryptionKeyUnavailableException, AwsServiceException, SdkClientException, CodeCommitException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetBranchResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (GetBranchResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetBranch").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getBranchRequest).withMarshaller((Marshaller)new GetBranchRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public GetCommentResponse getComment(GetCommentRequest getCommentRequest) throws CommentDoesNotExistException, CommentIdRequiredException, InvalidCommentIdException, CommentDeletedException, AwsServiceException, SdkClientException, CodeCommitException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetCommentResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (GetCommentResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetComment").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getCommentRequest).withMarshaller((Marshaller)new GetCommentRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public GetCommentsForComparedCommitResponse getCommentsForComparedCommit(GetCommentsForComparedCommitRequest getCommentsForComparedCommitRequest) throws RepositoryNameRequiredException, RepositoryDoesNotExistException, InvalidRepositoryNameException, CommitIdRequiredException, InvalidCommitIdException, CommitDoesNotExistException, InvalidMaxResultsException, InvalidContinuationTokenException, EncryptionIntegrityChecksFailedException, EncryptionKeyAccessDeniedException, EncryptionKeyDisabledException, EncryptionKeyNotFoundException, EncryptionKeyUnavailableException, AwsServiceException, SdkClientException, CodeCommitException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetCommentsForComparedCommitResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (GetCommentsForComparedCommitResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetCommentsForComparedCommit").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getCommentsForComparedCommitRequest).withMarshaller((Marshaller)new GetCommentsForComparedCommitRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public GetCommentsForComparedCommitIterable getCommentsForComparedCommitPaginator(GetCommentsForComparedCommitRequest getCommentsForComparedCommitRequest) throws RepositoryNameRequiredException, RepositoryDoesNotExistException, InvalidRepositoryNameException, CommitIdRequiredException, InvalidCommitIdException, CommitDoesNotExistException, InvalidMaxResultsException, InvalidContinuationTokenException, EncryptionIntegrityChecksFailedException, EncryptionKeyAccessDeniedException, EncryptionKeyDisabledException, EncryptionKeyNotFoundException, EncryptionKeyUnavailableException, AwsServiceException, SdkClientException, CodeCommitException {
        return new GetCommentsForComparedCommitIterable(this, this.applyPaginatorUserAgent(getCommentsForComparedCommitRequest));
    }

    @Override
    public GetCommentsForPullRequestResponse getCommentsForPullRequest(GetCommentsForPullRequestRequest getCommentsForPullRequestRequest) throws PullRequestIdRequiredException, PullRequestDoesNotExistException, InvalidPullRequestIdException, RepositoryNameRequiredException, RepositoryDoesNotExistException, InvalidRepositoryNameException, CommitIdRequiredException, InvalidCommitIdException, CommitDoesNotExistException, InvalidMaxResultsException, InvalidContinuationTokenException, RepositoryNotAssociatedWithPullRequestException, EncryptionIntegrityChecksFailedException, EncryptionKeyAccessDeniedException, EncryptionKeyDisabledException, EncryptionKeyNotFoundException, EncryptionKeyUnavailableException, AwsServiceException, SdkClientException, CodeCommitException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetCommentsForPullRequestResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (GetCommentsForPullRequestResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetCommentsForPullRequest").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getCommentsForPullRequestRequest).withMarshaller((Marshaller)new GetCommentsForPullRequestRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public GetCommentsForPullRequestIterable getCommentsForPullRequestPaginator(GetCommentsForPullRequestRequest getCommentsForPullRequestRequest) throws PullRequestIdRequiredException, PullRequestDoesNotExistException, InvalidPullRequestIdException, RepositoryNameRequiredException, RepositoryDoesNotExistException, InvalidRepositoryNameException, CommitIdRequiredException, InvalidCommitIdException, CommitDoesNotExistException, InvalidMaxResultsException, InvalidContinuationTokenException, RepositoryNotAssociatedWithPullRequestException, EncryptionIntegrityChecksFailedException, EncryptionKeyAccessDeniedException, EncryptionKeyDisabledException, EncryptionKeyNotFoundException, EncryptionKeyUnavailableException, AwsServiceException, SdkClientException, CodeCommitException {
        return new GetCommentsForPullRequestIterable(this, this.applyPaginatorUserAgent(getCommentsForPullRequestRequest));
    }

    @Override
    public GetCommitResponse getCommit(GetCommitRequest getCommitRequest) throws RepositoryNameRequiredException, InvalidRepositoryNameException, RepositoryDoesNotExistException, CommitIdRequiredException, InvalidCommitIdException, CommitIdDoesNotExistException, EncryptionIntegrityChecksFailedException, EncryptionKeyAccessDeniedException, EncryptionKeyDisabledException, EncryptionKeyNotFoundException, EncryptionKeyUnavailableException, AwsServiceException, SdkClientException, CodeCommitException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetCommitResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (GetCommitResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetCommit").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getCommitRequest).withMarshaller((Marshaller)new GetCommitRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public GetDifferencesResponse getDifferences(GetDifferencesRequest getDifferencesRequest) throws RepositoryNameRequiredException, RepositoryDoesNotExistException, InvalidRepositoryNameException, InvalidContinuationTokenException, InvalidMaxResultsException, InvalidCommitIdException, CommitRequiredException, InvalidCommitException, CommitDoesNotExistException, InvalidPathException, PathDoesNotExistException, EncryptionIntegrityChecksFailedException, EncryptionKeyAccessDeniedException, EncryptionKeyDisabledException, EncryptionKeyNotFoundException, EncryptionKeyUnavailableException, AwsServiceException, SdkClientException, CodeCommitException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetDifferencesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (GetDifferencesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetDifferences").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getDifferencesRequest).withMarshaller((Marshaller)new GetDifferencesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public GetDifferencesIterable getDifferencesPaginator(GetDifferencesRequest getDifferencesRequest) throws RepositoryNameRequiredException, RepositoryDoesNotExistException, InvalidRepositoryNameException, InvalidContinuationTokenException, InvalidMaxResultsException, InvalidCommitIdException, CommitRequiredException, InvalidCommitException, CommitDoesNotExistException, InvalidPathException, PathDoesNotExistException, EncryptionIntegrityChecksFailedException, EncryptionKeyAccessDeniedException, EncryptionKeyDisabledException, EncryptionKeyNotFoundException, EncryptionKeyUnavailableException, AwsServiceException, SdkClientException, CodeCommitException {
        return new GetDifferencesIterable(this, this.applyPaginatorUserAgent(getDifferencesRequest));
    }

    @Override
    public GetFileResponse getFile(GetFileRequest getFileRequest) throws RepositoryNameRequiredException, InvalidRepositoryNameException, RepositoryDoesNotExistException, InvalidCommitException, CommitDoesNotExistException, PathRequiredException, InvalidPathException, FileDoesNotExistException, EncryptionIntegrityChecksFailedException, EncryptionKeyAccessDeniedException, EncryptionKeyDisabledException, EncryptionKeyNotFoundException, EncryptionKeyUnavailableException, FileTooLargeException, AwsServiceException, SdkClientException, CodeCommitException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetFileResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (GetFileResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetFile").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getFileRequest).withMarshaller((Marshaller)new GetFileRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public GetFolderResponse getFolder(GetFolderRequest getFolderRequest) throws RepositoryNameRequiredException, InvalidRepositoryNameException, RepositoryDoesNotExistException, InvalidCommitException, CommitDoesNotExistException, PathRequiredException, InvalidPathException, FolderDoesNotExistException, EncryptionIntegrityChecksFailedException, EncryptionKeyAccessDeniedException, EncryptionKeyDisabledException, EncryptionKeyNotFoundException, EncryptionKeyUnavailableException, AwsServiceException, SdkClientException, CodeCommitException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetFolderResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (GetFolderResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetFolder").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getFolderRequest).withMarshaller((Marshaller)new GetFolderRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public GetMergeConflictsResponse getMergeConflicts(GetMergeConflictsRequest getMergeConflictsRequest) throws RepositoryNameRequiredException, InvalidRepositoryNameException, RepositoryDoesNotExistException, MergeOptionRequiredException, InvalidMergeOptionException, InvalidDestinationCommitSpecifierException, InvalidSourceCommitSpecifierException, CommitRequiredException, CommitDoesNotExistException, InvalidCommitException, TipsDivergenceExceededException, EncryptionIntegrityChecksFailedException, EncryptionKeyAccessDeniedException, EncryptionKeyDisabledException, EncryptionKeyNotFoundException, EncryptionKeyUnavailableException, AwsServiceException, SdkClientException, CodeCommitException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetMergeConflictsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (GetMergeConflictsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetMergeConflicts").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getMergeConflictsRequest).withMarshaller((Marshaller)new GetMergeConflictsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public GetPullRequestResponse getPullRequest(GetPullRequestRequest getPullRequestRequest) throws PullRequestDoesNotExistException, InvalidPullRequestIdException, PullRequestIdRequiredException, EncryptionIntegrityChecksFailedException, EncryptionKeyAccessDeniedException, EncryptionKeyDisabledException, EncryptionKeyNotFoundException, EncryptionKeyUnavailableException, AwsServiceException, SdkClientException, CodeCommitException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetPullRequestResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (GetPullRequestResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetPullRequest").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getPullRequestRequest).withMarshaller((Marshaller)new GetPullRequestRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public GetRepositoryResponse getRepository(GetRepositoryRequest getRepositoryRequest) throws RepositoryNameRequiredException, RepositoryDoesNotExistException, InvalidRepositoryNameException, EncryptionIntegrityChecksFailedException, EncryptionKeyAccessDeniedException, EncryptionKeyDisabledException, EncryptionKeyNotFoundException, EncryptionKeyUnavailableException, AwsServiceException, SdkClientException, CodeCommitException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetRepositoryResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (GetRepositoryResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetRepository").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getRepositoryRequest).withMarshaller((Marshaller)new GetRepositoryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public GetRepositoryTriggersResponse getRepositoryTriggers(GetRepositoryTriggersRequest getRepositoryTriggersRequest) throws RepositoryNameRequiredException, InvalidRepositoryNameException, RepositoryDoesNotExistException, EncryptionIntegrityChecksFailedException, EncryptionKeyAccessDeniedException, EncryptionKeyDisabledException, EncryptionKeyNotFoundException, EncryptionKeyUnavailableException, AwsServiceException, SdkClientException, CodeCommitException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetRepositoryTriggersResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (GetRepositoryTriggersResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetRepositoryTriggers").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getRepositoryTriggersRequest).withMarshaller((Marshaller)new GetRepositoryTriggersRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListBranchesResponse listBranches(ListBranchesRequest listBranchesRequest) throws RepositoryNameRequiredException, RepositoryDoesNotExistException, InvalidRepositoryNameException, EncryptionIntegrityChecksFailedException, EncryptionKeyAccessDeniedException, EncryptionKeyDisabledException, EncryptionKeyNotFoundException, EncryptionKeyUnavailableException, InvalidContinuationTokenException, AwsServiceException, SdkClientException, CodeCommitException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListBranchesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ListBranchesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListBranches").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listBranchesRequest).withMarshaller((Marshaller)new ListBranchesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListBranchesIterable listBranchesPaginator(ListBranchesRequest listBranchesRequest) throws RepositoryNameRequiredException, RepositoryDoesNotExistException, InvalidRepositoryNameException, EncryptionIntegrityChecksFailedException, EncryptionKeyAccessDeniedException, EncryptionKeyDisabledException, EncryptionKeyNotFoundException, EncryptionKeyUnavailableException, InvalidContinuationTokenException, AwsServiceException, SdkClientException, CodeCommitException {
        return new ListBranchesIterable(this, this.applyPaginatorUserAgent(listBranchesRequest));
    }

    @Override
    public ListPullRequestsResponse listPullRequests(ListPullRequestsRequest listPullRequestsRequest) throws InvalidPullRequestStatusException, InvalidAuthorArnException, AuthorDoesNotExistException, RepositoryNameRequiredException, InvalidRepositoryNameException, RepositoryDoesNotExistException, InvalidMaxResultsException, InvalidContinuationTokenException, EncryptionIntegrityChecksFailedException, EncryptionKeyAccessDeniedException, EncryptionKeyDisabledException, EncryptionKeyNotFoundException, EncryptionKeyUnavailableException, AwsServiceException, SdkClientException, CodeCommitException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListPullRequestsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ListPullRequestsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListPullRequests").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listPullRequestsRequest).withMarshaller((Marshaller)new ListPullRequestsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListPullRequestsIterable listPullRequestsPaginator(ListPullRequestsRequest listPullRequestsRequest) throws InvalidPullRequestStatusException, InvalidAuthorArnException, AuthorDoesNotExistException, RepositoryNameRequiredException, InvalidRepositoryNameException, RepositoryDoesNotExistException, InvalidMaxResultsException, InvalidContinuationTokenException, EncryptionIntegrityChecksFailedException, EncryptionKeyAccessDeniedException, EncryptionKeyDisabledException, EncryptionKeyNotFoundException, EncryptionKeyUnavailableException, AwsServiceException, SdkClientException, CodeCommitException {
        return new ListPullRequestsIterable(this, this.applyPaginatorUserAgent(listPullRequestsRequest));
    }

    @Override
    public ListRepositoriesResponse listRepositories(ListRepositoriesRequest listRepositoriesRequest) throws InvalidSortByException, InvalidOrderException, InvalidContinuationTokenException, AwsServiceException, SdkClientException, CodeCommitException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListRepositoriesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ListRepositoriesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListRepositories").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listRepositoriesRequest).withMarshaller((Marshaller)new ListRepositoriesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListRepositoriesIterable listRepositoriesPaginator(ListRepositoriesRequest listRepositoriesRequest) throws InvalidSortByException, InvalidOrderException, InvalidContinuationTokenException, AwsServiceException, SdkClientException, CodeCommitException {
        return new ListRepositoriesIterable(this, this.applyPaginatorUserAgent(listRepositoriesRequest));
    }

    @Override
    public MergePullRequestByFastForwardResponse mergePullRequestByFastForward(MergePullRequestByFastForwardRequest mergePullRequestByFastForwardRequest) throws ManualMergeRequiredException, PullRequestAlreadyClosedException, PullRequestDoesNotExistException, InvalidPullRequestIdException, PullRequestIdRequiredException, TipOfSourceReferenceIsDifferentException, ReferenceDoesNotExistException, InvalidCommitIdException, RepositoryNameRequiredException, InvalidRepositoryNameException, RepositoryDoesNotExistException, EncryptionIntegrityChecksFailedException, EncryptionKeyAccessDeniedException, EncryptionKeyDisabledException, EncryptionKeyNotFoundException, EncryptionKeyUnavailableException, AwsServiceException, SdkClientException, CodeCommitException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, MergePullRequestByFastForwardResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (MergePullRequestByFastForwardResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("MergePullRequestByFastForward").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)mergePullRequestByFastForwardRequest).withMarshaller((Marshaller)new MergePullRequestByFastForwardRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public PostCommentForComparedCommitResponse postCommentForComparedCommit(PostCommentForComparedCommitRequest postCommentForComparedCommitRequest) throws RepositoryNameRequiredException, RepositoryDoesNotExistException, InvalidRepositoryNameException, ClientRequestTokenRequiredException, InvalidClientRequestTokenException, IdempotencyParameterMismatchException, CommentContentRequiredException, CommentContentSizeLimitExceededException, InvalidFileLocationException, InvalidRelativeFileVersionEnumException, PathRequiredException, InvalidFilePositionException, CommitIdRequiredException, InvalidCommitIdException, EncryptionIntegrityChecksFailedException, EncryptionKeyAccessDeniedException, EncryptionKeyDisabledException, EncryptionKeyNotFoundException, EncryptionKeyUnavailableException, BeforeCommitIdAndAfterCommitIdAreSameException, CommitDoesNotExistException, InvalidPathException, PathDoesNotExistException, AwsServiceException, SdkClientException, CodeCommitException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PostCommentForComparedCommitResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (PostCommentForComparedCommitResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PostCommentForComparedCommit").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)postCommentForComparedCommitRequest).withMarshaller((Marshaller)new PostCommentForComparedCommitRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public PostCommentForPullRequestResponse postCommentForPullRequest(PostCommentForPullRequestRequest postCommentForPullRequestRequest) throws PullRequestDoesNotExistException, InvalidPullRequestIdException, PullRequestIdRequiredException, RepositoryNotAssociatedWithPullRequestException, RepositoryNameRequiredException, RepositoryDoesNotExistException, InvalidRepositoryNameException, ClientRequestTokenRequiredException, InvalidClientRequestTokenException, IdempotencyParameterMismatchException, CommentContentRequiredException, CommentContentSizeLimitExceededException, InvalidFileLocationException, InvalidRelativeFileVersionEnumException, PathRequiredException, InvalidFilePositionException, CommitIdRequiredException, InvalidCommitIdException, EncryptionIntegrityChecksFailedException, EncryptionKeyAccessDeniedException, EncryptionKeyDisabledException, EncryptionKeyNotFoundException, EncryptionKeyUnavailableException, CommitDoesNotExistException, InvalidPathException, PathDoesNotExistException, BeforeCommitIdAndAfterCommitIdAreSameException, AwsServiceException, SdkClientException, CodeCommitException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PostCommentForPullRequestResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (PostCommentForPullRequestResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PostCommentForPullRequest").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)postCommentForPullRequestRequest).withMarshaller((Marshaller)new PostCommentForPullRequestRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public PostCommentReplyResponse postCommentReply(PostCommentReplyRequest postCommentReplyRequest) throws ClientRequestTokenRequiredException, InvalidClientRequestTokenException, IdempotencyParameterMismatchException, CommentContentRequiredException, CommentContentSizeLimitExceededException, CommentDoesNotExistException, CommentIdRequiredException, InvalidCommentIdException, AwsServiceException, SdkClientException, CodeCommitException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PostCommentReplyResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (PostCommentReplyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PostCommentReply").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)postCommentReplyRequest).withMarshaller((Marshaller)new PostCommentReplyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public PutFileResponse putFile(PutFileRequest putFileRequest) throws RepositoryNameRequiredException, InvalidRepositoryNameException, RepositoryDoesNotExistException, ParentCommitIdRequiredException, InvalidParentCommitIdException, ParentCommitDoesNotExistException, ParentCommitIdOutdatedException, FileContentRequiredException, FileContentSizeLimitExceededException, PathRequiredException, InvalidPathException, BranchNameRequiredException, InvalidBranchNameException, BranchDoesNotExistException, BranchNameIsTagNameException, InvalidFileModeException, NameLengthExceededException, InvalidEmailException, CommitMessageLengthExceededException, InvalidDeletionParameterException, EncryptionIntegrityChecksFailedException, EncryptionKeyAccessDeniedException, EncryptionKeyDisabledException, EncryptionKeyNotFoundException, EncryptionKeyUnavailableException, SameFileContentException, FileNameConflictsWithDirectoryNameException, DirectoryNameConflictsWithFileNameException, AwsServiceException, SdkClientException, CodeCommitException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutFileResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (PutFileResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutFile").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)putFileRequest).withMarshaller((Marshaller)new PutFileRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public PutRepositoryTriggersResponse putRepositoryTriggers(PutRepositoryTriggersRequest putRepositoryTriggersRequest) throws RepositoryDoesNotExistException, RepositoryNameRequiredException, InvalidRepositoryNameException, RepositoryTriggersListRequiredException, MaximumRepositoryTriggersExceededException, InvalidRepositoryTriggerNameException, InvalidRepositoryTriggerDestinationArnException, InvalidRepositoryTriggerRegionException, InvalidRepositoryTriggerCustomDataException, MaximumBranchesExceededException, InvalidRepositoryTriggerBranchNameException, InvalidRepositoryTriggerEventsException, RepositoryTriggerNameRequiredException, RepositoryTriggerDestinationArnRequiredException, RepositoryTriggerBranchNameListRequiredException, RepositoryTriggerEventsListRequiredException, EncryptionIntegrityChecksFailedException, EncryptionKeyAccessDeniedException, EncryptionKeyDisabledException, EncryptionKeyNotFoundException, EncryptionKeyUnavailableException, AwsServiceException, SdkClientException, CodeCommitException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutRepositoryTriggersResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (PutRepositoryTriggersResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutRepositoryTriggers").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)putRepositoryTriggersRequest).withMarshaller((Marshaller)new PutRepositoryTriggersRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public TestRepositoryTriggersResponse testRepositoryTriggers(TestRepositoryTriggersRequest testRepositoryTriggersRequest) throws RepositoryDoesNotExistException, RepositoryNameRequiredException, InvalidRepositoryNameException, RepositoryTriggersListRequiredException, MaximumRepositoryTriggersExceededException, InvalidRepositoryTriggerNameException, InvalidRepositoryTriggerDestinationArnException, InvalidRepositoryTriggerRegionException, InvalidRepositoryTriggerCustomDataException, MaximumBranchesExceededException, InvalidRepositoryTriggerBranchNameException, InvalidRepositoryTriggerEventsException, RepositoryTriggerNameRequiredException, RepositoryTriggerDestinationArnRequiredException, RepositoryTriggerBranchNameListRequiredException, RepositoryTriggerEventsListRequiredException, EncryptionIntegrityChecksFailedException, EncryptionKeyAccessDeniedException, EncryptionKeyDisabledException, EncryptionKeyNotFoundException, EncryptionKeyUnavailableException, AwsServiceException, SdkClientException, CodeCommitException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TestRepositoryTriggersResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (TestRepositoryTriggersResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("TestRepositoryTriggers").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)testRepositoryTriggersRequest).withMarshaller((Marshaller)new TestRepositoryTriggersRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public UpdateCommentResponse updateComment(UpdateCommentRequest updateCommentRequest) throws CommentContentRequiredException, CommentContentSizeLimitExceededException, CommentDoesNotExistException, CommentIdRequiredException, InvalidCommentIdException, CommentNotCreatedByCallerException, CommentDeletedException, AwsServiceException, SdkClientException, CodeCommitException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateCommentResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (UpdateCommentResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateComment").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateCommentRequest).withMarshaller((Marshaller)new UpdateCommentRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public UpdateDefaultBranchResponse updateDefaultBranch(UpdateDefaultBranchRequest updateDefaultBranchRequest) throws RepositoryNameRequiredException, RepositoryDoesNotExistException, InvalidRepositoryNameException, BranchNameRequiredException, InvalidBranchNameException, BranchDoesNotExistException, EncryptionIntegrityChecksFailedException, EncryptionKeyAccessDeniedException, EncryptionKeyDisabledException, EncryptionKeyNotFoundException, EncryptionKeyUnavailableException, AwsServiceException, SdkClientException, CodeCommitException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateDefaultBranchResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (UpdateDefaultBranchResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateDefaultBranch").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateDefaultBranchRequest).withMarshaller((Marshaller)new UpdateDefaultBranchRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public UpdatePullRequestDescriptionResponse updatePullRequestDescription(UpdatePullRequestDescriptionRequest updatePullRequestDescriptionRequest) throws PullRequestDoesNotExistException, InvalidPullRequestIdException, PullRequestIdRequiredException, InvalidDescriptionException, PullRequestAlreadyClosedException, AwsServiceException, SdkClientException, CodeCommitException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdatePullRequestDescriptionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (UpdatePullRequestDescriptionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdatePullRequestDescription").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updatePullRequestDescriptionRequest).withMarshaller((Marshaller)new UpdatePullRequestDescriptionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public UpdatePullRequestStatusResponse updatePullRequestStatus(UpdatePullRequestStatusRequest updatePullRequestStatusRequest) throws PullRequestDoesNotExistException, InvalidPullRequestIdException, PullRequestIdRequiredException, InvalidPullRequestStatusUpdateException, InvalidPullRequestStatusException, PullRequestStatusRequiredException, EncryptionIntegrityChecksFailedException, EncryptionKeyAccessDeniedException, EncryptionKeyDisabledException, EncryptionKeyNotFoundException, EncryptionKeyUnavailableException, AwsServiceException, SdkClientException, CodeCommitException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdatePullRequestStatusResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (UpdatePullRequestStatusResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdatePullRequestStatus").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updatePullRequestStatusRequest).withMarshaller((Marshaller)new UpdatePullRequestStatusRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public UpdatePullRequestTitleResponse updatePullRequestTitle(UpdatePullRequestTitleRequest updatePullRequestTitleRequest) throws PullRequestDoesNotExistException, InvalidPullRequestIdException, PullRequestIdRequiredException, TitleRequiredException, InvalidTitleException, PullRequestAlreadyClosedException, AwsServiceException, SdkClientException, CodeCommitException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdatePullRequestTitleResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (UpdatePullRequestTitleResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdatePullRequestTitle").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updatePullRequestTitleRequest).withMarshaller((Marshaller)new UpdatePullRequestTitleRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public UpdateRepositoryDescriptionResponse updateRepositoryDescription(UpdateRepositoryDescriptionRequest updateRepositoryDescriptionRequest) throws RepositoryNameRequiredException, RepositoryDoesNotExistException, InvalidRepositoryNameException, InvalidRepositoryDescriptionException, EncryptionIntegrityChecksFailedException, EncryptionKeyAccessDeniedException, EncryptionKeyDisabledException, EncryptionKeyNotFoundException, EncryptionKeyUnavailableException, AwsServiceException, SdkClientException, CodeCommitException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateRepositoryDescriptionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (UpdateRepositoryDescriptionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateRepositoryDescription").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateRepositoryDescriptionRequest).withMarshaller((Marshaller)new UpdateRepositoryDescriptionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public UpdateRepositoryNameResponse updateRepositoryName(UpdateRepositoryNameRequest updateRepositoryNameRequest) throws RepositoryDoesNotExistException, RepositoryNameExistsException, RepositoryNameRequiredException, InvalidRepositoryNameException, AwsServiceException, SdkClientException, CodeCommitException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateRepositoryNameResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (UpdateRepositoryNameResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateRepositoryName").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateRepositoryNameRequest).withMarshaller((Marshaller)new UpdateRepositoryNameRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(CodeCommitException::builder).protocol(AwsJsonProtocol.AWS_JSON).protocolVersion("1.1").registerModeledException(ExceptionMetadata.builder().errorCode("TargetsRequiredException").exceptionBuilderSupplier(TargetsRequiredException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("RepositoryLimitExceededException").exceptionBuilderSupplier(RepositoryLimitExceededException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("FileContentRequiredException").exceptionBuilderSupplier(FileContentRequiredException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("BranchNameIsTagNameException").exceptionBuilderSupplier(BranchNameIsTagNameException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("CommitIdRequiredException").exceptionBuilderSupplier(CommitIdRequiredException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("CommentDeletedException").exceptionBuilderSupplier(CommentDeletedException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TitleRequiredException").exceptionBuilderSupplier(TitleRequiredException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidBlobIdException").exceptionBuilderSupplier(InvalidBlobIdException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidRepositoryDescriptionException").exceptionBuilderSupplier(InvalidRepositoryDescriptionException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidTargetsException").exceptionBuilderSupplier(InvalidTargetsException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerDestinationArnException").exceptionBuilderSupplier(InvalidRepositoryTriggerDestinationArnException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("CommentDoesNotExistException").exceptionBuilderSupplier(CommentDoesNotExistException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("MaximumRepositoryTriggersExceededException").exceptionBuilderSupplier(MaximumRepositoryTriggersExceededException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("BlobIdRequiredException").exceptionBuilderSupplier(BlobIdRequiredException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("RepositoryNamesRequiredException").exceptionBuilderSupplier(RepositoryNamesRequiredException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("AuthorDoesNotExistException").exceptionBuilderSupplier(AuthorDoesNotExistException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidFilePositionException").exceptionBuilderSupplier(InvalidFilePositionException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("FileNameConflictsWithDirectoryNameException").exceptionBuilderSupplier(FileNameConflictsWithDirectoryNameException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("EncryptionKeyAccessDeniedException").exceptionBuilderSupplier(EncryptionKeyAccessDeniedException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("BeforeCommitIdAndAfterCommitIdAreSameException").exceptionBuilderSupplier(BeforeCommitIdAndAfterCommitIdAreSameException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("BranchDoesNotExistException").exceptionBuilderSupplier(BranchDoesNotExistException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("PullRequestDoesNotExistException").exceptionBuilderSupplier(PullRequestDoesNotExistException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ReferenceTypeNotSupportedException").exceptionBuilderSupplier(ReferenceTypeNotSupportedException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("RepositoryTriggerEventsListRequiredException").exceptionBuilderSupplier(RepositoryTriggerEventsListRequiredException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("CommitDoesNotExistException").exceptionBuilderSupplier(CommitDoesNotExistException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerCustomDataException").exceptionBuilderSupplier(InvalidRepositoryTriggerCustomDataException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerEventsException").exceptionBuilderSupplier(InvalidRepositoryTriggerEventsException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("RepositoryNotAssociatedWithPullRequestException").exceptionBuilderSupplier(RepositoryNotAssociatedWithPullRequestException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("MaximumRepositoryNamesExceededException").exceptionBuilderSupplier(MaximumRepositoryNamesExceededException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("RepositoryDoesNotExistException").exceptionBuilderSupplier(RepositoryDoesNotExistException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidFileLocationException").exceptionBuilderSupplier(InvalidFileLocationException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("MaximumOpenPullRequestsExceededException").exceptionBuilderSupplier(MaximumOpenPullRequestsExceededException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DefaultBranchCannotBeDeletedException").exceptionBuilderSupplier(DefaultBranchCannotBeDeletedException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("MaximumBranchesExceededException").exceptionBuilderSupplier(MaximumBranchesExceededException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("EncryptionKeyNotFoundException").exceptionBuilderSupplier(EncryptionKeyNotFoundException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidPathException").exceptionBuilderSupplier(InvalidPathException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidRelativeFileVersionEnumException").exceptionBuilderSupplier(InvalidRelativeFileVersionEnumException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidClientRequestTokenException").exceptionBuilderSupplier(InvalidClientRequestTokenException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("RepositoryNameRequiredException").exceptionBuilderSupplier(RepositoryNameRequiredException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidReferenceNameException").exceptionBuilderSupplier(InvalidReferenceNameException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("RepositoryTriggerDestinationArnRequiredException").exceptionBuilderSupplier(RepositoryTriggerDestinationArnRequiredException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidAuthorArnException").exceptionBuilderSupplier(InvalidAuthorArnException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("CommentContentRequiredException").exceptionBuilderSupplier(CommentContentRequiredException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("PathRequiredException").exceptionBuilderSupplier(PathRequiredException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("RepositoryTriggerNameRequiredException").exceptionBuilderSupplier(RepositoryTriggerNameRequiredException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("CommitIdDoesNotExistException").exceptionBuilderSupplier(CommitIdDoesNotExistException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidPullRequestStatusException").exceptionBuilderSupplier(InvalidPullRequestStatusException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidParentCommitIdException").exceptionBuilderSupplier(InvalidParentCommitIdException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ReferenceNameRequiredException").exceptionBuilderSupplier(ReferenceNameRequiredException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidPullRequestStatusUpdateException").exceptionBuilderSupplier(InvalidPullRequestStatusUpdateException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ParentCommitIdRequiredException").exceptionBuilderSupplier(ParentCommitIdRequiredException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidCommentIdException").exceptionBuilderSupplier(InvalidCommentIdException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidPullRequestEventTypeException").exceptionBuilderSupplier(InvalidPullRequestEventTypeException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidCommitException").exceptionBuilderSupplier(InvalidCommitException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ActorDoesNotExistException").exceptionBuilderSupplier(ActorDoesNotExistException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("IdempotencyParameterMismatchException").exceptionBuilderSupplier(IdempotencyParameterMismatchException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidDescriptionException").exceptionBuilderSupplier(InvalidDescriptionException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("MultipleRepositoriesInPullRequestException").exceptionBuilderSupplier(MultipleRepositoriesInPullRequestException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("BlobIdDoesNotExistException").exceptionBuilderSupplier(BlobIdDoesNotExistException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("MergeOptionRequiredException").exceptionBuilderSupplier(MergeOptionRequiredException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("FolderDoesNotExistException").exceptionBuilderSupplier(FolderDoesNotExistException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidPullRequestIdException").exceptionBuilderSupplier(InvalidPullRequestIdException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("PullRequestIdRequiredException").exceptionBuilderSupplier(PullRequestIdRequiredException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("RepositoryNameExistsException").exceptionBuilderSupplier(RepositoryNameExistsException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("FileDoesNotExistException").exceptionBuilderSupplier(FileDoesNotExistException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("PathDoesNotExistException").exceptionBuilderSupplier(PathDoesNotExistException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TipOfSourceReferenceIsDifferentException").exceptionBuilderSupplier(TipOfSourceReferenceIsDifferentException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("BranchNameExistsException").exceptionBuilderSupplier(BranchNameExistsException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("RepositoryTriggersListRequiredException").exceptionBuilderSupplier(RepositoryTriggersListRequiredException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("EncryptionIntegrityChecksFailedException").exceptionBuilderSupplier(EncryptionIntegrityChecksFailedException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("CommitMessageLengthExceededException").exceptionBuilderSupplier(CommitMessageLengthExceededException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidCommitIdException").exceptionBuilderSupplier(InvalidCommitIdException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidOrderException").exceptionBuilderSupplier(InvalidOrderException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidEmailException").exceptionBuilderSupplier(InvalidEmailException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("PullRequestAlreadyClosedException").exceptionBuilderSupplier(PullRequestAlreadyClosedException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("BranchNameRequiredException").exceptionBuilderSupplier(BranchNameRequiredException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidDeletionParameterException").exceptionBuilderSupplier(InvalidDeletionParameterException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("CommentIdRequiredException").exceptionBuilderSupplier(CommentIdRequiredException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerNameException").exceptionBuilderSupplier(InvalidRepositoryTriggerNameException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidMergeOptionException").exceptionBuilderSupplier(InvalidMergeOptionException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ParentCommitIdOutdatedException").exceptionBuilderSupplier(ParentCommitIdOutdatedException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidContinuationTokenException").exceptionBuilderSupplier(InvalidContinuationTokenException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("CommitRequiredException").exceptionBuilderSupplier(CommitRequiredException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ClientRequestTokenRequiredException").exceptionBuilderSupplier(ClientRequestTokenRequiredException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("NameLengthExceededException").exceptionBuilderSupplier(NameLengthExceededException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("EncryptionKeyDisabledException").exceptionBuilderSupplier(EncryptionKeyDisabledException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("CommentNotCreatedByCallerException").exceptionBuilderSupplier(CommentNotCreatedByCallerException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("FileContentSizeLimitExceededException").exceptionBuilderSupplier(FileContentSizeLimitExceededException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TargetRequiredException").exceptionBuilderSupplier(TargetRequiredException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("FileTooLargeException").exceptionBuilderSupplier(FileTooLargeException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ManualMergeRequiredException").exceptionBuilderSupplier(ManualMergeRequiredException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerBranchNameException").exceptionBuilderSupplier(InvalidRepositoryTriggerBranchNameException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("PullRequestStatusRequiredException").exceptionBuilderSupplier(PullRequestStatusRequiredException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TipsDivergenceExceededException").exceptionBuilderSupplier(TipsDivergenceExceededException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidSortByException").exceptionBuilderSupplier(InvalidSortByException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("SameFileContentException").exceptionBuilderSupplier(SameFileContentException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidTargetException").exceptionBuilderSupplier(InvalidTargetException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerRegionException").exceptionBuilderSupplier(InvalidRepositoryTriggerRegionException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ReferenceDoesNotExistException").exceptionBuilderSupplier(ReferenceDoesNotExistException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("CommentContentSizeLimitExceededException").exceptionBuilderSupplier(CommentContentSizeLimitExceededException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").exceptionBuilderSupplier(InvalidMaxResultsException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ParentCommitDoesNotExistException").exceptionBuilderSupplier(ParentCommitDoesNotExistException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidActorArnException").exceptionBuilderSupplier(InvalidActorArnException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidDestinationCommitSpecifierException").exceptionBuilderSupplier(InvalidDestinationCommitSpecifierException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("RepositoryTriggerBranchNameListRequiredException").exceptionBuilderSupplier(RepositoryTriggerBranchNameListRequiredException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidFileModeException").exceptionBuilderSupplier(InvalidFileModeException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidSourceCommitSpecifierException").exceptionBuilderSupplier(InvalidSourceCommitSpecifierException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DirectoryNameConflictsWithFileNameException").exceptionBuilderSupplier(DirectoryNameConflictsWithFileNameException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("SourceAndDestinationAreSameException").exceptionBuilderSupplier(SourceAndDestinationAreSameException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidTitleException").exceptionBuilderSupplier(InvalidTitleException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("EncryptionKeyUnavailableException").exceptionBuilderSupplier(EncryptionKeyUnavailableException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidRepositoryNameException").exceptionBuilderSupplier(InvalidRepositoryNameException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidBranchNameException").exceptionBuilderSupplier(InvalidBranchNameException::builder).build());
    }

    public void close() {
        this.clientHandler.close();
    }

    private <T extends CodeCommitRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.3.2").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((CodeCommitRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }
}

