/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codecommit.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BlobMetadata
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BlobMetadata> {
    private static final SdkField<String> BLOB_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(BlobMetadata.getter(BlobMetadata::blobId)).setter(BlobMetadata.setter(Builder::blobId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blobId").build()}).build();
    private static final SdkField<String> PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(BlobMetadata.getter(BlobMetadata::path)).setter(BlobMetadata.setter(Builder::path)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("path").build()}).build();
    private static final SdkField<String> MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(BlobMetadata.getter(BlobMetadata::mode)).setter(BlobMetadata.setter(Builder::mode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mode").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BLOB_ID_FIELD, PATH_FIELD, MODE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String blobId;
    private final String path;
    private final String mode;

    private BlobMetadata(BuilderImpl builder) {
        this.blobId = builder.blobId;
        this.path = builder.path;
        this.mode = builder.mode;
    }

    public String blobId() {
        return this.blobId;
    }

    public String path() {
        return this.path;
    }

    public String mode() {
        return this.mode;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.blobId());
        hashCode = 31 * hashCode + Objects.hashCode(this.path());
        hashCode = 31 * hashCode + Objects.hashCode(this.mode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BlobMetadata)) {
            return false;
        }
        BlobMetadata other = (BlobMetadata)obj;
        return Objects.equals(this.blobId(), other.blobId()) && Objects.equals(this.path(), other.path()) && Objects.equals(this.mode(), other.mode());
    }

    public String toString() {
        return ToString.builder((String)"BlobMetadata").add("BlobId", (Object)this.blobId()).add("Path", (Object)this.path()).add("Mode", (Object)this.mode()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "blobId": {
                return Optional.ofNullable(clazz.cast(this.blobId()));
            }
            case "path": {
                return Optional.ofNullable(clazz.cast(this.path()));
            }
            case "mode": {
                return Optional.ofNullable(clazz.cast(this.mode()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BlobMetadata, T> g) {
        return obj -> g.apply((BlobMetadata)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String blobId;
        private String path;
        private String mode;

        private BuilderImpl() {
        }

        private BuilderImpl(BlobMetadata model) {
            this.blobId(model.blobId);
            this.path(model.path);
            this.mode(model.mode);
        }

        public final String getBlobId() {
            return this.blobId;
        }

        @Override
        public final Builder blobId(String blobId) {
            this.blobId = blobId;
            return this;
        }

        public final void setBlobId(String blobId) {
            this.blobId = blobId;
        }

        public final String getPath() {
            return this.path;
        }

        @Override
        public final Builder path(String path) {
            this.path = path;
            return this;
        }

        public final void setPath(String path) {
            this.path = path;
        }

        public final String getMode() {
            return this.mode;
        }

        @Override
        public final Builder mode(String mode) {
            this.mode = mode;
            return this;
        }

        public final void setMode(String mode) {
            this.mode = mode;
        }

        public BlobMetadata build() {
            return new BlobMetadata(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BlobMetadata> {
        public Builder blobId(String var1);

        public Builder path(String var1);

        public Builder mode(String var1);
    }
}

