/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codecommit.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Comment
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Comment> {
    private static final SdkField<String> COMMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Comment.getter(Comment::commentId)).setter(Comment.setter(Builder::commentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("commentId").build()}).build();
    private static final SdkField<String> CONTENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Comment.getter(Comment::content)).setter(Comment.setter(Builder::content)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("content").build()}).build();
    private static final SdkField<String> IN_REPLY_TO_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Comment.getter(Comment::inReplyTo)).setter(Comment.setter(Builder::inReplyTo)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inReplyTo").build()}).build();
    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(Comment.getter(Comment::creationDate)).setter(Comment.setter(Builder::creationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDate").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(Comment.getter(Comment::lastModifiedDate)).setter(Comment.setter(Builder::lastModifiedDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModifiedDate").build()}).build();
    private static final SdkField<String> AUTHOR_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Comment.getter(Comment::authorArn)).setter(Comment.setter(Builder::authorArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authorArn").build()}).build();
    private static final SdkField<Boolean> DELETED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(Comment.getter(Comment::deleted)).setter(Comment.setter(Builder::deleted)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deleted").build()}).build();
    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Comment.getter(Comment::clientRequestToken)).setter(Comment.setter(Builder::clientRequestToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientRequestToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMMENT_ID_FIELD, CONTENT_FIELD, IN_REPLY_TO_FIELD, CREATION_DATE_FIELD, LAST_MODIFIED_DATE_FIELD, AUTHOR_ARN_FIELD, DELETED_FIELD, CLIENT_REQUEST_TOKEN_FIELD));
    private static final long serialVersionUID = 1L;
    private final String commentId;
    private final String content;
    private final String inReplyTo;
    private final Instant creationDate;
    private final Instant lastModifiedDate;
    private final String authorArn;
    private final Boolean deleted;
    private final String clientRequestToken;

    private Comment(BuilderImpl builder) {
        this.commentId = builder.commentId;
        this.content = builder.content;
        this.inReplyTo = builder.inReplyTo;
        this.creationDate = builder.creationDate;
        this.lastModifiedDate = builder.lastModifiedDate;
        this.authorArn = builder.authorArn;
        this.deleted = builder.deleted;
        this.clientRequestToken = builder.clientRequestToken;
    }

    public String commentId() {
        return this.commentId;
    }

    public String content() {
        return this.content;
    }

    public String inReplyTo() {
        return this.inReplyTo;
    }

    public Instant creationDate() {
        return this.creationDate;
    }

    public Instant lastModifiedDate() {
        return this.lastModifiedDate;
    }

    public String authorArn() {
        return this.authorArn;
    }

    public Boolean deleted() {
        return this.deleted;
    }

    public String clientRequestToken() {
        return this.clientRequestToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.commentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.content());
        hashCode = 31 * hashCode + Objects.hashCode(this.inReplyTo());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.authorArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.deleted());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientRequestToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Comment)) {
            return false;
        }
        Comment other = (Comment)obj;
        return Objects.equals(this.commentId(), other.commentId()) && Objects.equals(this.content(), other.content()) && Objects.equals(this.inReplyTo(), other.inReplyTo()) && Objects.equals(this.creationDate(), other.creationDate()) && Objects.equals(this.lastModifiedDate(), other.lastModifiedDate()) && Objects.equals(this.authorArn(), other.authorArn()) && Objects.equals(this.deleted(), other.deleted()) && Objects.equals(this.clientRequestToken(), other.clientRequestToken());
    }

    public String toString() {
        return ToString.builder((String)"Comment").add("CommentId", (Object)this.commentId()).add("Content", (Object)this.content()).add("InReplyTo", (Object)this.inReplyTo()).add("CreationDate", (Object)this.creationDate()).add("LastModifiedDate", (Object)this.lastModifiedDate()).add("AuthorArn", (Object)this.authorArn()).add("Deleted", (Object)this.deleted()).add("ClientRequestToken", (Object)this.clientRequestToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "commentId": {
                return Optional.ofNullable(clazz.cast(this.commentId()));
            }
            case "content": {
                return Optional.ofNullable(clazz.cast(this.content()));
            }
            case "inReplyTo": {
                return Optional.ofNullable(clazz.cast(this.inReplyTo()));
            }
            case "creationDate": {
                return Optional.ofNullable(clazz.cast(this.creationDate()));
            }
            case "lastModifiedDate": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedDate()));
            }
            case "authorArn": {
                return Optional.ofNullable(clazz.cast(this.authorArn()));
            }
            case "deleted": {
                return Optional.ofNullable(clazz.cast(this.deleted()));
            }
            case "clientRequestToken": {
                return Optional.ofNullable(clazz.cast(this.clientRequestToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Comment, T> g) {
        return obj -> g.apply((Comment)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String commentId;
        private String content;
        private String inReplyTo;
        private Instant creationDate;
        private Instant lastModifiedDate;
        private String authorArn;
        private Boolean deleted;
        private String clientRequestToken;

        private BuilderImpl() {
        }

        private BuilderImpl(Comment model) {
            this.commentId(model.commentId);
            this.content(model.content);
            this.inReplyTo(model.inReplyTo);
            this.creationDate(model.creationDate);
            this.lastModifiedDate(model.lastModifiedDate);
            this.authorArn(model.authorArn);
            this.deleted(model.deleted);
            this.clientRequestToken(model.clientRequestToken);
        }

        public final String getCommentId() {
            return this.commentId;
        }

        @Override
        public final Builder commentId(String commentId) {
            this.commentId = commentId;
            return this;
        }

        public final void setCommentId(String commentId) {
            this.commentId = commentId;
        }

        public final String getContent() {
            return this.content;
        }

        @Override
        public final Builder content(String content) {
            this.content = content;
            return this;
        }

        public final void setContent(String content) {
            this.content = content;
        }

        public final String getInReplyTo() {
            return this.inReplyTo;
        }

        @Override
        public final Builder inReplyTo(String inReplyTo) {
            this.inReplyTo = inReplyTo;
            return this;
        }

        public final void setInReplyTo(String inReplyTo) {
            this.inReplyTo = inReplyTo;
        }

        public final Instant getCreationDate() {
            return this.creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        public final Instant getLastModifiedDate() {
            return this.lastModifiedDate;
        }

        @Override
        public final Builder lastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            return this;
        }

        public final void setLastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
        }

        public final String getAuthorArn() {
            return this.authorArn;
        }

        @Override
        public final Builder authorArn(String authorArn) {
            this.authorArn = authorArn;
            return this;
        }

        public final void setAuthorArn(String authorArn) {
            this.authorArn = authorArn;
        }

        public final Boolean getDeleted() {
            return this.deleted;
        }

        @Override
        public final Builder deleted(Boolean deleted) {
            this.deleted = deleted;
            return this;
        }

        public final void setDeleted(Boolean deleted) {
            this.deleted = deleted;
        }

        public final String getClientRequestToken() {
            return this.clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        public Comment build() {
            return new Comment(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Comment> {
        public Builder commentId(String var1);

        public Builder content(String var1);

        public Builder inReplyTo(String var1);

        public Builder creationDate(Instant var1);

        public Builder lastModifiedDate(Instant var1);

        public Builder authorArn(String var1);

        public Builder deleted(Boolean var1);

        public Builder clientRequestToken(String var1);
    }
}

