/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codecommit.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codecommit.model.CodeCommitRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteFileRequest
extends CodeCommitRequest
implements ToCopyableBuilder<Builder, DeleteFileRequest> {
    private static final SdkField<String> REPOSITORY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DeleteFileRequest.getter(DeleteFileRequest::repositoryName)).setter(DeleteFileRequest.setter(Builder::repositoryName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositoryName").build()}).build();
    private static final SdkField<String> BRANCH_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DeleteFileRequest.getter(DeleteFileRequest::branchName)).setter(DeleteFileRequest.setter(Builder::branchName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("branchName").build()}).build();
    private static final SdkField<String> FILE_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DeleteFileRequest.getter(DeleteFileRequest::filePath)).setter(DeleteFileRequest.setter(Builder::filePath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filePath").build()}).build();
    private static final SdkField<String> PARENT_COMMIT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DeleteFileRequest.getter(DeleteFileRequest::parentCommitId)).setter(DeleteFileRequest.setter(Builder::parentCommitId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parentCommitId").build()}).build();
    private static final SdkField<Boolean> KEEP_EMPTY_FOLDERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(DeleteFileRequest.getter(DeleteFileRequest::keepEmptyFolders)).setter(DeleteFileRequest.setter(Builder::keepEmptyFolders)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("keepEmptyFolders").build()}).build();
    private static final SdkField<String> COMMIT_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DeleteFileRequest.getter(DeleteFileRequest::commitMessage)).setter(DeleteFileRequest.setter(Builder::commitMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("commitMessage").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DeleteFileRequest.getter(DeleteFileRequest::name)).setter(DeleteFileRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> EMAIL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DeleteFileRequest.getter(DeleteFileRequest::email)).setter(DeleteFileRequest.setter(Builder::email)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("email").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPOSITORY_NAME_FIELD, BRANCH_NAME_FIELD, FILE_PATH_FIELD, PARENT_COMMIT_ID_FIELD, KEEP_EMPTY_FOLDERS_FIELD, COMMIT_MESSAGE_FIELD, NAME_FIELD, EMAIL_FIELD));
    private final String repositoryName;
    private final String branchName;
    private final String filePath;
    private final String parentCommitId;
    private final Boolean keepEmptyFolders;
    private final String commitMessage;
    private final String name;
    private final String email;

    private DeleteFileRequest(BuilderImpl builder) {
        super(builder);
        this.repositoryName = builder.repositoryName;
        this.branchName = builder.branchName;
        this.filePath = builder.filePath;
        this.parentCommitId = builder.parentCommitId;
        this.keepEmptyFolders = builder.keepEmptyFolders;
        this.commitMessage = builder.commitMessage;
        this.name = builder.name;
        this.email = builder.email;
    }

    public String repositoryName() {
        return this.repositoryName;
    }

    public String branchName() {
        return this.branchName;
    }

    public String filePath() {
        return this.filePath;
    }

    public String parentCommitId() {
        return this.parentCommitId;
    }

    public Boolean keepEmptyFolders() {
        return this.keepEmptyFolders;
    }

    public String commitMessage() {
        return this.commitMessage;
    }

    public String name() {
        return this.name;
    }

    public String email() {
        return this.email;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.repositoryName());
        hashCode = 31 * hashCode + Objects.hashCode(this.branchName());
        hashCode = 31 * hashCode + Objects.hashCode(this.filePath());
        hashCode = 31 * hashCode + Objects.hashCode(this.parentCommitId());
        hashCode = 31 * hashCode + Objects.hashCode(this.keepEmptyFolders());
        hashCode = 31 * hashCode + Objects.hashCode(this.commitMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.email());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteFileRequest)) {
            return false;
        }
        DeleteFileRequest other = (DeleteFileRequest)((Object)obj);
        return Objects.equals(this.repositoryName(), other.repositoryName()) && Objects.equals(this.branchName(), other.branchName()) && Objects.equals(this.filePath(), other.filePath()) && Objects.equals(this.parentCommitId(), other.parentCommitId()) && Objects.equals(this.keepEmptyFolders(), other.keepEmptyFolders()) && Objects.equals(this.commitMessage(), other.commitMessage()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.email(), other.email());
    }

    public String toString() {
        return ToString.builder((String)"DeleteFileRequest").add("RepositoryName", (Object)this.repositoryName()).add("BranchName", (Object)this.branchName()).add("FilePath", (Object)this.filePath()).add("ParentCommitId", (Object)this.parentCommitId()).add("KeepEmptyFolders", (Object)this.keepEmptyFolders()).add("CommitMessage", (Object)this.commitMessage()).add("Name", (Object)this.name()).add("Email", (Object)this.email()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "repositoryName": {
                return Optional.ofNullable(clazz.cast(this.repositoryName()));
            }
            case "branchName": {
                return Optional.ofNullable(clazz.cast(this.branchName()));
            }
            case "filePath": {
                return Optional.ofNullable(clazz.cast(this.filePath()));
            }
            case "parentCommitId": {
                return Optional.ofNullable(clazz.cast(this.parentCommitId()));
            }
            case "keepEmptyFolders": {
                return Optional.ofNullable(clazz.cast(this.keepEmptyFolders()));
            }
            case "commitMessage": {
                return Optional.ofNullable(clazz.cast(this.commitMessage()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "email": {
                return Optional.ofNullable(clazz.cast(this.email()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteFileRequest, T> g) {
        return obj -> g.apply((DeleteFileRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeCommitRequest.BuilderImpl
    implements Builder {
        private String repositoryName;
        private String branchName;
        private String filePath;
        private String parentCommitId;
        private Boolean keepEmptyFolders;
        private String commitMessage;
        private String name;
        private String email;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteFileRequest model) {
            super(model);
            this.repositoryName(model.repositoryName);
            this.branchName(model.branchName);
            this.filePath(model.filePath);
            this.parentCommitId(model.parentCommitId);
            this.keepEmptyFolders(model.keepEmptyFolders);
            this.commitMessage(model.commitMessage);
            this.name(model.name);
            this.email(model.email);
        }

        public final String getRepositoryName() {
            return this.repositoryName;
        }

        @Override
        public final Builder repositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
            return this;
        }

        public final void setRepositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
        }

        public final String getBranchName() {
            return this.branchName;
        }

        @Override
        public final Builder branchName(String branchName) {
            this.branchName = branchName;
            return this;
        }

        public final void setBranchName(String branchName) {
            this.branchName = branchName;
        }

        public final String getFilePath() {
            return this.filePath;
        }

        @Override
        public final Builder filePath(String filePath) {
            this.filePath = filePath;
            return this;
        }

        public final void setFilePath(String filePath) {
            this.filePath = filePath;
        }

        public final String getParentCommitId() {
            return this.parentCommitId;
        }

        @Override
        public final Builder parentCommitId(String parentCommitId) {
            this.parentCommitId = parentCommitId;
            return this;
        }

        public final void setParentCommitId(String parentCommitId) {
            this.parentCommitId = parentCommitId;
        }

        public final Boolean getKeepEmptyFolders() {
            return this.keepEmptyFolders;
        }

        @Override
        public final Builder keepEmptyFolders(Boolean keepEmptyFolders) {
            this.keepEmptyFolders = keepEmptyFolders;
            return this;
        }

        public final void setKeepEmptyFolders(Boolean keepEmptyFolders) {
            this.keepEmptyFolders = keepEmptyFolders;
        }

        public final String getCommitMessage() {
            return this.commitMessage;
        }

        @Override
        public final Builder commitMessage(String commitMessage) {
            this.commitMessage = commitMessage;
            return this;
        }

        public final void setCommitMessage(String commitMessage) {
            this.commitMessage = commitMessage;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getEmail() {
            return this.email;
        }

        @Override
        public final Builder email(String email) {
            this.email = email;
            return this;
        }

        public final void setEmail(String email) {
            this.email = email;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteFileRequest build() {
            return new DeleteFileRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CodeCommitRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteFileRequest> {
        public Builder repositoryName(String var1);

        public Builder branchName(String var1);

        public Builder filePath(String var1);

        public Builder parentCommitId(String var1);

        public Builder keepEmptyFolders(Boolean var1);

        public Builder commitMessage(String var1);

        public Builder name(String var1);

        public Builder email(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

