/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codecommit.model;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.adapter.StandardMemberCopier;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codecommit.model.CodeCommitResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetBlobResponse
extends CodeCommitResponse
implements ToCopyableBuilder<Builder, GetBlobResponse> {
    private static final SdkField<SdkBytes> CONTENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_BYTES).getter(GetBlobResponse.getter(GetBlobResponse::content)).setter(GetBlobResponse.setter(Builder::content)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("content").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTENT_FIELD));
    private final SdkBytes content;

    private GetBlobResponse(BuilderImpl builder) {
        super(builder);
        this.content = builder.content;
    }

    public SdkBytes content() {
        return this.content;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.content());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetBlobResponse)) {
            return false;
        }
        GetBlobResponse other = (GetBlobResponse)((Object)obj);
        return Objects.equals(this.content(), other.content());
    }

    public String toString() {
        return ToString.builder((String)"GetBlobResponse").add("Content", (Object)this.content()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "content": {
                return Optional.ofNullable(clazz.cast(this.content()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetBlobResponse, T> g) {
        return obj -> g.apply((GetBlobResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeCommitResponse.BuilderImpl
    implements Builder {
        private SdkBytes content;

        private BuilderImpl() {
        }

        private BuilderImpl(GetBlobResponse model) {
            super(model);
            this.content(model.content);
        }

        public final ByteBuffer getContent() {
            return this.content == null ? null : this.content.asByteBuffer();
        }

        @Override
        public final Builder content(SdkBytes content) {
            this.content = StandardMemberCopier.copy((SdkBytes)content);
            return this;
        }

        public final void setContent(ByteBuffer content) {
            this.content(content == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)content));
        }

        @Override
        public GetBlobResponse build() {
            return new GetBlobResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CodeCommitResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetBlobResponse> {
        public Builder content(SdkBytes var1);
    }
}

