/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codecommit.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.codecommit.model.CodeCommitResponse;
import software.amazon.awssdk.services.codecommit.model.CommentsForPullRequest;
import software.amazon.awssdk.services.codecommit.model.CommentsForPullRequestDataCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetCommentsForPullRequestResponse
extends CodeCommitResponse
implements ToCopyableBuilder<Builder, GetCommentsForPullRequestResponse> {
    private static final SdkField<List<CommentsForPullRequest>> COMMENTS_FOR_PULL_REQUEST_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(GetCommentsForPullRequestResponse.getter(GetCommentsForPullRequestResponse::commentsForPullRequestData)).setter(GetCommentsForPullRequestResponse.setter(Builder::commentsForPullRequestData)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("commentsForPullRequestData").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CommentsForPullRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetCommentsForPullRequestResponse.getter(GetCommentsForPullRequestResponse::nextToken)).setter(GetCommentsForPullRequestResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMMENTS_FOR_PULL_REQUEST_DATA_FIELD, NEXT_TOKEN_FIELD));
    private final List<CommentsForPullRequest> commentsForPullRequestData;
    private final String nextToken;

    private GetCommentsForPullRequestResponse(BuilderImpl builder) {
        super(builder);
        this.commentsForPullRequestData = builder.commentsForPullRequestData;
        this.nextToken = builder.nextToken;
    }

    public List<CommentsForPullRequest> commentsForPullRequestData() {
        return this.commentsForPullRequestData;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.commentsForPullRequestData());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCommentsForPullRequestResponse)) {
            return false;
        }
        GetCommentsForPullRequestResponse other = (GetCommentsForPullRequestResponse)((Object)obj);
        return Objects.equals(this.commentsForPullRequestData(), other.commentsForPullRequestData()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"GetCommentsForPullRequestResponse").add("CommentsForPullRequestData", this.commentsForPullRequestData()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "commentsForPullRequestData": {
                return Optional.ofNullable(clazz.cast(this.commentsForPullRequestData()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetCommentsForPullRequestResponse, T> g) {
        return obj -> g.apply((GetCommentsForPullRequestResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeCommitResponse.BuilderImpl
    implements Builder {
        private List<CommentsForPullRequest> commentsForPullRequestData = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetCommentsForPullRequestResponse model) {
            super(model);
            this.commentsForPullRequestData(model.commentsForPullRequestData);
            this.nextToken(model.nextToken);
        }

        public final Collection<CommentsForPullRequest.Builder> getCommentsForPullRequestData() {
            return this.commentsForPullRequestData != null ? (Collection)this.commentsForPullRequestData.stream().map(CommentsForPullRequest::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder commentsForPullRequestData(Collection<CommentsForPullRequest> commentsForPullRequestData) {
            this.commentsForPullRequestData = CommentsForPullRequestDataCopier.copy(commentsForPullRequestData);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder commentsForPullRequestData(CommentsForPullRequest ... commentsForPullRequestData) {
            this.commentsForPullRequestData(Arrays.asList(commentsForPullRequestData));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder commentsForPullRequestData(Consumer<CommentsForPullRequest.Builder> ... commentsForPullRequestData) {
            this.commentsForPullRequestData(Stream.of(commentsForPullRequestData).map(c -> (CommentsForPullRequest)((CommentsForPullRequest.Builder)CommentsForPullRequest.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setCommentsForPullRequestData(Collection<CommentsForPullRequest.BuilderImpl> commentsForPullRequestData) {
            this.commentsForPullRequestData = CommentsForPullRequestDataCopier.copyFromBuilder(commentsForPullRequestData);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public GetCommentsForPullRequestResponse build() {
            return new GetCommentsForPullRequestResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CodeCommitResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetCommentsForPullRequestResponse> {
        public Builder commentsForPullRequestData(Collection<CommentsForPullRequest> var1);

        public Builder commentsForPullRequestData(CommentsForPullRequest ... var1);

        public Builder commentsForPullRequestData(Consumer<CommentsForPullRequest.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

