/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codecommit.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.codecommit.model.CodeCommitResponse;
import software.amazon.awssdk.services.codecommit.model.File;
import software.amazon.awssdk.services.codecommit.model.FileListCopier;
import software.amazon.awssdk.services.codecommit.model.Folder;
import software.amazon.awssdk.services.codecommit.model.FolderListCopier;
import software.amazon.awssdk.services.codecommit.model.SubModule;
import software.amazon.awssdk.services.codecommit.model.SubModuleListCopier;
import software.amazon.awssdk.services.codecommit.model.SymbolicLink;
import software.amazon.awssdk.services.codecommit.model.SymbolicLinkListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetFolderResponse
extends CodeCommitResponse
implements ToCopyableBuilder<Builder, GetFolderResponse> {
    private static final SdkField<String> COMMIT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetFolderResponse.getter(GetFolderResponse::commitId)).setter(GetFolderResponse.setter(Builder::commitId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("commitId").build()}).build();
    private static final SdkField<String> FOLDER_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetFolderResponse.getter(GetFolderResponse::folderPath)).setter(GetFolderResponse.setter(Builder::folderPath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("folderPath").build()}).build();
    private static final SdkField<String> TREE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetFolderResponse.getter(GetFolderResponse::treeId)).setter(GetFolderResponse.setter(Builder::treeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("treeId").build()}).build();
    private static final SdkField<List<Folder>> SUB_FOLDERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(GetFolderResponse.getter(GetFolderResponse::subFolders)).setter(GetFolderResponse.setter(Builder::subFolders)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subFolders").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Folder::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<File>> FILES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(GetFolderResponse.getter(GetFolderResponse::files)).setter(GetFolderResponse.setter(Builder::files)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("files").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(File::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<SymbolicLink>> SYMBOLIC_LINKS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(GetFolderResponse.getter(GetFolderResponse::symbolicLinks)).setter(GetFolderResponse.setter(Builder::symbolicLinks)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("symbolicLinks").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SymbolicLink::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<SubModule>> SUB_MODULES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(GetFolderResponse.getter(GetFolderResponse::subModules)).setter(GetFolderResponse.setter(Builder::subModules)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subModules").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SubModule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMMIT_ID_FIELD, FOLDER_PATH_FIELD, TREE_ID_FIELD, SUB_FOLDERS_FIELD, FILES_FIELD, SYMBOLIC_LINKS_FIELD, SUB_MODULES_FIELD));
    private final String commitId;
    private final String folderPath;
    private final String treeId;
    private final List<Folder> subFolders;
    private final List<File> files;
    private final List<SymbolicLink> symbolicLinks;
    private final List<SubModule> subModules;

    private GetFolderResponse(BuilderImpl builder) {
        super(builder);
        this.commitId = builder.commitId;
        this.folderPath = builder.folderPath;
        this.treeId = builder.treeId;
        this.subFolders = builder.subFolders;
        this.files = builder.files;
        this.symbolicLinks = builder.symbolicLinks;
        this.subModules = builder.subModules;
    }

    public String commitId() {
        return this.commitId;
    }

    public String folderPath() {
        return this.folderPath;
    }

    public String treeId() {
        return this.treeId;
    }

    public List<Folder> subFolders() {
        return this.subFolders;
    }

    public List<File> files() {
        return this.files;
    }

    public List<SymbolicLink> symbolicLinks() {
        return this.symbolicLinks;
    }

    public List<SubModule> subModules() {
        return this.subModules;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.commitId());
        hashCode = 31 * hashCode + Objects.hashCode(this.folderPath());
        hashCode = 31 * hashCode + Objects.hashCode(this.treeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.subFolders());
        hashCode = 31 * hashCode + Objects.hashCode(this.files());
        hashCode = 31 * hashCode + Objects.hashCode(this.symbolicLinks());
        hashCode = 31 * hashCode + Objects.hashCode(this.subModules());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetFolderResponse)) {
            return false;
        }
        GetFolderResponse other = (GetFolderResponse)((Object)obj);
        return Objects.equals(this.commitId(), other.commitId()) && Objects.equals(this.folderPath(), other.folderPath()) && Objects.equals(this.treeId(), other.treeId()) && Objects.equals(this.subFolders(), other.subFolders()) && Objects.equals(this.files(), other.files()) && Objects.equals(this.symbolicLinks(), other.symbolicLinks()) && Objects.equals(this.subModules(), other.subModules());
    }

    public String toString() {
        return ToString.builder((String)"GetFolderResponse").add("CommitId", (Object)this.commitId()).add("FolderPath", (Object)this.folderPath()).add("TreeId", (Object)this.treeId()).add("SubFolders", this.subFolders()).add("Files", this.files()).add("SymbolicLinks", this.symbolicLinks()).add("SubModules", this.subModules()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "commitId": {
                return Optional.ofNullable(clazz.cast(this.commitId()));
            }
            case "folderPath": {
                return Optional.ofNullable(clazz.cast(this.folderPath()));
            }
            case "treeId": {
                return Optional.ofNullable(clazz.cast(this.treeId()));
            }
            case "subFolders": {
                return Optional.ofNullable(clazz.cast(this.subFolders()));
            }
            case "files": {
                return Optional.ofNullable(clazz.cast(this.files()));
            }
            case "symbolicLinks": {
                return Optional.ofNullable(clazz.cast(this.symbolicLinks()));
            }
            case "subModules": {
                return Optional.ofNullable(clazz.cast(this.subModules()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetFolderResponse, T> g) {
        return obj -> g.apply((GetFolderResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeCommitResponse.BuilderImpl
    implements Builder {
        private String commitId;
        private String folderPath;
        private String treeId;
        private List<Folder> subFolders = DefaultSdkAutoConstructList.getInstance();
        private List<File> files = DefaultSdkAutoConstructList.getInstance();
        private List<SymbolicLink> symbolicLinks = DefaultSdkAutoConstructList.getInstance();
        private List<SubModule> subModules = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetFolderResponse model) {
            super(model);
            this.commitId(model.commitId);
            this.folderPath(model.folderPath);
            this.treeId(model.treeId);
            this.subFolders(model.subFolders);
            this.files(model.files);
            this.symbolicLinks(model.symbolicLinks);
            this.subModules(model.subModules);
        }

        public final String getCommitId() {
            return this.commitId;
        }

        @Override
        public final Builder commitId(String commitId) {
            this.commitId = commitId;
            return this;
        }

        public final void setCommitId(String commitId) {
            this.commitId = commitId;
        }

        public final String getFolderPath() {
            return this.folderPath;
        }

        @Override
        public final Builder folderPath(String folderPath) {
            this.folderPath = folderPath;
            return this;
        }

        public final void setFolderPath(String folderPath) {
            this.folderPath = folderPath;
        }

        public final String getTreeId() {
            return this.treeId;
        }

        @Override
        public final Builder treeId(String treeId) {
            this.treeId = treeId;
            return this;
        }

        public final void setTreeId(String treeId) {
            this.treeId = treeId;
        }

        public final Collection<Folder.Builder> getSubFolders() {
            return this.subFolders != null ? (Collection)this.subFolders.stream().map(Folder::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder subFolders(Collection<Folder> subFolders) {
            this.subFolders = FolderListCopier.copy(subFolders);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subFolders(Folder ... subFolders) {
            this.subFolders(Arrays.asList(subFolders));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subFolders(Consumer<Folder.Builder> ... subFolders) {
            this.subFolders(Stream.of(subFolders).map(c -> (Folder)((Folder.Builder)Folder.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSubFolders(Collection<Folder.BuilderImpl> subFolders) {
            this.subFolders = FolderListCopier.copyFromBuilder(subFolders);
        }

        public final Collection<File.Builder> getFiles() {
            return this.files != null ? (Collection)this.files.stream().map(File::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder files(Collection<File> files) {
            this.files = FileListCopier.copy(files);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder files(File ... files) {
            this.files(Arrays.asList(files));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder files(Consumer<File.Builder> ... files) {
            this.files(Stream.of(files).map(c -> (File)((File.Builder)File.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFiles(Collection<File.BuilderImpl> files) {
            this.files = FileListCopier.copyFromBuilder(files);
        }

        public final Collection<SymbolicLink.Builder> getSymbolicLinks() {
            return this.symbolicLinks != null ? (Collection)this.symbolicLinks.stream().map(SymbolicLink::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder symbolicLinks(Collection<SymbolicLink> symbolicLinks) {
            this.symbolicLinks = SymbolicLinkListCopier.copy(symbolicLinks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder symbolicLinks(SymbolicLink ... symbolicLinks) {
            this.symbolicLinks(Arrays.asList(symbolicLinks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder symbolicLinks(Consumer<SymbolicLink.Builder> ... symbolicLinks) {
            this.symbolicLinks(Stream.of(symbolicLinks).map(c -> (SymbolicLink)((SymbolicLink.Builder)SymbolicLink.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSymbolicLinks(Collection<SymbolicLink.BuilderImpl> symbolicLinks) {
            this.symbolicLinks = SymbolicLinkListCopier.copyFromBuilder(symbolicLinks);
        }

        public final Collection<SubModule.Builder> getSubModules() {
            return this.subModules != null ? (Collection)this.subModules.stream().map(SubModule::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder subModules(Collection<SubModule> subModules) {
            this.subModules = SubModuleListCopier.copy(subModules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subModules(SubModule ... subModules) {
            this.subModules(Arrays.asList(subModules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subModules(Consumer<SubModule.Builder> ... subModules) {
            this.subModules(Stream.of(subModules).map(c -> (SubModule)((SubModule.Builder)SubModule.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSubModules(Collection<SubModule.BuilderImpl> subModules) {
            this.subModules = SubModuleListCopier.copyFromBuilder(subModules);
        }

        @Override
        public GetFolderResponse build() {
            return new GetFolderResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CodeCommitResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetFolderResponse> {
        public Builder commitId(String var1);

        public Builder folderPath(String var1);

        public Builder treeId(String var1);

        public Builder subFolders(Collection<Folder> var1);

        public Builder subFolders(Folder ... var1);

        public Builder subFolders(Consumer<Folder.Builder> ... var1);

        public Builder files(Collection<File> var1);

        public Builder files(File ... var1);

        public Builder files(Consumer<File.Builder> ... var1);

        public Builder symbolicLinks(Collection<SymbolicLink> var1);

        public Builder symbolicLinks(SymbolicLink ... var1);

        public Builder symbolicLinks(Consumer<SymbolicLink.Builder> ... var1);

        public Builder subModules(Collection<SubModule> var1);

        public Builder subModules(SubModule ... var1);

        public Builder subModules(Consumer<SubModule.Builder> ... var1);
    }
}

