/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codecommit.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codecommit.model.CodeCommitRequest;
import software.amazon.awssdk.services.codecommit.model.MergeOptionTypeEnum;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetMergeConflictsRequest
extends CodeCommitRequest
implements ToCopyableBuilder<Builder, GetMergeConflictsRequest> {
    private static final SdkField<String> REPOSITORY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetMergeConflictsRequest.getter(GetMergeConflictsRequest::repositoryName)).setter(GetMergeConflictsRequest.setter(Builder::repositoryName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositoryName").build()}).build();
    private static final SdkField<String> DESTINATION_COMMIT_SPECIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetMergeConflictsRequest.getter(GetMergeConflictsRequest::destinationCommitSpecifier)).setter(GetMergeConflictsRequest.setter(Builder::destinationCommitSpecifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationCommitSpecifier").build()}).build();
    private static final SdkField<String> SOURCE_COMMIT_SPECIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetMergeConflictsRequest.getter(GetMergeConflictsRequest::sourceCommitSpecifier)).setter(GetMergeConflictsRequest.setter(Builder::sourceCommitSpecifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceCommitSpecifier").build()}).build();
    private static final SdkField<String> MERGE_OPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetMergeConflictsRequest.getter(GetMergeConflictsRequest::mergeOptionAsString)).setter(GetMergeConflictsRequest.setter(Builder::mergeOption)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mergeOption").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPOSITORY_NAME_FIELD, DESTINATION_COMMIT_SPECIFIER_FIELD, SOURCE_COMMIT_SPECIFIER_FIELD, MERGE_OPTION_FIELD));
    private final String repositoryName;
    private final String destinationCommitSpecifier;
    private final String sourceCommitSpecifier;
    private final String mergeOption;

    private GetMergeConflictsRequest(BuilderImpl builder) {
        super(builder);
        this.repositoryName = builder.repositoryName;
        this.destinationCommitSpecifier = builder.destinationCommitSpecifier;
        this.sourceCommitSpecifier = builder.sourceCommitSpecifier;
        this.mergeOption = builder.mergeOption;
    }

    public String repositoryName() {
        return this.repositoryName;
    }

    public String destinationCommitSpecifier() {
        return this.destinationCommitSpecifier;
    }

    public String sourceCommitSpecifier() {
        return this.sourceCommitSpecifier;
    }

    public MergeOptionTypeEnum mergeOption() {
        return MergeOptionTypeEnum.fromValue(this.mergeOption);
    }

    public String mergeOptionAsString() {
        return this.mergeOption;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.repositoryName());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationCommitSpecifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceCommitSpecifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.mergeOptionAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetMergeConflictsRequest)) {
            return false;
        }
        GetMergeConflictsRequest other = (GetMergeConflictsRequest)((Object)obj);
        return Objects.equals(this.repositoryName(), other.repositoryName()) && Objects.equals(this.destinationCommitSpecifier(), other.destinationCommitSpecifier()) && Objects.equals(this.sourceCommitSpecifier(), other.sourceCommitSpecifier()) && Objects.equals(this.mergeOptionAsString(), other.mergeOptionAsString());
    }

    public String toString() {
        return ToString.builder((String)"GetMergeConflictsRequest").add("RepositoryName", (Object)this.repositoryName()).add("DestinationCommitSpecifier", (Object)this.destinationCommitSpecifier()).add("SourceCommitSpecifier", (Object)this.sourceCommitSpecifier()).add("MergeOption", (Object)this.mergeOptionAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "repositoryName": {
                return Optional.ofNullable(clazz.cast(this.repositoryName()));
            }
            case "destinationCommitSpecifier": {
                return Optional.ofNullable(clazz.cast(this.destinationCommitSpecifier()));
            }
            case "sourceCommitSpecifier": {
                return Optional.ofNullable(clazz.cast(this.sourceCommitSpecifier()));
            }
            case "mergeOption": {
                return Optional.ofNullable(clazz.cast(this.mergeOptionAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetMergeConflictsRequest, T> g) {
        return obj -> g.apply((GetMergeConflictsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeCommitRequest.BuilderImpl
    implements Builder {
        private String repositoryName;
        private String destinationCommitSpecifier;
        private String sourceCommitSpecifier;
        private String mergeOption;

        private BuilderImpl() {
        }

        private BuilderImpl(GetMergeConflictsRequest model) {
            super(model);
            this.repositoryName(model.repositoryName);
            this.destinationCommitSpecifier(model.destinationCommitSpecifier);
            this.sourceCommitSpecifier(model.sourceCommitSpecifier);
            this.mergeOption(model.mergeOption);
        }

        public final String getRepositoryName() {
            return this.repositoryName;
        }

        @Override
        public final Builder repositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
            return this;
        }

        public final void setRepositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
        }

        public final String getDestinationCommitSpecifier() {
            return this.destinationCommitSpecifier;
        }

        @Override
        public final Builder destinationCommitSpecifier(String destinationCommitSpecifier) {
            this.destinationCommitSpecifier = destinationCommitSpecifier;
            return this;
        }

        public final void setDestinationCommitSpecifier(String destinationCommitSpecifier) {
            this.destinationCommitSpecifier = destinationCommitSpecifier;
        }

        public final String getSourceCommitSpecifier() {
            return this.sourceCommitSpecifier;
        }

        @Override
        public final Builder sourceCommitSpecifier(String sourceCommitSpecifier) {
            this.sourceCommitSpecifier = sourceCommitSpecifier;
            return this;
        }

        public final void setSourceCommitSpecifier(String sourceCommitSpecifier) {
            this.sourceCommitSpecifier = sourceCommitSpecifier;
        }

        public final String getMergeOptionAsString() {
            return this.mergeOption;
        }

        @Override
        public final Builder mergeOption(String mergeOption) {
            this.mergeOption = mergeOption;
            return this;
        }

        @Override
        public final Builder mergeOption(MergeOptionTypeEnum mergeOption) {
            this.mergeOption(mergeOption.toString());
            return this;
        }

        public final void setMergeOption(String mergeOption) {
            this.mergeOption = mergeOption;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetMergeConflictsRequest build() {
            return new GetMergeConflictsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CodeCommitRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetMergeConflictsRequest> {
        public Builder repositoryName(String var1);

        public Builder destinationCommitSpecifier(String var1);

        public Builder sourceCommitSpecifier(String var1);

        public Builder mergeOption(String var1);

        public Builder mergeOption(MergeOptionTypeEnum var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

