/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codecommit.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codecommit.model.CodeCommitResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetMergeConflictsResponse
extends CodeCommitResponse
implements ToCopyableBuilder<Builder, GetMergeConflictsResponse> {
    private static final SdkField<Boolean> MERGEABLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(GetMergeConflictsResponse.getter(GetMergeConflictsResponse::mergeable)).setter(GetMergeConflictsResponse.setter(Builder::mergeable)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mergeable").build()}).build();
    private static final SdkField<String> DESTINATION_COMMIT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetMergeConflictsResponse.getter(GetMergeConflictsResponse::destinationCommitId)).setter(GetMergeConflictsResponse.setter(Builder::destinationCommitId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationCommitId").build()}).build();
    private static final SdkField<String> SOURCE_COMMIT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetMergeConflictsResponse.getter(GetMergeConflictsResponse::sourceCommitId)).setter(GetMergeConflictsResponse.setter(Builder::sourceCommitId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceCommitId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MERGEABLE_FIELD, DESTINATION_COMMIT_ID_FIELD, SOURCE_COMMIT_ID_FIELD));
    private final Boolean mergeable;
    private final String destinationCommitId;
    private final String sourceCommitId;

    private GetMergeConflictsResponse(BuilderImpl builder) {
        super(builder);
        this.mergeable = builder.mergeable;
        this.destinationCommitId = builder.destinationCommitId;
        this.sourceCommitId = builder.sourceCommitId;
    }

    public Boolean mergeable() {
        return this.mergeable;
    }

    public String destinationCommitId() {
        return this.destinationCommitId;
    }

    public String sourceCommitId() {
        return this.sourceCommitId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.mergeable());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationCommitId());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceCommitId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetMergeConflictsResponse)) {
            return false;
        }
        GetMergeConflictsResponse other = (GetMergeConflictsResponse)((Object)obj);
        return Objects.equals(this.mergeable(), other.mergeable()) && Objects.equals(this.destinationCommitId(), other.destinationCommitId()) && Objects.equals(this.sourceCommitId(), other.sourceCommitId());
    }

    public String toString() {
        return ToString.builder((String)"GetMergeConflictsResponse").add("Mergeable", (Object)this.mergeable()).add("DestinationCommitId", (Object)this.destinationCommitId()).add("SourceCommitId", (Object)this.sourceCommitId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "mergeable": {
                return Optional.ofNullable(clazz.cast(this.mergeable()));
            }
            case "destinationCommitId": {
                return Optional.ofNullable(clazz.cast(this.destinationCommitId()));
            }
            case "sourceCommitId": {
                return Optional.ofNullable(clazz.cast(this.sourceCommitId()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetMergeConflictsResponse, T> g) {
        return obj -> g.apply((GetMergeConflictsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeCommitResponse.BuilderImpl
    implements Builder {
        private Boolean mergeable;
        private String destinationCommitId;
        private String sourceCommitId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetMergeConflictsResponse model) {
            super(model);
            this.mergeable(model.mergeable);
            this.destinationCommitId(model.destinationCommitId);
            this.sourceCommitId(model.sourceCommitId);
        }

        public final Boolean getMergeable() {
            return this.mergeable;
        }

        @Override
        public final Builder mergeable(Boolean mergeable) {
            this.mergeable = mergeable;
            return this;
        }

        public final void setMergeable(Boolean mergeable) {
            this.mergeable = mergeable;
        }

        public final String getDestinationCommitId() {
            return this.destinationCommitId;
        }

        @Override
        public final Builder destinationCommitId(String destinationCommitId) {
            this.destinationCommitId = destinationCommitId;
            return this;
        }

        public final void setDestinationCommitId(String destinationCommitId) {
            this.destinationCommitId = destinationCommitId;
        }

        public final String getSourceCommitId() {
            return this.sourceCommitId;
        }

        @Override
        public final Builder sourceCommitId(String sourceCommitId) {
            this.sourceCommitId = sourceCommitId;
            return this;
        }

        public final void setSourceCommitId(String sourceCommitId) {
            this.sourceCommitId = sourceCommitId;
        }

        @Override
        public GetMergeConflictsResponse build() {
            return new GetMergeConflictsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CodeCommitResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetMergeConflictsResponse> {
        public Builder mergeable(Boolean var1);

        public Builder destinationCommitId(String var1);

        public Builder sourceCommitId(String var1);
    }
}

