/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codecommit.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codecommit.model.CodeCommitRequest;
import software.amazon.awssdk.services.codecommit.model.PullRequestStatusEnum;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListPullRequestsRequest
extends CodeCommitRequest
implements ToCopyableBuilder<Builder, ListPullRequestsRequest> {
    private static final SdkField<String> REPOSITORY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListPullRequestsRequest.getter(ListPullRequestsRequest::repositoryName)).setter(ListPullRequestsRequest.setter(Builder::repositoryName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositoryName").build()}).build();
    private static final SdkField<String> AUTHOR_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListPullRequestsRequest.getter(ListPullRequestsRequest::authorArn)).setter(ListPullRequestsRequest.setter(Builder::authorArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authorArn").build()}).build();
    private static final SdkField<String> PULL_REQUEST_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListPullRequestsRequest.getter(ListPullRequestsRequest::pullRequestStatusAsString)).setter(ListPullRequestsRequest.setter(Builder::pullRequestStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pullRequestStatus").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListPullRequestsRequest.getter(ListPullRequestsRequest::nextToken)).setter(ListPullRequestsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(ListPullRequestsRequest.getter(ListPullRequestsRequest::maxResults)).setter(ListPullRequestsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPOSITORY_NAME_FIELD, AUTHOR_ARN_FIELD, PULL_REQUEST_STATUS_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));
    private final String repositoryName;
    private final String authorArn;
    private final String pullRequestStatus;
    private final String nextToken;
    private final Integer maxResults;

    private ListPullRequestsRequest(BuilderImpl builder) {
        super(builder);
        this.repositoryName = builder.repositoryName;
        this.authorArn = builder.authorArn;
        this.pullRequestStatus = builder.pullRequestStatus;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    public String repositoryName() {
        return this.repositoryName;
    }

    public String authorArn() {
        return this.authorArn;
    }

    public PullRequestStatusEnum pullRequestStatus() {
        return PullRequestStatusEnum.fromValue(this.pullRequestStatus);
    }

    public String pullRequestStatusAsString() {
        return this.pullRequestStatus;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Integer maxResults() {
        return this.maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.repositoryName());
        hashCode = 31 * hashCode + Objects.hashCode(this.authorArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.pullRequestStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPullRequestsRequest)) {
            return false;
        }
        ListPullRequestsRequest other = (ListPullRequestsRequest)((Object)obj);
        return Objects.equals(this.repositoryName(), other.repositoryName()) && Objects.equals(this.authorArn(), other.authorArn()) && Objects.equals(this.pullRequestStatusAsString(), other.pullRequestStatusAsString()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults());
    }

    public String toString() {
        return ToString.builder((String)"ListPullRequestsRequest").add("RepositoryName", (Object)this.repositoryName()).add("AuthorArn", (Object)this.authorArn()).add("PullRequestStatus", (Object)this.pullRequestStatusAsString()).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "repositoryName": {
                return Optional.ofNullable(clazz.cast(this.repositoryName()));
            }
            case "authorArn": {
                return Optional.ofNullable(clazz.cast(this.authorArn()));
            }
            case "pullRequestStatus": {
                return Optional.ofNullable(clazz.cast(this.pullRequestStatusAsString()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListPullRequestsRequest, T> g) {
        return obj -> g.apply((ListPullRequestsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeCommitRequest.BuilderImpl
    implements Builder {
        private String repositoryName;
        private String authorArn;
        private String pullRequestStatus;
        private String nextToken;
        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPullRequestsRequest model) {
            super(model);
            this.repositoryName(model.repositoryName);
            this.authorArn(model.authorArn);
            this.pullRequestStatus(model.pullRequestStatus);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
        }

        public final String getRepositoryName() {
            return this.repositoryName;
        }

        @Override
        public final Builder repositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
            return this;
        }

        public final void setRepositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
        }

        public final String getAuthorArn() {
            return this.authorArn;
        }

        @Override
        public final Builder authorArn(String authorArn) {
            this.authorArn = authorArn;
            return this;
        }

        public final void setAuthorArn(String authorArn) {
            this.authorArn = authorArn;
        }

        public final String getPullRequestStatusAsString() {
            return this.pullRequestStatus;
        }

        @Override
        public final Builder pullRequestStatus(String pullRequestStatus) {
            this.pullRequestStatus = pullRequestStatus;
            return this;
        }

        @Override
        public final Builder pullRequestStatus(PullRequestStatusEnum pullRequestStatus) {
            this.pullRequestStatus(pullRequestStatus.toString());
            return this;
        }

        public final void setPullRequestStatus(String pullRequestStatus) {
            this.pullRequestStatus = pullRequestStatus;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListPullRequestsRequest build() {
            return new ListPullRequestsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CodeCommitRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListPullRequestsRequest> {
        public Builder repositoryName(String var1);

        public Builder authorArn(String var1);

        public Builder pullRequestStatus(String var1);

        public Builder pullRequestStatus(PullRequestStatusEnum var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

