/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codecommit.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codecommit.model.CodeCommitRequest;
import software.amazon.awssdk.services.codecommit.model.OrderEnum;
import software.amazon.awssdk.services.codecommit.model.SortByEnum;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListRepositoriesRequest
extends CodeCommitRequest
implements ToCopyableBuilder<Builder, ListRepositoriesRequest> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListRepositoriesRequest.getter(ListRepositoriesRequest::nextToken)).setter(ListRepositoriesRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<String> SORT_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListRepositoriesRequest.getter(ListRepositoriesRequest::sortByAsString)).setter(ListRepositoriesRequest.setter(Builder::sortBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sortBy").build()}).build();
    private static final SdkField<String> ORDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListRepositoriesRequest.getter(ListRepositoriesRequest::orderAsString)).setter(ListRepositoriesRequest.setter(Builder::order)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("order").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, SORT_BY_FIELD, ORDER_FIELD));
    private final String nextToken;
    private final String sortBy;
    private final String order;

    private ListRepositoriesRequest(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.sortBy = builder.sortBy;
        this.order = builder.order;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public SortByEnum sortBy() {
        return SortByEnum.fromValue(this.sortBy);
    }

    public String sortByAsString() {
        return this.sortBy;
    }

    public OrderEnum order() {
        return OrderEnum.fromValue(this.order);
    }

    public String orderAsString() {
        return this.order;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.sortByAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.orderAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRepositoriesRequest)) {
            return false;
        }
        ListRepositoriesRequest other = (ListRepositoriesRequest)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.sortByAsString(), other.sortByAsString()) && Objects.equals(this.orderAsString(), other.orderAsString());
    }

    public String toString() {
        return ToString.builder((String)"ListRepositoriesRequest").add("NextToken", (Object)this.nextToken()).add("SortBy", (Object)this.sortByAsString()).add("Order", (Object)this.orderAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "sortBy": {
                return Optional.ofNullable(clazz.cast(this.sortByAsString()));
            }
            case "order": {
                return Optional.ofNullable(clazz.cast(this.orderAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListRepositoriesRequest, T> g) {
        return obj -> g.apply((ListRepositoriesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeCommitRequest.BuilderImpl
    implements Builder {
        private String nextToken;
        private String sortBy;
        private String order;

        private BuilderImpl() {
        }

        private BuilderImpl(ListRepositoriesRequest model) {
            super(model);
            this.nextToken(model.nextToken);
            this.sortBy(model.sortBy);
            this.order(model.order);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final String getSortByAsString() {
            return this.sortBy;
        }

        @Override
        public final Builder sortBy(String sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        @Override
        public final Builder sortBy(SortByEnum sortBy) {
            this.sortBy(sortBy.toString());
            return this;
        }

        public final void setSortBy(String sortBy) {
            this.sortBy = sortBy;
        }

        public final String getOrderAsString() {
            return this.order;
        }

        @Override
        public final Builder order(String order) {
            this.order = order;
            return this;
        }

        @Override
        public final Builder order(OrderEnum order) {
            this.order(order.toString());
            return this;
        }

        public final void setOrder(String order) {
            this.order = order;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListRepositoriesRequest build() {
            return new ListRepositoriesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CodeCommitRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListRepositoriesRequest> {
        public Builder nextToken(String var1);

        public Builder sortBy(String var1);

        public Builder sortBy(SortByEnum var1);

        public Builder order(String var1);

        public Builder order(OrderEnum var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

