/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codecommit.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codecommit.model.CodeCommitRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MergePullRequestByFastForwardRequest
extends CodeCommitRequest
implements ToCopyableBuilder<Builder, MergePullRequestByFastForwardRequest> {
    private static final SdkField<String> PULL_REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(MergePullRequestByFastForwardRequest.getter(MergePullRequestByFastForwardRequest::pullRequestId)).setter(MergePullRequestByFastForwardRequest.setter(Builder::pullRequestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pullRequestId").build()}).build();
    private static final SdkField<String> REPOSITORY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(MergePullRequestByFastForwardRequest.getter(MergePullRequestByFastForwardRequest::repositoryName)).setter(MergePullRequestByFastForwardRequest.setter(Builder::repositoryName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositoryName").build()}).build();
    private static final SdkField<String> SOURCE_COMMIT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(MergePullRequestByFastForwardRequest.getter(MergePullRequestByFastForwardRequest::sourceCommitId)).setter(MergePullRequestByFastForwardRequest.setter(Builder::sourceCommitId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceCommitId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PULL_REQUEST_ID_FIELD, REPOSITORY_NAME_FIELD, SOURCE_COMMIT_ID_FIELD));
    private final String pullRequestId;
    private final String repositoryName;
    private final String sourceCommitId;

    private MergePullRequestByFastForwardRequest(BuilderImpl builder) {
        super(builder);
        this.pullRequestId = builder.pullRequestId;
        this.repositoryName = builder.repositoryName;
        this.sourceCommitId = builder.sourceCommitId;
    }

    public String pullRequestId() {
        return this.pullRequestId;
    }

    public String repositoryName() {
        return this.repositoryName;
    }

    public String sourceCommitId() {
        return this.sourceCommitId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.pullRequestId());
        hashCode = 31 * hashCode + Objects.hashCode(this.repositoryName());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceCommitId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MergePullRequestByFastForwardRequest)) {
            return false;
        }
        MergePullRequestByFastForwardRequest other = (MergePullRequestByFastForwardRequest)((Object)obj);
        return Objects.equals(this.pullRequestId(), other.pullRequestId()) && Objects.equals(this.repositoryName(), other.repositoryName()) && Objects.equals(this.sourceCommitId(), other.sourceCommitId());
    }

    public String toString() {
        return ToString.builder((String)"MergePullRequestByFastForwardRequest").add("PullRequestId", (Object)this.pullRequestId()).add("RepositoryName", (Object)this.repositoryName()).add("SourceCommitId", (Object)this.sourceCommitId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "pullRequestId": {
                return Optional.ofNullable(clazz.cast(this.pullRequestId()));
            }
            case "repositoryName": {
                return Optional.ofNullable(clazz.cast(this.repositoryName()));
            }
            case "sourceCommitId": {
                return Optional.ofNullable(clazz.cast(this.sourceCommitId()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MergePullRequestByFastForwardRequest, T> g) {
        return obj -> g.apply((MergePullRequestByFastForwardRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeCommitRequest.BuilderImpl
    implements Builder {
        private String pullRequestId;
        private String repositoryName;
        private String sourceCommitId;

        private BuilderImpl() {
        }

        private BuilderImpl(MergePullRequestByFastForwardRequest model) {
            super(model);
            this.pullRequestId(model.pullRequestId);
            this.repositoryName(model.repositoryName);
            this.sourceCommitId(model.sourceCommitId);
        }

        public final String getPullRequestId() {
            return this.pullRequestId;
        }

        @Override
        public final Builder pullRequestId(String pullRequestId) {
            this.pullRequestId = pullRequestId;
            return this;
        }

        public final void setPullRequestId(String pullRequestId) {
            this.pullRequestId = pullRequestId;
        }

        public final String getRepositoryName() {
            return this.repositoryName;
        }

        @Override
        public final Builder repositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
            return this;
        }

        public final void setRepositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
        }

        public final String getSourceCommitId() {
            return this.sourceCommitId;
        }

        @Override
        public final Builder sourceCommitId(String sourceCommitId) {
            this.sourceCommitId = sourceCommitId;
            return this;
        }

        public final void setSourceCommitId(String sourceCommitId) {
            this.sourceCommitId = sourceCommitId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public MergePullRequestByFastForwardRequest build() {
            return new MergePullRequestByFastForwardRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CodeCommitRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, MergePullRequestByFastForwardRequest> {
        public Builder pullRequestId(String var1);

        public Builder repositoryName(String var1);

        public Builder sourceCommitId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

