/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codecommit.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PullRequestCreatedEventMetadata
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PullRequestCreatedEventMetadata> {
    private static final SdkField<String> REPOSITORY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PullRequestCreatedEventMetadata.getter(PullRequestCreatedEventMetadata::repositoryName)).setter(PullRequestCreatedEventMetadata.setter(Builder::repositoryName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositoryName").build()}).build();
    private static final SdkField<String> SOURCE_COMMIT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PullRequestCreatedEventMetadata.getter(PullRequestCreatedEventMetadata::sourceCommitId)).setter(PullRequestCreatedEventMetadata.setter(Builder::sourceCommitId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceCommitId").build()}).build();
    private static final SdkField<String> DESTINATION_COMMIT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PullRequestCreatedEventMetadata.getter(PullRequestCreatedEventMetadata::destinationCommitId)).setter(PullRequestCreatedEventMetadata.setter(Builder::destinationCommitId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationCommitId").build()}).build();
    private static final SdkField<String> MERGE_BASE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PullRequestCreatedEventMetadata.getter(PullRequestCreatedEventMetadata::mergeBase)).setter(PullRequestCreatedEventMetadata.setter(Builder::mergeBase)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mergeBase").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPOSITORY_NAME_FIELD, SOURCE_COMMIT_ID_FIELD, DESTINATION_COMMIT_ID_FIELD, MERGE_BASE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String repositoryName;
    private final String sourceCommitId;
    private final String destinationCommitId;
    private final String mergeBase;

    private PullRequestCreatedEventMetadata(BuilderImpl builder) {
        this.repositoryName = builder.repositoryName;
        this.sourceCommitId = builder.sourceCommitId;
        this.destinationCommitId = builder.destinationCommitId;
        this.mergeBase = builder.mergeBase;
    }

    public String repositoryName() {
        return this.repositoryName;
    }

    public String sourceCommitId() {
        return this.sourceCommitId;
    }

    public String destinationCommitId() {
        return this.destinationCommitId;
    }

    public String mergeBase() {
        return this.mergeBase;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.repositoryName());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceCommitId());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationCommitId());
        hashCode = 31 * hashCode + Objects.hashCode(this.mergeBase());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PullRequestCreatedEventMetadata)) {
            return false;
        }
        PullRequestCreatedEventMetadata other = (PullRequestCreatedEventMetadata)obj;
        return Objects.equals(this.repositoryName(), other.repositoryName()) && Objects.equals(this.sourceCommitId(), other.sourceCommitId()) && Objects.equals(this.destinationCommitId(), other.destinationCommitId()) && Objects.equals(this.mergeBase(), other.mergeBase());
    }

    public String toString() {
        return ToString.builder((String)"PullRequestCreatedEventMetadata").add("RepositoryName", (Object)this.repositoryName()).add("SourceCommitId", (Object)this.sourceCommitId()).add("DestinationCommitId", (Object)this.destinationCommitId()).add("MergeBase", (Object)this.mergeBase()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "repositoryName": {
                return Optional.ofNullable(clazz.cast(this.repositoryName()));
            }
            case "sourceCommitId": {
                return Optional.ofNullable(clazz.cast(this.sourceCommitId()));
            }
            case "destinationCommitId": {
                return Optional.ofNullable(clazz.cast(this.destinationCommitId()));
            }
            case "mergeBase": {
                return Optional.ofNullable(clazz.cast(this.mergeBase()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PullRequestCreatedEventMetadata, T> g) {
        return obj -> g.apply((PullRequestCreatedEventMetadata)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String repositoryName;
        private String sourceCommitId;
        private String destinationCommitId;
        private String mergeBase;

        private BuilderImpl() {
        }

        private BuilderImpl(PullRequestCreatedEventMetadata model) {
            this.repositoryName(model.repositoryName);
            this.sourceCommitId(model.sourceCommitId);
            this.destinationCommitId(model.destinationCommitId);
            this.mergeBase(model.mergeBase);
        }

        public final String getRepositoryName() {
            return this.repositoryName;
        }

        @Override
        public final Builder repositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
            return this;
        }

        public final void setRepositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
        }

        public final String getSourceCommitId() {
            return this.sourceCommitId;
        }

        @Override
        public final Builder sourceCommitId(String sourceCommitId) {
            this.sourceCommitId = sourceCommitId;
            return this;
        }

        public final void setSourceCommitId(String sourceCommitId) {
            this.sourceCommitId = sourceCommitId;
        }

        public final String getDestinationCommitId() {
            return this.destinationCommitId;
        }

        @Override
        public final Builder destinationCommitId(String destinationCommitId) {
            this.destinationCommitId = destinationCommitId;
            return this;
        }

        public final void setDestinationCommitId(String destinationCommitId) {
            this.destinationCommitId = destinationCommitId;
        }

        public final String getMergeBase() {
            return this.mergeBase;
        }

        @Override
        public final Builder mergeBase(String mergeBase) {
            this.mergeBase = mergeBase;
            return this;
        }

        public final void setMergeBase(String mergeBase) {
            this.mergeBase = mergeBase;
        }

        public PullRequestCreatedEventMetadata build() {
            return new PullRequestCreatedEventMetadata(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PullRequestCreatedEventMetadata> {
        public Builder repositoryName(String var1);

        public Builder sourceCommitId(String var1);

        public Builder destinationCommitId(String var1);

        public Builder mergeBase(String var1);
    }
}

