/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codecommit.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum PullRequestEventType {
    PULL_REQUEST_CREATED("PULL_REQUEST_CREATED"),
    PULL_REQUEST_STATUS_CHANGED("PULL_REQUEST_STATUS_CHANGED"),
    PULL_REQUEST_SOURCE_REFERENCE_UPDATED("PULL_REQUEST_SOURCE_REFERENCE_UPDATED"),
    PULL_REQUEST_MERGE_STATE_CHANGED("PULL_REQUEST_MERGE_STATE_CHANGED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private PullRequestEventType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static PullRequestEventType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(PullRequestEventType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<PullRequestEventType> knownValues() {
        return Stream.of(PullRequestEventType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

