/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codecommit.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codecommit.model.MergeMetadata;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PullRequestTarget
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PullRequestTarget> {
    private static final SdkField<String> REPOSITORY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PullRequestTarget.getter(PullRequestTarget::repositoryName)).setter(PullRequestTarget.setter(Builder::repositoryName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositoryName").build()}).build();
    private static final SdkField<String> SOURCE_REFERENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PullRequestTarget.getter(PullRequestTarget::sourceReference)).setter(PullRequestTarget.setter(Builder::sourceReference)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceReference").build()}).build();
    private static final SdkField<String> DESTINATION_REFERENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PullRequestTarget.getter(PullRequestTarget::destinationReference)).setter(PullRequestTarget.setter(Builder::destinationReference)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationReference").build()}).build();
    private static final SdkField<String> DESTINATION_COMMIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PullRequestTarget.getter(PullRequestTarget::destinationCommit)).setter(PullRequestTarget.setter(Builder::destinationCommit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationCommit").build()}).build();
    private static final SdkField<String> SOURCE_COMMIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PullRequestTarget.getter(PullRequestTarget::sourceCommit)).setter(PullRequestTarget.setter(Builder::sourceCommit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceCommit").build()}).build();
    private static final SdkField<String> MERGE_BASE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PullRequestTarget.getter(PullRequestTarget::mergeBase)).setter(PullRequestTarget.setter(Builder::mergeBase)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mergeBase").build()}).build();
    private static final SdkField<MergeMetadata> MERGE_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(PullRequestTarget.getter(PullRequestTarget::mergeMetadata)).setter(PullRequestTarget.setter(Builder::mergeMetadata)).constructor(MergeMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mergeMetadata").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPOSITORY_NAME_FIELD, SOURCE_REFERENCE_FIELD, DESTINATION_REFERENCE_FIELD, DESTINATION_COMMIT_FIELD, SOURCE_COMMIT_FIELD, MERGE_BASE_FIELD, MERGE_METADATA_FIELD));
    private static final long serialVersionUID = 1L;
    private final String repositoryName;
    private final String sourceReference;
    private final String destinationReference;
    private final String destinationCommit;
    private final String sourceCommit;
    private final String mergeBase;
    private final MergeMetadata mergeMetadata;

    private PullRequestTarget(BuilderImpl builder) {
        this.repositoryName = builder.repositoryName;
        this.sourceReference = builder.sourceReference;
        this.destinationReference = builder.destinationReference;
        this.destinationCommit = builder.destinationCommit;
        this.sourceCommit = builder.sourceCommit;
        this.mergeBase = builder.mergeBase;
        this.mergeMetadata = builder.mergeMetadata;
    }

    public String repositoryName() {
        return this.repositoryName;
    }

    public String sourceReference() {
        return this.sourceReference;
    }

    public String destinationReference() {
        return this.destinationReference;
    }

    public String destinationCommit() {
        return this.destinationCommit;
    }

    public String sourceCommit() {
        return this.sourceCommit;
    }

    public String mergeBase() {
        return this.mergeBase;
    }

    public MergeMetadata mergeMetadata() {
        return this.mergeMetadata;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.repositoryName());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceReference());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationReference());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationCommit());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceCommit());
        hashCode = 31 * hashCode + Objects.hashCode(this.mergeBase());
        hashCode = 31 * hashCode + Objects.hashCode(this.mergeMetadata());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PullRequestTarget)) {
            return false;
        }
        PullRequestTarget other = (PullRequestTarget)obj;
        return Objects.equals(this.repositoryName(), other.repositoryName()) && Objects.equals(this.sourceReference(), other.sourceReference()) && Objects.equals(this.destinationReference(), other.destinationReference()) && Objects.equals(this.destinationCommit(), other.destinationCommit()) && Objects.equals(this.sourceCommit(), other.sourceCommit()) && Objects.equals(this.mergeBase(), other.mergeBase()) && Objects.equals(this.mergeMetadata(), other.mergeMetadata());
    }

    public String toString() {
        return ToString.builder((String)"PullRequestTarget").add("RepositoryName", (Object)this.repositoryName()).add("SourceReference", (Object)this.sourceReference()).add("DestinationReference", (Object)this.destinationReference()).add("DestinationCommit", (Object)this.destinationCommit()).add("SourceCommit", (Object)this.sourceCommit()).add("MergeBase", (Object)this.mergeBase()).add("MergeMetadata", (Object)this.mergeMetadata()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "repositoryName": {
                return Optional.ofNullable(clazz.cast(this.repositoryName()));
            }
            case "sourceReference": {
                return Optional.ofNullable(clazz.cast(this.sourceReference()));
            }
            case "destinationReference": {
                return Optional.ofNullable(clazz.cast(this.destinationReference()));
            }
            case "destinationCommit": {
                return Optional.ofNullable(clazz.cast(this.destinationCommit()));
            }
            case "sourceCommit": {
                return Optional.ofNullable(clazz.cast(this.sourceCommit()));
            }
            case "mergeBase": {
                return Optional.ofNullable(clazz.cast(this.mergeBase()));
            }
            case "mergeMetadata": {
                return Optional.ofNullable(clazz.cast(this.mergeMetadata()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PullRequestTarget, T> g) {
        return obj -> g.apply((PullRequestTarget)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String repositoryName;
        private String sourceReference;
        private String destinationReference;
        private String destinationCommit;
        private String sourceCommit;
        private String mergeBase;
        private MergeMetadata mergeMetadata;

        private BuilderImpl() {
        }

        private BuilderImpl(PullRequestTarget model) {
            this.repositoryName(model.repositoryName);
            this.sourceReference(model.sourceReference);
            this.destinationReference(model.destinationReference);
            this.destinationCommit(model.destinationCommit);
            this.sourceCommit(model.sourceCommit);
            this.mergeBase(model.mergeBase);
            this.mergeMetadata(model.mergeMetadata);
        }

        public final String getRepositoryName() {
            return this.repositoryName;
        }

        @Override
        public final Builder repositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
            return this;
        }

        public final void setRepositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
        }

        public final String getSourceReference() {
            return this.sourceReference;
        }

        @Override
        public final Builder sourceReference(String sourceReference) {
            this.sourceReference = sourceReference;
            return this;
        }

        public final void setSourceReference(String sourceReference) {
            this.sourceReference = sourceReference;
        }

        public final String getDestinationReference() {
            return this.destinationReference;
        }

        @Override
        public final Builder destinationReference(String destinationReference) {
            this.destinationReference = destinationReference;
            return this;
        }

        public final void setDestinationReference(String destinationReference) {
            this.destinationReference = destinationReference;
        }

        public final String getDestinationCommit() {
            return this.destinationCommit;
        }

        @Override
        public final Builder destinationCommit(String destinationCommit) {
            this.destinationCommit = destinationCommit;
            return this;
        }

        public final void setDestinationCommit(String destinationCommit) {
            this.destinationCommit = destinationCommit;
        }

        public final String getSourceCommit() {
            return this.sourceCommit;
        }

        @Override
        public final Builder sourceCommit(String sourceCommit) {
            this.sourceCommit = sourceCommit;
            return this;
        }

        public final void setSourceCommit(String sourceCommit) {
            this.sourceCommit = sourceCommit;
        }

        public final String getMergeBase() {
            return this.mergeBase;
        }

        @Override
        public final Builder mergeBase(String mergeBase) {
            this.mergeBase = mergeBase;
            return this;
        }

        public final void setMergeBase(String mergeBase) {
            this.mergeBase = mergeBase;
        }

        public final MergeMetadata.Builder getMergeMetadata() {
            return this.mergeMetadata != null ? this.mergeMetadata.toBuilder() : null;
        }

        @Override
        public final Builder mergeMetadata(MergeMetadata mergeMetadata) {
            this.mergeMetadata = mergeMetadata;
            return this;
        }

        public final void setMergeMetadata(MergeMetadata.BuilderImpl mergeMetadata) {
            this.mergeMetadata = mergeMetadata != null ? mergeMetadata.build() : null;
        }

        public PullRequestTarget build() {
            return new PullRequestTarget(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PullRequestTarget> {
        public Builder repositoryName(String var1);

        public Builder sourceReference(String var1);

        public Builder destinationReference(String var1);

        public Builder destinationCommit(String var1);

        public Builder sourceCommit(String var1);

        public Builder mergeBase(String var1);

        public Builder mergeMetadata(MergeMetadata var1);

        default public Builder mergeMetadata(Consumer<MergeMetadata.Builder> mergeMetadata) {
            return this.mergeMetadata((MergeMetadata)((MergeMetadata.Builder)MergeMetadata.builder().applyMutation(mergeMetadata)).build());
        }
    }
}

