/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codecommit.paginators;

import java.util.Collections;
import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.codecommit.CodeCommitClient;
import software.amazon.awssdk.services.codecommit.model.DescribePullRequestEventsRequest;
import software.amazon.awssdk.services.codecommit.model.DescribePullRequestEventsResponse;

public class DescribePullRequestEventsIterable
implements SdkIterable<DescribePullRequestEventsResponse> {
    private final CodeCommitClient client;
    private final DescribePullRequestEventsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribePullRequestEventsIterable(CodeCommitClient client, DescribePullRequestEventsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribePullRequestEventsResponseFetcher();
    }

    public Iterator<DescribePullRequestEventsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private final DescribePullRequestEventsIterable resume(DescribePullRequestEventsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribePullRequestEventsIterable(this.client, (DescribePullRequestEventsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new DescribePullRequestEventsIterable(this.client, this.firstRequest){

            @Override
            public Iterator<DescribePullRequestEventsResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class DescribePullRequestEventsResponseFetcher
    implements SyncPageFetcher<DescribePullRequestEventsResponse> {
        private DescribePullRequestEventsResponseFetcher() {
        }

        public boolean hasNextPage(DescribePullRequestEventsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribePullRequestEventsResponse nextPage(DescribePullRequestEventsResponse previousPage) {
            if (previousPage == null) {
                return DescribePullRequestEventsIterable.this.client.describePullRequestEvents(DescribePullRequestEventsIterable.this.firstRequest);
            }
            return DescribePullRequestEventsIterable.this.client.describePullRequestEvents((DescribePullRequestEventsRequest)((Object)DescribePullRequestEventsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

