/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codecommit.paginators;

import java.util.Collections;
import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.codecommit.CodeCommitClient;
import software.amazon.awssdk.services.codecommit.model.GetCommentsForPullRequestRequest;
import software.amazon.awssdk.services.codecommit.model.GetCommentsForPullRequestResponse;

public class GetCommentsForPullRequestIterable
implements SdkIterable<GetCommentsForPullRequestResponse> {
    private final CodeCommitClient client;
    private final GetCommentsForPullRequestRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetCommentsForPullRequestIterable(CodeCommitClient client, GetCommentsForPullRequestRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new GetCommentsForPullRequestResponseFetcher();
    }

    public Iterator<GetCommentsForPullRequestResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private final GetCommentsForPullRequestIterable resume(GetCommentsForPullRequestResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new GetCommentsForPullRequestIterable(this.client, (GetCommentsForPullRequestRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new GetCommentsForPullRequestIterable(this.client, this.firstRequest){

            @Override
            public Iterator<GetCommentsForPullRequestResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class GetCommentsForPullRequestResponseFetcher
    implements SyncPageFetcher<GetCommentsForPullRequestResponse> {
        private GetCommentsForPullRequestResponseFetcher() {
        }

        public boolean hasNextPage(GetCommentsForPullRequestResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetCommentsForPullRequestResponse nextPage(GetCommentsForPullRequestResponse previousPage) {
            if (previousPage == null) {
                return GetCommentsForPullRequestIterable.this.client.getCommentsForPullRequest(GetCommentsForPullRequestIterable.this.firstRequest);
            }
            return GetCommentsForPullRequestIterable.this.client.getCommentsForPullRequest((GetCommentsForPullRequestRequest)((Object)GetCommentsForPullRequestIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

