/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codecommit.paginators;

import java.util.Collections;
import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.codecommit.CodeCommitClient;
import software.amazon.awssdk.services.codecommit.model.ListPullRequestsRequest;
import software.amazon.awssdk.services.codecommit.model.ListPullRequestsResponse;

public class ListPullRequestsIterable
implements SdkIterable<ListPullRequestsResponse> {
    private final CodeCommitClient client;
    private final ListPullRequestsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListPullRequestsIterable(CodeCommitClient client, ListPullRequestsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListPullRequestsResponseFetcher();
    }

    public Iterator<ListPullRequestsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private final ListPullRequestsIterable resume(ListPullRequestsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListPullRequestsIterable(this.client, (ListPullRequestsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListPullRequestsIterable(this.client, this.firstRequest){

            @Override
            public Iterator<ListPullRequestsResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class ListPullRequestsResponseFetcher
    implements SyncPageFetcher<ListPullRequestsResponse> {
        private ListPullRequestsResponseFetcher() {
        }

        public boolean hasNextPage(ListPullRequestsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListPullRequestsResponse nextPage(ListPullRequestsResponse previousPage) {
            if (previousPage == null) {
                return ListPullRequestsIterable.this.client.listPullRequests(ListPullRequestsIterable.this.firstRequest);
            }
            return ListPullRequestsIterable.this.client.listPullRequests((ListPullRequestsRequest)((Object)ListPullRequestsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

