/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codecommit.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.codecommit.CodeCommitAsyncClient;
import software.amazon.awssdk.services.codecommit.model.ListRepositoriesRequest;
import software.amazon.awssdk.services.codecommit.model.ListRepositoriesResponse;
import software.amazon.awssdk.services.codecommit.model.RepositoryNameIdPair;

public class ListRepositoriesPublisher
implements SdkPublisher<ListRepositoriesResponse> {
    private final CodeCommitAsyncClient client;
    private final ListRepositoriesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListRepositoriesPublisher(CodeCommitAsyncClient client, ListRepositoriesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListRepositoriesPublisher(CodeCommitAsyncClient client, ListRepositoriesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListRepositoriesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListRepositoriesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<RepositoryNameIdPair> repositories() {
        Function<ListRepositoriesResponse, Iterator> getIterator = response -> {
            if (response != null && response.repositories() != null) {
                return response.repositories().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListRepositoriesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private final ListRepositoriesPublisher resume(ListRepositoriesResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListRepositoriesPublisher(this.client, (ListRepositoriesRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListRepositoriesPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super ListRepositoriesResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class ListRepositoriesResponseFetcher
    implements AsyncPageFetcher<ListRepositoriesResponse> {
        private ListRepositoriesResponseFetcher() {
        }

        public boolean hasNextPage(ListRepositoriesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListRepositoriesResponse> nextPage(ListRepositoriesResponse previousPage) {
            if (previousPage == null) {
                return ListRepositoriesPublisher.this.client.listRepositories(ListRepositoriesPublisher.this.firstRequest);
            }
            return ListRepositoriesPublisher.this.client.listRepositories((ListRepositoriesRequest)((Object)ListRepositoriesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

