/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codecommit.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Returns information about errors in a BatchGetRepositories operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchGetRepositoriesError implements SdkPojo, Serializable,
        ToCopyableBuilder<BatchGetRepositoriesError.Builder, BatchGetRepositoriesError> {
    private static final SdkField<String> REPOSITORY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("repositoryId").getter(getter(BatchGetRepositoriesError::repositoryId))
            .setter(setter(Builder::repositoryId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositoryId").build()).build();

    private static final SdkField<String> REPOSITORY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("repositoryName").getter(getter(BatchGetRepositoriesError::repositoryName))
            .setter(setter(Builder::repositoryName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositoryName").build()).build();

    private static final SdkField<String> ERROR_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("errorCode").getter(getter(BatchGetRepositoriesError::errorCodeAsString))
            .setter(setter(Builder::errorCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorCode").build()).build();

    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("errorMessage").getter(getter(BatchGetRepositoriesError::errorMessage))
            .setter(setter(Builder::errorMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorMessage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPOSITORY_ID_FIELD,
            REPOSITORY_NAME_FIELD, ERROR_CODE_FIELD, ERROR_MESSAGE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String repositoryId;

    private final String repositoryName;

    private final String errorCode;

    private final String errorMessage;

    private BatchGetRepositoriesError(BuilderImpl builder) {
        this.repositoryId = builder.repositoryId;
        this.repositoryName = builder.repositoryName;
        this.errorCode = builder.errorCode;
        this.errorMessage = builder.errorMessage;
    }

    /**
     * <p>
     * The ID of a repository that either could not be found or was not in a valid state.
     * </p>
     * 
     * @return The ID of a repository that either could not be found or was not in a valid state.
     */
    public final String repositoryId() {
        return repositoryId;
    }

    /**
     * <p>
     * The name of a repository that either could not be found or was not in a valid state.
     * </p>
     * 
     * @return The name of a repository that either could not be found or was not in a valid state.
     */
    public final String repositoryName() {
        return repositoryName;
    }

    /**
     * <p>
     * An error code that specifies the type of failure.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #errorCode} will
     * return {@link BatchGetRepositoriesErrorCodeEnum#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #errorCodeAsString}.
     * </p>
     * 
     * @return An error code that specifies the type of failure.
     * @see BatchGetRepositoriesErrorCodeEnum
     */
    public final BatchGetRepositoriesErrorCodeEnum errorCode() {
        return BatchGetRepositoriesErrorCodeEnum.fromValue(errorCode);
    }

    /**
     * <p>
     * An error code that specifies the type of failure.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #errorCode} will
     * return {@link BatchGetRepositoriesErrorCodeEnum#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #errorCodeAsString}.
     * </p>
     * 
     * @return An error code that specifies the type of failure.
     * @see BatchGetRepositoriesErrorCodeEnum
     */
    public final String errorCodeAsString() {
        return errorCode;
    }

    /**
     * <p>
     * An error message that provides detail about why the repository either was not found or was not in a valid state.
     * </p>
     * 
     * @return An error message that provides detail about why the repository either was not found or was not in a valid
     *         state.
     */
    public final String errorMessage() {
        return errorMessage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(repositoryId());
        hashCode = 31 * hashCode + Objects.hashCode(repositoryName());
        hashCode = 31 * hashCode + Objects.hashCode(errorCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(errorMessage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetRepositoriesError)) {
            return false;
        }
        BatchGetRepositoriesError other = (BatchGetRepositoriesError) obj;
        return Objects.equals(repositoryId(), other.repositoryId()) && Objects.equals(repositoryName(), other.repositoryName())
                && Objects.equals(errorCodeAsString(), other.errorCodeAsString())
                && Objects.equals(errorMessage(), other.errorMessage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchGetRepositoriesError").add("RepositoryId", repositoryId())
                .add("RepositoryName", repositoryName()).add("ErrorCode", errorCodeAsString())
                .add("ErrorMessage", errorMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "repositoryId":
            return Optional.ofNullable(clazz.cast(repositoryId()));
        case "repositoryName":
            return Optional.ofNullable(clazz.cast(repositoryName()));
        case "errorCode":
            return Optional.ofNullable(clazz.cast(errorCodeAsString()));
        case "errorMessage":
            return Optional.ofNullable(clazz.cast(errorMessage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("repositoryId", REPOSITORY_ID_FIELD);
        map.put("repositoryName", REPOSITORY_NAME_FIELD);
        map.put("errorCode", ERROR_CODE_FIELD);
        map.put("errorMessage", ERROR_MESSAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchGetRepositoriesError, T> g) {
        return obj -> g.apply((BatchGetRepositoriesError) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BatchGetRepositoriesError> {
        /**
         * <p>
         * The ID of a repository that either could not be found or was not in a valid state.
         * </p>
         * 
         * @param repositoryId
         *        The ID of a repository that either could not be found or was not in a valid state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repositoryId(String repositoryId);

        /**
         * <p>
         * The name of a repository that either could not be found or was not in a valid state.
         * </p>
         * 
         * @param repositoryName
         *        The name of a repository that either could not be found or was not in a valid state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repositoryName(String repositoryName);

        /**
         * <p>
         * An error code that specifies the type of failure.
         * </p>
         * 
         * @param errorCode
         *        An error code that specifies the type of failure.
         * @see BatchGetRepositoriesErrorCodeEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BatchGetRepositoriesErrorCodeEnum
         */
        Builder errorCode(String errorCode);

        /**
         * <p>
         * An error code that specifies the type of failure.
         * </p>
         * 
         * @param errorCode
         *        An error code that specifies the type of failure.
         * @see BatchGetRepositoriesErrorCodeEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BatchGetRepositoriesErrorCodeEnum
         */
        Builder errorCode(BatchGetRepositoriesErrorCodeEnum errorCode);

        /**
         * <p>
         * An error message that provides detail about why the repository either was not found or was not in a valid
         * state.
         * </p>
         * 
         * @param errorMessage
         *        An error message that provides detail about why the repository either was not found or was not in a
         *        valid state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorMessage(String errorMessage);
    }

    static final class BuilderImpl implements Builder {
        private String repositoryId;

        private String repositoryName;

        private String errorCode;

        private String errorMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetRepositoriesError model) {
            repositoryId(model.repositoryId);
            repositoryName(model.repositoryName);
            errorCode(model.errorCode);
            errorMessage(model.errorMessage);
        }

        public final String getRepositoryId() {
            return repositoryId;
        }

        public final void setRepositoryId(String repositoryId) {
            this.repositoryId = repositoryId;
        }

        @Override
        public final Builder repositoryId(String repositoryId) {
            this.repositoryId = repositoryId;
            return this;
        }

        public final String getRepositoryName() {
            return repositoryName;
        }

        public final void setRepositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
        }

        @Override
        public final Builder repositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
            return this;
        }

        public final String getErrorCode() {
            return errorCode;
        }

        public final void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        @Override
        public final Builder errorCode(String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        @Override
        public final Builder errorCode(BatchGetRepositoriesErrorCodeEnum errorCode) {
            this.errorCode(errorCode == null ? null : errorCode.toString());
            return this;
        }

        public final String getErrorMessage() {
            return errorMessage;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        @Override
        public BatchGetRepositoriesError build() {
            return new BatchGetRepositoriesError(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
