/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codecommit.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the output of a batch get repositories operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchGetRepositoriesResponse extends CodeCommitResponse implements
        ToCopyableBuilder<BatchGetRepositoriesResponse.Builder, BatchGetRepositoriesResponse> {
    private static final SdkField<List<RepositoryMetadata>> REPOSITORIES_FIELD = SdkField
            .<List<RepositoryMetadata>> builder(MarshallingType.LIST)
            .memberName("repositories")
            .getter(getter(BatchGetRepositoriesResponse::repositories))
            .setter(setter(Builder::repositories))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositories").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RepositoryMetadata> builder(MarshallingType.SDK_POJO)
                                            .constructor(RepositoryMetadata::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> REPOSITORIES_NOT_FOUND_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("repositoriesNotFound")
            .getter(getter(BatchGetRepositoriesResponse::repositoriesNotFound))
            .setter(setter(Builder::repositoriesNotFound))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositoriesNotFound").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<BatchGetRepositoriesError>> ERRORS_FIELD = SdkField
            .<List<BatchGetRepositoriesError>> builder(MarshallingType.LIST)
            .memberName("errors")
            .getter(getter(BatchGetRepositoriesResponse::errors))
            .setter(setter(Builder::errors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errors").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BatchGetRepositoriesError> builder(MarshallingType.SDK_POJO)
                                            .constructor(BatchGetRepositoriesError::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPOSITORIES_FIELD,
            REPOSITORIES_NOT_FOUND_FIELD, ERRORS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<RepositoryMetadata> repositories;

    private final List<String> repositoriesNotFound;

    private final List<BatchGetRepositoriesError> errors;

    private BatchGetRepositoriesResponse(BuilderImpl builder) {
        super(builder);
        this.repositories = builder.repositories;
        this.repositoriesNotFound = builder.repositoriesNotFound;
        this.errors = builder.errors;
    }

    /**
     * For responses, this returns true if the service returned a value for the Repositories property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRepositories() {
        return repositories != null && !(repositories instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of repositories returned by the batch get repositories operation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRepositories} method.
     * </p>
     * 
     * @return A list of repositories returned by the batch get repositories operation.
     */
    public final List<RepositoryMetadata> repositories() {
        return repositories;
    }

    /**
     * For responses, this returns true if the service returned a value for the RepositoriesNotFound property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRepositoriesNotFound() {
        return repositoriesNotFound != null && !(repositoriesNotFound instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Returns a list of repository names for which information could not be found.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRepositoriesNotFound} method.
     * </p>
     * 
     * @return Returns a list of repository names for which information could not be found.
     */
    public final List<String> repositoriesNotFound() {
        return repositoriesNotFound;
    }

    /**
     * For responses, this returns true if the service returned a value for the Errors property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasErrors() {
        return errors != null && !(errors instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Returns information about any errors returned when attempting to retrieve information about the repositories.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasErrors} method.
     * </p>
     * 
     * @return Returns information about any errors returned when attempting to retrieve information about the
     *         repositories.
     */
    public final List<BatchGetRepositoriesError> errors() {
        return errors;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasRepositories() ? repositories() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasRepositoriesNotFound() ? repositoriesNotFound() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasErrors() ? errors() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetRepositoriesResponse)) {
            return false;
        }
        BatchGetRepositoriesResponse other = (BatchGetRepositoriesResponse) obj;
        return hasRepositories() == other.hasRepositories() && Objects.equals(repositories(), other.repositories())
                && hasRepositoriesNotFound() == other.hasRepositoriesNotFound()
                && Objects.equals(repositoriesNotFound(), other.repositoriesNotFound()) && hasErrors() == other.hasErrors()
                && Objects.equals(errors(), other.errors());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchGetRepositoriesResponse").add("Repositories", hasRepositories() ? repositories() : null)
                .add("RepositoriesNotFound", hasRepositoriesNotFound() ? repositoriesNotFound() : null)
                .add("Errors", hasErrors() ? errors() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "repositories":
            return Optional.ofNullable(clazz.cast(repositories()));
        case "repositoriesNotFound":
            return Optional.ofNullable(clazz.cast(repositoriesNotFound()));
        case "errors":
            return Optional.ofNullable(clazz.cast(errors()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("repositories", REPOSITORIES_FIELD);
        map.put("repositoriesNotFound", REPOSITORIES_NOT_FOUND_FIELD);
        map.put("errors", ERRORS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchGetRepositoriesResponse, T> g) {
        return obj -> g.apply((BatchGetRepositoriesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeCommitResponse.Builder, SdkPojo, CopyableBuilder<Builder, BatchGetRepositoriesResponse> {
        /**
         * <p>
         * A list of repositories returned by the batch get repositories operation.
         * </p>
         * 
         * @param repositories
         *        A list of repositories returned by the batch get repositories operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repositories(Collection<RepositoryMetadata> repositories);

        /**
         * <p>
         * A list of repositories returned by the batch get repositories operation.
         * </p>
         * 
         * @param repositories
         *        A list of repositories returned by the batch get repositories operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repositories(RepositoryMetadata... repositories);

        /**
         * <p>
         * A list of repositories returned by the batch get repositories operation.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.codecommit.model.RepositoryMetadata.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.codecommit.model.RepositoryMetadata#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.codecommit.model.RepositoryMetadata.Builder#build()} is called
         * immediately and its result is passed to {@link #repositories(List<RepositoryMetadata>)}.
         * 
         * @param repositories
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.codecommit.model.RepositoryMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #repositories(java.util.Collection<RepositoryMetadata>)
         */
        Builder repositories(Consumer<RepositoryMetadata.Builder>... repositories);

        /**
         * <p>
         * Returns a list of repository names for which information could not be found.
         * </p>
         * 
         * @param repositoriesNotFound
         *        Returns a list of repository names for which information could not be found.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repositoriesNotFound(Collection<String> repositoriesNotFound);

        /**
         * <p>
         * Returns a list of repository names for which information could not be found.
         * </p>
         * 
         * @param repositoriesNotFound
         *        Returns a list of repository names for which information could not be found.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repositoriesNotFound(String... repositoriesNotFound);

        /**
         * <p>
         * Returns information about any errors returned when attempting to retrieve information about the repositories.
         * </p>
         * 
         * @param errors
         *        Returns information about any errors returned when attempting to retrieve information about the
         *        repositories.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errors(Collection<BatchGetRepositoriesError> errors);

        /**
         * <p>
         * Returns information about any errors returned when attempting to retrieve information about the repositories.
         * </p>
         * 
         * @param errors
         *        Returns information about any errors returned when attempting to retrieve information about the
         *        repositories.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errors(BatchGetRepositoriesError... errors);

        /**
         * <p>
         * Returns information about any errors returned when attempting to retrieve information about the repositories.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.codecommit.model.BatchGetRepositoriesError.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.codecommit.model.BatchGetRepositoriesError#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.codecommit.model.BatchGetRepositoriesError.Builder#build()} is called
         * immediately and its result is passed to {@link #errors(List<BatchGetRepositoriesError>)}.
         * 
         * @param errors
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.codecommit.model.BatchGetRepositoriesError.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #errors(java.util.Collection<BatchGetRepositoriesError>)
         */
        Builder errors(Consumer<BatchGetRepositoriesError.Builder>... errors);
    }

    static final class BuilderImpl extends CodeCommitResponse.BuilderImpl implements Builder {
        private List<RepositoryMetadata> repositories = DefaultSdkAutoConstructList.getInstance();

        private List<String> repositoriesNotFound = DefaultSdkAutoConstructList.getInstance();

        private List<BatchGetRepositoriesError> errors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetRepositoriesResponse model) {
            super(model);
            repositories(model.repositories);
            repositoriesNotFound(model.repositoriesNotFound);
            errors(model.errors);
        }

        public final List<RepositoryMetadata.Builder> getRepositories() {
            List<RepositoryMetadata.Builder> result = RepositoryMetadataListCopier.copyToBuilder(this.repositories);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRepositories(Collection<RepositoryMetadata.BuilderImpl> repositories) {
            this.repositories = RepositoryMetadataListCopier.copyFromBuilder(repositories);
        }

        @Override
        public final Builder repositories(Collection<RepositoryMetadata> repositories) {
            this.repositories = RepositoryMetadataListCopier.copy(repositories);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder repositories(RepositoryMetadata... repositories) {
            repositories(Arrays.asList(repositories));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder repositories(Consumer<RepositoryMetadata.Builder>... repositories) {
            repositories(Stream.of(repositories).map(c -> RepositoryMetadata.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getRepositoriesNotFound() {
            if (repositoriesNotFound instanceof SdkAutoConstructList) {
                return null;
            }
            return repositoriesNotFound;
        }

        public final void setRepositoriesNotFound(Collection<String> repositoriesNotFound) {
            this.repositoriesNotFound = RepositoryNotFoundListCopier.copy(repositoriesNotFound);
        }

        @Override
        public final Builder repositoriesNotFound(Collection<String> repositoriesNotFound) {
            this.repositoriesNotFound = RepositoryNotFoundListCopier.copy(repositoriesNotFound);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder repositoriesNotFound(String... repositoriesNotFound) {
            repositoriesNotFound(Arrays.asList(repositoriesNotFound));
            return this;
        }

        public final List<BatchGetRepositoriesError.Builder> getErrors() {
            List<BatchGetRepositoriesError.Builder> result = BatchGetRepositoriesErrorsListCopier.copyToBuilder(this.errors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setErrors(Collection<BatchGetRepositoriesError.BuilderImpl> errors) {
            this.errors = BatchGetRepositoriesErrorsListCopier.copyFromBuilder(errors);
        }

        @Override
        public final Builder errors(Collection<BatchGetRepositoriesError> errors) {
            this.errors = BatchGetRepositoriesErrorsListCopier.copy(errors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(BatchGetRepositoriesError... errors) {
            errors(Arrays.asList(errors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(Consumer<BatchGetRepositoriesError.Builder>... errors) {
            errors(Stream.of(errors).map(c -> BatchGetRepositoriesError.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchGetRepositoriesResponse build() {
            return new BatchGetRepositoriesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
