/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codecommit.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the input of a create branch operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateBranchRequest extends CodeCommitRequest implements
        ToCopyableBuilder<CreateBranchRequest.Builder, CreateBranchRequest> {
    private static final SdkField<String> REPOSITORY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("repositoryName").getter(getter(CreateBranchRequest::repositoryName))
            .setter(setter(Builder::repositoryName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositoryName").build()).build();

    private static final SdkField<String> BRANCH_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("branchName").getter(getter(CreateBranchRequest::branchName)).setter(setter(Builder::branchName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("branchName").build()).build();

    private static final SdkField<String> COMMIT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("commitId").getter(getter(CreateBranchRequest::commitId)).setter(setter(Builder::commitId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("commitId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPOSITORY_NAME_FIELD,
            BRANCH_NAME_FIELD, COMMIT_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String repositoryName;

    private final String branchName;

    private final String commitId;

    private CreateBranchRequest(BuilderImpl builder) {
        super(builder);
        this.repositoryName = builder.repositoryName;
        this.branchName = builder.branchName;
        this.commitId = builder.commitId;
    }

    /**
     * <p>
     * The name of the repository in which you want to create the new branch.
     * </p>
     * 
     * @return The name of the repository in which you want to create the new branch.
     */
    public final String repositoryName() {
        return repositoryName;
    }

    /**
     * <p>
     * The name of the new branch to create.
     * </p>
     * 
     * @return The name of the new branch to create.
     */
    public final String branchName() {
        return branchName;
    }

    /**
     * <p>
     * The ID of the commit to point the new branch to.
     * </p>
     * 
     * @return The ID of the commit to point the new branch to.
     */
    public final String commitId() {
        return commitId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(repositoryName());
        hashCode = 31 * hashCode + Objects.hashCode(branchName());
        hashCode = 31 * hashCode + Objects.hashCode(commitId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateBranchRequest)) {
            return false;
        }
        CreateBranchRequest other = (CreateBranchRequest) obj;
        return Objects.equals(repositoryName(), other.repositoryName()) && Objects.equals(branchName(), other.branchName())
                && Objects.equals(commitId(), other.commitId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateBranchRequest").add("RepositoryName", repositoryName()).add("BranchName", branchName())
                .add("CommitId", commitId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "repositoryName":
            return Optional.ofNullable(clazz.cast(repositoryName()));
        case "branchName":
            return Optional.ofNullable(clazz.cast(branchName()));
        case "commitId":
            return Optional.ofNullable(clazz.cast(commitId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("repositoryName", REPOSITORY_NAME_FIELD);
        map.put("branchName", BRANCH_NAME_FIELD);
        map.put("commitId", COMMIT_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateBranchRequest, T> g) {
        return obj -> g.apply((CreateBranchRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeCommitRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateBranchRequest> {
        /**
         * <p>
         * The name of the repository in which you want to create the new branch.
         * </p>
         * 
         * @param repositoryName
         *        The name of the repository in which you want to create the new branch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repositoryName(String repositoryName);

        /**
         * <p>
         * The name of the new branch to create.
         * </p>
         * 
         * @param branchName
         *        The name of the new branch to create.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder branchName(String branchName);

        /**
         * <p>
         * The ID of the commit to point the new branch to.
         * </p>
         * 
         * @param commitId
         *        The ID of the commit to point the new branch to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder commitId(String commitId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CodeCommitRequest.BuilderImpl implements Builder {
        private String repositoryName;

        private String branchName;

        private String commitId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateBranchRequest model) {
            super(model);
            repositoryName(model.repositoryName);
            branchName(model.branchName);
            commitId(model.commitId);
        }

        public final String getRepositoryName() {
            return repositoryName;
        }

        public final void setRepositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
        }

        @Override
        public final Builder repositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
            return this;
        }

        public final String getBranchName() {
            return branchName;
        }

        public final void setBranchName(String branchName) {
            this.branchName = branchName;
        }

        @Override
        public final Builder branchName(String branchName) {
            this.branchName = branchName;
            return this;
        }

        public final String getCommitId() {
            return commitId;
        }

        public final void setCommitId(String commitId) {
            this.commitId = commitId;
        }

        @Override
        public final Builder commitId(String commitId) {
            this.commitId = commitId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateBranchRequest build() {
            return new CreateBranchRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
