/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codecommit.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribePullRequestEventsRequest extends CodeCommitRequest implements
        ToCopyableBuilder<DescribePullRequestEventsRequest.Builder, DescribePullRequestEventsRequest> {
    private static final SdkField<String> PULL_REQUEST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("pullRequestId").getter(getter(DescribePullRequestEventsRequest::pullRequestId))
            .setter(setter(Builder::pullRequestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pullRequestId").build()).build();

    private static final SdkField<String> PULL_REQUEST_EVENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("pullRequestEventType").getter(getter(DescribePullRequestEventsRequest::pullRequestEventTypeAsString))
            .setter(setter(Builder::pullRequestEventType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pullRequestEventType").build())
            .build();

    private static final SdkField<String> ACTOR_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("actorArn").getter(getter(DescribePullRequestEventsRequest::actorArn)).setter(setter(Builder::actorArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actorArn").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(DescribePullRequestEventsRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(DescribePullRequestEventsRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PULL_REQUEST_ID_FIELD,
            PULL_REQUEST_EVENT_TYPE_FIELD, ACTOR_ARN_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String pullRequestId;

    private final String pullRequestEventType;

    private final String actorArn;

    private final String nextToken;

    private final Integer maxResults;

    private DescribePullRequestEventsRequest(BuilderImpl builder) {
        super(builder);
        this.pullRequestId = builder.pullRequestId;
        this.pullRequestEventType = builder.pullRequestEventType;
        this.actorArn = builder.actorArn;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * <p>
     * The system-generated ID of the pull request. To get this ID, use <a>ListPullRequests</a>.
     * </p>
     * 
     * @return The system-generated ID of the pull request. To get this ID, use <a>ListPullRequests</a>.
     */
    public final String pullRequestId() {
        return pullRequestId;
    }

    /**
     * <p>
     * Optional. The pull request event type about which you want to return information.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #pullRequestEventType} will return {@link PullRequestEventType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #pullRequestEventTypeAsString}.
     * </p>
     * 
     * @return Optional. The pull request event type about which you want to return information.
     * @see PullRequestEventType
     */
    public final PullRequestEventType pullRequestEventType() {
        return PullRequestEventType.fromValue(pullRequestEventType);
    }

    /**
     * <p>
     * Optional. The pull request event type about which you want to return information.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #pullRequestEventType} will return {@link PullRequestEventType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #pullRequestEventTypeAsString}.
     * </p>
     * 
     * @return Optional. The pull request event type about which you want to return information.
     * @see PullRequestEventType
     */
    public final String pullRequestEventTypeAsString() {
        return pullRequestEventType;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the user whose actions resulted in the event. Examples include updating the
     * pull request with more commits or changing the status of a pull request.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the user whose actions resulted in the event. Examples include updating
     *         the pull request with more commits or changing the status of a pull request.
     */
    public final String actorArn() {
        return actorArn;
    }

    /**
     * <p>
     * An enumeration token that, when provided in a request, returns the next batch of the results.
     * </p>
     * 
     * @return An enumeration token that, when provided in a request, returns the next batch of the results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * A non-zero, non-negative integer used to limit the number of returned results. The default is 100 events, which
     * is also the maximum number of events that can be returned in a result.
     * </p>
     * 
     * @return A non-zero, non-negative integer used to limit the number of returned results. The default is 100 events,
     *         which is also the maximum number of events that can be returned in a result.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(pullRequestId());
        hashCode = 31 * hashCode + Objects.hashCode(pullRequestEventTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(actorArn());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribePullRequestEventsRequest)) {
            return false;
        }
        DescribePullRequestEventsRequest other = (DescribePullRequestEventsRequest) obj;
        return Objects.equals(pullRequestId(), other.pullRequestId())
                && Objects.equals(pullRequestEventTypeAsString(), other.pullRequestEventTypeAsString())
                && Objects.equals(actorArn(), other.actorArn()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(maxResults(), other.maxResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribePullRequestEventsRequest").add("PullRequestId", pullRequestId())
                .add("PullRequestEventType", pullRequestEventTypeAsString()).add("ActorArn", actorArn())
                .add("NextToken", nextToken()).add("MaxResults", maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "pullRequestId":
            return Optional.ofNullable(clazz.cast(pullRequestId()));
        case "pullRequestEventType":
            return Optional.ofNullable(clazz.cast(pullRequestEventTypeAsString()));
        case "actorArn":
            return Optional.ofNullable(clazz.cast(actorArn()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("pullRequestId", PULL_REQUEST_ID_FIELD);
        map.put("pullRequestEventType", PULL_REQUEST_EVENT_TYPE_FIELD);
        map.put("actorArn", ACTOR_ARN_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribePullRequestEventsRequest, T> g) {
        return obj -> g.apply((DescribePullRequestEventsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeCommitRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribePullRequestEventsRequest> {
        /**
         * <p>
         * The system-generated ID of the pull request. To get this ID, use <a>ListPullRequests</a>.
         * </p>
         * 
         * @param pullRequestId
         *        The system-generated ID of the pull request. To get this ID, use <a>ListPullRequests</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pullRequestId(String pullRequestId);

        /**
         * <p>
         * Optional. The pull request event type about which you want to return information.
         * </p>
         * 
         * @param pullRequestEventType
         *        Optional. The pull request event type about which you want to return information.
         * @see PullRequestEventType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PullRequestEventType
         */
        Builder pullRequestEventType(String pullRequestEventType);

        /**
         * <p>
         * Optional. The pull request event type about which you want to return information.
         * </p>
         * 
         * @param pullRequestEventType
         *        Optional. The pull request event type about which you want to return information.
         * @see PullRequestEventType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PullRequestEventType
         */
        Builder pullRequestEventType(PullRequestEventType pullRequestEventType);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the user whose actions resulted in the event. Examples include updating the
         * pull request with more commits or changing the status of a pull request.
         * </p>
         * 
         * @param actorArn
         *        The Amazon Resource Name (ARN) of the user whose actions resulted in the event. Examples include
         *        updating the pull request with more commits or changing the status of a pull request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actorArn(String actorArn);

        /**
         * <p>
         * An enumeration token that, when provided in a request, returns the next batch of the results.
         * </p>
         * 
         * @param nextToken
         *        An enumeration token that, when provided in a request, returns the next batch of the results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * A non-zero, non-negative integer used to limit the number of returned results. The default is 100 events,
         * which is also the maximum number of events that can be returned in a result.
         * </p>
         * 
         * @param maxResults
         *        A non-zero, non-negative integer used to limit the number of returned results. The default is 100
         *        events, which is also the maximum number of events that can be returned in a result.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CodeCommitRequest.BuilderImpl implements Builder {
        private String pullRequestId;

        private String pullRequestEventType;

        private String actorArn;

        private String nextToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribePullRequestEventsRequest model) {
            super(model);
            pullRequestId(model.pullRequestId);
            pullRequestEventType(model.pullRequestEventType);
            actorArn(model.actorArn);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
        }

        public final String getPullRequestId() {
            return pullRequestId;
        }

        public final void setPullRequestId(String pullRequestId) {
            this.pullRequestId = pullRequestId;
        }

        @Override
        public final Builder pullRequestId(String pullRequestId) {
            this.pullRequestId = pullRequestId;
            return this;
        }

        public final String getPullRequestEventType() {
            return pullRequestEventType;
        }

        public final void setPullRequestEventType(String pullRequestEventType) {
            this.pullRequestEventType = pullRequestEventType;
        }

        @Override
        public final Builder pullRequestEventType(String pullRequestEventType) {
            this.pullRequestEventType = pullRequestEventType;
            return this;
        }

        @Override
        public final Builder pullRequestEventType(PullRequestEventType pullRequestEventType) {
            this.pullRequestEventType(pullRequestEventType == null ? null : pullRequestEventType.toString());
            return this;
        }

        public final String getActorArn() {
            return actorArn;
        }

        public final void setActorArn(String actorArn) {
            this.actorArn = actorArn;
        }

        @Override
        public final Builder actorArn(String actorArn) {
            this.actorArn = actorArn;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribePullRequestEventsRequest build() {
            return new DescribePullRequestEventsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
