/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codecommit.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetCommentsForPullRequestResponse extends CodeCommitResponse implements
        ToCopyableBuilder<GetCommentsForPullRequestResponse.Builder, GetCommentsForPullRequestResponse> {
    private static final SdkField<List<CommentsForPullRequest>> COMMENTS_FOR_PULL_REQUEST_DATA_FIELD = SdkField
            .<List<CommentsForPullRequest>> builder(MarshallingType.LIST)
            .memberName("commentsForPullRequestData")
            .getter(getter(GetCommentsForPullRequestResponse::commentsForPullRequestData))
            .setter(setter(Builder::commentsForPullRequestData))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("commentsForPullRequestData").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CommentsForPullRequest> builder(MarshallingType.SDK_POJO)
                                            .constructor(CommentsForPullRequest::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(GetCommentsForPullRequestResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            COMMENTS_FOR_PULL_REQUEST_DATA_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<CommentsForPullRequest> commentsForPullRequestData;

    private final String nextToken;

    private GetCommentsForPullRequestResponse(BuilderImpl builder) {
        super(builder);
        this.commentsForPullRequestData = builder.commentsForPullRequestData;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the CommentsForPullRequestData property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasCommentsForPullRequestData() {
        return commentsForPullRequestData != null && !(commentsForPullRequestData instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of comment objects on the pull request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCommentsForPullRequestData} method.
     * </p>
     * 
     * @return An array of comment objects on the pull request.
     */
    public final List<CommentsForPullRequest> commentsForPullRequestData() {
        return commentsForPullRequestData;
    }

    /**
     * <p>
     * An enumeration token that can be used in a request to return the next batch of the results.
     * </p>
     * 
     * @return An enumeration token that can be used in a request to return the next batch of the results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasCommentsForPullRequestData() ? commentsForPullRequestData() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCommentsForPullRequestResponse)) {
            return false;
        }
        GetCommentsForPullRequestResponse other = (GetCommentsForPullRequestResponse) obj;
        return hasCommentsForPullRequestData() == other.hasCommentsForPullRequestData()
                && Objects.equals(commentsForPullRequestData(), other.commentsForPullRequestData())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetCommentsForPullRequestResponse")
                .add("CommentsForPullRequestData", hasCommentsForPullRequestData() ? commentsForPullRequestData() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "commentsForPullRequestData":
            return Optional.ofNullable(clazz.cast(commentsForPullRequestData()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("commentsForPullRequestData", COMMENTS_FOR_PULL_REQUEST_DATA_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetCommentsForPullRequestResponse, T> g) {
        return obj -> g.apply((GetCommentsForPullRequestResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeCommitResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetCommentsForPullRequestResponse> {
        /**
         * <p>
         * An array of comment objects on the pull request.
         * </p>
         * 
         * @param commentsForPullRequestData
         *        An array of comment objects on the pull request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder commentsForPullRequestData(Collection<CommentsForPullRequest> commentsForPullRequestData);

        /**
         * <p>
         * An array of comment objects on the pull request.
         * </p>
         * 
         * @param commentsForPullRequestData
         *        An array of comment objects on the pull request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder commentsForPullRequestData(CommentsForPullRequest... commentsForPullRequestData);

        /**
         * <p>
         * An array of comment objects on the pull request.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.codecommit.model.CommentsForPullRequest.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.codecommit.model.CommentsForPullRequest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.codecommit.model.CommentsForPullRequest.Builder#build()} is called
         * immediately and its result is passed to {@link #commentsForPullRequestData(List<CommentsForPullRequest>)}.
         * 
         * @param commentsForPullRequestData
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.codecommit.model.CommentsForPullRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #commentsForPullRequestData(java.util.Collection<CommentsForPullRequest>)
         */
        Builder commentsForPullRequestData(Consumer<CommentsForPullRequest.Builder>... commentsForPullRequestData);

        /**
         * <p>
         * An enumeration token that can be used in a request to return the next batch of the results.
         * </p>
         * 
         * @param nextToken
         *        An enumeration token that can be used in a request to return the next batch of the results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends CodeCommitResponse.BuilderImpl implements Builder {
        private List<CommentsForPullRequest> commentsForPullRequestData = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetCommentsForPullRequestResponse model) {
            super(model);
            commentsForPullRequestData(model.commentsForPullRequestData);
            nextToken(model.nextToken);
        }

        public final List<CommentsForPullRequest.Builder> getCommentsForPullRequestData() {
            List<CommentsForPullRequest.Builder> result = CommentsForPullRequestDataCopier
                    .copyToBuilder(this.commentsForPullRequestData);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCommentsForPullRequestData(Collection<CommentsForPullRequest.BuilderImpl> commentsForPullRequestData) {
            this.commentsForPullRequestData = CommentsForPullRequestDataCopier.copyFromBuilder(commentsForPullRequestData);
        }

        @Override
        public final Builder commentsForPullRequestData(Collection<CommentsForPullRequest> commentsForPullRequestData) {
            this.commentsForPullRequestData = CommentsForPullRequestDataCopier.copy(commentsForPullRequestData);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder commentsForPullRequestData(CommentsForPullRequest... commentsForPullRequestData) {
            commentsForPullRequestData(Arrays.asList(commentsForPullRequestData));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder commentsForPullRequestData(Consumer<CommentsForPullRequest.Builder>... commentsForPullRequestData) {
            commentsForPullRequestData(Stream.of(commentsForPullRequestData)
                    .map(c -> CommentsForPullRequest.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public GetCommentsForPullRequestResponse build() {
            return new GetCommentsForPullRequestResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
