/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codecommit.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the output of a get commit operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetCommitResponse extends CodeCommitResponse implements
        ToCopyableBuilder<GetCommitResponse.Builder, GetCommitResponse> {
    private static final SdkField<Commit> COMMIT_FIELD = SdkField.<Commit> builder(MarshallingType.SDK_POJO).memberName("commit")
            .getter(getter(GetCommitResponse::commit)).setter(setter(Builder::commit)).constructor(Commit::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("commit").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMMIT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Commit commit;

    private GetCommitResponse(BuilderImpl builder) {
        super(builder);
        this.commit = builder.commit;
    }

    /**
     * <p>
     * A commit data type object that contains information about the specified commit.
     * </p>
     * 
     * @return A commit data type object that contains information about the specified commit.
     */
    public final Commit commit() {
        return commit;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(commit());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCommitResponse)) {
            return false;
        }
        GetCommitResponse other = (GetCommitResponse) obj;
        return Objects.equals(commit(), other.commit());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetCommitResponse").add("Commit", commit()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "commit":
            return Optional.ofNullable(clazz.cast(commit()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("commit", COMMIT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetCommitResponse, T> g) {
        return obj -> g.apply((GetCommitResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeCommitResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetCommitResponse> {
        /**
         * <p>
         * A commit data type object that contains information about the specified commit.
         * </p>
         * 
         * @param commit
         *        A commit data type object that contains information about the specified commit.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder commit(Commit commit);

        /**
         * <p>
         * A commit data type object that contains information about the specified commit.
         * </p>
         * This is a convenience method that creates an instance of the {@link Commit.Builder} avoiding the need to
         * create one manually via {@link Commit#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Commit.Builder#build()} is called immediately and its result is
         * passed to {@link #commit(Commit)}.
         * 
         * @param commit
         *        a consumer that will call methods on {@link Commit.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #commit(Commit)
         */
        default Builder commit(Consumer<Commit.Builder> commit) {
            return commit(Commit.builder().applyMutation(commit).build());
        }
    }

    static final class BuilderImpl extends CodeCommitResponse.BuilderImpl implements Builder {
        private Commit commit;

        private BuilderImpl() {
        }

        private BuilderImpl(GetCommitResponse model) {
            super(model);
            commit(model.commit);
        }

        public final Commit.Builder getCommit() {
            return commit != null ? commit.toBuilder() : null;
        }

        public final void setCommit(Commit.BuilderImpl commit) {
            this.commit = commit != null ? commit.build() : null;
        }

        @Override
        public final Builder commit(Commit commit) {
            this.commit = commit;
            return this;
        }

        @Override
        public GetCommitResponse build() {
            return new GetCommitResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
