/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codecommit.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class MergeBranchesByFastForwardRequest extends CodeCommitRequest implements
        ToCopyableBuilder<MergeBranchesByFastForwardRequest.Builder, MergeBranchesByFastForwardRequest> {
    private static final SdkField<String> REPOSITORY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("repositoryName").getter(getter(MergeBranchesByFastForwardRequest::repositoryName))
            .setter(setter(Builder::repositoryName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositoryName").build()).build();

    private static final SdkField<String> SOURCE_COMMIT_SPECIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sourceCommitSpecifier").getter(getter(MergeBranchesByFastForwardRequest::sourceCommitSpecifier))
            .setter(setter(Builder::sourceCommitSpecifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceCommitSpecifier").build())
            .build();

    private static final SdkField<String> DESTINATION_COMMIT_SPECIFIER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("destinationCommitSpecifier")
            .getter(getter(MergeBranchesByFastForwardRequest::destinationCommitSpecifier))
            .setter(setter(Builder::destinationCommitSpecifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationCommitSpecifier").build())
            .build();

    private static final SdkField<String> TARGET_BRANCH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("targetBranch").getter(getter(MergeBranchesByFastForwardRequest::targetBranch))
            .setter(setter(Builder::targetBranch))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetBranch").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPOSITORY_NAME_FIELD,
            SOURCE_COMMIT_SPECIFIER_FIELD, DESTINATION_COMMIT_SPECIFIER_FIELD, TARGET_BRANCH_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String repositoryName;

    private final String sourceCommitSpecifier;

    private final String destinationCommitSpecifier;

    private final String targetBranch;

    private MergeBranchesByFastForwardRequest(BuilderImpl builder) {
        super(builder);
        this.repositoryName = builder.repositoryName;
        this.sourceCommitSpecifier = builder.sourceCommitSpecifier;
        this.destinationCommitSpecifier = builder.destinationCommitSpecifier;
        this.targetBranch = builder.targetBranch;
    }

    /**
     * <p>
     * The name of the repository where you want to merge two branches.
     * </p>
     * 
     * @return The name of the repository where you want to merge two branches.
     */
    public final String repositoryName() {
        return repositoryName;
    }

    /**
     * <p>
     * The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, a branch name
     * or a full commit ID).
     * </p>
     * 
     * @return The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, a
     *         branch name or a full commit ID).
     */
    public final String sourceCommitSpecifier() {
        return sourceCommitSpecifier;
    }

    /**
     * <p>
     * The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, a branch name
     * or a full commit ID).
     * </p>
     * 
     * @return The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, a
     *         branch name or a full commit ID).
     */
    public final String destinationCommitSpecifier() {
        return destinationCommitSpecifier;
    }

    /**
     * <p>
     * The branch where the merge is applied.
     * </p>
     * 
     * @return The branch where the merge is applied.
     */
    public final String targetBranch() {
        return targetBranch;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(repositoryName());
        hashCode = 31 * hashCode + Objects.hashCode(sourceCommitSpecifier());
        hashCode = 31 * hashCode + Objects.hashCode(destinationCommitSpecifier());
        hashCode = 31 * hashCode + Objects.hashCode(targetBranch());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MergeBranchesByFastForwardRequest)) {
            return false;
        }
        MergeBranchesByFastForwardRequest other = (MergeBranchesByFastForwardRequest) obj;
        return Objects.equals(repositoryName(), other.repositoryName())
                && Objects.equals(sourceCommitSpecifier(), other.sourceCommitSpecifier())
                && Objects.equals(destinationCommitSpecifier(), other.destinationCommitSpecifier())
                && Objects.equals(targetBranch(), other.targetBranch());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MergeBranchesByFastForwardRequest").add("RepositoryName", repositoryName())
                .add("SourceCommitSpecifier", sourceCommitSpecifier())
                .add("DestinationCommitSpecifier", destinationCommitSpecifier()).add("TargetBranch", targetBranch()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "repositoryName":
            return Optional.ofNullable(clazz.cast(repositoryName()));
        case "sourceCommitSpecifier":
            return Optional.ofNullable(clazz.cast(sourceCommitSpecifier()));
        case "destinationCommitSpecifier":
            return Optional.ofNullable(clazz.cast(destinationCommitSpecifier()));
        case "targetBranch":
            return Optional.ofNullable(clazz.cast(targetBranch()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("repositoryName", REPOSITORY_NAME_FIELD);
        map.put("sourceCommitSpecifier", SOURCE_COMMIT_SPECIFIER_FIELD);
        map.put("destinationCommitSpecifier", DESTINATION_COMMIT_SPECIFIER_FIELD);
        map.put("targetBranch", TARGET_BRANCH_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MergeBranchesByFastForwardRequest, T> g) {
        return obj -> g.apply((MergeBranchesByFastForwardRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeCommitRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, MergeBranchesByFastForwardRequest> {
        /**
         * <p>
         * The name of the repository where you want to merge two branches.
         * </p>
         * 
         * @param repositoryName
         *        The name of the repository where you want to merge two branches.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repositoryName(String repositoryName);

        /**
         * <p>
         * The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, a branch
         * name or a full commit ID).
         * </p>
         * 
         * @param sourceCommitSpecifier
         *        The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, a
         *        branch name or a full commit ID).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceCommitSpecifier(String sourceCommitSpecifier);

        /**
         * <p>
         * The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, a branch
         * name or a full commit ID).
         * </p>
         * 
         * @param destinationCommitSpecifier
         *        The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, a
         *        branch name or a full commit ID).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationCommitSpecifier(String destinationCommitSpecifier);

        /**
         * <p>
         * The branch where the merge is applied.
         * </p>
         * 
         * @param targetBranch
         *        The branch where the merge is applied.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetBranch(String targetBranch);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CodeCommitRequest.BuilderImpl implements Builder {
        private String repositoryName;

        private String sourceCommitSpecifier;

        private String destinationCommitSpecifier;

        private String targetBranch;

        private BuilderImpl() {
        }

        private BuilderImpl(MergeBranchesByFastForwardRequest model) {
            super(model);
            repositoryName(model.repositoryName);
            sourceCommitSpecifier(model.sourceCommitSpecifier);
            destinationCommitSpecifier(model.destinationCommitSpecifier);
            targetBranch(model.targetBranch);
        }

        public final String getRepositoryName() {
            return repositoryName;
        }

        public final void setRepositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
        }

        @Override
        public final Builder repositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
            return this;
        }

        public final String getSourceCommitSpecifier() {
            return sourceCommitSpecifier;
        }

        public final void setSourceCommitSpecifier(String sourceCommitSpecifier) {
            this.sourceCommitSpecifier = sourceCommitSpecifier;
        }

        @Override
        public final Builder sourceCommitSpecifier(String sourceCommitSpecifier) {
            this.sourceCommitSpecifier = sourceCommitSpecifier;
            return this;
        }

        public final String getDestinationCommitSpecifier() {
            return destinationCommitSpecifier;
        }

        public final void setDestinationCommitSpecifier(String destinationCommitSpecifier) {
            this.destinationCommitSpecifier = destinationCommitSpecifier;
        }

        @Override
        public final Builder destinationCommitSpecifier(String destinationCommitSpecifier) {
            this.destinationCommitSpecifier = destinationCommitSpecifier;
            return this;
        }

        public final String getTargetBranch() {
            return targetBranch;
        }

        public final void setTargetBranch(String targetBranch) {
            this.targetBranch = targetBranch;
        }

        @Override
        public final Builder targetBranch(String targetBranch) {
            this.targetBranch = targetBranch;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public MergeBranchesByFastForwardRequest build() {
            return new MergeBranchesByFastForwardRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
