/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codecommit.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Returns information about an override event for approval rules for a pull request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ApprovalRuleOverriddenEventMetadata implements SdkPojo, Serializable,
        ToCopyableBuilder<ApprovalRuleOverriddenEventMetadata.Builder, ApprovalRuleOverriddenEventMetadata> {
    private static final SdkField<String> REVISION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("revisionId").getter(getter(ApprovalRuleOverriddenEventMetadata::revisionId))
            .setter(setter(Builder::revisionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("revisionId").build()).build();

    private static final SdkField<String> OVERRIDE_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("overrideStatus").getter(getter(ApprovalRuleOverriddenEventMetadata::overrideStatusAsString))
            .setter(setter(Builder::overrideStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("overrideStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REVISION_ID_FIELD,
            OVERRIDE_STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String revisionId;

    private final String overrideStatus;

    private ApprovalRuleOverriddenEventMetadata(BuilderImpl builder) {
        this.revisionId = builder.revisionId;
        this.overrideStatus = builder.overrideStatus;
    }

    /**
     * <p>
     * The revision ID of the pull request when the override event occurred.
     * </p>
     * 
     * @return The revision ID of the pull request when the override event occurred.
     */
    public final String revisionId() {
        return revisionId;
    }

    /**
     * <p>
     * The status of the override event.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #overrideStatus}
     * will return {@link OverrideStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #overrideStatusAsString}.
     * </p>
     * 
     * @return The status of the override event.
     * @see OverrideStatus
     */
    public final OverrideStatus overrideStatus() {
        return OverrideStatus.fromValue(overrideStatus);
    }

    /**
     * <p>
     * The status of the override event.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #overrideStatus}
     * will return {@link OverrideStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #overrideStatusAsString}.
     * </p>
     * 
     * @return The status of the override event.
     * @see OverrideStatus
     */
    public final String overrideStatusAsString() {
        return overrideStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(revisionId());
        hashCode = 31 * hashCode + Objects.hashCode(overrideStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApprovalRuleOverriddenEventMetadata)) {
            return false;
        }
        ApprovalRuleOverriddenEventMetadata other = (ApprovalRuleOverriddenEventMetadata) obj;
        return Objects.equals(revisionId(), other.revisionId())
                && Objects.equals(overrideStatusAsString(), other.overrideStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ApprovalRuleOverriddenEventMetadata").add("RevisionId", revisionId())
                .add("OverrideStatus", overrideStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "revisionId":
            return Optional.ofNullable(clazz.cast(revisionId()));
        case "overrideStatus":
            return Optional.ofNullable(clazz.cast(overrideStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("revisionId", REVISION_ID_FIELD);
        map.put("overrideStatus", OVERRIDE_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ApprovalRuleOverriddenEventMetadata, T> g) {
        return obj -> g.apply((ApprovalRuleOverriddenEventMetadata) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ApprovalRuleOverriddenEventMetadata> {
        /**
         * <p>
         * The revision ID of the pull request when the override event occurred.
         * </p>
         * 
         * @param revisionId
         *        The revision ID of the pull request when the override event occurred.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder revisionId(String revisionId);

        /**
         * <p>
         * The status of the override event.
         * </p>
         * 
         * @param overrideStatus
         *        The status of the override event.
         * @see OverrideStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OverrideStatus
         */
        Builder overrideStatus(String overrideStatus);

        /**
         * <p>
         * The status of the override event.
         * </p>
         * 
         * @param overrideStatus
         *        The status of the override event.
         * @see OverrideStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OverrideStatus
         */
        Builder overrideStatus(OverrideStatus overrideStatus);
    }

    static final class BuilderImpl implements Builder {
        private String revisionId;

        private String overrideStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(ApprovalRuleOverriddenEventMetadata model) {
            revisionId(model.revisionId);
            overrideStatus(model.overrideStatus);
        }

        public final String getRevisionId() {
            return revisionId;
        }

        public final void setRevisionId(String revisionId) {
            this.revisionId = revisionId;
        }

        @Override
        public final Builder revisionId(String revisionId) {
            this.revisionId = revisionId;
            return this;
        }

        public final String getOverrideStatus() {
            return overrideStatus;
        }

        public final void setOverrideStatus(String overrideStatus) {
            this.overrideStatus = overrideStatus;
        }

        @Override
        public final Builder overrideStatus(String overrideStatus) {
            this.overrideStatus = overrideStatus;
            return this;
        }

        @Override
        public final Builder overrideStatus(OverrideStatus overrideStatus) {
            this.overrideStatus(overrideStatus == null ? null : overrideStatus.toString());
            return this;
        }

        @Override
        public ApprovalRuleOverriddenEventMetadata build() {
            return new ApprovalRuleOverriddenEventMetadata(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
