/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codecommit.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchDescribeMergeConflictsResponse extends CodeCommitResponse implements
        ToCopyableBuilder<BatchDescribeMergeConflictsResponse.Builder, BatchDescribeMergeConflictsResponse> {
    private static final SdkField<List<Conflict>> CONFLICTS_FIELD = SdkField
            .<List<Conflict>> builder(MarshallingType.LIST)
            .memberName("conflicts")
            .getter(getter(BatchDescribeMergeConflictsResponse::conflicts))
            .setter(setter(Builder::conflicts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("conflicts").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Conflict> builder(MarshallingType.SDK_POJO)
                                            .constructor(Conflict::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(BatchDescribeMergeConflictsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<List<BatchDescribeMergeConflictsError>> ERRORS_FIELD = SdkField
            .<List<BatchDescribeMergeConflictsError>> builder(MarshallingType.LIST)
            .memberName("errors")
            .getter(getter(BatchDescribeMergeConflictsResponse::errors))
            .setter(setter(Builder::errors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errors").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BatchDescribeMergeConflictsError> builder(MarshallingType.SDK_POJO)
                                            .constructor(BatchDescribeMergeConflictsError::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> DESTINATION_COMMIT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("destinationCommitId").getter(getter(BatchDescribeMergeConflictsResponse::destinationCommitId))
            .setter(setter(Builder::destinationCommitId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationCommitId").build())
            .build();

    private static final SdkField<String> SOURCE_COMMIT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sourceCommitId").getter(getter(BatchDescribeMergeConflictsResponse::sourceCommitId))
            .setter(setter(Builder::sourceCommitId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceCommitId").build()).build();

    private static final SdkField<String> BASE_COMMIT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("baseCommitId").getter(getter(BatchDescribeMergeConflictsResponse::baseCommitId))
            .setter(setter(Builder::baseCommitId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("baseCommitId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFLICTS_FIELD,
            NEXT_TOKEN_FIELD, ERRORS_FIELD, DESTINATION_COMMIT_ID_FIELD, SOURCE_COMMIT_ID_FIELD, BASE_COMMIT_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<Conflict> conflicts;

    private final String nextToken;

    private final List<BatchDescribeMergeConflictsError> errors;

    private final String destinationCommitId;

    private final String sourceCommitId;

    private final String baseCommitId;

    private BatchDescribeMergeConflictsResponse(BuilderImpl builder) {
        super(builder);
        this.conflicts = builder.conflicts;
        this.nextToken = builder.nextToken;
        this.errors = builder.errors;
        this.destinationCommitId = builder.destinationCommitId;
        this.sourceCommitId = builder.sourceCommitId;
        this.baseCommitId = builder.baseCommitId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Conflicts property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasConflicts() {
        return conflicts != null && !(conflicts instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of conflicts for each file, including the conflict metadata and the hunks of the differences between the
     * files.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasConflicts} method.
     * </p>
     * 
     * @return A list of conflicts for each file, including the conflict metadata and the hunks of the differences
     *         between the files.
     */
    public final List<Conflict> conflicts() {
        return conflicts;
    }

    /**
     * <p>
     * An enumeration token that can be used in a request to return the next batch of the results.
     * </p>
     * 
     * @return An enumeration token that can be used in a request to return the next batch of the results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Errors property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasErrors() {
        return errors != null && !(errors instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of any errors returned while describing the merge conflicts for each file.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasErrors} method.
     * </p>
     * 
     * @return A list of any errors returned while describing the merge conflicts for each file.
     */
    public final List<BatchDescribeMergeConflictsError> errors() {
        return errors;
    }

    /**
     * <p>
     * The commit ID of the destination commit specifier that was used in the merge evaluation.
     * </p>
     * 
     * @return The commit ID of the destination commit specifier that was used in the merge evaluation.
     */
    public final String destinationCommitId() {
        return destinationCommitId;
    }

    /**
     * <p>
     * The commit ID of the source commit specifier that was used in the merge evaluation.
     * </p>
     * 
     * @return The commit ID of the source commit specifier that was used in the merge evaluation.
     */
    public final String sourceCommitId() {
        return sourceCommitId;
    }

    /**
     * <p>
     * The commit ID of the merge base.
     * </p>
     * 
     * @return The commit ID of the merge base.
     */
    public final String baseCommitId() {
        return baseCommitId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasConflicts() ? conflicts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasErrors() ? errors() : null);
        hashCode = 31 * hashCode + Objects.hashCode(destinationCommitId());
        hashCode = 31 * hashCode + Objects.hashCode(sourceCommitId());
        hashCode = 31 * hashCode + Objects.hashCode(baseCommitId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchDescribeMergeConflictsResponse)) {
            return false;
        }
        BatchDescribeMergeConflictsResponse other = (BatchDescribeMergeConflictsResponse) obj;
        return hasConflicts() == other.hasConflicts() && Objects.equals(conflicts(), other.conflicts())
                && Objects.equals(nextToken(), other.nextToken()) && hasErrors() == other.hasErrors()
                && Objects.equals(errors(), other.errors()) && Objects.equals(destinationCommitId(), other.destinationCommitId())
                && Objects.equals(sourceCommitId(), other.sourceCommitId())
                && Objects.equals(baseCommitId(), other.baseCommitId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchDescribeMergeConflictsResponse").add("Conflicts", hasConflicts() ? conflicts() : null)
                .add("NextToken", nextToken()).add("Errors", hasErrors() ? errors() : null)
                .add("DestinationCommitId", destinationCommitId()).add("SourceCommitId", sourceCommitId())
                .add("BaseCommitId", baseCommitId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "conflicts":
            return Optional.ofNullable(clazz.cast(conflicts()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "errors":
            return Optional.ofNullable(clazz.cast(errors()));
        case "destinationCommitId":
            return Optional.ofNullable(clazz.cast(destinationCommitId()));
        case "sourceCommitId":
            return Optional.ofNullable(clazz.cast(sourceCommitId()));
        case "baseCommitId":
            return Optional.ofNullable(clazz.cast(baseCommitId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("conflicts", CONFLICTS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("errors", ERRORS_FIELD);
        map.put("destinationCommitId", DESTINATION_COMMIT_ID_FIELD);
        map.put("sourceCommitId", SOURCE_COMMIT_ID_FIELD);
        map.put("baseCommitId", BASE_COMMIT_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchDescribeMergeConflictsResponse, T> g) {
        return obj -> g.apply((BatchDescribeMergeConflictsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeCommitResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, BatchDescribeMergeConflictsResponse> {
        /**
         * <p>
         * A list of conflicts for each file, including the conflict metadata and the hunks of the differences between
         * the files.
         * </p>
         * 
         * @param conflicts
         *        A list of conflicts for each file, including the conflict metadata and the hunks of the differences
         *        between the files.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder conflicts(Collection<Conflict> conflicts);

        /**
         * <p>
         * A list of conflicts for each file, including the conflict metadata and the hunks of the differences between
         * the files.
         * </p>
         * 
         * @param conflicts
         *        A list of conflicts for each file, including the conflict metadata and the hunks of the differences
         *        between the files.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder conflicts(Conflict... conflicts);

        /**
         * <p>
         * A list of conflicts for each file, including the conflict metadata and the hunks of the differences between
         * the files.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.codecommit.model.Conflict.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.codecommit.model.Conflict#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.codecommit.model.Conflict.Builder#build()} is called immediately and
         * its result is passed to {@link #conflicts(List<Conflict>)}.
         * 
         * @param conflicts
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.codecommit.model.Conflict.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #conflicts(java.util.Collection<Conflict>)
         */
        Builder conflicts(Consumer<Conflict.Builder>... conflicts);

        /**
         * <p>
         * An enumeration token that can be used in a request to return the next batch of the results.
         * </p>
         * 
         * @param nextToken
         *        An enumeration token that can be used in a request to return the next batch of the results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * A list of any errors returned while describing the merge conflicts for each file.
         * </p>
         * 
         * @param errors
         *        A list of any errors returned while describing the merge conflicts for each file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errors(Collection<BatchDescribeMergeConflictsError> errors);

        /**
         * <p>
         * A list of any errors returned while describing the merge conflicts for each file.
         * </p>
         * 
         * @param errors
         *        A list of any errors returned while describing the merge conflicts for each file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errors(BatchDescribeMergeConflictsError... errors);

        /**
         * <p>
         * A list of any errors returned while describing the merge conflicts for each file.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.codecommit.model.BatchDescribeMergeConflictsError.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.codecommit.model.BatchDescribeMergeConflictsError#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.codecommit.model.BatchDescribeMergeConflictsError.Builder#build()} is
         * called immediately and its result is passed to {@link #errors(List<BatchDescribeMergeConflictsError>)}.
         * 
         * @param errors
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.codecommit.model.BatchDescribeMergeConflictsError.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #errors(java.util.Collection<BatchDescribeMergeConflictsError>)
         */
        Builder errors(Consumer<BatchDescribeMergeConflictsError.Builder>... errors);

        /**
         * <p>
         * The commit ID of the destination commit specifier that was used in the merge evaluation.
         * </p>
         * 
         * @param destinationCommitId
         *        The commit ID of the destination commit specifier that was used in the merge evaluation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationCommitId(String destinationCommitId);

        /**
         * <p>
         * The commit ID of the source commit specifier that was used in the merge evaluation.
         * </p>
         * 
         * @param sourceCommitId
         *        The commit ID of the source commit specifier that was used in the merge evaluation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceCommitId(String sourceCommitId);

        /**
         * <p>
         * The commit ID of the merge base.
         * </p>
         * 
         * @param baseCommitId
         *        The commit ID of the merge base.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder baseCommitId(String baseCommitId);
    }

    static final class BuilderImpl extends CodeCommitResponse.BuilderImpl implements Builder {
        private List<Conflict> conflicts = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private List<BatchDescribeMergeConflictsError> errors = DefaultSdkAutoConstructList.getInstance();

        private String destinationCommitId;

        private String sourceCommitId;

        private String baseCommitId;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchDescribeMergeConflictsResponse model) {
            super(model);
            conflicts(model.conflicts);
            nextToken(model.nextToken);
            errors(model.errors);
            destinationCommitId(model.destinationCommitId);
            sourceCommitId(model.sourceCommitId);
            baseCommitId(model.baseCommitId);
        }

        public final List<Conflict.Builder> getConflicts() {
            List<Conflict.Builder> result = ConflictsCopier.copyToBuilder(this.conflicts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setConflicts(Collection<Conflict.BuilderImpl> conflicts) {
            this.conflicts = ConflictsCopier.copyFromBuilder(conflicts);
        }

        @Override
        public final Builder conflicts(Collection<Conflict> conflicts) {
            this.conflicts = ConflictsCopier.copy(conflicts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder conflicts(Conflict... conflicts) {
            conflicts(Arrays.asList(conflicts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder conflicts(Consumer<Conflict.Builder>... conflicts) {
            conflicts(Stream.of(conflicts).map(c -> Conflict.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<BatchDescribeMergeConflictsError.Builder> getErrors() {
            List<BatchDescribeMergeConflictsError.Builder> result = BatchDescribeMergeConflictsErrorsCopier
                    .copyToBuilder(this.errors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setErrors(Collection<BatchDescribeMergeConflictsError.BuilderImpl> errors) {
            this.errors = BatchDescribeMergeConflictsErrorsCopier.copyFromBuilder(errors);
        }

        @Override
        public final Builder errors(Collection<BatchDescribeMergeConflictsError> errors) {
            this.errors = BatchDescribeMergeConflictsErrorsCopier.copy(errors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(BatchDescribeMergeConflictsError... errors) {
            errors(Arrays.asList(errors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(Consumer<BatchDescribeMergeConflictsError.Builder>... errors) {
            errors(Stream.of(errors).map(c -> BatchDescribeMergeConflictsError.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getDestinationCommitId() {
            return destinationCommitId;
        }

        public final void setDestinationCommitId(String destinationCommitId) {
            this.destinationCommitId = destinationCommitId;
        }

        @Override
        public final Builder destinationCommitId(String destinationCommitId) {
            this.destinationCommitId = destinationCommitId;
            return this;
        }

        public final String getSourceCommitId() {
            return sourceCommitId;
        }

        public final void setSourceCommitId(String sourceCommitId) {
            this.sourceCommitId = sourceCommitId;
        }

        @Override
        public final Builder sourceCommitId(String sourceCommitId) {
            this.sourceCommitId = sourceCommitId;
            return this;
        }

        public final String getBaseCommitId() {
            return baseCommitId;
        }

        public final void setBaseCommitId(String baseCommitId) {
            this.baseCommitId = baseCommitId;
        }

        @Override
        public final Builder baseCommitId(String baseCommitId) {
            this.baseCommitId = baseCommitId;
            return this;
        }

        @Override
        public BatchDescribeMergeConflictsResponse build() {
            return new BatchDescribeMergeConflictsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
