/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codecommit.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the input of a batch get repositories operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchGetRepositoriesRequest extends CodeCommitRequest implements
        ToCopyableBuilder<BatchGetRepositoriesRequest.Builder, BatchGetRepositoriesRequest> {
    private static final SdkField<List<String>> REPOSITORY_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("repositoryNames")
            .getter(getter(BatchGetRepositoriesRequest::repositoryNames))
            .setter(setter(Builder::repositoryNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositoryNames").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPOSITORY_NAMES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<String> repositoryNames;

    private BatchGetRepositoriesRequest(BuilderImpl builder) {
        super(builder);
        this.repositoryNames = builder.repositoryNames;
    }

    /**
     * For responses, this returns true if the service returned a value for the RepositoryNames property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRepositoryNames() {
        return repositoryNames != null && !(repositoryNames instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The names of the repositories to get information about.
     * </p>
     * <note>
     * <p>
     * The length constraint limit is for each string in the array. The array itself can be empty.
     * </p>
     * </note>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRepositoryNames} method.
     * </p>
     * 
     * @return The names of the repositories to get information about.</p> <note>
     *         <p>
     *         The length constraint limit is for each string in the array. The array itself can be empty.
     *         </p>
     */
    public final List<String> repositoryNames() {
        return repositoryNames;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasRepositoryNames() ? repositoryNames() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetRepositoriesRequest)) {
            return false;
        }
        BatchGetRepositoriesRequest other = (BatchGetRepositoriesRequest) obj;
        return hasRepositoryNames() == other.hasRepositoryNames() && Objects.equals(repositoryNames(), other.repositoryNames());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchGetRepositoriesRequest")
                .add("RepositoryNames", hasRepositoryNames() ? repositoryNames() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "repositoryNames":
            return Optional.ofNullable(clazz.cast(repositoryNames()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("repositoryNames", REPOSITORY_NAMES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchGetRepositoriesRequest, T> g) {
        return obj -> g.apply((BatchGetRepositoriesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeCommitRequest.Builder, SdkPojo, CopyableBuilder<Builder, BatchGetRepositoriesRequest> {
        /**
         * <p>
         * The names of the repositories to get information about.
         * </p>
         * <note>
         * <p>
         * The length constraint limit is for each string in the array. The array itself can be empty.
         * </p>
         * </note>
         * 
         * @param repositoryNames
         *        The names of the repositories to get information about.</p> <note>
         *        <p>
         *        The length constraint limit is for each string in the array. The array itself can be empty.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repositoryNames(Collection<String> repositoryNames);

        /**
         * <p>
         * The names of the repositories to get information about.
         * </p>
         * <note>
         * <p>
         * The length constraint limit is for each string in the array. The array itself can be empty.
         * </p>
         * </note>
         * 
         * @param repositoryNames
         *        The names of the repositories to get information about.</p> <note>
         *        <p>
         *        The length constraint limit is for each string in the array. The array itself can be empty.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repositoryNames(String... repositoryNames);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CodeCommitRequest.BuilderImpl implements Builder {
        private List<String> repositoryNames = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetRepositoriesRequest model) {
            super(model);
            repositoryNames(model.repositoryNames);
        }

        public final Collection<String> getRepositoryNames() {
            if (repositoryNames instanceof SdkAutoConstructList) {
                return null;
            }
            return repositoryNames;
        }

        public final void setRepositoryNames(Collection<String> repositoryNames) {
            this.repositoryNames = RepositoryNameListCopier.copy(repositoryNames);
        }

        @Override
        public final Builder repositoryNames(Collection<String> repositoryNames) {
            this.repositoryNames = RepositoryNameListCopier.copy(repositoryNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder repositoryNames(String... repositoryNames) {
            repositoryNames(Arrays.asList(repositoryNames));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchGetRepositoriesRequest build() {
            return new BatchGetRepositoriesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
